/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.io.pof;

import com.tangosol.io.pof.PofHelper;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.run.xml.SimpleParser;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlSerializable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

public class XmlSerializablePofSerializer
extends PofHelper
implements PofSerializer {
    protected final int m_nTypeId;

    public XmlSerializablePofSerializer(int nTypeId) {
        XmlSerializablePofSerializer.azzert(nTypeId >= 0, "user type identifier cannot be negative");
        this.m_nTypeId = nTypeId;
    }

    public void serialize(PofWriter out, Object o) throws IOException {
        XmlSerializable xmlser;
        try {
            xmlser = (XmlSerializable)o;
        }
        catch (ClassCastException e) {
            String sClass = null;
            try {
                sClass = out.getPofContext().getClassName(this.m_nTypeId);
            }
            catch (Exception eIgnore) {
                // empty catch block
            }
            String sActual = null;
            try {
                sActual = o.getClass().getName();
            }
            catch (Exception eIgnore) {
                // empty catch block
            }
            throw new IOException("An exception occurred writing an XmlSerializable user type to a POF stream: type-id=" + this.m_nTypeId + (sClass == null ? "" : ", class-name=" + sClass) + (sActual == null ? "" : ", actual class-name=" + sActual) + ", exception=\n" + e);
        }
        XmlElement xml = xmlser.toXml();
        StringWriter writer = new StringWriter();
        PrintWriter printer = new PrintWriter(writer);
        xml.writeXml(printer, false);
        printer.close();
        out.writeString(0, writer.toString());
        out.writeRemainder(null);
    }

    public Object deserialize(PofReader in) throws IOException {
        XmlSerializable xmlser;
        try {
            xmlser = (XmlSerializable)in.getPofContext().getClass(this.m_nTypeId).newInstance();
        }
        catch (Exception e) {
            String sClass = null;
            try {
                sClass = in.getPofContext().getClassName(this.m_nTypeId);
            }
            catch (Exception eIgnore) {
                // empty catch block
            }
            throw new IOException("An exception occurred instantiating an XmlSerializable user type from a POF stream: type-id=" + this.m_nTypeId + (sClass == null ? "" : ", class-name=" + sClass) + ", exception=\n" + e);
        }
        String sXml = in.readString(0);
        XmlDocument xml = new SimpleParser().parseXml(sXml);
        xmlser.fromXml(xml);
        in.readRemainder();
        return xmlser;
    }
}

