/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.java.type;

import com.tangosol.java.type.Type;

public class PrimitiveType
extends Type {
    PrimitiveType(String sSig) {
        super(sSig);
        PrimitiveType.azzert(sSig.length() == 1);
        switch (sSig.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                break;
            }
            default: {
                throw PrimitiveType.azzert();
            }
        }
    }

    public boolean isNumeric() {
        switch (this.getSignature().charAt(0)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': {
                return true;
            }
        }
        return false;
    }

    public boolean isIntegral() {
        switch (this.getSignature().charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'J': 
            case 'S': {
                return true;
            }
        }
        return false;
    }

    public boolean isFloatingPoint() {
        switch (this.getSignature().charAt(0)) {
            case 'D': 
            case 'F': {
                return true;
            }
        }
        return false;
    }

    public int getWordCount() {
        switch (this.getSignature().charAt(0)) {
            case 'D': 
            case 'J': {
                return 2;
            }
        }
        return 1;
    }

    public String toString() {
        String sSig = this.getSignature();
        switch (sSig.charAt(0)) {
            case 'Z': {
                return "boolean";
            }
            case 'C': {
                return "char";
            }
            case 'B': {
                return "byte";
            }
            case 'S': {
                return "short";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'F': {
                return "float";
            }
            case 'D': {
                return "double";
            }
        }
        throw new IllegalStateException("Illegal primitive signature: " + sSig);
    }
}

