/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.PriorityTask;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class AbstractPriorityTask
extends ExternalizableHelper
implements PriorityTask,
ExternalizableLite,
PortableObject {
    private int m_iSchedulingPriority = 0;
    private long m_lExecutionTimeout = 0L;
    private long m_lRequestTimeout = 0L;

    public int getSchedulingPriority() {
        return this.m_iSchedulingPriority;
    }

    public long getExecutionTimeoutMillis() {
        return this.m_lExecutionTimeout;
    }

    public long getRequestTimeoutMillis() {
        return this.m_lRequestTimeout;
    }

    public void runCanceled(boolean fAbandoned) {
    }

    public void setSchedulingPriority(int iPriority) {
        if (iPriority < 0 || iPriority > 2) {
            throw new IllegalArgumentException("Invalid priority: " + iPriority);
        }
        this.m_iSchedulingPriority = iPriority;
    }

    public void setExecutionTimeoutMillis(long lTimeout) {
        if (lTimeout < -1L) {
            throw new IllegalArgumentException("Invalid timeout: " + lTimeout);
        }
        this.m_lExecutionTimeout = lTimeout;
    }

    public void setRequestTimeoutMillis(long lTimeout) {
        if (lTimeout < -1L) {
            throw new IllegalArgumentException("Invalid timeout: " + lTimeout);
        }
        this.m_lRequestTimeout = lTimeout;
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_iSchedulingPriority = AbstractPriorityTask.readInt(in);
        this.m_lExecutionTimeout = AbstractPriorityTask.readLong(in);
        this.m_lRequestTimeout = AbstractPriorityTask.readLong(in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        AbstractPriorityTask.writeInt(out, this.m_iSchedulingPriority);
        AbstractPriorityTask.writeLong(out, this.m_lExecutionTimeout);
        AbstractPriorityTask.writeLong(out, this.m_lRequestTimeout);
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_iSchedulingPriority = in.readInt(0);
        this.m_lExecutionTimeout = in.readLong(1);
        this.m_lRequestTimeout = in.readLong(2);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeInt(0, this.m_iSchedulingPriority);
        out.writeLong(1, this.m_lExecutionTimeout);
        out.writeLong(2, this.m_lRequestTimeout);
    }
}

