/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import [Ljava.lang.String;;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.CacheService;
import com.tangosol.net.Cluster;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.InvocationService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.Service;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.TransactionMap;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;

public abstract class CacheFactory
extends Base {
    public static final String PRODUCT;
    public static final String VERSION;
    public static final int LOG_MIN = 0;
    public static final int LOG_MAX = 9;
    public static final int LOG_ALWAYS = 0;
    public static final int LOG_ERR = 1;
    public static final int LOG_WARN = 2;
    public static final int LOG_INFO = 3;
    public static final int LOG_DEBUG = 5;
    public static final int LOG_QUIET = 6;
    private static final String COHERENCE = "com.tangosol.coherence.component.application.console.Coherence";
    private static ConfigurableCacheFactory s_factory;
    private static final Method METHOD_GETCLUSTER;
    private static final Method METHOD_SETCLUSTER;
    private static final Method METHOD_GETLOCALTX;
    private static final Method METHOD_TRACE;
    private static final Method METHOD_ISTRACEENABLED;
    private static final Method METHOD_GETSERVICECONFIG;
    private static final Method METHOD_MAIN;
    private static final Throwable INIT_FAILURE;

    public static NamedCache getReplicatedCache() {
        return CacheFactory.getReplicatedCacheService(null).ensureCache(null, null);
    }

    public static NamedCache getReplicatedCache(String sName) {
        return CacheFactory.getReplicatedCacheService(null).ensureCache(sName, null);
    }

    public static NamedCache getReplicatedCache(String sName, ClassLoader loader) {
        return CacheFactory.getReplicatedCacheService(null).ensureCache(sName, loader);
    }

    public static CacheService getReplicatedCacheService(String sName) {
        return CacheFactory.getReplicatedCacheService(sName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheService getReplicatedCacheService(String sName, BackingMapManager manager) {
        Cluster cluster;
        if (sName == null || sName.length() == 0) {
            sName = "ReplicatedCache";
        }
        Cluster cluster2 = cluster = CacheFactory.ensureCluster();
        synchronized (cluster2) {
            CacheService service = (CacheService)cluster.ensureService(sName, "ReplicatedCache");
            if (!service.isRunning()) {
                service.configure(CacheFactory.getServiceConfig("ReplicatedCache"));
                service.setBackingMapManager(manager);
                service.start();
            }
            return service;
        }
    }

    public static NamedCache getOptimisticCache() {
        return CacheFactory.getOptimisticCacheService(null).ensureCache(null, null);
    }

    public static NamedCache getOptimisticCache(String sName) {
        return CacheFactory.getOptimisticCacheService(null).ensureCache(sName, null);
    }

    public static NamedCache getOptimisticCache(String sName, ClassLoader loader) {
        return CacheFactory.getOptimisticCacheService(null).ensureCache(sName, loader);
    }

    public static CacheService getOptimisticCacheService(String sName) {
        return CacheFactory.getOptimisticCacheService(sName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheService getOptimisticCacheService(String sName, BackingMapManager manager) {
        Cluster cluster;
        if (sName == null || sName.length() == 0) {
            sName = "OptimisticCache";
        }
        Cluster cluster2 = cluster = CacheFactory.ensureCluster();
        synchronized (cluster2) {
            CacheService service = (CacheService)cluster.ensureService(sName, "OptimisticCache");
            if (!service.isRunning()) {
                service.configure(CacheFactory.getServiceConfig("OptimisticCache"));
                service.setBackingMapManager(manager);
                service.start();
            }
            return service;
        }
    }

    public static NamedCache getDistributedCache() {
        return CacheFactory.getDistributedCacheService(null).ensureCache(null, null);
    }

    public static NamedCache getDistributedCache(String sName) {
        return CacheFactory.getDistributedCacheService(null).ensureCache(sName, null);
    }

    public static NamedCache getDistributedCache(String sName, ClassLoader loader) {
        return CacheFactory.getDistributedCacheService(null).ensureCache(sName, loader);
    }

    public static CacheService getDistributedCacheService(String sName) {
        return CacheFactory.getDistributedCacheService(sName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheService getDistributedCacheService(String sName, BackingMapManager manager) {
        Cluster cluster;
        if (sName == null || sName.length() == 0) {
            sName = "DistributedCache";
        }
        Cluster cluster2 = cluster = CacheFactory.ensureCluster();
        synchronized (cluster2) {
            CacheService service = (CacheService)cluster.ensureService(sName, "DistributedCache");
            if (!service.isRunning()) {
                service.configure(CacheFactory.getServiceConfig("DistributedCache"));
                service.setBackingMapManager(manager);
                service.start();
            }
            return service;
        }
    }

    public static CacheService getLocalCacheService(String sName) {
        return CacheFactory.getLocalCacheService(sName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheService getLocalCacheService(String sName, BackingMapManager manager) {
        Cluster cluster;
        if (sName == null || sName.length() == 0) {
            sName = "LocalCache";
        }
        Cluster cluster2 = cluster = CacheFactory.getCluster();
        synchronized (cluster2) {
            CacheService service = (CacheService)cluster.ensureService(sName, "LocalCache");
            if (!service.isRunning()) {
                service.configure(CacheFactory.getServiceConfig("LocalCache"));
                service.setBackingMapManager(manager);
                service.start();
            }
            return service;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurableCacheFactory getConfigurableCacheFactory() {
        ConfigurableCacheFactory factory = s_factory;
        if (factory == null) {
            Class clazz = CacheFactory.class;
            synchronized (clazz) {
                factory = s_factory;
                if (factory == null) {
                    XmlElement xmlFactory = CacheFactory.getConfigurableCacheFactoryConfig();
                    String sClass = xmlFactory.getSafeElement("class-name").getString("com.tangosol.net.DefaultConfigurableCacheFactory");
                    try {
                        Class<?> clz = Class.forName(sClass);
                        Object[] aoParam = XmlHelper.parseInitParams(xmlFactory.getSafeElement("init-params"));
                        factory = (ConfigurableCacheFactory)ClassHelper.newInstance(clz, aoParam);
                    }
                    catch (Exception e) {
                        throw CacheFactory.ensureRuntimeException(e, "Failed to load the factory");
                    }
                    CacheFactory.setConfigurableCacheFactory(factory);
                }
            }
        }
        return factory;
    }

    public static void setConfigurableCacheFactory(ConfigurableCacheFactory factory) {
        s_factory = factory;
    }

    public static Service getService(String sName) {
        return CacheFactory.getConfigurableCacheFactory().ensureService(sName);
    }

    public static NamedCache getCache(String sName) {
        return CacheFactory.getCache(sName, null);
    }

    public static NamedCache getCache(String sName, ClassLoader loader) {
        return CacheFactory.getConfigurableCacheFactory().ensureCache(sName, loader);
    }

    public static TransactionMap getLocalTransaction(NamedCache map) {
        if (map == null) {
            throw new IllegalArgumentException("NamedCache must be specified");
        }
        if (INIT_FAILURE != null) {
            throw CacheFactory.ensureRuntimeException(INIT_FAILURE);
        }
        try {
            return (TransactionMap)METHOD_GETLOCALTX.invoke(null, map);
        }
        catch (Exception e) {
            throw CacheFactory.ensureRuntimeException(e);
        }
    }

    public static boolean commitTransactionCollection(Collection collCaches, int cRetry) {
        TransactionMap cacheTx;
        int iCache;
        if (cRetry < 0 || cRetry > 100) {
            throw new IllegalArgumentException("illegal retry count: " + cRetry);
        }
        int cTry = 1 + cRetry;
        List listCaches = collCaches instanceof List ? (List)collCaches : new ImmutableArrayList(collCaches);
        int cCaches = listCaches.size();
        for (iCache = 0; iCache < cCaches; ++iCache) {
            cacheTx = (TransactionMap)listCaches.get(iCache);
            boolean fPrepared = false;
            for (int iTry = 0; iTry < cTry; ++iTry) {
                try {
                    cacheTx.prepare();
                    fPrepared = true;
                    break;
                }
                catch (ConcurrentModificationException e) {
                    if (iTry < cRetry) {
                        try {
                            Thread.sleep(1 + CacheFactory.getRandom().nextInt(5));
                        }
                        catch (Throwable eIgnored) {}
                        continue;
                    }
                    CacheFactory.log("Unable to prepare transaction:\n" + CacheFactory.getStackTrace(e), 4);
                    continue;
                }
                catch (RuntimeException e) {
                    break;
                }
                catch (Error e) {
                    CacheFactory.log("Error during prepare (tx will rollback):\n" + CacheFactory.getStackTrace(e), 1);
                    break;
                }
            }
            if (fPrepared) continue;
            CacheFactory.rollbackTransactionCollection(collCaches);
            return false;
        }
        for (iCache = 0; iCache < cCaches; ++iCache) {
            cacheTx = (TransactionMap)listCaches.get(iCache);
            try {
                cacheTx.commit();
                continue;
            }
            catch (Throwable e) {
                String sCategory;
                String string = sCategory = e instanceof Error ? "Error" : "Exception";
                if (iCache == 0) {
                    CacheFactory.log(sCategory + " during commit (tx will rollback):\n" + CacheFactory.getStackTrace(e), 1);
                    CacheFactory.rollbackTransactionCollection(collCaches);
                    return false;
                }
                CacheFactory.log(sCategory + " during commit (tx will continue, " + "but tx outcome is nondeterministic):\n" + CacheFactory.getStackTrace(e), 1);
            }
        }
        return true;
    }

    public static void rollbackTransactionCollection(Collection collCaches) {
        Iterator iter = collCaches.iterator();
        while (iter.hasNext()) {
            TransactionMap cacheTx = (TransactionMap)iter.next();
            try {
                cacheTx.rollback();
            }
            catch (Throwable e) {
                CacheFactory.log((e instanceof Error ? "Error" : "Exception") + " during rollback (ignored):\n" + CacheFactory.getStackTrace(e), 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InvocationService getInvocationService(String sName) {
        Cluster cluster;
        if (sName == null || sName.length() == 0) {
            sName = "Invocation";
        }
        Cluster cluster2 = cluster = CacheFactory.ensureCluster();
        synchronized (cluster2) {
            InvocationService service = (InvocationService)cluster.ensureService(sName, "Invocation");
            if (!service.isRunning()) {
                service.configure(CacheFactory.getServiceConfig("Invocation"));
                service.start();
            }
            return service;
        }
    }

    public static Cluster getCluster() {
        if (INIT_FAILURE != null) {
            throw CacheFactory.ensureRuntimeException(INIT_FAILURE);
        }
        try {
            return (Cluster)METHOD_GETCLUSTER.invoke(null, ClassHelper.VOID);
        }
        catch (Exception e) {
            throw CacheFactory.ensureRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cluster ensureCluster() {
        Cluster cluster;
        Cluster cluster2 = cluster = CacheFactory.getCluster();
        synchronized (cluster2) {
            if (!cluster.isRunning()) {
                cluster.configure(CacheFactory.getClusterConfig());
                cluster.start();
            }
            return cluster;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Cluster cluster;
        Cluster cluster2 = cluster = CacheFactory.getCluster();
        synchronized (cluster2) {
            cluster.shutdown();
            try {
                METHOD_SETCLUSTER.invoke(null, new Object[]{null});
            }
            catch (Exception e) {
                throw CacheFactory.ensureRuntimeException(e);
            }
            finally {
                CacheFactory.setConfigurableCacheFactory(null);
            }
        }
    }

    public static void releaseCache(NamedCache map) {
        map.release();
    }

    public static void destroyCache(NamedCache map) {
        map.destroy();
    }

    public static void log(String sMessage, int nSeverity) {
        try {
            METHOD_TRACE.invoke(null, sMessage, CacheFactory.makeInteger(nSeverity));
        }
        catch (Throwable e) {
            if (nSeverity > 0) {
                System.err.println(sMessage);
            }
            System.out.println(sMessage);
        }
    }

    public static boolean isLogEnabled(int nSeverity) {
        try {
            return (Boolean)METHOD_ISTRACEENABLED.invoke(null, CacheFactory.makeInteger(nSeverity));
        }
        catch (Throwable e) {
            return true;
        }
    }

    public static XmlElement getClusterConfig() {
        return CacheFactory.getServiceConfig("Cluster");
    }

    public static XmlElement getReplicatedCacheConfig() {
        return CacheFactory.getServiceConfig("ReplicatedCache");
    }

    public static XmlElement getDistributedCacheConfig() {
        return CacheFactory.getServiceConfig("DistributedCache");
    }

    public static XmlElement getLoggingConfig() {
        return CacheFactory.getServiceConfig("$Logger");
    }

    public static XmlElement getConfigurableCacheFactoryConfig() {
        return CacheFactory.getServiceConfig("$CacheFactory");
    }

    public static XmlElement getSecurityConfig() {
        return CacheFactory.getServiceConfig("$Security");
    }

    public static XmlElement getManagementConfig() {
        return CacheFactory.getServiceConfig("$Management");
    }

    public static XmlElement getServiceConfig(String sServiceType) {
        if (INIT_FAILURE != null) {
            throw CacheFactory.ensureRuntimeException(INIT_FAILURE);
        }
        try {
            return (XmlElement)METHOD_GETSERVICECONFIG.invoke(null, sServiceType);
        }
        catch (Exception e) {
            throw CacheFactory.ensureRuntimeException(e);
        }
    }

    public static void initLogging() {
    }

    public static void main(String[] asArg) throws Exception {
        if (INIT_FAILURE != null) {
            throw CacheFactory.ensureRuntimeException(INIT_FAILURE);
        }
        METHOD_MAIN.invoke(null, new Object[]{asArg});
    }

    static {
        String sProduct = null;
        String sVersion = null;
        Method methGetCluster = null;
        Method methSetCluster = null;
        Method methGetLocalTransaction = null;
        Method methTrace = null;
        Method methIsTraceEnabled = null;
        Method methGetServiceConfig = null;
        Method methMain = null;
        Throwable eInitFailure = null;
        try {
            Class<?> clzLibrary = Class.forName(COHERENCE);
            sProduct = (String)clzLibrary.getField("TITLE").get(null);
            sVersion = (String)clzLibrary.getField("VERSION").get(null);
            methGetCluster = clzLibrary.getMethod("getCluster", new Class[0]);
            methSetCluster = clzLibrary.getMethod("setCluster", Cluster.class);
            methGetLocalTransaction = clzLibrary.getMethod("getLocalTransaction", NamedCache.class);
            methTrace = clzLibrary.getMethod("_trace", String.class, Integer.TYPE);
            methIsTraceEnabled = clzLibrary.getMethod("_isTraceEnabled", Integer.TYPE);
            methGetServiceConfig = clzLibrary.getMethod("getServiceConfig", String.class);
            methMain = clzLibrary.getMethod("main", String;.class);
            CacheFactory.setOut(new LoggingWriter(0));
            CacheFactory.setErr(new LoggingWriter(1));
            CacheFactory.setLog(new LoggingWriter(3));
            CacheFactory.setLogEcho(false);
        }
        catch (Throwable e) {
            eInitFailure = e;
        }
        PRODUCT = sProduct;
        VERSION = sVersion;
        METHOD_GETCLUSTER = methGetCluster;
        METHOD_SETCLUSTER = methSetCluster;
        METHOD_GETLOCALTX = methGetLocalTransaction;
        METHOD_TRACE = methTrace;
        METHOD_ISTRACEENABLED = methIsTraceEnabled;
        METHOD_GETSERVICECONFIG = methGetServiceConfig;
        METHOD_MAIN = methMain;
        INIT_FAILURE = eInitFailure;
    }

    public static class LoggingWriter
    extends PrintWriter {
        private int m_nSev;

        public LoggingWriter(int nSev) {
            super(new CharArrayWriter());
            this.m_nSev = nSev;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void println() {
            CharArrayWriter out = (CharArrayWriter)this.out;
            Object object = this.lock;
            synchronized (object) {
                String s = out.toString();
                out.reset();
                CacheFactory.log(s, this.m_nSev);
            }
        }
    }
}

