/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.io.WrapperStreamFactory;
import com.tangosol.run.xml.XmlConfigurable;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class CompressionFilter
extends Base
implements WrapperStreamFactory,
XmlConfigurable {
    private XmlElement m_xmlConfig;
    private int m_nLevel = -1;
    private int m_nStrategy = 0;
    private int m_cbBuffer;
    private boolean m_fGzip;

    public InputStream getInputStream(InputStream stream) {
        int cbBuffer = this.m_cbBuffer;
        if (this.m_fGzip) {
            if (cbBuffer == 0) {
                try {
                    return new GZIPInputStream(stream);
                }
                catch (IOException e) {
                    throw new WrapperException(e);
                }
            }
            try {
                return new GZIPInputStream(stream, cbBuffer);
            }
            catch (IOException e) {
                throw new WrapperException(e);
            }
        }
        Inflater inflater = new Inflater();
        return cbBuffer == 0 ? new InflaterInputShell(stream, inflater) : new InflaterInputShell(stream, inflater, cbBuffer);
    }

    public OutputStream getOutputStream(OutputStream stream) {
        int cbBuffer = this.m_cbBuffer;
        if (this.m_fGzip) {
            if (cbBuffer == 0) {
                try {
                    return new GZIPOutputStream(stream);
                }
                catch (IOException e) {
                    throw new WrapperException(e);
                }
            }
            try {
                return new GZIPOutputStream(stream, cbBuffer);
            }
            catch (IOException e) {
                throw new WrapperException(e);
            }
        }
        Deflater deflater = new Deflater();
        if (this.m_nLevel != -1) {
            deflater.setLevel(this.m_nLevel);
        }
        if (this.m_nStrategy != 0) {
            deflater.setStrategy(this.m_nStrategy);
        }
        return cbBuffer == 0 ? new DeflaterOutputShell(stream, deflater) : new DeflaterOutputShell(stream, deflater, cbBuffer);
    }

    public XmlElement getConfig() {
        return this.m_xmlConfig;
    }

    public void setConfig(XmlElement xml) {
        this.m_xmlConfig = xml;
        if (xml != null) {
            this.m_cbBuffer = xml.getSafeElement("buffer-length").getInt(this.m_cbBuffer);
            this.m_fGzip = false;
            String sStrategy = xml.getSafeElement("strategy").getString("gzip");
            if (sStrategy.equals("default")) {
                this.m_nStrategy = 0;
            } else if (sStrategy.equals("huffman-only")) {
                this.m_nStrategy = 2;
            } else if (sStrategy.equals("filtered")) {
                this.m_nStrategy = 1;
            } else if (sStrategy.equals("gzip")) {
                this.m_nStrategy = 0;
                this.m_fGzip = true;
            } else {
                try {
                    this.m_nStrategy = Integer.parseInt(sStrategy);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.m_fGzip) {
                this.m_nLevel = -1;
            } else {
                String sLevel = xml.getSafeElement("level").getString("default");
                if (sLevel.equals("default")) {
                    this.m_nLevel = -1;
                } else if (sLevel.endsWith("compression")) {
                    this.m_nLevel = 9;
                } else if (sLevel.endsWith("speed")) {
                    this.m_nLevel = 1;
                } else if (sLevel.equals("none")) {
                    this.m_nLevel = 0;
                } else {
                    try {
                        this.m_nLevel = Integer.parseInt(sLevel);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static class DeflaterOutputShell
    extends DeflaterOutputStream {
        private byte[] m_singleByteBuf = new byte[1];

        public DeflaterOutputShell(OutputStream stream, Deflater deflater) {
            super(stream, deflater);
        }

        public DeflaterOutputShell(OutputStream stream, Deflater deflater, int cbSize) {
            super(stream, deflater, cbSize);
        }

        public void close() throws IOException {
            super.close();
            this.def.end();
        }

        public void write(int b) throws IOException {
            byte[] ab = this.m_singleByteBuf;
            ab[0] = (byte)(b & 0xFF);
            this.write(ab, 0, 1);
        }
    }

    public static class InflaterInputShell
    extends InflaterInputStream {
        private byte[] m_singleByteBuf = new byte[1];

        public InflaterInputShell(InputStream stream, Inflater inflater) {
            super(stream, inflater);
        }

        public InflaterInputShell(InputStream stream, Inflater inflater, int cbSize) {
            super(stream, inflater, cbSize);
        }

        public void close() throws IOException {
            super.close();
            this.inf.end();
        }

        public int read() throws IOException {
            byte[] ab = this.m_singleByteBuf;
            return this.read(ab, 0, 1) == -1 ? -1 : ab[0] & 0xFF;
        }
    }
}

