/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;

public class DatagramPacketOutputStream
extends OutputStream {
    private DatagramPacket m_packet;
    private byte[] m_ab;
    private int m_of;
    private int m_cb;

    public DatagramPacketOutputStream(DatagramPacket packet) {
        this.m_packet = packet;
        this.reset();
    }

    public void write(int b) throws IOException {
        byte[] abDest = this.m_ab;
        int ofDest = this.m_of;
        int cbDest = this.m_cb;
        if (ofDest >= cbDest) {
            throw new IOException("buffer over-run");
        }
        abDest[ofDest] = (byte)b;
        this.m_of = ofDest + 1;
    }

    public void write(byte[] abSrc, int ofSrc, int cbCopy) throws IOException {
        byte[] abDest = this.m_ab;
        int cbDest = this.m_cb;
        int ofDest = this.m_of;
        if (cbCopy > cbDest - ofDest) {
            throw new IOException("buffer over-run");
        }
        System.arraycopy(abSrc, ofSrc, abDest, ofDest, cbCopy);
        this.m_of = ofDest + cbCopy;
    }

    public void flush() throws IOException {
        this.m_packet.setLength(this.m_of);
    }

    public void close() {
        this.reset();
    }

    public void reset() {
        this.m_ab = this.m_packet.getData();
        this.m_of = this.m_packet.getOffset();
        this.m_cb = this.m_ab.length;
    }
}

