/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.dev.tools.CommandLineTool;
import com.tangosol.net.DatagramPacketOutputStream;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class DatagramTest
extends Base {
    public static final int MB = 0x100000;
    public static final String COMMAND_ADDR_LOCAL = "local";
    public static final int DEFAULT_PORT = 9999;
    public static final String DEFAULT_IP_LOCAL = "localhost";
    public static final String DEFAULT_ADDR_LOCAL = "localhost:9999";
    public static final String COMMAND_PACKET_SIZE = "packetSize";
    public static final int DEFAULT_PACKET_SIZE = 1468;
    public static final String COMMAND_PAYLOAD = "payload";
    public static final int DEFAULT_PAYLOAD = 0;
    public static final String COMMAND_TX_RATE = "txRate";
    public static final int DEFAULT_TX_RATE = -1;
    public static final String COMMAND_PROCESS_BYTES = "processBytes";
    public static final int DEFAULT_PROCESS_BYTES = 4;
    public static final String COMMAND_TX_PACKET_BUFFER_SIZE = "txBufferSize";
    public static final int DEFAULT_TX_PACKET_BUFFER_SIZE = 16;
    public static final String COMMAND_RX_PACKET_BUFFER_SIZE = "rxBufferSize";
    public static final int DEFAULT_RX_PACKET_BUFFER_SIZE = 1428;
    public static final String COMMAND_LOG = "log";
    public static final String DEFAULT_LOG = null;
    public static final String COMMAND_REPORT_INTERVAL = "reportInterval";
    public static final int DEFAULT_REPORT_INTERVAL = 100000;
    public static final String COMMAND_LOG_INTERVAL = "logInterval";
    public static final int DEFAULT_LOG_INTERVAL = 100000;
    public static final String COMMAND_TICK_INTERVAL = "tickInterval";
    public static final int DEFAULT_TICK_INTERVAL = 1000;
    public static final String COMMAND_TX_ITERATIONS = "txIterations";
    public static final int DEFAULT_TX_ITERATIONS = -1;
    public static final String COMMAND_TX_DURATION_MS = "txDurationMs";
    public static final long DEFAULT_TX_DURATION_MS = -1L;
    public static final String COMMAND_RX_TIMEOUT_MS = "rxTimeoutMs";
    public static final int DEFAULT_RX_TIMEOUT_MS = 1000;
    public static final String[] VALID_COMMANDS = new String[]{"local", "packetSize", "payload", "txRate", "processBytes", "txBufferSize", "rxBufferSize", "reportInterval", "log", "logInterval", "tickInterval", "txIterations", "txDurationMs", "rxTimeoutMs"};
    public static final String SWITCH_HELP = "?";
    public static final String SWITCH_POLITE = "polite";
    public static final String SWITCH_RAND = "rand";
    public static final String[] VALID_SWITCHES = new String[]{"?", "polite", "rand"};

    public static void main(String[] asArg) {
        int cTimeoutMs;
        InetSocketAddress addrLocal = null;
        StartFlag startFlag = null;
        PublisherConfig pConfig = null;
        ListenerConfig lConfig = new ListenerConfig();
        try {
            String sAddrValue;
            ArrayList<String> lArg = new ArrayList<String>(Arrays.asList(asArg));
            List lSwitches = DatagramTest.extractSwitches(lArg, VALID_SWITCHES);
            asArg = lArg.toArray(new String[lArg.size()]);
            if (lSwitches.contains(SWITCH_HELP)) {
                DatagramTest.showInstructions();
                return;
            }
            ListMap lCmd = CommandLineTool.parseArguments(asArg, VALID_COMMANDS, true);
            addrLocal = DatagramTest.translateAddress((String)DatagramTest.processCommand(lCmd, COMMAND_ADDR_LOCAL, DEFAULT_ADDR_LOCAL));
            lConfig.setPacketSize(DatagramTest.processIntCommand(lCmd, COMMAND_PACKET_SIZE, 1468));
            lConfig.setPayload(DatagramTest.processIntCommand(lCmd, COMMAND_PAYLOAD, 0));
            lConfig.setProcessPacketBytes(DatagramTest.processIntCommand(lCmd, COMMAND_PROCESS_BYTES, 4));
            lConfig.setReportInterval(DatagramTest.processIntCommand(lCmd, COMMAND_REPORT_INTERVAL, 100000));
            lConfig.setTickInterval(DatagramTest.processIntCommand(lCmd, COMMAND_TICK_INTERVAL, 1000));
            lConfig.setBufferPackets(DatagramTest.processIntCommand(lCmd, COMMAND_RX_PACKET_BUFFER_SIZE, 1428));
            lConfig.setLog((String)DatagramTest.processCommand(lCmd, COMMAND_LOG, DEFAULT_LOG));
            lConfig.setLogInterval(DatagramTest.processIntCommand(lCmd, COMMAND_LOG_INTERVAL, 100000));
            cTimeoutMs = DatagramTest.processIntCommand(lCmd, COMMAND_RX_TIMEOUT_MS, 1000);
            ArrayList<InetSocketAddress> lAddrPeer = null;
            int i = 0;
            while ((sAddrValue = (String)lCmd.get(DatagramTest.makeInteger(i))) != null) {
                if (lAddrPeer == null) {
                    lAddrPeer = new ArrayList<InetSocketAddress>();
                }
                lAddrPeer.add(DatagramTest.translateAddress(sAddrValue));
                ++i;
            }
            if (lAddrPeer != null) {
                pConfig = new PublisherConfig();
                pConfig.setAddrPeers(lAddrPeer.toArray(new InetSocketAddress[lAddrPeer.size()]));
                pConfig.setPacketSize(DatagramTest.processIntCommand(lCmd, COMMAND_PACKET_SIZE, 1468));
                pConfig.setPayload(DatagramTest.processIntCommand(lCmd, COMMAND_PAYLOAD, 0));
                pConfig.setProcessPacketBytes(DatagramTest.processIntCommand(lCmd, COMMAND_PROCESS_BYTES, 4));
                pConfig.setReportInterval(DatagramTest.processIntCommand(lCmd, COMMAND_REPORT_INTERVAL, 100000));
                pConfig.setTickInterval(DatagramTest.processIntCommand(lCmd, COMMAND_TICK_INTERVAL, 1000));
                pConfig.setBufferPackets(DatagramTest.processIntCommand(lCmd, COMMAND_TX_PACKET_BUFFER_SIZE, 16));
                pConfig.setRate(DatagramTest.processIntCommand(lCmd, COMMAND_TX_RATE, -1));
                pConfig.setIterationLimit(DatagramTest.processIntCommand(lCmd, COMMAND_TX_ITERATIONS, -1));
                pConfig.setDurationLimitMs(DatagramTest.processLongCommand(lCmd, COMMAND_TX_DURATION_MS, -1L));
                if (lSwitches.contains(SWITCH_POLITE)) {
                    startFlag = new StartFlag();
                }
            }
            if (lSwitches.contains(SWITCH_RAND)) {
                lConfig.setPayload(-lConfig.getPayload());
                pConfig.setPayload(-pConfig.getPayload());
            }
            if (lCmd.isEmpty()) {
                DatagramTest.showInstructions();
                DatagramTest.out();
                DatagramTest.out("running with all default values...");
                DatagramTest.out();
            }
        }
        catch (Throwable e) {
            DatagramTest.err();
            DatagramTest.err(e);
            DatagramTest.err();
            DatagramTest.showInstructions();
            return;
        }
        if (!DatagramTest.checkUnicast(addrLocal) || !lConfig.check() || pConfig != null && !pConfig.check()) {
            DatagramTest.showInstructions();
            return;
        }
        try {
            DatagramSocket socket = new DatagramSocket(addrLocal);
            socket.setSoTimeout(cTimeoutMs);
            DatagramListener listener = new DatagramListener(socket, startFlag, lConfig);
            if (pConfig != null) {
                DatagramPublisher publisher = new DatagramPublisher(socket, startFlag, pConfig);
                Thread thPublisher = DatagramTest.makeThread(null, publisher, "TestPublisher");
                Thread thListener = DatagramTest.makeThread(null, listener, "TestListener");
                thListener.setDaemon(true);
                thListener.start();
                thPublisher.setDaemon(true);
                thPublisher.start();
                long cDurationLimitMs = pConfig.getDurationLimitMs();
                if (cDurationLimitMs > 0L) {
                    if (startFlag != null) {
                        startFlag.waitForGo();
                    }
                    thPublisher.join(cDurationLimitMs);
                    return;
                }
                thPublisher.join();
            } else {
                listener.run();
            }
        }
        catch (Exception e) {
            DatagramTest.err("An exception occurred while executing the DatagramTest:");
            DatagramTest.err(e);
            return;
        }
    }

    protected static List extractSwitches(Collection colArg, String[] asValidSwitch) {
        LinkedList<String> lResult = new LinkedList<String>();
        int c = asValidSwitch.length;
        for (int i = 0; i < c; ++i) {
            String sSwitch = "-" + asValidSwitch[i];
            Iterator iter = colArg.iterator();
            while (iter.hasNext()) {
                String sArg = (String)iter.next();
                if (!sArg.equals(sSwitch)) continue;
                lResult.add(asValidSwitch[i]);
                iter.remove();
            }
        }
        return lResult;
    }

    protected static Object processCommand(Map mapCommands, String sName) throws UnsupportedOperationException {
        Object value = mapCommands.get(sName);
        if (value == null) {
            throw new UnsupportedOperationException("-" + sName + " must be specified.");
        }
        return value;
    }

    protected static Object processCommand(Map mapCommands, String sName, Object oDefault) throws UnsupportedOperationException {
        Object value = mapCommands.get(sName);
        return value == null ? oDefault : value;
    }

    protected static int processIntCommand(Map mapCommands, String sName, int iDefault) throws UnsupportedOperationException {
        Object value = mapCommands.get(sName);
        return value == null ? iDefault : Integer.parseInt((String)value);
    }

    protected static int processIntCommand(Map mapCommands, String sName) throws UnsupportedOperationException {
        Object value = DatagramTest.processCommand(mapCommands, sName);
        return Integer.parseInt((String)value);
    }

    protected static long processLongCommand(Map mapCommands, String sName, long lDefault) throws UnsupportedOperationException {
        Object value = mapCommands.get(sName);
        return value == null ? lDefault : Long.parseLong((String)value);
    }

    protected static InetSocketAddress translateAddress(String sAddr) throws UnknownHostException {
        int iIndex = sAddr.lastIndexOf(58);
        int iPort = 9999;
        if (iIndex != -1) {
            iPort = Integer.parseInt(sAddr.substring(iIndex + 1));
            sAddr = sAddr.substring(0, iIndex);
        }
        if (sAddr.equals("*")) {
            return new InetSocketAddress(iPort);
        }
        if (sAddr.equals(DEFAULT_IP_LOCAL) || sAddr.length() == 0) {
            return new InetSocketAddress(InetAddress.getLocalHost(), iPort);
        }
        return new InetSocketAddress(sAddr, iPort);
    }

    public static boolean checkProcessPacketBytes(int cbPacket, int cProcessPacketBytes) {
        if (cProcessPacketBytes < 4 || cProcessPacketBytes % 4 != 0 || cProcessPacketBytes > cbPacket) {
            DatagramTest.err("processPacketBytes must be between 4 and the packet size, in multiples of 4.");
            return false;
        }
        return true;
    }

    private static boolean checkUnicast(InetSocketAddress addr) {
        InetAddress iAddr = addr.getAddress();
        if (iAddr != null && iAddr.isMulticastAddress()) {
            DatagramTest.err("Interface address " + addr + " is multi-cast; it must be an IP address bound to a physical interface");
            return false;
        }
        return true;
    }

    private static boolean checkUnicast(InetSocketAddress[] aAddr) {
        int c = aAddr.length;
        for (int i = 0; i < c; ++i) {
            if (DatagramTest.checkUnicast(aAddr[i])) continue;
            return false;
        }
        return true;
    }

    public static String computeThroughputMBPerSec(long cBytes, long lDurationMs) {
        if (lDurationMs == 0L) {
            return "NaN";
        }
        float flMBs = (float)cBytes / 1048576.0f;
        int iThpt = Math.round(flMBs / (float)lDurationMs * 1000.0f);
        return Integer.toString(iThpt) + " MB/sec";
    }

    public static String computeThroughputPacketsPerSec(int cPackets, long lDurationMs) {
        if (lDurationMs == 0L) {
            return "NaN";
        }
        int iThpt = Math.round((float)cPackets / (float)lDurationMs * 1000.0f);
        return Integer.toString(iThpt) + " packets/sec";
    }

    protected static void showInstructions() {
        DatagramTest.out();
        DatagramTest.out("java com.tangosol.net.DatagramTest <-local addr:port> [commands ...] [addr:port ...]");
        DatagramTest.out();
        DatagramTest.out("command option descriptions:");
        DatagramTest.out("\t-local          (optional) the local address to bind to, specified as addr:port, default localhost:9999");
        DatagramTest.out("\t-packetSize     (optional) the size of packet to work with, specified in bytes, default 1468");
        DatagramTest.out("\t-payload        (optional) the amount of data to include in each packet, 0 to match packet size, default 0");
        DatagramTest.out("\t-processBytes   (optional) the number of bytes (in multiples of 4) of each packet to process, default 4");
        DatagramTest.out("\t-rxBufferSize   (optional) the size of the receive buffer, specified in packets, default 1428");
        DatagramTest.out("\t-rxTimeoutMs    (optional) the durtaion of inactivity before a connection is closed, default 1000");
        DatagramTest.out("\t-txBufferSize   (optional) the size of the transmit buffer, specified in packets, default 16");
        DatagramTest.out("\t-txRate         (optional) the rate at which to transmit data, specified in megabytes, default unlimited");
        DatagramTest.out("\t-txIterations   (optional) specifies the number of packets to publish before exiting, default unlimited");
        DatagramTest.out("\t-txDurationMs   (optional) specifies how long to publish before exiting, default unlimited");
        DatagramTest.out("\t-reportInterval (optional) the interval at which to output a report, specified in packets, default 100000");
        DatagramTest.out("\t-tickInterval   (optional) the interval at which to output tick marks, default 1000");
        DatagramTest.out("\t-log            (optional) the name of a file to save a tabular report of measured performance, default none");
        DatagramTest.out("\t-logInterval    (optional) the interval at which to output a measurement to the log, default 100000");
        DatagramTest.out("\t-polite         (optional) switch indicating if the publisher should wait for the listener to be contacted before publishing.");
        DatagramTest.out("\targuments       (optional) space separated list of addresses to publish to, specified as addr:port");
        DatagramTest.out();
        DatagramTest.out("examples:");
        DatagramTest.out("java com.tangosol.net.DatagramTest -local box1:9999 -packetSize 1468 -polite box2:9999");
        DatagramTest.out("java com.tangosol.net.DatagramTest -local box2:9999 -packetSize 1468 box1:9999");
    }

    protected static class StartFlag {
        protected volatile boolean m_fGo;

        protected StartFlag() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void go() {
            StartFlag startFlag = this;
            synchronized (startFlag) {
                this.m_fGo = true;
                this.notifyAll();
            }
        }

        public void stop() {
            this.m_fGo = false;
        }

        public boolean isStopped() {
            return !this.m_fGo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForGo() throws InterruptedException {
            StartFlag startFlag = this;
            synchronized (startFlag) {
                while (!this.m_fGo) {
                    this.wait();
                }
            }
        }
    }

    protected static class PacketTracker {
        protected SocketAddress m_addrSender;
        protected int m_cPacketsRcvd;
        protected long m_lStartTime;
        protected long m_lLastPacketArrivalTime;
        protected int m_nMin;
        protected int m_nMax;
        protected int m_nNext;
        protected int m_cOutOfOrder;
        protected long m_cTotalOutOfOrderOffset;
        protected long m_cBytesReceived;
        protected long m_cGaps;
        protected long m_cGapPackets;
        protected long m_cGapMillis;

        public PacketTracker(SocketAddress addrSender) {
            this.m_addrSender = addrSender;
            this.reset(System.currentTimeMillis());
        }

        public void trackArrival(int nCurrent, int cBytes) {
            long ldtNow = System.currentTimeMillis();
            ++this.m_cPacketsRcvd;
            if (this.m_cPacketsRcvd == 1) {
                this.m_nMin = this.m_nMax = nCurrent;
            } else if (nCurrent > this.m_nMax) {
                this.m_nMax = nCurrent;
            } else if (nCurrent < this.m_nMin) {
                this.m_nMin = nCurrent;
            }
            if (this.m_cPacketsRcvd > 1) {
                if (nCurrent < this.m_nNext) {
                    ++this.m_cOutOfOrder;
                    this.m_cTotalOutOfOrderOffset += (long)Math.abs(this.m_cPacketsRcvd - (nCurrent - this.m_nMin + 1));
                } else if (nCurrent > this.m_nNext) {
                    ++this.m_cGaps;
                    this.m_cGapPackets += (long)(nCurrent - this.m_nNext);
                    this.m_cGapMillis += ldtNow - this.m_lLastPacketArrivalTime;
                }
            }
            this.m_lLastPacketArrivalTime = ldtNow;
            this.m_nNext = this.m_nMax + 1;
            this.m_cBytesReceived += (long)cBytes;
        }

        public void reset(long lTimeMs) {
            this.m_cPacketsRcvd = 0;
            this.m_lStartTime = lTimeMs;
            this.m_lLastPacketArrivalTime = lTimeMs;
            this.m_nMin = 0;
            this.m_nMax = -1;
            this.m_nNext = 0;
            this.m_cOutOfOrder = 0;
            this.m_cTotalOutOfOrderOffset = 0L;
            this.m_cBytesReceived = 0L;
            this.m_cGaps = 0L;
            this.m_cGapPackets = 0L;
            this.m_cGapMillis = 0L;
        }

        public long computeDurationMillis() {
            return this.m_lLastPacketArrivalTime - this.m_lStartTime;
        }

        public int computeSentPackets() {
            return this.m_nMax - this.m_nMin + 1;
        }

        public int computeMissingPackets() {
            return this.computeSentPackets() - this.m_cPacketsRcvd;
        }

        public long computeAverageOutOfOrderOffset() {
            return this.m_cOutOfOrder == 0 ? 0L : this.m_cTotalOutOfOrderOffset / (long)this.m_cOutOfOrder;
        }

        public float computeSuccessRate() {
            int cSent = this.computeSentPackets();
            if (cSent == 0) {
                return 0.0f;
            }
            return (float)this.m_cPacketsRcvd / (float)this.computeSentPackets();
        }

        public int computeThroughputMBPerSec() {
            long lDuration = this.computeDurationMillis();
            if (lDuration == 0L) {
                return -1;
            }
            float flMBs = (float)this.m_cBytesReceived / 1048576.0f;
            return Math.round(flMBs / (float)lDuration * 1000.0f);
        }

        public int computeThroughputPacketsPerSec() {
            long lDuration = this.computeDurationMillis();
            if (lDuration == 0L) {
                return -1;
            }
            return Math.round((float)this.m_cPacketsRcvd / (float)lDuration * 1000.0f);
        }

        public int computeAveragePacketSize() {
            if (this.m_cPacketsRcvd == 0) {
                return 0;
            }
            return (int)(this.m_cBytesReceived / (long)this.m_cPacketsRcvd);
        }

        public static String getTabularReportHeader() {
            return "publisher\t" + "duration ms\t" + "packet size\t" + "throughput mb/sec\t" + "throughput packets/sec\t" + "sent packets\t" + "received packets\t" + "missing packets\t" + "success rate\t" + "out of order\t" + "avg out of order offset\t" + "gaps\t" + "avg gap size\t" + "avg gap time ms";
        }

        public String getTabularReport() {
            return "" + this.m_addrSender + '\t' + this.computeDurationMillis() + '\t' + this.computeAveragePacketSize() + '\t' + this.computeThroughputMBPerSec() + '\t' + this.computeThroughputPacketsPerSec() + '\t' + this.computeSentPackets() + '\t' + this.m_cPacketsRcvd + '\t' + this.computeMissingPackets() + '\t' + this.computeSuccessRate() + '\t' + this.m_cOutOfOrder + '\t' + this.computeAverageOutOfOrderOffset() + this.m_cGaps + '\t' + this.m_cGapPackets / Math.max(1L, this.m_cGaps) + '\t' + this.m_cGapMillis / Math.max(1L, this.m_cGaps);
        }

        public String toString() {
            long lDurationMs = this.computeDurationMillis();
            int cSent = this.computeSentPackets();
            return new StringBuffer().append("Rx from publisher: ").append(this.m_addrSender).append("\n\t     elapsed: ").append(lDurationMs).append("ms").append("\n\t packet size: ").append(this.computeAveragePacketSize()).append("\n\t  throughput: ").append(DatagramTest.computeThroughputMBPerSec(this.m_cBytesReceived, lDurationMs)).append("\n\t              ").append(DatagramTest.computeThroughputPacketsPerSec(this.m_cPacketsRcvd, lDurationMs)).append("\n\t    received: ").append(this.m_cPacketsRcvd).append(" of ").append(cSent).append("\n\t     missing: ").append(this.computeMissingPackets()).append("\n\tsuccess rate: ").append(this.computeSuccessRate()).append("\n\tout of order: ").append(this.m_cOutOfOrder).append("\n\t  avg offset: ").append(this.computeAverageOutOfOrderOffset()).append("\n\t        gaps: ").append(this.m_cGaps).append("\n\tavg gap size: ").append(this.m_cGapPackets / Math.max(1L, this.m_cGaps)).append("\n\tavg gap time: ").append(this.m_cGapMillis / Math.max(1L, this.m_cGaps)) + "ms".toString();
        }

        public static String toString(PacketTracker[] aTracker) {
            long lStartTime = Long.MAX_VALUE;
            long lLastTime = 0L;
            long cBytes = 0L;
            int cOutOfOrder = 0;
            int cTotalOutOfOrderOffset = 0;
            int cRcvd = 0;
            int cSent = 0;
            long cGaps = 0L;
            int cGapPackets = 0;
            int cGapMillis = 0;
            int c = aTracker.length;
            for (int i = 0; i < c; ++i) {
                PacketTracker tracker = aTracker[i];
                if (tracker.m_lStartTime < lStartTime) {
                    lStartTime = tracker.m_lStartTime;
                }
                if (tracker.m_lLastPacketArrivalTime > lLastTime) {
                    lLastTime = tracker.m_lLastPacketArrivalTime;
                }
                cSent += tracker.m_nMax - tracker.m_nMin + 1;
                cRcvd += tracker.m_cPacketsRcvd;
                cBytes += tracker.m_cBytesReceived;
                cOutOfOrder += tracker.m_cOutOfOrder;
                cTotalOutOfOrderOffset = (int)((long)cTotalOutOfOrderOffset + tracker.m_cTotalOutOfOrderOffset);
                cGaps += tracker.m_cGaps;
                cGapPackets = (int)((long)cGapPackets + tracker.m_cGapPackets);
                cGapMillis = (int)((long)cGapMillis + tracker.m_cGapMillis);
            }
            long lDurationMs = lLastTime - lStartTime;
            int iAvgOffset = cTotalOutOfOrderOffset / cRcvd;
            String sThptMB = DatagramTest.computeThroughputMBPerSec(cBytes, lDurationMs);
            String sThptPk = DatagramTest.computeThroughputPacketsPerSec(cRcvd, lDurationMs);
            return new StringBuffer().append("Rx Summary from " + aTracker.length + " publisher(s): ").append("\n\t     elapsed: ").append(lDurationMs).append("ms").append("\n\t  throughput: ").append(sThptMB).append("\n\t              ").append(sThptPk).append("\n\t    received: ").append(cRcvd).append(" of ").append(cSent).append("\n\t     missing: ").append(cSent - cRcvd).append("\n\tsuccess rate: ").append((float)cRcvd / (float)cSent).append("\n\tout of order: ").append(cOutOfOrder).append("\n\t  avg offset: ").append(iAvgOffset).append("\n\t        gaps: ").append(cGaps).append("\n\tavg gap size: ").append((long)cGapPackets / Math.max(1L, cGaps)).append("\n\tavg gap time: ").append((long)cGapMillis / Math.max(1L, cGaps)) + "ms".toString();
        }

        public static void generateReport(String sPeriod, Map mapTracker) {
            Base.out();
            Base.out(sPeriod);
            Iterator iter = mapTracker.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Base.out(entry.getValue() + "\n");
            }
            if (mapTracker.size() > 1) {
                Base.out(PacketTracker.toString(mapTracker.values().toArray(new PacketTracker[0])));
            }
        }
    }

    public static class DatagramListener
    extends Base
    implements Runnable {
        protected DatagramSocket m_socket;
        protected StartFlag m_startFlag;
        protected ListenerConfig m_config;
        protected PrintStream m_pstreamLog;

        public DatagramListener(DatagramSocket socket, StartFlag startFlag, ListenerConfig config) throws IOException {
            int cbBufferSize = config.m_cbPacket * config.m_cBufferPackets;
            socket.setReceiveBufferSize(cbBufferSize);
            int iRcvSize = socket.getReceiveBufferSize();
            if (iRcvSize < cbBufferSize) {
                throw new IllegalArgumentException("Receieve buffer size setting was not accepted by the OS, the buffer is only " + iRcvSize + " bytes, or " + iRcvSize / config.m_cbPacket + " packets, " + " please increase your OS socket buffer limits or use the " + " -" + DatagramTest.COMMAND_RX_PACKET_BUFFER_SIZE + " test parameter to request a smaller buffer.");
            }
            String sLog = config.m_sLog;
            if (sLog != null) {
                if (sLog.equals("stdout")) {
                    this.m_pstreamLog = System.out;
                    this.logHeader();
                } else if (sLog.equals("stderr")) {
                    this.m_pstreamLog = System.err;
                    this.logHeader();
                } else {
                    File fLog = new File(sLog);
                    boolean fNewFile = !fLog.exists();
                    this.m_pstreamLog = new PrintStream(new FileOutputStream(fLog, true));
                    if (fNewFile) {
                        this.logHeader();
                    }
                }
            }
            this.m_config = config;
            this.m_startFlag = startFlag;
            this.m_socket = socket;
        }

        /*
         * Unable to fully structure code
         */
        public void run() {
            socket = this.m_socket;
            cProcessPacketBytes = this.m_config.m_cProcessPacketBytes;
            cReportInterval = this.m_config.m_cReportInterval;
            cbPacket = this.m_config.m_cbPacket;
            cbPayload = this.m_config.m_cbPayload;
            DatagramListener.out("starting listener: at " + socket.getLocalSocketAddress());
            DatagramListener.out(this.m_config);
            DatagramListener.out();
            try {
                cTickInterval = this.m_config.m_cTickInterval;
                cBigTickInterval = cTickInterval * 10;
                packet = new DatagramPacket(new byte[cbPacket], 0, cbPacket);
                startFlag = this.m_startFlag;
                bStream = new ByteArrayInputStream(packet.getData());
                stream = new DataInputStream(bStream);
                cRxPackets = 0;
                mapLifeTracker = new HashMap<SocketAddress, PacketTracker>();
                mapNowTracker = new HashMap<SocketAddress, PacketTracker>();
                cLogInterval = this.m_config.getLogInterval();
                block4: while (true) {
                    try {
                        socket.receive(packet);
                    }
                    catch (InterruptedIOException e) {
                        if (mapLifeTracker.size() <= 0) continue;
                        DatagramListener.out("\nClients have stopped.");
                        PacketTracker.generateReport("Lifetime:", mapLifeTracker);
                        this.log(mapLifeTracker);
                        mapLifeTracker.clear();
                        mapNowTracker.clear();
                        cRxPackets = 0;
                        startFlag = this.m_startFlag;
                        if (startFlag == null) continue;
                        startFlag.stop();
                        continue;
                    }
                    ++cRxPackets;
                    bStream.reset();
                    if (startFlag != null) {
                        startFlag.go();
                        startFlag = null;
                    }
                    addrSender = packet.getSocketAddress();
                    lifeTracker = (PacketTracker)mapLifeTracker.get(addrSender);
                    nowTracker = (PacketTracker)mapNowTracker.get(addrSender);
                    if (lifeTracker == null) {
                        lifeTracker = new PacketTracker(addrSender);
                        nowTracker = new PacketTracker(addrSender);
                        mapLifeTracker.put(addrSender, lifeTracker);
                        mapNowTracker.put(addrSender, nowTracker);
                        DatagramListener.out("\nRecieving data from " + mapLifeTracker.size() + " publisher(s).");
                    }
                    nCurrent = 0;
                    nBytes = cbPayload < 0 ? packet.getLength() : Math.min(cbPayload, packet.getLength());
                    nProcess = cProcessPacketBytes < nBytes ? cProcessPacketBytes : nBytes;
                    c = nProcess / 4;
                    for (i = 0; i < c; ++i) {
                        n = stream.readInt();
                        if (i == 0) {
                            nCurrent = n;
                            lifeTracker.trackArrival(nCurrent, nBytes);
                            nowTracker.trackArrival(nCurrent, nBytes);
                            continue;
                        }
                        if (n == nCurrent) continue;
                        if (n == 0) {
                            if (cRxPackets % 10000 != 0) break;
                            DatagramListener.out("the packet is not full, configure plubisher to process the same number of bytes");
                            break;
                        }
                        DatagramListener.err("corrupted packet from " + addrSender + " at i=" + i + ", n=" + n + ", nCurrent=" + nCurrent);
                        break;
                    }
                    if (cTickInterval != 0 && cRxPackets % cTickInterval == 0) {
                        System.out.print(cRxPackets % cBigTickInterval == 0 ? 'I' : 'i');
                        System.out.flush();
                    }
                    if (cLogInterval != 0 && cRxPackets % cLogInterval == 0) {
                        this.log(mapLifeTracker);
                    }
                    if (cReportInterval == 0 || cRxPackets % cReportInterval != 0) continue;
                    PacketTracker.generateReport("Lifetime:", mapLifeTracker);
                    PacketTracker.generateReport("Now:", mapNowTracker);
                    iter = mapNowTracker.values().iterator();
                    while (true) {
                        if (iter.hasNext()) ** break;
                        continue block4;
                        ((PacketTracker)iter.next()).reset(System.currentTimeMillis());
                    }
                    break;
                }
            }
            catch (Exception e) {
                DatagramListener.err("test encounted exception:");
                DatagramListener.err(e);
                return;
            }
        }

        protected void logHeader() {
            this.m_pstreamLog.println(PacketTracker.getTabularReportHeader());
        }

        protected void log(Map mapTracker) {
            Iterator iter = mapTracker.values().iterator();
            while (iter.hasNext()) {
                this.log((PacketTracker)iter.next());
            }
        }

        protected void log(PacketTracker tracker) {
            if (this.m_pstreamLog != null) {
                this.m_pstreamLog.println(tracker.getTabularReport());
            }
        }
    }

    public static class DatagramPublisher
    extends Base
    implements Runnable {
        protected DatagramSocket m_socket;
        protected PublisherConfig m_config;
        protected StartFlag m_startFlag;

        public DatagramPublisher(DatagramSocket socket, StartFlag startFlag, PublisherConfig config) throws IOException {
            socket.setSendBufferSize(config.getPacketSize() * config.getBufferPackets());
            this.m_config = config;
            this.m_socket = socket;
            this.m_startFlag = startFlag;
        }

        public void run() {
            InetSocketAddress[] aAddrPeer = this.m_config.getAddrPeers();
            int cPeer = aAddrPeer.length;
            int cbPacket = this.m_config.getPacketSize();
            int cbPayload = this.m_config.getPayload();
            int cReportInterval = this.m_config.getReportInterval();
            int cProcessPacketBytes = this.m_config.getProcessPacketBytes();
            int cRate = this.m_config.getRate();
            StartFlag startFlag = this.m_startFlag;
            DatagramSocket socket = this.m_socket;
            StringBuffer sbAddrs = new StringBuffer();
            for (int i = 0; i < cPeer; ++i) {
                if (i > 0) {
                    sbAddrs.append(", ");
                }
                sbAddrs.append(aAddrPeer[i].toString());
            }
            DatagramPublisher.out("starting publisher: at " + socket.getLocalSocketAddress() + " sending to " + sbAddrs);
            DatagramPublisher.out(this.m_config);
            DatagramPublisher.out();
            int cRateBytes = cRate * 0x100000;
            int cAvgPacket = cbPayload < 0 ? cbPacket + cbPayload / 2 : cbPayload;
            int iPktsPerSecond = Math.round((float)cRateBytes / (float)cAvgPacket);
            int iBurstPackets = iPktsPerSecond / 100;
            if (cRateBytes > 0) {
                DatagramPublisher.out("setting packet burst to " + iBurstPackets);
            } else {
                DatagramPublisher.out("no packet burst limit");
            }
            try {
                long lStart;
                byte[] aBytes = new byte[cbPacket];
                DatagramPacket packet = new DatagramPacket(aBytes, 0, cbPacket);
                DataOutputStream stream = new DataOutputStream(new DatagramPacketOutputStream(packet));
                int cTxPackets = 0;
                long cTxBytes = 0L;
                int cTickInterval = this.m_config.getTickInterval();
                int cBigTickInterval = cTickInterval * 10;
                long lLastRateCheckTime = lStart = System.currentTimeMillis();
                long lLastReportTime = lStart;
                int cThisReportTxBytes = 0;
                int cThisReportTxPackets = 0;
                int cIterationLimit = this.m_config.getIterationLimit();
                Random random = new Random();
                int iIter = 1;
                while (true) {
                    int nBytes;
                    if (startFlag != null && startFlag.isStopped()) {
                        DatagramPublisher.out("waiting for listener to be contacted before publishing");
                        try {
                            this.m_startFlag.waitForGo();
                        }
                        catch (InterruptedException e) {
                            DatagramPublisher.err("Interrupted while waiting to start publishing");
                            return;
                        }
                    }
                    if (cIterationLimit > 0 && iIter % cIterationLimit == 0) {
                        DatagramPublisher.out("iteration limit reached");
                        return;
                    }
                    int cInts = cProcessPacketBytes / 4;
                    for (int i = 0; i < cInts; ++i) {
                        stream.writeInt(iIter);
                    }
                    stream.flush();
                    if (cbPayload < 0) {
                        nBytes = cbPacket - random.nextInt(-cbPayload);
                        packet.setLength(nBytes);
                    } else {
                        nBytes = cbPayload;
                        packet.setLength(cbPacket);
                    }
                    for (int i = 0; i < cPeer; ++i) {
                        long lNow;
                        packet.setAddress(aAddrPeer[i].getAddress());
                        packet.setPort(aAddrPeer[i].getPort());
                        socket.send(packet);
                        ++cThisReportTxPackets;
                        cTxBytes += (long)nBytes;
                        cThisReportTxBytes += nBytes;
                        if (cTickInterval != 0 && ++cTxPackets % cTickInterval == 0) {
                            System.out.print(cTxPackets % cBigTickInterval == 0 ? (char)'O' : 'o');
                            System.out.flush();
                        }
                        if (cReportInterval != 0 && cTxPackets % cReportInterval == 0) {
                            lNow = System.currentTimeMillis();
                            long lDuration = lNow - lStart;
                            long lLastDuration = lNow - lLastReportTime;
                            StringBuffer sbReport = new StringBuffer();
                            sbReport.append("\nTx summary ").append(cPeer).append(" peers:").append("\n   life: ").append(DatagramTest.computeThroughputMBPerSec(cTxBytes, lDuration)).append(", ").append(DatagramTest.computeThroughputPacketsPerSec(cTxPackets, lDuration)).append("\n    now: ").append(DatagramTest.computeThroughputMBPerSec(cThisReportTxBytes, lLastDuration)).append(", ").append(DatagramTest.computeThroughputPacketsPerSec(cThisReportTxPackets, lLastDuration));
                            if (cRateBytes > 0) {
                                sbReport.append(", packets/burst: ").append(iBurstPackets).append(", bursts/second: ").append((float)iPktsPerSecond / (float)iBurstPackets);
                            }
                            DatagramPublisher.out(sbReport.toString());
                            lLastReportTime = lNow;
                            cThisReportTxPackets = 0;
                            cThisReportTxBytes = 0;
                        }
                        if (cRateBytes <= 0) continue;
                        if (cTxPackets % iBurstPackets == 0) {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException x) {
                                // empty catch block
                            }
                        }
                        if (cTxPackets % iPktsPerSecond != 0) continue;
                        lNow = System.currentTimeMillis();
                        long lDelta = lNow - lLastRateCheckTime;
                        lLastRateCheckTime = lNow;
                        float flPct = (float)lDelta / 1000.0f;
                        iBurstPackets = Math.round((float)iBurstPackets * flPct);
                    }
                    stream.close();
                    ++iIter;
                }
            }
            catch (Exception e) {
                DatagramPublisher.out("test encounted exception:");
                DatagramPublisher.out(e);
                return;
            }
        }
    }

    public static class ListenerConfig
    extends TestConfiguration {
        protected String m_sLog;
        protected int m_cLogInterval;

        public String toString() {
            return super.toString() + '\n' + "        log: " + this.m_sLog + '\n' + "     log on: " + this.m_cLogInterval * this.m_cbPacket / 0x100000 + " MBs";
        }

        public String getLog() {
            return this.m_sLog;
        }

        public void setLog(String sLog) {
            this.m_sLog = sLog;
        }

        public int getLogInterval() {
            return this.m_cLogInterval;
        }

        public void setLogInterval(int cLogInterval) {
            this.m_cLogInterval = cLogInterval;
        }
    }

    public static class PublisherConfig
    extends TestConfiguration {
        protected InetSocketAddress[] m_aAddrPeer;
        protected int m_cRate;
        protected int m_cIterationLimit;
        protected long m_cDurationLimitMs;

        public String toString() {
            return super.toString() + '\n' + "      peers: " + this.m_aAddrPeer.length + '\n' + "       rate: " + (this.m_cRate > 0 ? Integer.toString(this.m_cRate) : "no limit");
        }

        public boolean check() {
            return super.check() & DatagramTest.checkUnicast(this.m_aAddrPeer);
        }

        public InetSocketAddress[] getAddrPeers() {
            return this.m_aAddrPeer;
        }

        public void setAddrPeers(InetSocketAddress[] aAddrPeer) {
            this.m_aAddrPeer = aAddrPeer;
        }

        public int getRate() {
            return this.m_cRate;
        }

        public void setRate(int cRate) {
            this.m_cRate = cRate;
        }

        public int getIterationLimit() {
            return this.m_cIterationLimit;
        }

        public void setIterationLimit(int cIterations) {
            this.m_cIterationLimit = cIterations;
        }

        public long getDurationLimitMs() {
            return this.m_cDurationLimitMs;
        }

        public void setDurationLimitMs(long cDurationMs) {
            this.m_cDurationLimitMs = cDurationMs;
        }
    }

    public static class TestConfiguration {
        protected int m_cReportInterval;
        protected int m_cTickInterval;
        protected int m_cbPacket;
        protected int m_cbPayload;
        protected int m_cProcessPacketBytes;
        protected int m_cBufferPackets;

        public String toString() {
            return "packet size: " + this.m_cbPacket + " bytes" + '\n' + "buffer size: " + this.m_cBufferPackets + " packets" + '\n' + "  report on: " + this.m_cReportInterval + " packets, " + this.m_cReportInterval * this.m_cbPacket / 0x100000 + " MBs" + '\n' + "    process: " + this.m_cProcessPacketBytes + " bytes/packet";
        }

        public boolean check() {
            return DatagramTest.checkProcessPacketBytes(this.m_cbPacket, this.m_cProcessPacketBytes);
        }

        public int getReportInterval() {
            return this.m_cReportInterval;
        }

        public void setReportInterval(int cReportInterval) {
            this.m_cReportInterval = cReportInterval;
        }

        public int getTickInterval() {
            return this.m_cTickInterval;
        }

        public void setTickInterval(int cTickInterval) {
            this.m_cTickInterval = cTickInterval;
        }

        public int getPacketSize() {
            return this.m_cbPacket;
        }

        public void setPacketSize(int cbPacket) {
            this.m_cbPacket = cbPacket;
        }

        public int getPayload() {
            return this.m_cbPayload;
        }

        public void setPayload(int cbPayload) {
            if (cbPayload == 0) {
                cbPayload = this.m_cbPacket;
            } else if (cbPayload > this.m_cbPacket) {
                throw new IllegalArgumentException("Payload cannot exceed packet size.");
            }
            this.m_cbPayload = cbPayload;
        }

        public int getProcessPacketBytes() {
            return this.m_cProcessPacketBytes;
        }

        public void setProcessPacketBytes(int cProcessPacketBytes) {
            this.m_cProcessPacketBytes = cProcessPacketBytes;
        }

        public int getBufferPackets() {
            return this.m_cBufferPackets;
        }

        public void setBufferPackets(int cBufferPackets) {
            this.m_cBufferPackets = cBufferPackets;
        }
    }
}

