/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.net.CacheFactory;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.DefaultConfigurableCacheFactory;
import com.tangosol.net.Service;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DefaultCacheServer
extends Base {
    protected static volatile boolean s_fShutdown;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] asArg) {
        Class LOCK;
        DefaultConfigurableCacheFactory factory;
        try {
            factory = (DefaultConfigurableCacheFactory)CacheFactory.getConfigurableCacheFactory();
        }
        catch (ClassCastException e) {
            DefaultCacheServer.out("Unable to use " + CacheFactory.getConfigurableCacheFactory().getClass());
            return;
        }
        if (asArg.length > 0) {
            factory.setConfig(DefaultConfigurableCacheFactory.loadConfig(asArg[0]));
        }
        CacheFactory.setConfigurableCacheFactory(factory);
        Runtime.getRuntime().addShutdownHook(DefaultCacheServer.makeThread(null, new ShutdownProcess(), null));
        DefaultCacheServer.start(factory);
        CacheFactory.log("Started DefaultCacheServer...\n\n" + CacheFactory.getCluster() + '\n', 3);
        int cWaitSec = 5;
        try {
            cWaitSec = Math.max(0, Integer.parseInt(asArg[1]));
        }
        catch (Exception e) {
            // empty catch block
        }
        Class clazz = LOCK = DefaultCacheServer.class;
        synchronized (clazz) {
            while (true) {
                try {
                    LOCK.wait((long)cWaitSec * 1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (s_fShutdown) break;
                try {
                    DefaultCacheServer.start(factory);
                }
                catch (Throwable e) {
                    CacheFactory.log("Failed to restart services: " + e, 1);
                }
            }
        }
    }

    public static List start() {
        return DefaultCacheServer.start(CacheFactory.getConfigurableCacheFactory());
    }

    public static List start(ConfigurableCacheFactory factory) {
        if (!(factory instanceof DefaultConfigurableCacheFactory)) {
            throw new UnsupportedOperationException("Unable to use " + factory.getClass());
        }
        LinkedList<Service> list = new LinkedList<Service>();
        XmlElement xmlConfig = factory.getConfig();
        Iterator iter = xmlConfig.getSafeElement("caching-schemes").getElementList().iterator();
        while (iter.hasNext()) {
            Service service;
            XmlElement xmlScheme = (XmlElement)iter.next();
            if (!xmlScheme.getSafeElement("autostart").getBoolean() || list.contains(service = ((DefaultConfigurableCacheFactory)factory).ensureService(xmlScheme))) continue;
            list.add(service);
        }
        return list;
    }

    public static void startDaemon() {
        Thread thread = DefaultCacheServer.makeThread(null, new Runnable(){

            public void run() {
                DefaultCacheServer.main(new String[0]);
            }
        }, "DefaultCacheServer");
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Class LOCK;
        Class clazz = LOCK = DefaultCacheServer.class;
        synchronized (clazz) {
            s_fShutdown = true;
            CacheFactory.shutdown();
            LOCK.notifyAll();
        }
    }

    protected static class ShutdownProcess
    implements Runnable {
        protected ShutdownProcess() {
        }

        public void run() {
            s_fShutdown = true;
        }
    }
}

