/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.io.AsyncBinaryStore;
import com.tangosol.io.AsyncBinaryStoreManager;
import com.tangosol.io.BinaryStore;
import com.tangosol.io.BinaryStoreManager;
import com.tangosol.io.bdb.BerkeleyDBBinaryStoreManager;
import com.tangosol.io.lh.LHBinaryStore;
import com.tangosol.io.lh.LHBinaryStoreManager;
import com.tangosol.io.nio.AbstractBufferManager;
import com.tangosol.io.nio.BinaryMap;
import com.tangosol.io.nio.BinaryMapStore;
import com.tangosol.io.nio.DirectBufferManager;
import com.tangosol.io.nio.DirectStoreManager;
import com.tangosol.io.nio.MappedBufferManager;
import com.tangosol.io.nio.MappedStoreManager;
import com.tangosol.net.AbstractBackingMapManager;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.Cluster;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.Member;
import com.tangosol.net.NamedCache;
import com.tangosol.net.Service;
import com.tangosol.net.cache.AbstractBundler;
import com.tangosol.net.cache.BundlingNamedCache;
import com.tangosol.net.cache.CacheLoader;
import com.tangosol.net.cache.CacheStore;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.net.cache.MapCacheStore;
import com.tangosol.net.cache.NearCache;
import com.tangosol.net.cache.OldCache;
import com.tangosol.net.cache.OverflowMap;
import com.tangosol.net.cache.ReadWriteBackingMap;
import com.tangosol.net.cache.SerializationCache;
import com.tangosol.net.cache.SerializationMap;
import com.tangosol.net.cache.SerializationPagedCache;
import com.tangosol.net.cache.SimpleOverflowMap;
import com.tangosol.net.cache.SimpleSerializationMap;
import com.tangosol.net.cache.VersionedBackingMap;
import com.tangosol.net.cache.VersionedNearCache;
import com.tangosol.net.management.Registry;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.SimpleParser;
import com.tangosol.run.xml.XmlConfigurable;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.AbstractKeyBasedMap;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.LiteMap;
import com.tangosol.util.MapListener;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.Resources;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.WrapperConcurrentMap;
import com.tangosol.util.WrapperException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DefaultConfigurableCacheFactory
extends Base
implements ConfigurableCacheFactory {
    public static final String FILE_CFG_CACHE = "coherence-cache-config.xml";
    public static final String CACHE_NAME = "{cache-name}";
    public static final String CLASS_LOADER = "{class-loader}";
    public static final String MGR_CONTEXT = "{manager-context}";
    public static final String SCHEME_REF = "{scheme-ref}";
    public static final int SCHEME_UNKNOWN = 0;
    public static final int SCHEME_REPLICATED = 1;
    public static final int SCHEME_OPTIMISTIC = 2;
    public static final int SCHEME_DISTRIBUTED = 3;
    public static final int SCHEME_NEAR = 4;
    public static final int SCHEME_VERSIONED_NEAR = 5;
    public static final int SCHEME_LOCAL = 6;
    public static final int SCHEME_OVERFLOW = 7;
    public static final int SCHEME_DISK = 8;
    public static final int SCHEME_EXTERNAL = 9;
    public static final int SCHEME_EXTERNAL_PAGED = 10;
    public static final int SCHEME_CLASS = 11;
    public static final int SCHEME_READ_WRITE_BACKING = 12;
    public static final int SCHEME_VERSIONED_BACKING = 13;
    public static final int SCHEME_INVOCATION = 14;
    public static final int SCHEME_PROXY = 15;
    public static final int SCHEME_REMOTE_CACHE = 16;
    public static final int SCHEME_REMOTE_INVOCATION = 17;
    private XmlElement m_xmlConfig;
    protected ConcurrentMap m_mapByName = new WrapperConcurrentMap(new SafeHashMap(), false, -1L);
    private ThreadLocal m_tlo = new ThreadLocal();

    public DefaultConfigurableCacheFactory() {
        this(DefaultConfigurableCacheFactory.loadConfig(FILE_CFG_CACHE));
    }

    public DefaultConfigurableCacheFactory(String sPath) {
        this(DefaultConfigurableCacheFactory.loadConfig(sPath));
    }

    public DefaultConfigurableCacheFactory(String sPath, ClassLoader loader) {
        this(DefaultConfigurableCacheFactory.loadConfig(sPath, loader));
    }

    public DefaultConfigurableCacheFactory(XmlElement xmlConfig) {
        this.setConfig(xmlConfig);
    }

    public XmlElement getConfig() {
        return (XmlElement)this.m_xmlConfig.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfig(XmlElement xmlConfig) {
        ConcurrentMap mapByName = this.m_mapByName;
        mapByName.lock(ConcurrentMap.LOCK_ALL, -1L);
        try {
            xmlConfig = (XmlElement)xmlConfig.clone();
            XmlHelper.replaceSystemProperties(xmlConfig, "system-property");
            this.m_xmlConfig = xmlConfig;
            mapByName.clear();
        }
        finally {
            mapByName.unlock(ConcurrentMap.LOCK_ALL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamedCache ensureCache(String sCacheName, ClassLoader loader) {
        ConcurrentMap mapByName;
        Map mapByLoader;
        NamedCache cache = null;
        DefaultConfigurableCacheFactory.azzert(sCacheName != null);
        if (loader == null) {
            loader = DefaultConfigurableCacheFactory.getContextClassLoader();
        }
        if ((mapByLoader = (Map)(mapByName = this.m_mapByName).get(sCacheName)) != null) {
            try {
                cache = (NamedCache)mapByLoader.get(loader);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            if (cache != null && cache.isActive()) {
                return cache;
            }
        }
        mapByName.lock(sCacheName, -1L);
        try {
            mapByLoader = (Map)mapByName.get(sCacheName);
            if (mapByLoader == null) {
                mapByLoader = new LiteMap();
                mapByName.put(sCacheName, mapByLoader);
            } else {
                cache = (NamedCache)mapByLoader.get(loader);
                if (cache != null && cache.isActive()) {
                    NamedCache e = cache;
                    return e;
                }
                Iterator iter = mapByLoader.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    ClassLoader loaderTmp = (ClassLoader)entry.getKey();
                    NamedCache cacheTmp = (NamedCache)entry.getValue();
                    if (cacheTmp.isActive()) continue;
                    this.unregister(sCacheName, "tier=front,loader=" + (loaderTmp == null ? 0 : loaderTmp.hashCode()));
                    iter.remove();
                }
            }
            CacheInfo infoCache = this.findSchemeMapping(sCacheName);
            XmlElement xmlScheme = this.resolveScheme(infoCache);
            xmlScheme.addAttribute("tier").setString("front");
            this.pushCacheContext("tier=front,loader=" + (loader == null ? 0 : loader.hashCode()));
            cache = this.configureCache(infoCache, xmlScheme, loader);
            mapByLoader.put(loader, cache);
            NamedCache namedCache = cache;
            return namedCache;
        }
        finally {
            mapByName.unlock(sCacheName);
        }
    }

    public Service ensureService(String sServiceName) {
        return this.ensureService(this.findServiceScheme(sServiceName));
    }

    public static XmlDocument loadConfig(String sName) {
        return DefaultConfigurableCacheFactory.loadConfig(sName, null);
    }

    public static XmlDocument loadConfig(String sName, ClassLoader loader) {
        File file = new File(sName);
        SecurityException se = null;
        try {
            if (file.exists()) {
                return DefaultConfigurableCacheFactory.loadConfigFromFile(file);
            }
        }
        catch (SecurityException e) {
            se = e;
        }
        XmlDocument xml = DefaultConfigurableCacheFactory.loadConfigAsResource(sName, loader);
        if (se != null) {
            if (xml == null) {
                throw new WrapperException(se, "Cannot access configuration file '" + sName + "' due to insufficient privilages");
            }
            CacheFactory.log("Could not access configuration file '" + sName + "' due to insufficient privilages; however the " + "resource with the same name has been found", 2);
        }
        return xml;
    }

    public static XmlDocument loadConfigAsResource(String sResource, ClassLoader loader) {
        try {
            URL url = Resources.findResource(sResource, loader);
            if (url == null) {
                throw new IOException("Configuration is missing: \"" + sResource + "\", loader=" + loader);
            }
            InputStream stream = url.openStream();
            XmlDocument xml = new SimpleParser().parseXml(stream, "ISO-8859-1");
            CacheFactory.log("Loaded cache configuration from resource \"" + url + '\"', 3);
            return xml;
        }
        catch (IOException e) {
            throw new WrapperException(e, "Failed to load configuration resource: " + sResource);
        }
    }

    public static XmlDocument loadConfigFromFile(File file) {
        String sPath;
        if (file.isDirectory()) {
            file = new File(file, FILE_CFG_CACHE);
        }
        try {
            sPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            sPath = file.getAbsolutePath();
        }
        try {
            FileInputStream stream = new FileInputStream(file);
            XmlDocument xml = new SimpleParser().parseXml(stream);
            CacheFactory.log("Loaded cache configuration from file \"" + sPath + '\"', 3);
            return xml;
        }
        catch (IOException e) {
            throw new WrapperException(e, "Failed to load configuration file: " + sPath);
        }
    }

    public CacheInfo findSchemeMapping(String sCacheName) {
        XmlElement xmlMatch;
        XmlElement xmlDefaultMatch = null;
        XmlElement xmlPrefixMatch = null;
        XmlElement xmlExactMatch = null;
        Iterator iter = this.m_xmlConfig.getSafeElement("caching-scheme-mapping").getElements("cache-mapping");
        while (iter.hasNext()) {
            String sPrefix;
            XmlElement xmlMapping = (XmlElement)iter.next();
            String sName = xmlMapping.getSafeElement("cache-name").getString();
            if (sName.equals(sCacheName)) {
                xmlExactMatch = xmlMapping;
                break;
            }
            if (sName.equals("*")) {
                xmlDefaultMatch = xmlMapping;
                continue;
            }
            if (!sName.endsWith("*") || !sCacheName.startsWith(sPrefix = sName.substring(0, sName.indexOf(42)))) continue;
            xmlPrefixMatch = xmlMapping;
        }
        XmlElement xmlElement = xmlExactMatch != null ? xmlExactMatch : (xmlMatch = xmlPrefixMatch != null ? xmlPrefixMatch : xmlDefaultMatch);
        if (xmlMatch == null) {
            throw new IllegalArgumentException("No scheme for cache: \"" + sCacheName + '\"');
        }
        String sScheme = xmlMatch.getSafeElement("scheme-name").getString();
        HashMap<String, String> mapAttr = new HashMap<String, String>();
        Iterator iter2 = xmlMatch.getSafeElement("init-params").getElements("init-param");
        while (iter2.hasNext()) {
            XmlElement xmlParam = (XmlElement)iter2.next();
            String sName = xmlParam.getSafeElement("param-name").getString();
            String sValue = xmlParam.getSafeElement("param-value").getString();
            if (sName.length() == 0) continue;
            mapAttr.put(sName, sValue);
        }
        return new CacheInfo(sCacheName, sScheme, mapAttr);
    }

    public XmlElement resolveScheme(CacheInfo info) {
        XmlElement xmlScheme = this.findScheme(info.getSchemeName());
        info.replaceAttributes(xmlScheme);
        return this.resolveScheme(xmlScheme, info, false, true);
    }

    protected XmlElement findScheme(String sSchemeName) {
        if (sSchemeName != null) {
            Iterator iter = this.m_xmlConfig.getSafeElement("caching-schemes").getElementList().iterator();
            while (iter.hasNext()) {
                XmlElement xml = (XmlElement)iter.next();
                if (!xml.getSafeElement("scheme-name").getString().equals(sSchemeName)) continue;
                return (XmlElement)xml.clone();
            }
        }
        throw new IllegalArgumentException("Missing scheme: \"" + sSchemeName + '\"');
    }

    protected XmlElement findServiceScheme(String sServiceName) {
        if (sServiceName != null) {
            Iterator iter = this.m_xmlConfig.getSafeElement("caching-schemes").getElementList().iterator();
            while (iter.hasNext()) {
                XmlElement xml = (XmlElement)iter.next();
                if (!xml.getSafeElement("service-name").getString().equals(sServiceName)) continue;
                return (XmlElement)xml.clone();
            }
        }
        throw new IllegalArgumentException("Missing scheme for service: \"" + sServiceName + '\"');
    }

    protected XmlElement resolveScheme(XmlElement xmlScheme, CacheInfo info, boolean fChild, boolean fRequired) {
        String sRefName;
        if (fChild) {
            XmlElement xmlChild = null;
            Iterator iter = xmlScheme.getElementList().iterator();
            while (iter.hasNext()) {
                XmlElement xml = (XmlElement)iter.next();
                if (!xml.getName().endsWith("-scheme")) continue;
                if (xmlChild == null) {
                    xmlChild = xml;
                    continue;
                }
                throw new IllegalArgumentException("Scheme contains more then one child scheme:\n" + xmlScheme);
            }
            if (xmlChild == null) {
                if (fRequired) {
                    String sName = xmlScheme.getName();
                    if (xmlScheme == xmlScheme.getParent().getElement(sName)) {
                        throw new IllegalArgumentException("Child scheme is missing at:\n" + xmlScheme);
                    }
                    throw new IllegalArgumentException("Element \"" + sName + "\" is missing at:\n" + xmlScheme.getParent());
                }
                return null;
            }
            xmlScheme = xmlChild;
        }
        if ((sRefName = xmlScheme.getSafeElement("scheme-ref").getString()).length() == 0) {
            return xmlScheme;
        }
        XmlElement xmlBase = this.findScheme(sRefName);
        if (!xmlScheme.getName().equals(xmlBase.getName())) {
            throw new IllegalArgumentException("Reference does not match the scheme type: scheme=\n" + xmlScheme + "\nbase=" + xmlBase);
        }
        if (((Object)xmlScheme).equals(xmlBase)) {
            throw new IllegalArgumentException("Circular reference in scheme:\n" + xmlScheme);
        }
        if (info != null) {
            info.replaceAttributes(xmlBase);
        }
        XmlElement xmlResolve = this.resolveScheme(xmlBase, info, false, false);
        Iterator iter = xmlScheme.getElementList().iterator();
        while (iter.hasNext()) {
            XmlHelper.replaceElement(xmlResolve, (XmlElement)iter.next());
        }
        return xmlResolve;
    }

    protected NamedCache ensureCache(CacheInfo info, XmlElement xmlScheme, ClassLoader loader) {
        try {
            CacheService service = (CacheService)this.ensureService(xmlScheme);
            return service.ensureCache(info.getCacheName(), loader);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Invalid scheme:\n" + xmlScheme);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public Service ensureService(XmlElement xmlScheme) {
        void var5_4;
        void var4_5;
        xmlScheme = this.resolveScheme(xmlScheme, null, false, false);
        String sSchemeType = xmlScheme.getName();
        String sServiceName = xmlScheme.getSafeElement("service-name").getString();
        switch (this.translateSchemeType(sSchemeType)) {
            case 1: {
                Cluster cluster = CacheFactory.ensureCluster();
                String sServiceType = "ReplicatedCache";
                break;
            }
            case 2: {
                Cluster cluster = CacheFactory.ensureCluster();
                String sServiceType = "OptimisticCache";
                break;
            }
            case 3: {
                Cluster cluster = CacheFactory.ensureCluster();
                String sServiceType = "DistributedCache";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                Cluster cluster = CacheFactory.getCluster();
                String sServiceType = "LocalCache";
                break;
            }
            case 4: {
                return this.ensureService(this.resolveScheme(xmlScheme.getSafeElement("back-scheme"), null, true, true));
            }
            case 5: {
                XmlElement xmlVer = this.resolveScheme(xmlScheme.getSafeElement("version-transient-scheme"), null, true, true);
                XmlElement xmlBack = this.resolveScheme(xmlScheme.getSafeElement("back-scheme"), null, true, true);
                this.ensureService(xmlVer);
                return this.ensureService(xmlBack);
            }
            case 14: {
                Cluster cluster = CacheFactory.ensureCluster();
                String sServiceType = "Invocation";
                break;
            }
            case 15: {
                Cluster cluster = CacheFactory.ensureCluster();
                String sServiceType = "Proxy";
                break;
            }
            case 16: {
                Cluster cluster = CacheFactory.getCluster();
                String sServiceType = "RemoteCache";
                break;
            }
            case 17: {
                Cluster cluster = CacheFactory.getCluster();
                String sServiceType = "RemoteInvocation";
                break;
            }
            default: {
                throw new UnsupportedOperationException("ensureService: " + sSchemeType);
            }
        }
        if (sServiceName.length() == 0) {
            sServiceName = var4_5;
        }
        void var6_7 = var5_4;
        synchronized (var6_7) {
            Service service = var5_4.ensureService(sServiceName, (String)var4_5);
            if (service.isRunning()) {
                if (service instanceof CacheService) {
                    this.validateBackingMapManager((CacheService)service);
                }
            } else {
                XmlElement xmlConfig = CacheFactory.getServiceConfig((String)var4_5);
                if (xmlConfig != null) {
                    List listStandard = xmlConfig.getElementList();
                    int c = listStandard.size();
                    for (int i = 0; i < c; ++i) {
                        XmlElement xmlParamStandard = (XmlElement)listStandard.get(i);
                        String sParamName = xmlParamStandard.getName();
                        XmlElement xmlParam = xmlScheme.getElement(sParamName);
                        if (xmlParam == null || XmlHelper.isEmpty(xmlParam)) continue;
                        listStandard.set(i, xmlParam.clone());
                    }
                }
                service.configure(xmlConfig);
                if (service instanceof CacheService) {
                    ((CacheService)service).setBackingMapManager(new Manager());
                }
                service.start();
            }
            return service;
        }
    }

    private void validateBackingMapManager(CacheService service) {
        BackingMapManager manager = service.getBackingMapManager();
        if (!(manager instanceof Manager)) {
            throw new IllegalStateException("Service \"" + service.getInfo().getServiceName() + "\" has been started " + (manager == null ? "without a BackingMapManager" : "with a non-compatible BackingMapManager: " + manager));
        }
        DefaultConfigurableCacheFactory that = ((Manager)manager).getCacheFactory();
        if (that != this && !DefaultConfigurableCacheFactory.equals(that.getConfig(), this.getConfig())) {
            throw new IllegalStateException("Service \"" + service.getInfo().getServiceName() + "\" has been started by the factory with a different configuration descriptor");
        }
    }

    /*
     * WARNING - void declaration
     */
    protected NamedCache configureCache(CacheInfo info, XmlElement xmlScheme, ClassLoader loader) {
        void var5_5;
        String sSchemeType = xmlScheme.getName();
        switch (this.translateSchemeType(sSchemeType)) {
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                NamedCache cache = this.ensureCache(info, xmlScheme, loader);
                break;
            }
            case 3: 
            case 16: {
                NamedCache cache = this.ensureCache(info, xmlScheme, loader);
                XmlElement xmlBundling = xmlScheme.getElement("operation-bundling");
                if (xmlBundling == null) break;
                cache = this.instantiateBundlingNamedCache(cache, xmlBundling);
                break;
            }
            case 4: {
                NamedCache cache;
                String sCacheCtx = this.popCacheContext();
                XmlElement xmlFront = this.resolveScheme(xmlScheme.getSafeElement("front-scheme"), info, true, true);
                Map mapFront = this.configureBackingMap(info, xmlFront, null, loader, null);
                XmlElement xmlBack = this.resolveScheme(xmlScheme.getSafeElement("back-scheme"), info, true, true);
                NamedCache cacheBack = this.configureCache(info, xmlBack, loader);
                String sStrategy = xmlScheme.getSafeElement("invalidation-strategy").getString("auto");
                int nStrategy = sStrategy.equals("none") ? 0 : (sStrategy.equals("present") ? 1 : (sStrategy.equals("all") ? 2 : 3));
                String sSubclass = xmlScheme.getSafeElement("class-name").getString();
                if (sSubclass.length() == 0) {
                    cache = this.instantiateNearCache(mapFront, cacheBack, nStrategy);
                } else {
                    Object[] aoParam = new Object[]{mapFront, cacheBack, DefaultConfigurableCacheFactory.makeInteger(nStrategy)};
                    cache = (NamedCache)this.instantiateSubclass(sSubclass, NearCache.class, loader, aoParam, xmlScheme.getElement("init-params"));
                }
                if (sCacheCtx == null) break;
                this.register(cache, sCacheCtx);
                break;
            }
            case 5: {
                NamedCache cache;
                String sCacheCtx = this.popCacheContext();
                XmlElement xmlFront = this.resolveScheme(xmlScheme.getSafeElement("front-scheme"), info, true, true);
                Map mapFront = this.configureBackingMap(info, xmlFront, null, loader, null);
                XmlElement xmlBack = this.resolveScheme(xmlScheme.getSafeElement("back-scheme"), info, true, true);
                NamedCache cacheBack = this.ensureCache(info, xmlBack, loader);
                XmlElement xmlVer = xmlScheme.getSafeElement("version-transient-scheme");
                String sSuffix = xmlVer.getSafeElement("cache-name-suffix").getString("-version");
                xmlVer = this.resolveScheme(xmlVer, info, true, true);
                NamedCache cacheVer = this.ensureCache(info.getSyntheticInfo(sSuffix), xmlVer, loader);
                String sSubclass = xmlScheme.getSafeElement("class-name").getString();
                if (sSubclass.length() == 0) {
                    cache = this.instantiateVersionedNearCache(mapFront, cacheBack, cacheVer);
                } else {
                    Object[] aoParam = new Object[]{mapFront, cacheBack, cacheVer};
                    cache = (NamedCache)this.instantiateSubclass(sSubclass, VersionedNearCache.class, loader, aoParam, xmlScheme.getElement("init-params"));
                }
                if (sCacheCtx == null) break;
                this.register(cache, sCacheCtx);
                break;
            }
            default: {
                throw new UnsupportedOperationException("configureCache: " + sSchemeType);
            }
        }
        this.verifyMapListener(info, (Map)var5_5, xmlScheme, null, loader, null);
        return var5_5;
    }

    protected NearCache instantiateNearCache(Map mapFront, NamedCache mapBack, int nStrategy) {
        return new NearCache(mapFront, mapBack, nStrategy);
    }

    protected VersionedNearCache instantiateVersionedNearCache(Map mapLocal, NamedCache mapDist, NamedCache mapVersion) {
        return new VersionedNearCache(mapLocal, mapDist, mapVersion);
    }

    /*
     * WARNING - void declaration
     */
    public Map configureBackingMap(CacheInfo info, XmlElement xmlScheme, BackingMapManagerContext context, ClassLoader loader, Map mapListeners) {
        void var8_10;
        void var7_11;
        String sSchemeType = xmlScheme.getName();
        if (context != null) {
            loader = context.getClassLoader();
        }
        switch (this.translateSchemeType(sSchemeType)) {
            case 1: 
            case 2: 
            case 3: {
                XmlElement xmlBacking = this.resolveScheme(xmlScheme.getSafeElement("backing-map-scheme"), info, true, true);
                return this.configureBackingMap(info, xmlBacking, context, loader, mapListeners);
            }
            case 6: {
                String sCtx = this.popCacheContext();
                Map map = this.instantiateLocalCache(info, xmlScheme, loader);
                break;
            }
            case 4: {
                XmlElement xmlBack = this.resolveScheme(xmlScheme.getSafeElement("back-scheme"), info, true, true);
                return this.configureBackingMap(info, xmlBack, context, loader, mapListeners);
            }
            case 5: {
                XmlElement xmlBack = this.resolveScheme(xmlScheme.getSafeElement("back-scheme"), info, true, true);
                XmlElement xmlVer = xmlScheme.getSafeElement("version-transient-scheme");
                String sSuffix = xmlVer.getSafeElement("cache-name-suffix").getString("-version");
                xmlVer = this.resolveScheme(xmlVer, info, true, true);
                return this.configureBackingMap(info, info.getCacheName().endsWith(sSuffix) ? xmlVer : xmlBack, context, loader, mapListeners);
            }
            case 12: {
                if (context == null) {
                    throw new IllegalArgumentException("ReadWriteBackingMap requires BackingMapManagerContext");
                }
                String sCtx = this.popCacheContext();
                Map map = this.instantiateReadWriteBackingMap(info, xmlScheme, context, mapListeners);
                break;
            }
            case 13: {
                if (context == null) {
                    throw new IllegalArgumentException("VersionedBackingMap requires BackingMapManagerContext");
                }
                String sCtx = this.popCacheContext();
                Map map = this.instantiateVersionedBackingMap(info, xmlScheme, context, mapListeners);
                break;
            }
            case 7: {
                String sCtx = this.popCacheContext();
                Map map = this.instantiateOverflowBackingMap(info, xmlScheme, context, loader, mapListeners);
                break;
            }
            case 8: {
                String sCtx = this.popCacheContext();
                Map map = this.instantiateDiskBackingMap(info, xmlScheme, context, loader);
                break;
            }
            case 9: {
                String sCtx = this.popCacheContext();
                Map map = this.instantiateExternalBackingMap(info, xmlScheme, context, loader);
                break;
            }
            case 10: {
                String sCtx = this.popCacheContext();
                Map map = this.instantiatePagedExternalBackingMap(info, xmlScheme, context, loader);
                break;
            }
            case 16: {
                String sCtx = this.popCacheContext();
                Map map = this.configureCache(info, xmlScheme, loader);
                break;
            }
            case 11: {
                String sCtx = this.popCacheContext();
                Map map = this.instantiateMap(info, xmlScheme, context, loader);
                break;
            }
            default: {
                throw new UnsupportedOperationException("configureBackingMap: " + sSchemeType);
            }
        }
        this.verifyMapListener(info, (Map)var7_11, xmlScheme, context, loader, mapListeners);
        if (var8_10 != null) {
            this.register(context.getCacheService(), info.getCacheName(), (String)var8_10, (Map)var7_11);
        }
        return var7_11;
    }

    protected void verifyMapListener(CacheInfo info, Map map, XmlElement xmlScheme, BackingMapManagerContext context, ClassLoader loader, Map mapListeners) {
        XmlElement xmlListener = xmlScheme.getSafeElement("listener");
        XmlElement xmlClass = this.resolveScheme(xmlListener, info, true, false);
        if (xmlClass != null) {
            String sTier = xmlScheme.getSafeAttribute("tier").getString();
            if (sTier.length() > 0) {
                boolean fBackOnly = xmlListener.getSafeAttribute("target").getString().equals("backing-map");
                if (sTier.equals("front") && fBackOnly) {
                    return;
                }
                if (sTier.equals("back") && !fBackOnly) {
                    return;
                }
            }
            MapListener listener = this.instantiateMapListener(info, xmlClass, context, loader);
            try {
                ((ObservableMap)map).addMapListener(listener);
                if (mapListeners != null) {
                    mapListeners.put(DefaultConfigurableCacheFactory.makeInteger(System.identityHashCode(map)), listener);
                }
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Map is not observable: " + map.getClass());
            }
        }
    }

    protected Map instantiateReadWriteBackingMap(CacheInfo info, XmlElement xmlRWBM, BackingMapManagerContext context, Map mapListeners) {
        ReadWriteBackingMap rwbm;
        ObservableMap mapInternal;
        XmlElement xmlInternal = this.resolveScheme(xmlRWBM.getSafeElement("internal-cache-scheme"), info, true, true);
        XmlElement xmlMisses = this.resolveScheme(xmlRWBM.getSafeElement("miss-cache-scheme"), info, true, false);
        XmlElement xmlStore = this.resolveScheme(xmlRWBM.getSafeElement("cachestore-scheme"), info, false, false);
        ClassLoader loader = context.getClassLoader();
        Map mapMisses = xmlMisses == null ? null : this.instantiateLocalCache(info, xmlMisses, loader);
        boolean fReadOnly = xmlRWBM.getSafeElement("read-only").getBoolean();
        double dflRefreshAhead = xmlRWBM.getSafeElement("refresh-ahead-factor").getDouble();
        boolean fRethrow = xmlRWBM.getSafeElement("rollback-cachestore-failures").getBoolean();
        double dflWriteFactor = xmlRWBM.getSafeElement("write-batch-factor").getDouble();
        int cWriteRequeue = xmlRWBM.getSafeElement("write-requeue-threshold").getInt();
        String sWriteDelay = xmlRWBM.getSafeElement("write-delay").getString();
        int cWriteBehind = sWriteDelay == null || sWriteDelay.length() == 0 ? xmlRWBM.getSafeElement("write-delay-seconds").getInt() : (int)(DefaultConfigurableCacheFactory.parseTime(sWriteDelay, 1000) / 1000L);
        try {
            mapInternal = (ObservableMap)this.configureBackingMap(info, xmlInternal, context, null, mapListeners);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Map is not observable:\n" + xmlInternal);
        }
        CacheLoader store = this.instantiateCacheStore(info, xmlStore, context, loader);
        String sSubclass = xmlRWBM.getSafeElement("class-name").getString();
        if (sSubclass.length() == 0) {
            rwbm = store instanceof CacheStore ? this.instantiateReadWriteBackingMap(context, mapInternal, mapMisses, (CacheStore)store, fReadOnly, cWriteBehind, dflRefreshAhead) : this.instantiateReadWriteBackingMap(context, mapInternal, mapMisses, store);
        } else {
            Object[] objectArray;
            if (store instanceof CacheStore) {
                Object[] objectArray2 = new Object[7];
                objectArray2[0] = context;
                objectArray2[1] = mapInternal;
                objectArray2[2] = mapMisses;
                objectArray2[3] = store;
                objectArray2[4] = new Boolean(fReadOnly);
                objectArray2[5] = DefaultConfigurableCacheFactory.makeInteger(cWriteBehind);
                objectArray = objectArray2;
                objectArray2[6] = new Double(dflRefreshAhead);
            } else {
                Object[] objectArray3 = new Object[4];
                objectArray3[0] = context;
                objectArray3[1] = mapInternal;
                objectArray3[2] = mapMisses;
                objectArray = objectArray3;
                objectArray3[3] = store;
            }
            Object[] aoParam = objectArray;
            rwbm = (ReadWriteBackingMap)this.instantiateSubclass(sSubclass, ReadWriteBackingMap.class, loader, aoParam, xmlRWBM.getElement("init-params"));
        }
        rwbm.setRethrowExceptions(fRethrow);
        rwbm.setWriteBatchFactor(dflWriteFactor);
        rwbm.setWriteRequeueThreshold(cWriteRequeue);
        XmlElement xmlBundling = xmlStore.getElement("operation-bundling");
        if (xmlBundling != null) {
            ReadWriteBackingMap.CacheStoreWrapper storeWrapper = rwbm.getCacheStore();
            Iterator iter = xmlBundling.getElements("bundle-config");
            while (iter.hasNext()) {
                XmlElement xmlBundle = (XmlElement)iter.next();
                String sOperation = xmlBundle.getSafeElement("operation-name").getString("all");
                int cBundle = xmlBundle.getSafeElement("preferred-size").getInt();
                if (sOperation.equals("all")) {
                    this.initializeBundler(storeWrapper.ensureLoadBundler(cBundle), xmlBundle);
                    this.initializeBundler(storeWrapper.ensureStoreBundler(cBundle), xmlBundle);
                    this.initializeBundler(storeWrapper.ensureEraseBundler(cBundle), xmlBundle);
                    continue;
                }
                if (sOperation.equals("load")) {
                    this.initializeBundler(storeWrapper.ensureLoadBundler(cBundle), xmlBundle);
                    continue;
                }
                if (sOperation.equals("store")) {
                    this.initializeBundler(storeWrapper.ensureStoreBundler(cBundle), xmlBundle);
                    continue;
                }
                if (sOperation.equals("erase")) {
                    this.initializeBundler(storeWrapper.ensureEraseBundler(cBundle), xmlBundle);
                    continue;
                }
                throw new IllegalArgumentException("Invalid \"operation-name\" element:\n" + xmlBundle);
            }
        }
        return rwbm;
    }

    protected ReadWriteBackingMap instantiateReadWriteBackingMap(BackingMapManagerContext context, ObservableMap mapInternal, Map mapMisses, CacheStore store, boolean fReadOnly, int cWriteBehindSeconds, double dflRefreshAheadFactor) {
        return new ReadWriteBackingMap(context, mapInternal, mapMisses, store, fReadOnly, cWriteBehindSeconds, dflRefreshAheadFactor);
    }

    protected ReadWriteBackingMap instantiateReadWriteBackingMap(BackingMapManagerContext context, ObservableMap mapInternal, Map mapMisses, CacheLoader loader) {
        return new ReadWriteBackingMap(context, mapInternal, mapMisses, loader);
    }

    protected Map instantiateVersionedBackingMap(CacheInfo info, XmlElement xmlVBM, BackingMapManagerContext context, Map mapListeners) {
        VersionedBackingMap vbm;
        ObservableMap mapInternal;
        XmlElement xmlPersist = xmlVBM.getElement("version-persistent-scheme");
        String sPersistSuffix = "-persist";
        if (xmlPersist != null) {
            sPersistSuffix = xmlPersist.getSafeElement("cache-name-suffix").getString(sPersistSuffix);
            xmlPersist = this.resolveScheme(xmlPersist, info, true, false);
            if (info.getCacheName().endsWith(sPersistSuffix) && xmlPersist != null) {
                return this.configureBackingMap(info, xmlPersist, context, null, mapListeners);
            }
        }
        XmlElement xmlTrans = xmlVBM.getElement("version-transient-scheme");
        String sTransSuffix = "-version";
        if (xmlTrans != null) {
            sTransSuffix = xmlTrans.getSafeElement("cache-name-suffix").getString(sTransSuffix);
            xmlTrans = this.resolveScheme(xmlTrans, info, true, false);
            if (info.getCacheName().endsWith(sTransSuffix) && xmlTrans != null) {
                return this.configureBackingMap(info, xmlTrans, context, null, mapListeners);
            }
        }
        XmlElement xmlInternal = this.resolveScheme(xmlVBM.getSafeElement("internal-cache-scheme"), info, true, true);
        XmlElement xmlMisses = this.resolveScheme(xmlVBM.getSafeElement("miss-cache-scheme"), info, true, false);
        XmlElement xmlStore = this.resolveScheme(xmlVBM.getSafeElement("cachestore-scheme"), info, false, false);
        ClassLoader loader = context.getClassLoader();
        Map mapMisses = xmlMisses == null ? null : this.instantiateLocalCache(info, xmlMisses, loader);
        boolean fReadOnly = xmlVBM.getSafeElement("read-only").getBoolean();
        double dflRefreshAhead = xmlVBM.getSafeElement("refresh-ahead-factor").getDouble();
        boolean fRethrow = xmlVBM.getSafeElement("rollback-cachestore-failures").getBoolean();
        double dflWriteFactor = xmlVBM.getSafeElement("write-batch-factor").getDouble();
        int cWriteRequeue = xmlVBM.getSafeElement("write-requeue-threshold").getInt();
        NamedCache cachePersist = xmlPersist == null ? null : this.ensureCache(info.getSyntheticInfo(sPersistSuffix), xmlPersist, loader);
        NamedCache cacheTrans = xmlTrans == null ? null : this.ensureCache(info.getSyntheticInfo(sTransSuffix), xmlTrans, loader);
        boolean fManageTrans = xmlVBM.getSafeElement("manage-transient").getBoolean();
        String sWriteDelay = xmlVBM.getSafeElement("write-delay").getString();
        int cWriteBehind = sWriteDelay == null || sWriteDelay.length() == 0 ? xmlVBM.getSafeElement("write-delay-seconds").getInt() : (int)(DefaultConfigurableCacheFactory.parseTime(sWriteDelay, 1000) / 1000L);
        try {
            mapInternal = (ObservableMap)this.configureBackingMap(info, xmlInternal, context, null, mapListeners);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Map is not observable:\n" + xmlInternal);
        }
        CacheLoader store = this.instantiateCacheStore(info, xmlStore, context, loader);
        String sSubclass = xmlVBM.getSafeElement("class-name").getString();
        if (sSubclass.length() == 0) {
            vbm = store instanceof CacheStore ? this.instantiateVersionedBackingMap(context, mapInternal, mapMisses, (CacheStore)store, fReadOnly, cWriteBehind, dflRefreshAhead, cacheTrans, cachePersist, fManageTrans) : this.instantiateVersionedBackingMap(context, mapInternal, mapMisses, store, cacheTrans, cachePersist, fManageTrans);
        } else {
            Object[] objectArray;
            if (store instanceof CacheStore) {
                Object[] objectArray2 = new Object[10];
                objectArray2[0] = context;
                objectArray2[1] = mapInternal;
                objectArray2[2] = mapMisses;
                objectArray2[3] = store;
                objectArray2[4] = new Boolean(fReadOnly);
                objectArray2[5] = DefaultConfigurableCacheFactory.makeInteger(cWriteBehind);
                objectArray2[6] = new Double(dflRefreshAhead);
                objectArray2[7] = cacheTrans;
                objectArray2[8] = cachePersist;
                objectArray = objectArray2;
                objectArray2[9] = new Boolean(fManageTrans);
            } else {
                Object[] objectArray3 = new Object[7];
                objectArray3[0] = context;
                objectArray3[1] = mapInternal;
                objectArray3[2] = mapMisses;
                objectArray3[3] = store;
                objectArray3[4] = cacheTrans;
                objectArray3[5] = cachePersist;
                objectArray = objectArray3;
                objectArray3[6] = new Boolean(fManageTrans);
            }
            Object[] aoParam = objectArray;
            vbm = (VersionedBackingMap)this.instantiateSubclass(sSubclass, VersionedBackingMap.class, loader, aoParam, xmlVBM.getElement("init-params"));
        }
        vbm.setRethrowExceptions(fRethrow);
        vbm.setWriteBatchFactor(dflWriteFactor);
        vbm.setWriteRequeueThreshold(cWriteRequeue);
        return vbm;
    }

    protected VersionedBackingMap instantiateVersionedBackingMap(BackingMapManagerContext context, ObservableMap mapInternal, Map mapMisses, CacheStore store, boolean fReadOnly, int cWriteBehindSeconds, double dflRefreshAheadFactor, NamedCache mapVersionTransient, NamedCache mapVersionPersist, boolean fManageTransient) {
        return new VersionedBackingMap(context, mapInternal, mapMisses, store, fReadOnly, cWriteBehindSeconds, dflRefreshAheadFactor, mapVersionTransient, mapVersionPersist, fManageTransient);
    }

    protected VersionedBackingMap instantiateVersionedBackingMap(BackingMapManagerContext context, ObservableMap mapInternal, Map mapMisses, CacheLoader loader, NamedCache mapVersionTransient, NamedCache mapVersionPersist, boolean fManageTransient) {
        return new VersionedBackingMap(context, mapInternal, mapMisses, loader, mapVersionTransient, mapVersionPersist, fManageTransient);
    }

    protected Map instantiateLocalCache(CacheInfo info, XmlElement xmlLocal, ClassLoader loader) {
        LocalCache cache;
        block32: {
            XmlElement xmlStore;
            CacheLoader store;
            XmlElement xmlCalculator;
            String sSubclass;
            int cHighUnits = xmlLocal.getSafeElement("high-units").getInt();
            int cLowUnits = xmlLocal.getSafeElement("low-units").getInt();
            int cExpiryDelayMillis = (int)DefaultConfigurableCacheFactory.parseTime(xmlLocal.getSafeElement("expiry-delay").getString("0"), 1000);
            int cFlushDelayMillis = (int)DefaultConfigurableCacheFactory.parseTime(xmlLocal.getSafeElement("flush-delay").getString("0"), 1000);
            if (cHighUnits <= 0) {
                cHighUnits = Integer.MAX_VALUE;
            }
            if (cLowUnits <= 0) {
                cLowUnits = (int)((double)cHighUnits * 0.75);
            }
            if (cExpiryDelayMillis < 0) {
                cExpiryDelayMillis = 0;
            }
            if (cFlushDelayMillis < 0) {
                cFlushDelayMillis = 0;
            }
            if (cExpiryDelayMillis > 0 && cFlushDelayMillis == 0) {
                cFlushDelayMillis = 60000;
            }
            if ((sSubclass = xmlLocal.getSafeElement("class-name").getString()).length() == 0) {
                cache = this.instantiateLocalCache(cHighUnits, cExpiryDelayMillis);
            } else {
                Object[] aoParam = new Object[]{DefaultConfigurableCacheFactory.makeInteger(cHighUnits), DefaultConfigurableCacheFactory.makeInteger(cExpiryDelayMillis)};
                cache = (LocalCache)this.instantiateSubclass(sSubclass, LocalCache.class, loader, aoParam, xmlLocal.getElement("init-params"));
            }
            cache.setLowUnits(cLowUnits);
            cache.setFlushDelay(cFlushDelayMillis);
            XmlElement xmlEviction = xmlLocal.getElement("eviction-policy");
            if (xmlEviction != null) {
                String sEvictionType = xmlEviction.getString();
                int nEvictionType = -1;
                if (sEvictionType.equalsIgnoreCase("HYBRID")) {
                    nEvictionType = 0;
                } else if (sEvictionType.equalsIgnoreCase("LRU")) {
                    nEvictionType = 1;
                } else if (sEvictionType.equalsIgnoreCase("LFU")) {
                    nEvictionType = 2;
                }
                if (nEvictionType >= 0) {
                    cache.setEvictionType(nEvictionType);
                } else {
                    XmlElement xmlClass = xmlEviction.getElement("class-scheme");
                    if (xmlClass != null) {
                        try {
                            cache.setEvictionPolicy((OldCache.EvictionPolicy)this.instantiateAny(info, xmlClass, null, loader));
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("Unknown eviction policy:\n" + xmlClass);
                        }
                    }
                }
            }
            if ((xmlCalculator = xmlLocal.getElement("unit-calculator")) != null) {
                String sCalculatorType = xmlCalculator.getString();
                int nCalculatorType = -1;
                if (sCalculatorType.equalsIgnoreCase("FIXED")) {
                    nCalculatorType = 0;
                } else if (sCalculatorType.equalsIgnoreCase("BINARY")) {
                    nCalculatorType = 1;
                }
                if (nCalculatorType >= 0) {
                    cache.setUnitCalculatorType(nCalculatorType);
                } else {
                    XmlElement xmlClass = xmlCalculator.getElement("class-scheme");
                    if (xmlClass != null) {
                        try {
                            cache.setUnitCalculator((OldCache.UnitCalculator)this.instantiateAny(info, xmlClass, null, loader));
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("Unknown unit calculator:\n" + xmlClass);
                        }
                    }
                }
            }
            if ((store = this.instantiateCacheStore(info, xmlStore = this.resolveScheme(xmlLocal.getSafeElement("cachestore-scheme"), info, false, false), null, loader)) != null) {
                cache.setCacheLoader(store);
            }
            if (xmlLocal.getSafeElement("pre-load").getBoolean()) {
                try {
                    cache.loadAll();
                }
                catch (Throwable e) {
                    String sText = "An exception occurred while pre-loading the \"" + info.getCacheName() + "\" cache:" + '\n' + DefaultConfigurableCacheFactory.indentString(DefaultConfigurableCacheFactory.getStackTrace(e), "    ") + "\nThe following configuration was used for the \"" + info.getCacheName() + "\" cache:" + '\n' + DefaultConfigurableCacheFactory.indentString(((Object)xmlLocal).toString(), "    ");
                    if (!(e instanceof Error)) {
                        sText = sText + "\n(The exception has been logged and will be ignored.)";
                    }
                    CacheFactory.log(sText, 2);
                    if (!(e instanceof Error)) break block32;
                    throw (Error)e;
                }
            }
        }
        return cache;
    }

    protected LocalCache instantiateLocalCache(int cUnits, int cExpiryMillis) {
        return new LocalCache(cUnits, cExpiryMillis);
    }

    protected Map instantiateOverflowBackingMap(CacheInfo info, XmlElement xmlOverflow, BackingMapManagerContext context, ClassLoader loader, Map mapListeners) {
        Map mapOverflow;
        boolean fObservable;
        boolean fExpiry;
        int cExpiryMillis;
        Map mapMisses;
        block17: {
            boolean fExplicitOverflow;
            XmlElement xmlFront = this.resolveScheme(xmlOverflow.getSafeElement("front-scheme"), info, true, true);
            XmlElement xmlBack = this.resolveScheme(xmlOverflow.getSafeElement("back-scheme"), info, true, true);
            XmlElement xmlMisses = this.resolveScheme(xmlOverflow.getSafeElement("miss-cache-scheme"), info, true, false);
            Map mapFront = this.configureBackingMap(info, xmlFront, context, loader, mapListeners);
            Map mapBack = this.configureBackingMap(info, xmlBack, context, loader, mapListeners);
            mapMisses = xmlMisses == null ? null : this.instantiateLocalCache(info, xmlMisses, loader);
            String sSubclass = xmlOverflow.getSafeElement("class-name").getString();
            boolean fExplicit = sSubclass != null && sSubclass.length() > 0;
            cExpiryMillis = (int)DefaultConfigurableCacheFactory.parseTime(xmlOverflow.getSafeElement("expiry-delay").getString("0"), 1000);
            fExpiry = cExpiryMillis > 0 || xmlOverflow.getSafeElement("expiry-enabled").getBoolean();
            fObservable = mapBack instanceof ObservableMap;
            boolean bl = fExplicit && sSubclass.equals(OverflowMap.class.getName()) ? true : (fExplicitOverflow = false);
            boolean fExplicitSimple = fExplicit && sSubclass.equals(SimpleOverflowMap.class.getName());
            try {
                if (fExplicit && !fExplicitSimple && !fExplicitOverflow) {
                    Object[] objectArray;
                    block16: {
                        try {
                            Class clz = ExternalizableHelper.loadClass(sSubclass, loader, OverflowMap.class.getClassLoader());
                            if (OverflowMap.class.isAssignableFrom(clz)) {
                                fExplicitOverflow = true;
                                break block16;
                            }
                            if (SimpleOverflowMap.class.isAssignableFrom(clz)) {
                                fExplicitSimple = true;
                                break block16;
                            }
                            throw new IllegalArgumentException(sSubclass + " is not a sub-class of either OverflowMap or SimpleOverflowMap");
                        }
                        catch (Exception e) {
                            throw DefaultConfigurableCacheFactory.ensureRuntimeException(e);
                        }
                    }
                    if (fExplicitSimple && mapMisses != null) {
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = (ObservableMap)mapFront;
                        objectArray2[1] = mapBack;
                        objectArray = objectArray2;
                        objectArray2[2] = mapMisses;
                    } else {
                        Object[] objectArray3 = new Object[2];
                        objectArray3[0] = (ObservableMap)mapFront;
                        objectArray = objectArray3;
                        objectArray3[1] = mapBack;
                    }
                    Object[] aoParam = objectArray;
                    XmlElement xmlParams = xmlOverflow.getElement("init-params");
                    mapOverflow = (Map)this.instantiateSubclass(sSubclass, OverflowMap.class, loader, aoParam, xmlParams);
                    break block17;
                }
                mapOverflow = fExplicitSimple ? this.instantiateSimpleOverflowMap((ObservableMap)mapFront, mapBack, mapMisses) : this.instantiateOverflowMap((ObservableMap)mapFront, mapBack, fExpiry);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("FrontMap is not observable: " + mapFront.getClass());
            }
        }
        if (mapOverflow instanceof OverflowMap) {
            if (cExpiryMillis > 0) {
                ((OverflowMap)mapOverflow).setExpiryDelay(cExpiryMillis);
            }
            if (mapMisses != null) {
                CacheFactory.log("Cache " + info.getCacheName() + " of scheme " + info.getSchemeName() + " has a \"miss-cache-scheme\" configured; since" + " the default OverflowMap implementation has been" + " selected, the miss cache will not be used.", 2);
            }
        } else if (mapOverflow instanceof SimpleOverflowMap) {
            if (fExpiry) {
                CacheFactory.log("Cache " + info.getCacheName() + " of scheme " + info.getSchemeName() + " has \"expiry-enabled\" set to true or" + " \"expiry-delay\" configured; these settings will" + " have no effect, and expiry will not work," + " because the scheme explicitly ues a" + " SimpleOverflowMap.", 2);
            }
            if (fObservable) {
                CacheFactory.log("Cache " + info.getCacheName() + " of scheme " + info.getSchemeName() + " has a \"back-scheme\" that is observable;" + " the events from the back map will be ignored" + " because the scheme explicitly uses a" + " SimpleOverflowMap, and this could result in" + " missing events if the back map actively expires" + " and/or evicts its entries.", 2);
            }
        }
        return mapOverflow;
    }

    protected OverflowMap instantiateOverflowMap(ObservableMap mapFront, Map mapBack, boolean fExpiry) {
        OverflowMap map = new OverflowMap(mapFront, mapBack);
        if (fExpiry) {
            map.setExpiryEnabled(true);
        }
        return map;
    }

    protected SimpleOverflowMap instantiateSimpleOverflowMap(ObservableMap mapFront, Map mapBack, Map mapMisses) {
        return new SimpleOverflowMap(mapFront, mapBack, mapMisses);
    }

    protected Map instantiateDiskBackingMap(CacheInfo info, XmlElement xmlDisk, BackingMapManagerContext context, ClassLoader loader) {
        String sSubclass = xmlDisk.getSafeElement("class-name").getString();
        String sFS = xmlDisk.getSafeElement("file-manager").getString();
        String sPath = xmlDisk.getSafeElement("directory").getString();
        int cHighUnits = xmlDisk.getSafeElement("high-units").getInt();
        int cPages = xmlDisk.getSafeElement("page-limit").getInt();
        String sTarget = xmlDisk.getSafeAttribute("target").getString();
        boolean fAsync = xmlDisk.getSafeElement("async").getBoolean();
        int cbMaxAsync = (int)DefaultConfigurableCacheFactory.parseMemorySize(xmlDisk.getSafeElement("async-limit").getString("0"));
        int cPageSecs = (int)(DefaultConfigurableCacheFactory.parseTime(xmlDisk.getSafeElement("page-duration").getString("0"), 1000) / 1000L);
        int cExpiryMillis = (int)DefaultConfigurableCacheFactory.parseTime(xmlDisk.getSafeElement("expiry-delay").getString("0"), 1000);
        if (sPath.length() == 0) {
            sPath = xmlDisk.getSafeElement("root-directory").getString();
        }
        File file = sPath.length() == 0 ? null : new File(sPath);
        boolean fPaged = cPages > 0 && cPageSecs > 0;
        boolean fBackup = sTarget.equals("backup");
        boolean fBinaryMap = context != null && "DistributedCache".equals(context.getCacheService().getInfo().getServiceType());
        BinaryStore store = null;
        BinaryStoreManager storeMgr = null;
        if (sFS.equalsIgnoreCase("LH")) {
            if (fPaged) {
                storeMgr = new LHBinaryStoreManager(file);
            } else {
                String sName = xmlDisk.getSafeElement("file-name").getString();
                if (sName.trim().length() == 0) {
                    sName = null;
                }
                store = new LHBinaryStore(file, sName);
            }
        } else if (sFS.equalsIgnoreCase("NIO-memory") || sFS.equalsIgnoreCase("NIO-file")) {
            long cbInit = DefaultConfigurableCacheFactory.parseMemorySize(xmlDisk.getSafeElement("initial-size").getString("1"), 20);
            long cbMax = DefaultConfigurableCacheFactory.parseMemorySize(xmlDisk.getSafeElement("maximum-size").getString("1024"), 20);
            int cbMaxSize = (int)Math.min(Math.max(cbMax, 1L), 2147482624L);
            int cbInitSize = (int)Math.min(Math.max(cbInit, 1L), (long)cbMaxSize);
            if (fPaged) {
                storeMgr = sFS.equalsIgnoreCase("NIO-memory") ? new DirectStoreManager(cbInitSize, cbMaxSize) : new MappedStoreManager(cbInitSize, cbMaxSize, file);
            } else {
                AbstractBufferManager bufferMgr = sFS.equalsIgnoreCase("NIO-memory") ? new DirectBufferManager(cbInitSize, cbMaxSize) : new MappedBufferManager(cbInitSize, cbMaxSize, file);
                store = new BinaryMapStore(new BinaryMap(bufferMgr));
            }
        } else {
            throw new UnsupportedOperationException("file-manager: " + sFS);
        }
        if (fAsync) {
            if (store != null) {
                store = this.instantiateAsyncBinaryStore(store, cbMaxAsync);
            } else if (storeMgr != null) {
                storeMgr = this.instantiateAsyncBinaryStoreManager(storeMgr, cbMaxAsync);
            } else {
                throw new UnsupportedOperationException("async option without BinaryStore or BinaryStoreManager!");
            }
        }
        if (fPaged) {
            Object[] objectArray;
            if (sSubclass.length() == 0) {
                return fBinaryMap ? this.instantiateSerializationPagedCache(storeMgr, cPages, cPageSecs, true, fBackup) : this.instantiateSerializationPagedCache(storeMgr, cPages, cPageSecs, loader);
            }
            if (fBinaryMap) {
                Object[] objectArray2 = new Object[5];
                objectArray2[0] = storeMgr;
                objectArray2[1] = DefaultConfigurableCacheFactory.makeInteger(cPages);
                objectArray2[2] = DefaultConfigurableCacheFactory.makeInteger(cPageSecs);
                objectArray2[3] = Boolean.TRUE;
                objectArray = objectArray2;
                objectArray2[4] = new Boolean(fBackup);
            } else {
                Object[] objectArray3 = new Object[4];
                objectArray3[0] = storeMgr;
                objectArray3[1] = DefaultConfigurableCacheFactory.makeInteger(cPages);
                objectArray3[2] = DefaultConfigurableCacheFactory.makeInteger(cPageSecs);
                objectArray = objectArray3;
                objectArray3[3] = loader;
            }
            Object[] aoParam = objectArray;
            return (Map)this.instantiateSubclass(sSubclass, SerializationPagedCache.class, loader, aoParam, xmlDisk.getElement("init-params"));
        }
        return this.instantiateSerializationMap(store, fBinaryMap, loader, cHighUnits, cExpiryMillis, sSubclass, xmlDisk.getElement("init-params"));
    }

    protected Map instantiateSerializationMap(BinaryStore store, boolean fBinaryMap, ClassLoader loader, int cHighUnits, int cExpiryMillis, String sSubclass, XmlElement xmlInitParams) {
        Object[] objectArray;
        if (sSubclass.length() == 0) {
            if (cHighUnits > 0 || cExpiryMillis > 0) {
                SerializationCache cache;
                SerializationCache serializationCache = cache = fBinaryMap ? this.instantiateSerializationCache(store, cHighUnits, true) : this.instantiateSerializationCache(store, cHighUnits, loader);
                if (cExpiryMillis > 0) {
                    cache.setExpiryDelay(cExpiryMillis);
                }
                return cache;
            }
            return fBinaryMap ? this.instantiateSerializationMap(store, true) : this.instantiateSerializationMap(store, loader);
        }
        if (cHighUnits > 0 || cExpiryMillis > 0) {
            Object[] objectArray2;
            if (fBinaryMap) {
                Object[] objectArray3 = new Object[3];
                objectArray3[0] = store;
                objectArray3[1] = DefaultConfigurableCacheFactory.makeInteger(cHighUnits);
                objectArray2 = objectArray3;
                objectArray3[2] = Boolean.TRUE;
            } else {
                Object[] objectArray4 = new Object[3];
                objectArray4[0] = store;
                objectArray4[1] = DefaultConfigurableCacheFactory.makeInteger(cHighUnits);
                objectArray2 = objectArray4;
                objectArray4[2] = loader;
            }
            Object[] aoParam = objectArray2;
            SerializationCache cache = (SerializationCache)this.instantiateSubclass(sSubclass, SerializationCache.class, loader, aoParam, xmlInitParams);
            if (cExpiryMillis > 0) {
                cache.setExpiryDelay(cExpiryMillis);
            }
            return cache;
        }
        if (fBinaryMap) {
            Object[] objectArray5 = new Object[2];
            objectArray5[0] = store;
            objectArray = objectArray5;
            objectArray5[1] = Boolean.TRUE;
        } else {
            Object[] objectArray6 = new Object[2];
            objectArray6[0] = store;
            objectArray = objectArray6;
            objectArray6[1] = loader;
        }
        Object[] aoParam = objectArray;
        Map map = (Map)this.instantiateSubclass(sSubclass, AbstractKeyBasedMap.class, loader, aoParam, xmlInitParams);
        if (map instanceof SerializationMap || map instanceof SimpleSerializationMap) {
            return map;
        }
        throw new IllegalArgumentException(sSubclass + " does not extend either " + SerializationMap.class.getName() + " or " + SimpleSerializationMap.class.getName());
    }

    protected Map instantiateExternalBackingMap(CacheInfo info, XmlElement xmlExternal, BackingMapManagerContext context, ClassLoader loader) {
        String sSubclass = xmlExternal.getSafeElement("class-name").getString();
        int cHighUnits = xmlExternal.getSafeElement("high-units").getInt();
        int cExpiryMillis = (int)DefaultConfigurableCacheFactory.parseTime(xmlExternal.getSafeElement("expiry-delay").getString("0"), 1000);
        boolean fBinaryMap = context != null && "DistributedCache".equals(context.getCacheService().getInfo().getServiceType());
        BinaryStore store = this.instantiateBinaryStoreManager(xmlExternal, loader, false).createBinaryStore();
        return this.instantiateSerializationMap(store, fBinaryMap, loader, cHighUnits, cExpiryMillis, sSubclass, xmlExternal.getElement("init-params"));
    }

    protected Map instantiatePagedExternalBackingMap(CacheInfo info, XmlElement xmlPaged, BackingMapManagerContext context, ClassLoader loader) {
        Object[] objectArray;
        String sSubclass = xmlPaged.getSafeElement("class-name").getString();
        int cPages = xmlPaged.getSafeElement("page-limit").getInt();
        int cPageSecs = (int)(DefaultConfigurableCacheFactory.parseTime(xmlPaged.getSafeElement("page-duration").getString("5"), 1000) / 1000L);
        boolean fBackup = xmlPaged.getSafeAttribute("target").getString().equals("backup");
        boolean fBinaryMap = context != null && "DistributedCache".equals(context.getCacheService().getInfo().getServiceType());
        BinaryStoreManager mgr = this.instantiateBinaryStoreManager(xmlPaged, loader, true);
        if (sSubclass.length() == 0) {
            return fBinaryMap ? this.instantiateSerializationPagedCache(mgr, cPages, cPageSecs, true, fBackup) : this.instantiateSerializationPagedCache(mgr, cPages, cPageSecs, loader);
        }
        if (fBinaryMap) {
            Object[] objectArray2 = new Object[5];
            objectArray2[0] = mgr;
            objectArray2[1] = DefaultConfigurableCacheFactory.makeInteger(cPages);
            objectArray2[2] = DefaultConfigurableCacheFactory.makeInteger(cPageSecs);
            objectArray2[3] = Boolean.TRUE;
            objectArray = objectArray2;
            objectArray2[4] = new Boolean(fBackup);
        } else {
            Object[] objectArray3 = new Object[4];
            objectArray3[0] = mgr;
            objectArray3[1] = DefaultConfigurableCacheFactory.makeInteger(cPages);
            objectArray3[2] = DefaultConfigurableCacheFactory.makeInteger(cPageSecs);
            objectArray = objectArray3;
            objectArray3[3] = loader;
        }
        Object[] aoParam = objectArray;
        return (Map)this.instantiateSubclass(sSubclass, SerializationPagedCache.class, loader, aoParam, xmlPaged.getElement("init-params"));
    }

    protected BinaryStoreManager instantiateBinaryStoreManager(XmlElement xmlConfig, ClassLoader loader, boolean fPaged) {
        Iterator iter = xmlConfig.getElementList().iterator();
        while (iter.hasNext()) {
            Object[] aoParam;
            XmlElement xmlStore = (XmlElement)iter.next();
            String sType = xmlStore.getName();
            String sSubclass = xmlStore.getSafeElement("class-name").getString();
            XmlElement xmlParams = xmlStore.getElement("init-params");
            File fileDir = null;
            int cbMaxSize = 0;
            int cbInitSize = 0;
            if (sType.equals("lh-file-manager") || sType.equals("nio-file-manager") || sType.equals("bdb-store-manager")) {
                String sPath = xmlStore.getSafeElement("directory").getString();
                File file = fileDir = sPath.length() == 0 ? null : new File(sPath);
            }
            if (sType.equals("nio-file-manager") || sType.equals("nio-memory-manager")) {
                long cbInit = DefaultConfigurableCacheFactory.parseMemorySize(xmlStore.getSafeElement("initial-size").getString("1"), 20);
                long cbMax = DefaultConfigurableCacheFactory.parseMemorySize(xmlStore.getSafeElement("maximum-size").getString("1024"), 20);
                cbMaxSize = (int)Math.min(Math.max(cbMax, 1L), 2147482624L);
                cbInitSize = (int)Math.min(Math.max(cbInit, 1L), (long)cbMaxSize);
            }
            if (sType.equals("lh-file-manager")) {
                if (fPaged) {
                    if (sSubclass.length() == 0) {
                        return new LHBinaryStoreManager(fileDir);
                    }
                    aoParam = new Object[]{fileDir};
                    return (BinaryStoreManager)this.instantiateSubclass(sSubclass, LHBinaryStoreManager.class, loader, aoParam, xmlParams);
                }
                String sName = xmlStore.getSafeElement("file-name").getString().trim();
                if (sName.length() == 0) {
                    sName = null;
                }
                if (sSubclass.length() == 0) {
                    return new LHBinaryStoreManager(fileDir, sName);
                }
                Object[] aoParam2 = new Object[]{fileDir, sName};
                return (BinaryStoreManager)this.instantiateSubclass(sSubclass, LHBinaryStoreManager.class, loader, aoParam2, xmlParams);
            }
            if (sType.equals("bdb-store-manager")) {
                String sStoreName = xmlStore.getSafeElement("store-name").getString();
                try {
                    if (sSubclass.length() == 0) {
                        BerkeleyDBBinaryStoreManager bdbMgr = new BerkeleyDBBinaryStoreManager(fileDir, sStoreName);
                        if (xmlParams != null) {
                            SimpleElement xmlInit = new SimpleElement("config");
                            XmlHelper.transformInitParams(xmlInit, xmlParams);
                            bdbMgr.setConfig(xmlInit);
                        }
                        return bdbMgr;
                    }
                    Object[] aoParam3 = new Object[]{fileDir, sStoreName};
                    return (BinaryStoreManager)this.instantiateSubclass(sSubclass, BerkeleyDBBinaryStoreManager.class, loader, aoParam3, xmlParams);
                }
                catch (NoClassDefFoundError e) {
                    String sMsg = "Berkeley DB JE libraries are required to utilize a 'bdb-store-manager', visit www.sleepycat.com for additional information.";
                    throw DefaultConfigurableCacheFactory.ensureRuntimeException(e, sMsg);
                }
            }
            if (sType.equals("nio-file-manager")) {
                if (sSubclass.length() == 0) {
                    return new MappedStoreManager(cbInitSize, cbMaxSize, fileDir);
                }
                aoParam = new Object[]{DefaultConfigurableCacheFactory.makeInteger(cbInitSize), DefaultConfigurableCacheFactory.makeInteger(cbMaxSize), fileDir};
                return (BinaryStoreManager)this.instantiateSubclass(sSubclass, MappedStoreManager.class, loader, aoParam, xmlParams);
            }
            if (sType.equals("nio-memory-manager")) {
                if (sSubclass.length() == 0) {
                    return new DirectStoreManager(cbInitSize, cbMaxSize);
                }
                aoParam = new Object[]{DefaultConfigurableCacheFactory.makeInteger(cbInitSize), DefaultConfigurableCacheFactory.makeInteger(cbMaxSize)};
                return (BinaryStoreManager)this.instantiateSubclass(sSubclass, DirectStoreManager.class, loader, aoParam, xmlParams);
            }
            if (sType.equals("async-store-manager")) {
                Object[] objectArray;
                int cbMaxAsync = (int)DefaultConfigurableCacheFactory.parseMemorySize(xmlStore.getSafeElement("async-limit").getString("0"));
                BinaryStoreManager mgr = this.instantiateBinaryStoreManager(xmlStore, loader, fPaged);
                if (sSubclass.length() == 0) {
                    return this.instantiateAsyncBinaryStoreManager(mgr, cbMaxAsync);
                }
                if (cbMaxAsync <= 0) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = mgr;
                } else {
                    Object[] objectArray3 = new Object[2];
                    objectArray3[0] = mgr;
                    objectArray = objectArray3;
                    objectArray3[1] = DefaultConfigurableCacheFactory.makeInteger(cbMaxAsync);
                }
                Object[] aoParam4 = objectArray;
                return (BinaryStoreManager)this.instantiateSubclass(sSubclass, AsyncBinaryStoreManager.class, loader, aoParam4, xmlParams);
            }
            if (!sType.equals("custom-store-manager")) continue;
            if (sSubclass.length() == 0) {
                throw new IllegalArgumentException("Missing class-name:\n" + xmlStore);
            }
            return (BinaryStoreManager)this.instantiateSubclass(sSubclass, BinaryStoreManager.class, loader, null, xmlParams);
        }
        throw new IllegalArgumentException("Missing BinaryStoreManager configuration:\n" + xmlConfig);
    }

    protected AsyncBinaryStore instantiateAsyncBinaryStore(BinaryStore store, int cbMaxAsync) {
        return cbMaxAsync <= 0 ? new AsyncBinaryStore(store) : new AsyncBinaryStore(store, cbMaxAsync);
    }

    protected AsyncBinaryStoreManager instantiateAsyncBinaryStoreManager(BinaryStoreManager storeMgr, int cbMaxAsync) {
        return cbMaxAsync <= 0 ? new AsyncBinaryStoreManager(storeMgr) : new AsyncBinaryStoreManager(storeMgr, cbMaxAsync);
    }

    protected SerializationPagedCache instantiateSerializationPagedCache(BinaryStoreManager storeMgr, int cPages, int cPageSecs, ClassLoader loader) {
        return new SerializationPagedCache(storeMgr, cPages, cPageSecs, loader);
    }

    protected SerializationPagedCache instantiateSerializationPagedCache(BinaryStoreManager storeMgr, int cPages, int cPageSecs, boolean fBinaryMap, boolean fPassive) {
        return new SerializationPagedCache(storeMgr, cPages, cPageSecs, fBinaryMap, fPassive);
    }

    protected SerializationCache instantiateSerializationCache(BinaryStore store, int cMax, ClassLoader loader) {
        return new SerializationCache(store, cMax, loader);
    }

    protected SerializationCache instantiateSerializationCache(BinaryStore store, int cMax, boolean fBinaryMap) {
        return new SerializationCache(store, cMax, fBinaryMap);
    }

    protected SerializationMap instantiateSerializationMap(BinaryStore store, ClassLoader loader) {
        return new SerializationMap(store, loader);
    }

    protected SerializationMap instantiateSerializationMap(BinaryStore store, boolean fBinaryMap) {
        return new SerializationMap(store, fBinaryMap);
    }

    protected BundlingNamedCache instantiateBundlingNamedCache(NamedCache cache, XmlElement xmlBundling) {
        BundlingNamedCache cacheBundle = new BundlingNamedCache(cache);
        Iterator iter = xmlBundling.getElements("bundle-config");
        while (iter.hasNext()) {
            XmlElement xmlBundle = (XmlElement)iter.next();
            String sOperation = xmlBundle.getSafeElement("operation-name").getString("all");
            int cBundle = xmlBundle.getSafeElement("preferred-size").getInt();
            if (sOperation.equals("all")) {
                this.initializeBundler(cacheBundle.ensureGetBundler(cBundle), xmlBundle);
                this.initializeBundler(cacheBundle.ensurePutBundler(cBundle), xmlBundle);
                this.initializeBundler(cacheBundle.ensureRemoveBundler(cBundle), xmlBundle);
                continue;
            }
            if (sOperation.equals("get")) {
                this.initializeBundler(cacheBundle.ensureGetBundler(cBundle), xmlBundle);
                continue;
            }
            if (sOperation.equals("put")) {
                this.initializeBundler(cacheBundle.ensurePutBundler(cBundle), xmlBundle);
                continue;
            }
            if (sOperation.equals("remove")) {
                this.initializeBundler(cacheBundle.ensureRemoveBundler(cBundle), xmlBundle);
                continue;
            }
            throw new IllegalArgumentException("Invalid \"operation-name\" element:\n" + xmlBundle);
        }
        return cacheBundle;
    }

    protected void initializeBundler(AbstractBundler bundler, XmlElement xmlBundle) {
        if (bundler != null) {
            bundler.setThreadThreshold(xmlBundle.getSafeElement("thread-threshold").getInt(4));
            bundler.setDelayMillis(xmlBundle.getSafeElement("delay-millis").getLong(1L));
            bundler.setAllowAutoAdjust(xmlBundle.getSafeElement("auto-adjust").getBoolean(false));
        }
    }

    protected Map instantiateMap(CacheInfo info, XmlElement xmlClass, BackingMapManagerContext context, ClassLoader loader) {
        try {
            return (Map)this.instantiateAny(info, xmlClass, context, loader);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Not a map:\n" + xmlClass);
        }
    }

    protected CacheLoader instantiateCacheStore(CacheInfo info, XmlElement xmlStore, BackingMapManagerContext context, ClassLoader loader) {
        if ((xmlStore = this.resolveScheme(xmlStore, info, true, false)) == null || XmlHelper.isEmpty(xmlStore)) {
            return null;
        }
        String sSchemeType = xmlStore.getName();
        try {
            switch (this.translateSchemeType(sSchemeType)) {
                case 11: {
                    return (CacheLoader)this.instantiateAny(info, xmlStore, context, loader);
                }
                case 16: {
                    return (CacheLoader)((Object)this.configureCache(info, xmlStore, loader));
                }
            }
            throw new UnsupportedOperationException("instantiateCacheStore: " + sSchemeType);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Not a CacheLoader:\n" + xmlStore);
        }
    }

    protected MapListener instantiateMapListener(CacheInfo info, XmlElement xmlClass, BackingMapManagerContext context, ClassLoader loader) {
        try {
            return (MapListener)this.instantiateAny(info, xmlClass, context, loader);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Not a listener:\n" + xmlClass);
        }
    }

    protected Object instantiateAny(CacheInfo info, XmlElement xmlClass, BackingMapManagerContext context, ClassLoader loader) {
        if (this.translateSchemeType(xmlClass.getName()) != 11) {
            throw new IllegalArgumentException("Invalid class definition: " + xmlClass);
        }
        String sClass = xmlClass.getSafeElement("class-name").getString();
        String sMethod = null;
        if (sClass.length() == 0) {
            sClass = xmlClass.getSafeElement("class-factory-name").getString();
            sMethod = xmlClass.getSafeElement("method-name").getString();
            if (sClass.length() == 0 || sMethod.length() == 0) {
                throw new IllegalArgumentException("Class name is missing:\n" + xmlClass);
            }
        }
        XmlElement xmlParams = xmlClass.getElement("init-params");
        try {
            Class clz = ExternalizableHelper.loadClass(sClass, loader, null);
            if (xmlParams == null) {
                return sMethod == null ? clz.newInstance() : ClassHelper.invokeStatic(clz, sMethod, null);
            }
            if (XmlConfigurable.class.isAssignableFrom(clz)) {
                SimpleElement xmlConfig = new SimpleElement("config");
                XmlHelper.transformInitParams(xmlConfig, xmlParams);
                XmlConfigurable target = sMethod == null ? (XmlConfigurable)clz.newInstance() : (XmlConfigurable)ClassHelper.invokeStatic(clz, sMethod, null);
                target.setConfig(xmlConfig);
                return target;
            }
            Object[] aoParam = XmlHelper.parseInitParams(xmlParams);
            int c = aoParam.length;
            block8: for (int i = 0; i < c; ++i) {
                Object oParam = aoParam[i];
                if (!(oParam instanceof XmlElement)) continue;
                XmlElement xmlParam = (XmlElement)oParam;
                String sType = xmlParam.getSafeElement("param-type").getString();
                XmlElement xmlValue = xmlParam.getSafeElement("param-value");
                if (xmlValue.getString().equals(CLASS_LOADER)) {
                    aoParam[i] = loader;
                    continue;
                }
                if (xmlValue.getString().equals(MGR_CONTEXT)) {
                    aoParam[i] = context;
                    continue;
                }
                if (!sType.equals(SCHEME_REF)) continue;
                String sSchemeName = xmlValue.getString();
                XmlElement xmlScheme = this.resolveScheme(new CacheInfo(info.getCacheName(), sSchemeName, info.getAttributes()));
                String sSchemeType = xmlScheme.getName();
                switch (this.translateSchemeType(sSchemeType)) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 16: {
                        aoParam[i] = this.configureCache(info, xmlScheme, loader);
                        continue block8;
                    }
                    case 14: 
                    case 17: {
                        aoParam[i] = this.ensureService(xmlScheme);
                        continue block8;
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 13: {
                        Map mapListeners = context == null ? null : ((Manager)context.getManager()).m_mapBackingMapListeners;
                        aoParam[i] = this.configureBackingMap(info, xmlScheme, context, null, mapListeners);
                        continue block8;
                    }
                    case 11: {
                        aoParam[i] = this.instantiateAny(info, xmlScheme, context, loader);
                        continue block8;
                    }
                    default: {
                        throw new UnsupportedOperationException("instantiateAny: " + sSchemeType);
                    }
                }
            }
            return sMethod == null ? ClassHelper.newInstance(clz, aoParam) : ClassHelper.invokeStatic(clz, sMethod, aoParam);
        }
        catch (Throwable e) {
            String sTarget = sMethod == null ? '\"' + sClass + '\"' : "using factory method \"" + sClass + '.' + sMethod + "()\"";
            throw Base.ensureRuntimeException(e, "Failed to instantiate class " + sTarget + " using " + loader + "\n" + xmlClass);
        }
    }

    protected Object instantiateSubclass(String sClass, Class clzSuper, ClassLoader loader, Object[] aoParam, XmlElement xmlParams) {
        if (sClass == null || sClass.length() == 0 || clzSuper == null) {
            throw new IllegalArgumentException("Class name and super class must be specified");
        }
        try {
            Class clz = ExternalizableHelper.loadClass(sClass, loader, clzSuper.getClassLoader());
            if (!clzSuper.isAssignableFrom(clz)) {
                throw new IllegalArgumentException(clzSuper + " is not a super-class of " + clz);
            }
            Object oTarget = aoParam == null ? clz.newInstance() : ClassHelper.newInstance(clz, aoParam);
            if (xmlParams != null && oTarget instanceof XmlConfigurable) {
                SimpleElement xmlConfig = new SimpleElement("config");
                XmlHelper.transformInitParams(xmlConfig, xmlParams);
                ((XmlConfigurable)oTarget).setConfig(xmlConfig);
            }
            return oTarget;
        }
        catch (Exception e) {
            throw DefaultConfigurableCacheFactory.ensureRuntimeException(e, "Fail to instantiate subclass: " + sClass + " of " + clzSuper);
        }
    }

    public void release(Map map, Map mapListeners) {
        Integer Identity;
        MapListener listener;
        if (map instanceof ObservableMap && (listener = (MapListener)mapListeners.get(Identity = DefaultConfigurableCacheFactory.makeInteger(System.identityHashCode(map)))) != null) {
            ((ObservableMap)map).removeMapListener(listener);
            mapListeners.remove(Identity);
        }
        if (map instanceof LocalCache) {
            CacheLoader loader = ((LocalCache)map).getCacheLoader();
            if (loader instanceof MapCacheStore) {
                this.release(((MapCacheStore)loader).getMap(), mapListeners);
            } else {
                this.release(loader);
            }
        } else if (map instanceof OverflowMap) {
            this.release(((OverflowMap)map).getFrontMap(), mapListeners);
            this.release(((OverflowMap)map).getBackMap(), mapListeners);
        } else if (map instanceof ReadWriteBackingMap) {
            ((ReadWriteBackingMap)map).release();
            this.release(((ReadWriteBackingMap)map).getInternalCache(), mapListeners);
            this.release(((ReadWriteBackingMap)map).getCacheStore());
        } else if (map instanceof SerializationMap) {
            this.release(((SerializationMap)map).getBinaryStore());
        } else {
            Class<?> clzMap = map.getClass();
            do {
                if (!clzMap.getName().equals("com.tangosol.nio.BinaryMap")) continue;
                try {
                    Object bufmgr = ClassHelper.invoke(map, "getBufferManager", ClassHelper.VOID);
                    ClassHelper.invoke(bufmgr, "close", ClassHelper.VOID);
                }
                catch (Exception e) {}
                break;
            } while ((clzMap = clzMap.getSuperclass()) != null);
        }
    }

    protected void release(CacheLoader loader) {
        try {
            ClassHelper.invoke(loader, "close", ClassHelper.VOID);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void release(BinaryStore store) {
        if (store instanceof LHBinaryStore) {
            ((LHBinaryStore)store).close();
        } else {
            try {
                ClassHelper.invoke(store, "close", ClassHelper.VOID);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int translateSchemeType(String sScheme) {
        return sScheme.equals("replicated-scheme") ? 1 : (sScheme.equals("optimistic-scheme") ? 2 : (sScheme.equals("distributed-scheme") ? 3 : (sScheme.equals("local-scheme") ? 6 : (sScheme.equals("overflow-scheme") ? 7 : (sScheme.equals("disk-scheme") ? 8 : (sScheme.equals("external-scheme") ? 9 : (sScheme.equals("paged-external-scheme") ? 10 : (sScheme.equals("class-scheme") ? 11 : (sScheme.equals("near-scheme") ? 4 : (sScheme.equals("versioned-near-scheme") ? 5 : (sScheme.equals("read-write-backing-map-scheme") ? 12 : (sScheme.equals("versioned-backing-map-scheme") ? 13 : (sScheme.equals("invocation-scheme") ? 14 : (sScheme.equals("proxy-scheme") ? 15 : (sScheme.equals("remote-cache-scheme") ? 16 : (sScheme.equals("remote-invocation-scheme") ? 17 : 0))))))))))))))));
    }

    public static boolean isPutAllOptimized(Map map) {
        if (map instanceof SafeHashMap) {
            return false;
        }
        if (map instanceof ReadWriteBackingMap) {
            return DefaultConfigurableCacheFactory.isPutAllOptimized(((ReadWriteBackingMap)map).getInternalCache());
        }
        return !(map instanceof HashMap);
    }

    protected void register(NamedCache cache, String sContext) {
        this.register(cache.getCacheService(), cache.getCacheName(), sContext, cache);
    }

    protected void register(CacheService service, String sCacheName, String sContext, Map map) {
        try {
            Cluster cluster = service.getCluster();
            Registry registry = cluster.getManagement();
            if (registry != null) {
                String sName = "type=Cache,service=" + service.getInfo().getServiceName() + ",name=" + sCacheName;
                sName = registry.ensureGlobalName(sName);
                sName = sName + "," + sContext;
                registry.register(sName, map);
            }
        }
        catch (Throwable e) {
            CacheFactory.log("Failed to register cache \"" + sCacheName + "\"; " + e, 2);
        }
    }

    protected void unregister(CacheService service, String sCacheName) {
        try {
            Cluster cluster = service.getCluster();
            Registry registry = cluster.getManagement();
            if (registry != null) {
                Member member = cluster.getLocalMember();
                String sPattern = "type=Cache,service=" + service.getInfo().getServiceName() + ",name=" + sCacheName + (member == null ? "" : ",nodeId=" + member.getId()) + ",*";
                registry.unregister(sPattern);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void unregister(String sCacheName, String sContext) {
        try {
            Cluster cluster = CacheFactory.getCluster();
            Registry registry = cluster.getManagement();
            if (registry != null) {
                Member member = cluster.getLocalMember();
                String sPattern = "type=Cache,name=" + sCacheName + (member == null ? "" : ",nodeId=" + member.getId()) + "," + sContext + ",*";
                registry.unregister(sPattern);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void pushCacheContext(String sContext) {
        this.m_tlo.set(sContext);
    }

    protected String popCacheContext() {
        String s = (String)this.m_tlo.get();
        this.m_tlo.set(null);
        return s;
    }

    public static class CacheInfo {
        protected String m_sCacheName;
        protected String m_sSchemeName;
        protected Map m_mapAttribute;

        public CacheInfo(String sCacheName, String sSchemeName, Map mapAttribute) {
            this.m_sCacheName = sCacheName;
            this.m_sSchemeName = sSchemeName;
            this.m_mapAttribute = mapAttribute;
        }

        public String getCacheName() {
            return this.m_sCacheName;
        }

        public String getSchemeName() {
            return this.m_sSchemeName;
        }

        public Map getAttributes() {
            return this.m_mapAttribute;
        }

        public void replaceAttributes(XmlElement xml) {
            Iterator iter = xml.getElementList().iterator();
            while (iter.hasNext()) {
                XmlElement xmlChild = (XmlElement)iter.next();
                if (!xmlChild.isEmpty()) {
                    String sText = xmlChild.getString();
                    int ofStart = sText.indexOf(123);
                    int ofEnd = -1;
                    boolean fReplace = false;
                    StringBuffer sbTextNew = new StringBuffer();
                    while (ofStart >= 0) {
                        String sValue;
                        sbTextNew.append(sText.substring(ofEnd + 1, ofStart));
                        ofEnd = sText.indexOf(125, ofStart);
                        if (ofEnd < 0) {
                            CacheFactory.log("Invalid attribute format: " + sText, 1);
                            fReplace = false;
                            break;
                        }
                        String sAttribute = sText.substring(ofStart, ofEnd + 1);
                        String sAttrName = sText.substring(ofStart + 1, ofEnd);
                        String sDefault = null;
                        int ofDefault = sAttrName.indexOf(32);
                        if (ofDefault > 0) {
                            sDefault = sAttrName.substring(ofDefault + 1).trim();
                            sAttrName = sAttrName.substring(0, ofDefault);
                        }
                        String string = sValue = sAttribute.equals(DefaultConfigurableCacheFactory.CACHE_NAME) ? this.getCacheName() : (String)this.getAttributes().get(sAttrName);
                        if (sValue == null) {
                            if (sDefault == null) {
                                if (!(sAttribute.equals(DefaultConfigurableCacheFactory.CLASS_LOADER) || sAttribute.equals(DefaultConfigurableCacheFactory.MGR_CONTEXT) || sAttribute.equals(DefaultConfigurableCacheFactory.SCHEME_REF))) {
                                    CacheFactory.log("Missing parameter definition: " + sAttribute + " for cache \"" + this.getCacheName() + '\"', 2);
                                }
                                fReplace = false;
                                break;
                            }
                            sValue = sDefault;
                        }
                        sbTextNew.append(sValue);
                        fReplace = true;
                        ofStart = sText.indexOf(123, ofEnd);
                    }
                    if (fReplace) {
                        sbTextNew.append(sText.substring(ofEnd + 1));
                        xmlChild.setString(sbTextNew.toString());
                    }
                }
                this.replaceAttributes(xmlChild);
            }
        }

        public CacheInfo getSyntheticInfo(String sSuffix) {
            return new CacheInfo(this.getCacheName() + sSuffix, null, this.getAttributes());
        }
    }

    public class Manager
    extends AbstractBackingMapManager {
        private Map m_mapBackingMap;
        private Map m_mapBackingMapListeners;

        public void init(BackingMapManagerContext context) {
            super.init(context);
            this.m_mapBackingMap = new HashMap();
            this.m_mapBackingMapListeners = new HashMap();
        }

        public Map instantiateBackingMap(String sName) {
            CacheInfo infoCache = DefaultConfigurableCacheFactory.this.findSchemeMapping(sName);
            XmlElement xmlScheme = DefaultConfigurableCacheFactory.this.resolveScheme(infoCache);
            xmlScheme.addAttribute("tier").setString("back");
            DefaultConfigurableCacheFactory.this.pushCacheContext("tier=back");
            Map map = DefaultConfigurableCacheFactory.this.configureBackingMap(infoCache, xmlScheme, this.getContext(), null, this.m_mapBackingMapListeners);
            this.setBackingMap(sName, map);
            return map;
        }

        public void releaseBackingMap(String sName, Map map) {
            DefaultConfigurableCacheFactory.this.unregister(this.getContext().getCacheService(), sName);
            DefaultConfigurableCacheFactory.this.release(map, this.m_mapBackingMapListeners);
            this.setBackingMap(sName, null);
        }

        public Map getBackingMap(String sName) {
            return this.m_mapBackingMap == null ? null : (Map)this.m_mapBackingMap.get(sName);
        }

        protected void setBackingMap(String sName, Map map) {
            if (map != null && this.getBackingMap(sName) != null) {
                throw new IllegalArgumentException("BackingMap is not resettable: " + sName);
            }
            this.m_mapBackingMap.put(sName, map);
        }

        public DefaultConfigurableCacheFactory getCacheFactory() {
            return DefaultConfigurableCacheFactory.this;
        }
    }
}

