/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.util.Base;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

public abstract class InetAddressHelper
extends Base {
    public static final boolean PreferIPv4Stack = Boolean.getBoolean("java.net.preferIPv4Stack");
    public static final boolean PreferIPv6Addresses = Boolean.getBoolean("java.net.preferIPv6Addresses");

    public static InetAddress getLocalHost() throws UnknownHostException {
        InetAddress addrLocal = InetAddress.getLocalHost();
        if (addrLocal.isLoopbackAddress() || addrLocal.isAnyLocalAddress() || addrLocal.isLinkLocalAddress()) {
            InetAddress addrBest = null;
            List listAddr = InetAddressHelper.getAllLocalAddresses();
            Iterator iter = listAddr.iterator();
            while (iter.hasNext()) {
                InetAddress addr = (InetAddress)iter.next();
                if (addr.isLoopbackAddress() || addr.isAnyLocalAddress() || addr.isLinkLocalAddress()) continue;
                if (addr.isSiteLocalAddress()) {
                    if (addrBest != null) continue;
                    addrBest = addr;
                    continue;
                }
                return addr;
            }
            if (addrBest != null) {
                return addrBest;
            }
        }
        return addrLocal;
    }

    public static List getAllLocalAddresses() {
        ArrayList<InetAddress> listAddr = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> enmrNI = NetworkInterface.getNetworkInterfaces();
            while (enmrNI.hasMoreElements()) {
                NetworkInterface ni = enmrNI.nextElement();
                Enumeration<InetAddress> enmrAddr = ni.getInetAddresses();
                while (enmrAddr.hasMoreElements()) {
                    listAddr.add(enmrAddr.nextElement());
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return listAddr;
    }

    public static boolean isLoopbackAddress(InetAddress addr) {
        InetAddressHelper.azzert(addr != null);
        return addr.isLoopbackAddress();
    }

    public static boolean isAnyLocalAddress(InetAddress addr) {
        InetAddressHelper.azzert(addr != null);
        return addr.isAnyLocalAddress();
    }

    public static boolean isLinkLocalAddress(InetAddress addr) {
        InetAddressHelper.azzert(addr != null);
        return addr.isLinkLocalAddress();
    }

    public static boolean isSiteLocalAddress(InetAddress addr) {
        InetAddressHelper.azzert(addr != null);
        return addr.isSiteLocalAddress();
    }

    public static InetAddress getByAddress(byte[] abAddr) throws UnknownHostException {
        block4: {
            if (abAddr == null) {
                return null;
            }
            if (abAddr.length == 16 && !PreferIPv6Addresses) {
                for (int i = 0; i < 12; ++i) {
                    if (abAddr[i] == 0) {
                        continue;
                    }
                    break block4;
                }
                abAddr = new byte[]{abAddr[12], abAddr[13], abAddr[14], abAddr[15]};
            }
        }
        return InetAddress.getByAddress(abAddr);
    }

    public static boolean virtuallyEqual(byte[] abAddr1, byte[] abAddr2) {
        int cb1 = abAddr1.length;
        int cb2 = abAddr2.length;
        InetAddressHelper.azzert(cb1 == 4 || cb1 == 16);
        int of1 = 0;
        int of2 = 0;
        if (cb1 != cb2) {
            byte[] abIP6;
            InetAddressHelper.azzert(cb2 == 4 || cb2 == 16);
            if (cb1 == 4) {
                abIP6 = abAddr2;
                of2 = 12;
            } else {
                abIP6 = abAddr1;
                of1 = 12;
            }
            for (int of = 0; of < 12; ++of) {
                if (abIP6[of] == 0) continue;
                return false;
            }
        }
        while (of1 < cb1) {
            if (abAddr1[of1++] == abAddr2[of2++]) continue;
            return false;
        }
        return true;
    }

    public static long toLong(InetAddress addr) {
        InetAddressHelper.azzert(addr != null);
        byte[] ab = addr.getAddress();
        int of = ab.length == 4 ? 0 : 12;
        return ((long)ab[of + 0] & 0xFFL) << 24 | ((long)ab[of + 1] & 0xFFL) << 16 | ((long)ab[of + 2] & 0xFFL) << 8 | (long)ab[of + 3] & 0xFFL;
    }

    public static String toString(byte[] ab) {
        int cb = ab.length;
        int of = 0;
        InetAddressHelper.azzert(cb == 4 || cb == 16);
        StringBuffer sb = new StringBuffer(40);
        if (cb == 16) {
            boolean fIPv4 = true;
            int i = 0;
            while (i < 6) {
                int iVal = (ab[of + 0] & 0xFF) << 8 | ab[of + 1] & 0xFF;
                sb.append(InetAddressHelper.toHexString(iVal, InetAddressHelper.getMaxHexDigits(iVal))).append(':');
                fIPv4 &= iVal == 0;
                ++i;
                of += 2;
            }
            if (fIPv4) {
                sb.setLength(0);
                sb.append("::");
            }
        }
        int i = 0;
        while (i < 3) {
            sb.append(ab[of] & 0xFF).append('.');
            ++i;
            ++of;
        }
        sb.append(ab[of] & 0xFF);
        return sb.toString();
    }

    public static String toString(InetAddress addr) {
        if (addr == null) {
            return String.valueOf(addr);
        }
        if (addr instanceof Inet6Address) {
            return InetAddressHelper.toString(addr.getAddress());
        }
        return addr.getHostAddress();
    }
}

