/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.util.Base;
import com.tangosol.util.Daemon;
import com.tangosol.util.RecyclingLinkedList;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;

public class LoadBalancer
extends Base
implements Runnable {
    protected AddressPort m_addrportHost;
    protected AddressPort[] m_aAddrPortDest;
    protected Properties m_propOptions;
    protected Thread m_threadRunning;
    protected Queue m_queue;
    protected List m_listHandler = new ArrayList();
    protected boolean m_fRoundRobin;
    protected Random m_random = LoadBalancer.getRandom();
    protected int m_iNextDestination;

    public static void main(String[] asArgs) {
        LoadBalancer lb;
        int cArgs;
        AddressPort addrportHost = null;
        ArrayList<AddressPort> listAddrPort = new ArrayList<AddressPort>();
        Properties propOptions = new Properties();
        int n = cArgs = asArgs == null ? 0 : asArgs.length;
        for (int iArg = 0; iArg < cArgs; ++iArg) {
            int nPort;
            InetAddress addr;
            String sArg = asArgs[iArg];
            if (!(sArg != null & sArg.length() > 0)) continue;
            if (sArg.charAt(0) == '-') {
                int ofEq = sArg.indexOf(61);
                if (ofEq < 0) {
                    propOptions.put(sArg.substring(1), "true");
                    continue;
                }
                propOptions.put(sArg.substring(1, ofEq), sArg.substring(ofEq + 1));
                continue;
            }
            int ofColon = sArg.indexOf(58);
            if (ofColon < 0) {
                LoadBalancer.showInstructions();
                return;
            }
            String sAddr = sArg.substring(0, ofColon);
            String sPort = sArg.substring(ofColon + 1);
            if (sAddr.length() == 0 || sPort.length() == 0) {
                LoadBalancer.out("IP and port are required for both the host and all destination addresses");
                LoadBalancer.showInstructions();
                return;
            }
            try {
                addr = InetAddress.getByName(sAddr);
                nPort = Integer.parseInt(sPort);
            }
            catch (Exception e) {
                LoadBalancer.out(e);
                LoadBalancer.showInstructions();
                return;
            }
            if (nPort < 1 || nPort > 65535) {
                LoadBalancer.out("Illegal port value: " + nPort);
                LoadBalancer.showInstructions();
                return;
            }
            AddressPort addrport = new AddressPort(addr, nPort);
            if (addrportHost == null) {
                addrportHost = addrport;
                continue;
            }
            listAddrPort.add(addrport);
        }
        if (addrportHost == null || listAddrPort.isEmpty()) {
            LoadBalancer.showInstructions();
            return;
        }
        try {
            lb = new LoadBalancer(addrportHost, listAddrPort.toArray(new AddressPort[listAddrPort.size()]), propOptions);
        }
        catch (Exception e) {
            LoadBalancer.out(e);
            LoadBalancer.showInstructions();
            return;
        }
        lb.run();
    }

    public static void showInstructions() {
        LoadBalancer.out();
        LoadBalancer.out("java LoadBalancer <host-ip>:<host-port> <ip>:<port> <ip>:<port> ...");
        LoadBalancer.out();
    }

    public LoadBalancer(AddressPort addrportHost, AddressPort[] aAddrPortDest, Properties propOptions) {
        LoadBalancer.azzert(addrportHost != null);
        LoadBalancer.azzert(aAddrPortDest != null);
        int c = aAddrPortDest.length;
        for (int i = 0; i < c; ++i) {
            LoadBalancer.azzert(aAddrPortDest[i] != null);
        }
        LoadBalancer.azzert(propOptions != null);
        this.m_addrportHost = addrportHost;
        this.m_aAddrPortDest = aAddrPortDest;
        this.m_propOptions = propOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Queue queue;
        LoadBalancer loadBalancer = this;
        synchronized (loadBalancer) {
            if (this.m_threadRunning != null) {
                throw new IllegalStateException("Load balancer cannot be started on more than one thread or restarted once it stops");
            }
            this.m_threadRunning = Thread.currentThread();
        }
        int cBacklog = this.getProperty("backlog", 64);
        int cThreads = this.getProperty("threads", 64);
        boolean fKeepAlive = this.getProperty("keepalive", true);
        this.m_queue = queue = this.instantiateQueue();
        List listHandler = this.m_listHandler;
        for (int i = 0; i < cThreads; ++i) {
            listHandler.add(this.instantiateRequestHandler(queue));
        }
        this.m_fRoundRobin = this.getProperty("roundrobin", false);
        AddressPort addrportHost = this.getHost();
        ServerSocket socketAccept = null;
        try {
            try {
                socketAccept = new ServerSocket(addrportHost.nPort, cBacklog, addrportHost.address);
            }
            catch (IOException e) {
                throw new WrapperException(e);
            }
            while (true) {
                Socket socket = null;
                try {
                    socket = socketAccept.accept();
                    socket.setKeepAlive(fKeepAlive);
                    if (!fKeepAlive) {
                        socket.setSoTimeout(1000);
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (socket == null) continue;
                queue.add(socket);
            }
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            if (socketAccept != null) {
                try {
                    socketAccept.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            while (!queue.isEmpty()) {
                Socket socket = (Socket)queue.removeNoWait();
                if (socket == null) continue;
                try {
                    socket.close();
                }
                catch (Exception e) {}
            }
            throw throwable;
        }
    }

    public AddressPort getHost() {
        return this.m_addrportHost;
    }

    public int getDestinationCount() {
        AddressPort[] aAddrPort = this.m_aAddrPortDest;
        return aAddrPort == null ? 0 : aAddrPort.length;
    }

    public AddressPort getDestination(int i) {
        return this.m_aAddrPortDest[i];
    }

    public Socket getNextDestinationSocket() {
        for (int i = 0; i < 128; ++i) {
            AddressPort addrport = this.getNextDestination();
            if (addrport == null) {
                return null;
            }
            try {
                Socket socket = new Socket(addrport.address, addrport.nPort);
                LoadBalancer.out("routing to " + addrport);
                return socket;
            }
            catch (Exception e) {
                LoadBalancer.out("*** could not connect to " + addrport + "; " + e);
                continue;
            }
        }
        return null;
    }

    protected AddressPort getNextDestination() {
        return this.m_fRoundRobin ? this.getRoundRobinDestination() : this.getRandomDestination();
    }

    protected AddressPort getRandomDestination() {
        int c = this.getDestinationCount();
        if (c == 0) {
            return null;
        }
        int i = this.m_random.nextInt(c);
        return this.getDestination(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AddressPort getRoundRobinDestination() {
        int i;
        int c = this.getDestinationCount();
        if (c == 0) {
            return null;
        }
        LoadBalancer loadBalancer = this;
        synchronized (loadBalancer) {
            i = this.m_iNextDestination;
            this.m_iNextDestination = i + 1 >= c ? 0 : i + 1;
        }
        return this.getDestination(i);
    }

    protected Queue getQueue() {
        return this.m_queue;
    }

    public String getProperty(String sName, String sDefault) {
        return this.m_propOptions.getProperty(sName, sDefault);
    }

    public int getProperty(String sName, int nDefault) {
        String sValue = this.m_propOptions.getProperty(sName);
        if (sValue != null) {
            try {
                return Integer.parseInt(sValue);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return nDefault;
    }

    public boolean getProperty(String sName, boolean fDefault) {
        String sValue = this.m_propOptions.getProperty(sName);
        if (sValue != null) {
            try {
                switch (sValue.charAt(0)) {
                    case '0': 
                    case 'F': 
                    case 'N': 
                    case 'f': 
                    case 'n': {
                        return false;
                    }
                    case '1': 
                    case 'T': 
                    case 'Y': 
                    case 't': 
                    case 'y': {
                        return true;
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return fDefault;
    }

    protected static String parseThreadExtension(Daemon daemon) {
        Thread thread = daemon.getThread();
        if (thread == null) {
            return "";
        }
        String sName = thread.getName();
        int ofHyphen = sName.indexOf(45);
        return ofHyphen < 0 ? "" : sName.substring(ofHyphen);
    }

    protected Queue instantiateQueue() {
        return new Queue();
    }

    protected RequestHandler instantiateRequestHandler(Queue queue) {
        return new RequestHandler(queue);
    }

    protected ResponseHandler instantiateResponseHandler(RequestHandler daemonRequest) {
        return new ResponseHandler(daemonRequest);
    }

    public class ResponseHandler
    extends SocketHandler {
        protected RequestHandler m_daemonRequest;
        protected Socket m_socketServer;
        protected Socket m_socketClient;

        public ResponseHandler(RequestHandler daemonRequest) {
            super("ResponseHandler" + LoadBalancer.parseThreadExtension(daemonRequest));
            this.m_daemonRequest = daemonRequest;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            Socket socketServer = null;
            Socket socketClient = null;
            while (true) {
                try {
                    this.wait();
                    socketServer = this.m_socketServer;
                    socketClient = this.m_socketClient;
                    if (socketServer == null || socketClient == null) continue;
                    this.process(socketServer, socketClient);
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (Exception e) {}
                continue;
                finally {
                    try {
                        socketClient.close();
                    }
                    catch (Exception e) {}
                    try {
                        socketServer.close();
                    }
                    catch (Exception e) {}
                    continue;
                }
                break;
            }
        }

        public synchronized void relayResponse(Socket socketServer, Socket socketClient) {
            this.m_socketClient = socketClient;
            this.m_socketServer = socketServer;
            this.notify();
        }
    }

    public class RequestHandler
    extends SocketHandler {
        protected Queue m_queue;
        protected ResponseHandler m_daemonResponse;

        public RequestHandler(Queue queue) {
            super("RequestHandler-" + LoadBalancer.this.m_listHandler.size());
            this.m_queue = queue;
            this.m_daemonResponse = LoadBalancer.this.instantiateResponseHandler(this);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Queue queue = this.m_queue;
            RequestHandler.azzert(queue != null);
            ResponseHandler daemonResponse = this.m_daemonResponse;
            RequestHandler.azzert(daemonResponse != null);
            while (true) {
                Socket socketClient = null;
                Socket socketServer = null;
                try {
                    socketClient = (Socket)queue.remove();
                    socketServer = LoadBalancer.this.getNextDestinationSocket();
                    daemonResponse.relayResponse(socketServer, socketClient);
                    this.process(socketClient, socketServer);
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (Exception e) {}
                continue;
                finally {
                    try {
                        socketClient.close();
                    }
                    catch (Exception e) {}
                    try {
                        socketServer.close();
                    }
                    catch (Exception e) {}
                    continue;
                }
                break;
            }
        }
    }

    public static abstract class SocketHandler
    extends Daemon {
        protected byte[] m_abBuf;

        public SocketHandler(String sName) {
            super(sName, 5, false);
        }

        public abstract void run();

        protected void process(Socket socketIn, Socket socketOut) throws IOException {
            try {
                InputStream streamIn = socketIn.getInputStream();
                OutputStream streamOut = socketOut.getOutputStream();
                this.copy(streamIn, streamOut, this.ensureBuffer(socketIn));
            }
            catch (SocketException e) {
                try {
                    socketIn.close();
                }
                catch (Exception eIgnore) {
                    // empty catch block
                }
                try {
                    socketOut.close();
                }
                catch (Exception eIgnore) {
                    // empty catch block
                }
                throw e;
            }
        }

        protected void copy(InputStream streamIn, OutputStream streamOut, byte[] abBuf) throws IOException {
            int cb;
            while ((cb = streamIn.read(abBuf)) != -1) {
                if (cb <= 0) continue;
                streamOut.write(abBuf, 0, cb);
            }
        }

        protected byte[] ensureBuffer(Socket socket) {
            byte[] abBuf = this.m_abBuf;
            if (abBuf == null) {
                int cb = 0;
                try {
                    cb = socket.getReceiveBufferSize();
                }
                catch (SocketException e) {
                    // empty catch block
                }
                if (cb < 1) {
                    cb = 1024;
                }
                if (cb > 16384) {
                    cb = 16384;
                }
                this.m_abBuf = abBuf = new byte[cb];
            }
            return abBuf;
        }
    }

    public static class Queue
    extends Base {
        protected List m_list = new RecyclingLinkedList();

        public int size() {
            return this.m_list.size();
        }

        public boolean isEmpty() {
            return this.m_list.isEmpty();
        }

        public synchronized void add(Object o) {
            this.m_list.add(o);
            this.notify();
        }

        public synchronized Object remove() throws InterruptedException {
            List list = this.m_list;
            while (list.isEmpty()) {
                this.wait();
            }
            return list.remove(0);
        }

        public synchronized Object removeNoWait() {
            List list = this.m_list;
            if (list.isEmpty()) {
                return null;
            }
            return list.remove(0);
        }
    }

    public static class AddressPort
    extends Base {
        public final InetAddress address;
        public final int nPort;

        public AddressPort(InetAddress address, int nPort) {
            AddressPort.azzert(address != null);
            AddressPort.azzert(nPort > 0 && nPort <= 65535);
            this.address = address;
            this.nPort = nPort;
        }

        public String toString() {
            return this.address.getHostAddress() + ":" + this.nPort;
        }
    }
}

