/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net;

import com.tangosol.net.Member;
import com.tangosol.net.MemberListener;
import com.tangosol.net.Service;
import com.tangosol.util.Listeners;
import java.util.EventListener;
import java.util.EventObject;

public class MemberEvent
extends EventObject {
    public static final int MEMBER_JOINED = 1;
    public static final int MEMBER_LEAVING = 2;
    public static final int MEMBER_LEFT = 3;
    private static final String[] DESCRIPTIONS = new String[]{"<unknown>", "JOINED", "LEAVING", "LEFT"};
    private int m_nId;
    private Member m_member;

    public MemberEvent(Object oSource, int nId, Member member) {
        super(oSource);
        this.m_nId = nId;
        this.m_member = member;
    }

    public int getId() {
        return this.m_nId;
    }

    public Member getMember() {
        return this.m_member;
    }

    public Service getService() {
        return (Service)this.getSource();
    }

    public boolean isLocal() {
        try {
            Member member = this.getMember();
            return member == null || member.equals(this.getService().getCluster().getLocalMember());
        }
        catch (RuntimeException e) {
            return true;
        }
    }

    public String toString() {
        Member member = this.getMember();
        return "MemberEvent{Member=" + (member == null ? "Local" : String.valueOf(member.getId())) + ' ' + DESCRIPTIONS[this.getId()] + ' ' + this.getSource().getClass().getName() + '}';
    }

    public void dispatch(Listeners listeners) {
        if (listeners != null) {
            EventListener[] targets = listeners.listeners();
            int i = targets.length;
            while (--i >= 0) {
                MemberListener target = (MemberListener)targets[i];
                switch (this.getId()) {
                    case 1: {
                        target.memberJoined(this);
                        break;
                    }
                    case 2: {
                        target.memberLeaving(this);
                        break;
                    }
                    case 3: {
                        target.memberLeft(this);
                    }
                }
            }
        }
    }
}

