/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.net.cache.AbstractBundler;
import com.tangosol.util.AtomicCounter;
import com.tangosol.util.SafeHashMap;
import java.util.Collections;
import java.util.Map;

public abstract class AbstractEntryBundler
extends AbstractBundler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(Object oKey, Object oValue) {
        AtomicCounter counter = this.m_countThreads;
        int cThreads = (int)counter.increment();
        try {
            boolean fBurst;
            Bundle bundle;
            if (cThreads < this.getThreadThreshold()) {
                this.bundle(Collections.singletonMap(oKey, oValue));
                return;
            }
            while (true) {
                Bundle bundle2 = bundle = (Bundle)this.getOpenBundle();
                synchronized (bundle2) {
                    if (bundle.isOpen()) {
                        boolean fFirst = bundle.add(oKey, oValue);
                        fBurst = bundle.waitForResults(fFirst);
                        break;
                    }
                }
            }
            bundle.process(fBurst, oKey, oValue);
        }
        finally {
            counter.decrement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAll(Map map) {
        AtomicCounter counter = this.m_countThreads;
        int cThreads = (int)counter.increment();
        try {
            boolean fBurst;
            Bundle bundle;
            if (cThreads < this.getThreadThreshold()) {
                this.bundle(map);
                return;
            }
            while (true) {
                Bundle bundle2 = bundle = (Bundle)this.getOpenBundle();
                synchronized (bundle2) {
                    if (bundle.isOpen()) {
                        boolean fFirst = bundle.addAll(map);
                        fBurst = bundle.waitForResults(fFirst);
                        break;
                    }
                }
            }
            bundle.processAll(fBurst, map);
        }
        finally {
            counter.decrement();
        }
    }

    protected abstract void bundle(Map var1);

    protected AbstractBundler.Bundle instantiateBundle() {
        return new Bundle();
    }

    protected class Bundle
    extends AbstractBundler.Bundle {
        private Map m_mapEntries = new SafeHashMap();

        protected Bundle() {
        }

        protected boolean add(Object oKey, Object oValue) {
            Map map = this.m_mapEntries;
            boolean fFirst = map.isEmpty();
            map.put(oKey, oValue);
            return fFirst;
        }

        protected boolean addAll(Map map) {
            Map mapEntries = this.m_mapEntries;
            boolean fFirst = mapEntries.isEmpty();
            mapEntries.putAll(map);
            return fFirst;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void process(boolean fBurst, Object oKey, Object oValue) {
            try {
                if (!this.ensureResults(fBurst)) {
                    AbstractEntryBundler.this.bundle(Collections.singletonMap(oKey, oValue));
                }
            }
            finally {
                this.releaseThread();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processAll(boolean fBurst, Map map) {
            try {
                if (!this.ensureResults(fBurst)) {
                    AbstractEntryBundler.this.bundle(map);
                }
            }
            finally {
                this.releaseThread();
            }
        }

        protected int getBundleSize() {
            return Math.max(super.getBundleSize(), this.m_mapEntries.size());
        }

        protected void ensureResults() {
            AbstractEntryBundler.this.bundle(this.m_mapEntries);
        }

        protected synchronized boolean releaseThread() {
            boolean fRelease = super.releaseThread();
            if (fRelease) {
                this.m_mapEntries.clear();
            }
            return fRelease;
        }
    }
}

