/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.net.cache.LocalCache;
import com.tangosol.net.cache.OldCache;
import com.tangosol.util.Base;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import java.io.Serializable;

public abstract class AbstractEvictionPolicy
extends Base
implements OldCache.EvictionPolicy,
MapListener,
Serializable {
    private volatile LocalCache m_cache;

    public abstract void entryTouched(OldCache.Entry var1);

    public abstract void entryUpdated(OldCache.Entry var1);

    public abstract void requestEviction(int var1);

    public void entryInserted(MapEvent evt) {
        this.entryUpdated(this.getEntry(evt));
    }

    public void entryUpdated(MapEvent evt) {
        this.entryUpdated(this.getEntry(evt));
    }

    public void entryDeleted(MapEvent evt) {
        this.ensureLocalCache(evt);
    }

    protected LocalCache ensureLocalCache(MapEvent evt) {
        LocalCache cache = this.m_cache;
        if (cache == null) {
            try {
                cache = this.m_cache = (LocalCache)evt.getMap();
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Illegal map type: " + evt.getMap().getClass().getName());
            }
        }
        return cache;
    }

    protected OldCache.Entry getEntry(MapEvent evt) {
        return (OldCache.Entry)this.ensureLocalCache(evt).getEntryInternal(evt.getKey());
    }

    protected LocalCache getLocalCache() {
        return this.m_cache;
    }
}

