/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.io.BinaryStore;
import com.tangosol.net.cache.CacheEvent;
import com.tangosol.net.cache.SerializationMap;
import com.tangosol.util.Filter;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.ObservableMap;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractSerializationCache
extends SerializationMap
implements ObservableMap {
    private MapListenerSupport m_listenerSupport;

    public AbstractSerializationCache(BinaryStore store) {
        super(store);
    }

    public AbstractSerializationCache(BinaryStore store, ClassLoader loader) {
        super(store, loader);
    }

    public AbstractSerializationCache(BinaryStore store, boolean fBinaryMap) {
        super(store, fBinaryMap);
    }

    public synchronized void clear() {
        if (this.hasListeners()) {
            Iterator iter = this.getKeyMap().keySet().iterator();
            while (iter.hasNext()) {
                this.dispatchPendingEvent(iter.next(), 3, null, false);
            }
        }
        super.clear();
    }

    public Object put(Object oKey, Object oValue) {
        int nEvent = this.getKeyMap().containsKey(oKey) ? 2 : 1;
        Object oOrig = super.put(oKey, oValue);
        if (this.hasListeners()) {
            this.dispatchEvent(new CacheEvent(this, nEvent, oKey, oOrig, oValue, false));
        }
        return oOrig;
    }

    public void putAll(Map map) {
        if (this.hasListeners()) {
            Map mapKeys = this.getKeyMap();
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Object oKey = entry.getKey();
                int nEvent = mapKeys.containsKey(oKey) ? 2 : 1;
                this.dispatchPendingEvent(oKey, nEvent, entry.getValue(), false);
            }
        }
        super.putAll(map);
    }

    public Object remove(Object oKey) {
        boolean fContained = this.getKeyMap().containsKey(oKey);
        Object oOrig = super.remove(oKey);
        if (fContained && this.hasListeners()) {
            this.dispatchEvent(new CacheEvent(this, 3, oKey, oOrig, null, false));
        }
        return oOrig;
    }

    protected boolean removeBlind(Object oKey) {
        boolean fRemoved = false;
        if (this.getKeyMap().containsKey(oKey)) {
            if (this.hasListeners()) {
                this.dispatchPendingEvent(oKey, 3, null, false);
            }
            super.removeBlind(oKey);
            fRemoved = true;
        }
        return fRemoved;
    }

    public synchronized void addMapListener(MapListener listener) {
        this.addMapListener(listener, null, false);
    }

    public synchronized void removeMapListener(MapListener listener) {
        this.removeMapListener(listener, null);
    }

    public synchronized void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        AbstractSerializationCache.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support == null) {
            support = this.m_listenerSupport = new MapListenerSupport();
        }
        support.addListener(listener, oKey, fLite);
    }

    public synchronized void removeMapListener(MapListener listener, Object oKey) {
        AbstractSerializationCache.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support != null) {
            support.removeListener(listener, oKey);
            if (support.isEmpty()) {
                this.m_listenerSupport = null;
            }
        }
    }

    public synchronized void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        AbstractSerializationCache.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support == null) {
            support = this.m_listenerSupport = new MapListenerSupport();
        }
        support.addListener(listener, filter, fLite);
    }

    public synchronized void removeMapListener(MapListener listener, Filter filter) {
        AbstractSerializationCache.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support != null) {
            support.removeListener(listener, filter);
            if (support.isEmpty()) {
                this.m_listenerSupport = null;
            }
        }
    }

    public abstract void evict();

    protected String getDescription() {
        return super.getDescription() + ", hasListeners=" + this.hasListeners();
    }

    protected MapListenerSupport getMapListenerSupport() {
        return this.m_listenerSupport;
    }

    protected boolean hasListeners() {
        return this.m_listenerSupport != null;
    }

    protected void dispatchPendingEvent(Object oKey, int nId, Object oNewValue, boolean fSynthetic) {
        CacheEvent event = new CacheEvent(this, nId, oKey, null, oNewValue, fSynthetic){

            public Object getOldValue() {
                Object oOldValue = this.m_oValueOld;
                if (oOldValue == null) {
                    this.m_oValueOld = oOldValue = AbstractSerializationCache.this.get(this.getKey());
                }
                return oOldValue;
            }
        };
        this.dispatchEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvent(CacheEvent evt) {
        MapListenerSupport listenerSupport = this.getMapListenerSupport();
        if (listenerSupport != null) {
            AbstractSerializationCache abstractSerializationCache = this;
            synchronized (abstractSerializationCache) {
                listenerSupport.fireEvent(evt, false);
            }
        }
    }
}

