/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.cache.CacheLoaderCacheStore;
import com.tangosol.net.cache.CacheStore;
import com.tangosol.net.cache.IterableCacheLoader;
import com.tangosol.util.AbstractKeyBasedMap;
import com.tangosol.util.AbstractStableIterator;
import com.tangosol.util.ConverterCollections;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class CacheStoreMap
extends ConverterCollections.ConverterMap {
    public CacheStoreMap(BackingMapManagerContext ctx, IterableCacheLoader loader) {
        this(ctx, CacheLoaderCacheStore.wrapCacheLoader(loader));
    }

    public CacheStoreMap(BackingMapManagerContext ctx, CacheStore store) {
        this(ctx, store, false);
    }

    public CacheStoreMap(BackingMapManagerContext ctx, CacheStore store, boolean fBlind) {
        super(new ReadWriteMap(store, fBlind), ctx.getKeyToInternalConverter(), ctx.getKeyFromInternalConverter(), ctx.getValueToInternalConverter(), ctx.getValueFromInternalConverter());
        if (!(store instanceof IterableCacheLoader)) {
            throw new IllegalArgumentException("CacheStore must implement IterableCacheLoader");
        }
    }

    public static class ReadWriteMap
    extends AbstractKeyBasedMap {
        protected CacheStore m_store;
        protected boolean m_fBlind;
        protected boolean m_fStoreUnsupported;
        protected boolean m_fEraseUnsupported;

        public ReadWriteMap(CacheStore store, boolean fBlind) {
            this.m_store = store;
            this.m_fBlind = fBlind;
        }

        public void clear() {
        }

        public boolean containsKey(Object oKey) {
            return this.m_store.load(oKey) != null;
        }

        public Object get(Object oKey) {
            return this.m_store.load(oKey);
        }

        public Map getAll(Collection colKeys) {
            return this.m_store.loadAll(colKeys);
        }

        protected Iterator iterateKeys() {
            return new AbstractStableIterator(this){
                Iterator m_iter;
                private final /* synthetic */ ReadWriteMap this$0;
                {
                    this.this$0 = this$0;
                    this.m_iter = ((IterableCacheLoader)((Object)this.this$0.m_store)).keys();
                }

                protected void advance() {
                    Iterator iter = this.m_iter;
                    if (iter.hasNext()) {
                        this.setNext(iter.next());
                    }
                }

                protected void remove(Object oPrev) {
                    this.this$0.remove(oPrev);
                }
            };
        }

        public Object put(Object oKey, Object oValue) {
            CacheStore store = this.m_store;
            Object oOrig = this.isBlindPutAllowed() ? null : store.load(oKey);
            try {
                if (!this.m_fStoreUnsupported) {
                    this.m_store.store(oKey, oValue);
                }
            }
            catch (UnsupportedOperationException e) {
                this.m_fStoreUnsupported = true;
            }
            return oOrig;
        }

        public void putAll(Map map) {
            try {
                this.m_store.storeAll(map);
            }
            catch (UnsupportedOperationException e) {
                super.putAll(map);
            }
        }

        public Object remove(Object oKey) {
            Object oOrig;
            CacheStore store = this.m_store;
            boolean fBlind = this.isBlindRemoveAllowed();
            Object object = oOrig = fBlind ? null : store.load(oKey);
            if (fBlind || oOrig != null) {
                try {
                    if (!this.m_fEraseUnsupported) {
                        this.m_store.erase(oKey);
                    }
                }
                catch (UnsupportedOperationException e) {
                    this.m_fEraseUnsupported = true;
                }
            }
            return oOrig;
        }

        protected boolean removeBlind(Object oKey) {
            boolean fExists;
            CacheStore store = this.m_store;
            boolean bl = fExists = store.load(oKey) != null;
            if (fExists) {
                try {
                    if (!this.m_fEraseUnsupported) {
                        this.m_store.erase(oKey);
                    }
                }
                catch (UnsupportedOperationException e) {
                    this.m_fEraseUnsupported = true;
                }
            }
            return fExists;
        }

        protected boolean isBlindPutAllowed() {
            return this.m_fBlind;
        }

        protected boolean isBlindRemoveAllowed() {
            return this.m_fBlind;
        }

        protected boolean isStoreUnsupported() {
            return this.m_fStoreUnsupported;
        }

        protected boolean isEraseUnsupported() {
            return this.m_fEraseUnsupported;
        }
    }
}

