/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.net.cache.CacheEvent;
import com.tangosol.net.cache.CacheMap;
import com.tangosol.net.cache.CacheStatistics;
import com.tangosol.net.cache.SimpleCacheStatistics;
import com.tangosol.util.AbstractMapListener;
import com.tangosol.util.Base;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.Filter;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.MultiplexingMapListener;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.WrapperConcurrentMap;
import com.tangosol.util.filter.MapEventFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CachingMap
extends Base
implements Map,
CacheStatistics {
    public static final int LISTEN_NONE = 0;
    public static final int LISTEN_PRESENT = 1;
    public static final int LISTEN_ALL = 2;
    public static final int LISTEN_AUTO = 3;
    private static final boolean STRICT_SYNCHRO_LISTENER = "true".equals(System.getProperty("tangosol.coherence.near.strictlistener", "true"));
    private Map m_mapBack;
    private Map m_mapFront;
    protected int m_nStrategyTarget;
    protected int m_nStrategyCurrent;
    private MapListener m_listener;
    private FrontMapListener m_listenerFront;
    private ConcurrentMap m_mapControl;
    private SimpleCacheStatistics m_stats = new SimpleCacheStatistics();
    private volatile long m_cInvalidationHits;
    private volatile long m_cInvalidationMisses;
    private volatile long m_cRegisterListener;
    private final Object GLOBAL_KEY = new Object();
    private static final List IGNORE_LIST = new ImmutableArrayList(new Object[0]){

        public boolean add(Object o) {
            return true;
        }
    };

    public CachingMap(Map mapFront, Map mapBack) {
        this(mapFront, mapBack, 3);
    }

    public CachingMap(Map mapFront, Map mapBack, int nStrategy) {
        CachingMap.azzert(mapFront != null && mapBack != null, "Null map");
        CachingMap.azzert(0 <= nStrategy && nStrategy <= 3, "Invalid strategy value");
        this.m_mapFront = mapFront;
        this.m_mapBack = mapBack;
        this.m_mapControl = new WrapperConcurrentMap(new SafeHashMap(), false, 0L);
        if (nStrategy != 0) {
            if (mapBack instanceof ObservableMap) {
                this.m_listener = this.instantiateBackMapListener();
                if (mapFront instanceof ObservableMap) {
                    this.m_listenerFront = this.instantiateFrontMapListener();
                }
            } else {
                nStrategy = 0;
            }
        }
        this.m_nStrategyTarget = nStrategy;
        this.m_nStrategyCurrent = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        ConcurrentMap mapControl = this.getControlMap();
        if (!mapControl.lock(ConcurrentMap.LOCK_ALL, 0L)) {
            throw new IllegalStateException("Cache is in active use by other threads.");
        }
        try {
            mapControl.put(this.GLOBAL_KEY, IGNORE_LIST);
            switch (this.m_nStrategyCurrent) {
                case 1: {
                    this.unregisterFrontListener();
                    Iterator iter = this.getFrontMap().keySet().iterator();
                    while (iter.hasNext()) {
                        this.unregisterListener(iter.next());
                    }
                    break;
                }
                case 2: {
                    this.unregisterListener();
                }
            }
            this.m_listener = null;
            this.m_mapFront = null;
            this.m_mapBack = null;
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            mapControl.remove(this.GLOBAL_KEY);
            mapControl.unlock(ConcurrentMap.LOCK_ALL);
        }
    }

    public Map getFrontMap() {
        Map map = this.m_mapFront;
        if (map == null) {
            throw new IllegalStateException("Cache is not active");
        }
        return map;
    }

    public Map getBackMap() {
        Map map = this.m_mapBack;
        if (map == null) {
            throw new IllegalStateException("Cache is not active");
        }
        return map;
    }

    public int getInvalidationStrategy() {
        return this.m_nStrategyTarget;
    }

    public ConcurrentMap getControlMap() {
        return this.m_mapControl;
    }

    protected boolean isCoherent() {
        return this.m_listener != null;
    }

    public CacheStatistics getCacheStatistics() {
        return this.m_stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ConcurrentMap mapControl = this.getControlMap();
        int i = 0;
        while (!mapControl.lock(ConcurrentMap.LOCK_ALL, 0L)) {
            if (i == 100) {
                this.getBackMap().clear();
                if (this.m_nStrategyTarget == 0) {
                    this.getFrontMap().clear();
                }
                return;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Base.ensureRuntimeException(e);
            }
            ++i;
        }
        try {
            mapControl.put(this.GLOBAL_KEY, IGNORE_LIST);
            Map mapFront = this.getFrontMap();
            Map mapBack = this.getBackMap();
            switch (this.m_nStrategyCurrent) {
                case 1: {
                    this.unregisterFrontListener();
                    try {
                        Iterator iter = mapFront.keySet().iterator();
                        while (iter.hasNext()) {
                            this.unregisterListener(iter.next());
                            iter.remove();
                        }
                        break;
                    }
                    catch (RuntimeException e) {
                        this.registerFrontListener();
                        throw e;
                    }
                }
                case 2: {
                    this.unregisterListener();
                    try {
                        mapFront.clear();
                        break;
                    }
                    catch (RuntimeException e) {
                        this.registerListener();
                        throw e;
                    }
                }
                default: {
                    mapFront.clear();
                }
            }
            this.resetInvalidationStrategy();
            mapBack.clear();
        }
        finally {
            mapControl.remove(this.GLOBAL_KEY);
            mapControl.unlock(ConcurrentMap.LOCK_ALL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object oKey) {
        Map mapFront = this.getFrontMap();
        if (mapFront.containsKey(oKey)) {
            this.m_stats.registerHit();
            return true;
        }
        ConcurrentMap mapControl = this.getControlMap();
        mapControl.lock(oKey, -1L);
        try {
            if (mapFront.containsKey(oKey)) {
                this.m_stats.registerHit();
                boolean bl = true;
                return bl;
            }
            mapControl.put(oKey, IGNORE_LIST);
            this.m_stats.registerMiss();
            boolean bl = this.getBackMap().containsKey(oKey);
            return bl;
        }
        finally {
            mapControl.remove(oKey);
            mapControl.unlock(oKey);
        }
    }

    public boolean containsValue(Object oValue) {
        return this.getFrontMap().containsValue(oValue) || this.getBackMap().containsValue(oValue);
    }

    public Set entrySet() {
        Set set = this.getBackMap().entrySet();
        if (!this.isCoherent()) {
            set = Collections.unmodifiableSet(set);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object oKey) {
        long ldtStart = CachingMap.getSafeTimeMillis();
        Map mapFront = this.getFrontMap();
        Object oValue = mapFront.get(oKey);
        if (oValue != null) {
            this.m_stats.registerHit(ldtStart);
            return oValue;
        }
        ConcurrentMap mapControl = this.getControlMap();
        mapControl.lock(oKey, -1L);
        try {
            oValue = mapFront.get(oKey);
            if (oValue != null) {
                this.m_stats.registerHit(ldtStart);
                Object v = oValue;
                return v;
            }
            Map mapBack = this.getBackMap();
            if (this.m_nStrategyTarget == 0) {
                oValue = mapBack.get(oKey);
                if (oValue != null) {
                    mapFront.put(oKey, oValue);
                }
            } else {
                LinkedList listEvents = new LinkedList();
                mapControl.put(oKey, listEvents);
                this.registerListener(oKey);
                oValue = mapBack.get(oKey);
                LinkedList linkedList = listEvents;
                synchronized (linkedList) {
                    if (oValue == null) {
                        this.unregisterListener(oKey);
                    } else {
                        boolean fValid = true;
                        switch (listEvents.size()) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                MapEvent evt = (MapEvent)listEvents.get(0);
                                fValid = evt.getId() == 1 && evt instanceof CacheEvent && ((CacheEvent)evt).isSynthetic();
                                break;
                            }
                            default: {
                                fValid = false;
                            }
                        }
                        if (fValid) {
                            mapFront.put(oKey, oValue);
                        } else {
                            this.unregisterListener(oKey);
                            ++this.m_cInvalidationHits;
                        }
                    }
                    mapControl.remove(oKey);
                }
            }
            this.m_stats.registerMiss(ldtStart);
            Object v = oValue;
            return v;
        }
        finally {
            mapControl.unlock(oKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getAll(Collection colKeys) {
        HashMap mapResult;
        block25: {
            HashSet setFrontMiss;
            block23: {
                Iterator iter6;
                int cMisses;
                long ldtStart = CachingMap.getSafeTimeMillis();
                int cKeys = colKeys.size();
                Map mapFront = this.getFrontMap();
                if (mapFront instanceof CacheMap) {
                    mapResult = ((CacheMap)mapFront).getAll(colKeys);
                    setFrontMiss = new HashSet(colKeys);
                    setFrontMiss.removeAll(mapResult.keySet());
                } else {
                    mapResult = new HashMap(cKeys);
                    setFrontMiss = new HashSet(cKeys);
                    Iterator iter2 = colKeys.iterator();
                    while (iter2.hasNext()) {
                        Object oKey = iter2.next();
                        Object oValue = mapFront.get(oKey);
                        if (oValue == null) {
                            setFrontMiss.add(oKey);
                            continue;
                        }
                        mapResult.put(oKey, oValue);
                    }
                }
                int cHits = mapResult.size();
                if (cHits > 0) {
                    this.m_stats.registerHits(cHits, ldtStart);
                }
                if ((cMisses = setFrontMiss.size()) == 0) {
                    return mapResult;
                }
                Map mapBack = this.getBackMap();
                if (!(mapBack instanceof CacheMap)) break block23;
                HashSet setLocked = new HashSet(cMisses);
                int nStrategy = this.m_nStrategyTarget;
                LinkedList listEvents = nStrategy == 0 ? null : new LinkedList();
                ConcurrentMap mapControl = this.getControlMap();
                try {
                    Iterator iter3 = setFrontMiss.iterator();
                    while (iter3.hasNext()) {
                        Object oKey = iter3.next();
                        if (!mapControl.lock(oKey, 0L)) continue;
                        setLocked.add(oKey);
                        Object oValue = mapFront.get(oKey);
                        if (oValue == null) {
                            if (nStrategy == 0) continue;
                            mapControl.put(oKey, listEvents);
                            this.registerListener(oKey);
                            continue;
                        }
                        this.m_stats.registerHit(ldtStart);
                        mapResult.put(oKey, oValue);
                        mapControl.unlock(oKey);
                        setLocked.remove(oKey);
                        iter3.remove();
                    }
                    Map mapBackResult = ((CacheMap)mapBack).getAll(setFrontMiss);
                    mapResult.putAll(mapBackResult);
                    if (nStrategy == 0) {
                        Iterator iter4 = mapBackResult.entrySet().iterator();
                        while (iter4.hasNext()) {
                            Map.Entry entry = iter4.next();
                            Object oKey = entry.getKey();
                            Object oValue = entry.getValue();
                            if (oValue == null || !setLocked.contains(oKey)) continue;
                            mapFront.put(oKey, oValue);
                        }
                    } else {
                        HashSet setValid = new HashSet(setLocked);
                        Set setResult = mapBackResult.keySet();
                        setValid.retainAll(setResult);
                        LinkedList linkedList = listEvents;
                        synchronized (linkedList) {
                            Iterator iter5 = listEvents.iterator();
                            while (iter5.hasNext()) {
                                MapEvent evt = (MapEvent)iter5.next();
                                Object oKey = evt.getKey();
                                boolean fValid = setResult.remove(oKey) && evt.getId() == 1 && evt instanceof CacheEvent && ((CacheEvent)evt).isSynthetic();
                                if (fValid) continue;
                                setValid.remove(oKey);
                                ++this.m_cInvalidationHits;
                            }
                            iter5 = setLocked.iterator();
                            while (iter5.hasNext()) {
                                Object oKey = iter5.next();
                                Object oValue = mapResult.get(oKey);
                                if (oValue != null && setValid.contains(oKey)) {
                                    mapFront.put(oKey, oValue);
                                } else {
                                    this.unregisterListener(oKey);
                                }
                                mapControl.remove(oKey);
                            }
                        }
                    }
                    Object var25_28 = null;
                    iter6 = setLocked.iterator();
                }
                catch (Throwable throwable) {
                    Object var25_29 = null;
                    Iterator iter6 = setLocked.iterator();
                    while (iter6.hasNext()) {
                        mapControl.unlock(iter6.next());
                    }
                    throw throwable;
                }
                while (iter6.hasNext()) {
                    mapControl.unlock(iter6.next());
                }
                this.m_stats.registerMisses(cMisses, ldtStart);
                break block25;
            }
            Iterator iter = setFrontMiss.iterator();
            while (iter.hasNext()) {
                Object oKey = iter.next();
                Object oValue = this.get(oKey);
                if (oValue == null) continue;
                mapResult.put(oKey, oValue);
            }
        }
        return mapResult;
    }

    public boolean isEmpty() {
        return this.getBackMap().isEmpty();
    }

    public Set keySet() {
        Set set = this.getBackMap().keySet();
        if (!this.isCoherent()) {
            set = Collections.unmodifiableSet(set);
        }
        return set;
    }

    public Object put(Object oKey, Object oValue) {
        return this.put(oKey, oValue, true, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object oKey, Object oValue, boolean fReturn, long cMillis) {
        long ldtStart = CachingMap.getSafeTimeMillis();
        Map mapFront = this.getFrontMap();
        Map mapBack = this.getBackMap();
        int nStrategy = this.m_nStrategyTarget;
        ConcurrentMap mapControl = this.getControlMap();
        mapControl.lock(oKey, -1L);
        try {
            Object oOrig;
            Object oFront;
            List listEvents = null;
            Object v = oFront = oValue == null ? mapFront.remove(oKey) : mapFront.get(oKey);
            if (nStrategy != 0) {
                if (oValue == null) {
                    listEvents = IGNORE_LIST;
                    mapControl.put(oKey, listEvents);
                    if (oFront != null) {
                        this.unregisterListener(oKey);
                    }
                } else if (oFront != null || this.m_nStrategyCurrent == 2) {
                    listEvents = new LinkedList();
                    mapControl.put(oKey, listEvents);
                } else {
                    listEvents = IGNORE_LIST;
                    mapControl.put(oKey, listEvents);
                }
            }
            try {
                if (cMillis > 0L || fReturn) {
                    oOrig = CachingMap.put(mapBack, oKey, oValue, cMillis);
                } else {
                    mapBack.putAll(Collections.singletonMap(oKey, oValue));
                    oOrig = null;
                }
            }
            catch (RuntimeException e) {
                mapControl.remove(oKey);
                try {
                    this.invalidateFront(oKey);
                }
                catch (RuntimeException x) {
                    // empty catch block
                }
                throw e;
            }
            this.finalizePut(oKey, oValue, listEvents);
            this.m_stats.registerPut(ldtStart);
            Object object = oOrig;
            return object;
        }
        finally {
            mapControl.unlock(oKey);
        }
    }

    private static Object put(Map map, Object oKey, Object oValue, long cMillis) {
        if (map instanceof CacheMap) {
            return ((CacheMap)map).put(oKey, oValue, cMillis);
        }
        if (cMillis <= 0L) {
            return map.put(oKey, oValue);
        }
        throw new UnsupportedOperationException("Class \"" + map.getClass().getName() + "\" does not implement CacheMap interface");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map map) {
        Iterator iter4;
        if (map.size() == 1) {
            Iterator iter2 = map.entrySet().iterator();
            if (iter2.hasNext()) {
                Map.Entry entry = iter2.next();
                this.put(entry.getKey(), entry.getValue(), false, 0L);
            }
            return;
        }
        int nStrategy = this.m_nStrategyTarget;
        boolean fAllRegistered = this.m_nStrategyCurrent == 2;
        long ldtStart = CachingMap.getSafeTimeMillis();
        ConcurrentMap mapControl = this.getControlMap();
        Map mapFront = this.getFrontMap();
        Map mapBack = this.getBackMap();
        HashMap mapLocked = new HashMap();
        LinkedList listUnlockable = null;
        try {
            Object oKey;
            Map.Entry entry;
            Iterator iter3 = map.entrySet().iterator();
            while (iter3.hasNext()) {
                entry = iter3.next();
                oKey = entry.getKey();
                Object oValue = entry.getValue();
                if (oValue != null && mapControl.lock(oKey, 0L)) {
                    mapLocked.put(oKey, oValue);
                    if (nStrategy == 0) continue;
                    mapControl.put(oKey, fAllRegistered || mapFront.containsKey(oKey) ? new LinkedList() : IGNORE_LIST);
                    continue;
                }
                if (listUnlockable == null) {
                    listUnlockable = new LinkedList();
                }
                listUnlockable.add(oKey);
            }
            mapBack.putAll(map);
            if (nStrategy == 0) {
                mapFront.putAll(mapLocked);
                iter3 = mapLocked.keySet().iterator();
                while (iter3.hasNext()) {
                    mapControl.unlock(iter3.next());
                    iter3.remove();
                }
            } else {
                iter3 = mapLocked.entrySet().iterator();
                while (iter3.hasNext()) {
                    entry = iter3.next();
                    oKey = entry.getKey();
                    this.finalizePut(oKey, entry.getValue(), (List)mapControl.get(oKey));
                    mapControl.unlock(oKey);
                    iter3.remove();
                }
            }
            this.m_stats.registerPuts(map.size(), ldtStart);
            Object var16_16 = null;
            iter4 = mapLocked.keySet().iterator();
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            Iterator iter4 = mapLocked.keySet().iterator();
            while (iter4.hasNext()) {
                Object oKey = iter4.next();
                try {
                    this.invalidateFront(oKey);
                }
                catch (RuntimeException x) {
                    // empty catch block
                }
                mapControl.remove(oKey);
                mapControl.unlock(oKey);
            }
            if (listUnlockable != null && nStrategy == 0) {
                mapFront.keySet().removeAll(listUnlockable);
            }
            throw throwable;
        }
        while (iter4.hasNext()) {
            Object oKey = iter4.next();
            try {
                this.invalidateFront(oKey);
            }
            catch (RuntimeException x) {
                // empty catch block
            }
            mapControl.remove(oKey);
            mapControl.unlock(oKey);
        }
        if (listUnlockable != null && nStrategy == 0) {
            mapFront.keySet().removeAll(listUnlockable);
        }
    }

    protected void invalidateFront(Object oKey) {
        if (this.getFrontMap().remove(oKey) == null) {
            ++this.m_cInvalidationMisses;
        } else {
            this.unregisterListener(oKey);
            ++this.m_cInvalidationHits;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizePut(Object oKey, Object oValue, List listEvents) {
        Map mapFront = this.getFrontMap();
        ConcurrentMap mapControl = this.getControlMap();
        int nStrategy = this.m_nStrategyTarget;
        if (nStrategy == 0) {
            if (oValue != null) {
                mapFront.put(oKey, oValue);
            }
        } else if (listEvents == IGNORE_LIST) {
            mapControl.remove(oKey);
        } else {
            if (listEvents == null) {
                throw new IllegalStateException("Encountered unexpected key " + oKey + "; this may be caused by concurrent " + "modification of the supplied key(s), or by an " + "inconsistent hashCode() or equals() implementation.");
            }
            List list = listEvents;
            synchronized (list) {
                boolean fValid;
                if (oValue == null) {
                    fValid = false;
                } else {
                    switch (listEvents.size()) {
                        case 0: {
                            if (STRICT_SYNCHRO_LISTENER && (this.m_nStrategyCurrent == 2 || mapFront.containsKey(oKey))) {
                                CachingMap.log("Expected an insert/update for " + oKey + ", but none have been received");
                                fValid = false;
                                break;
                            }
                            fValid = true;
                            break;
                        }
                        case 1: {
                            int nId = ((MapEvent)listEvents.get(0)).getId();
                            fValid = nId == 1 || nId == 2;
                            break;
                        }
                        default: {
                            fValid = false;
                        }
                    }
                }
                if (fValid) {
                    if (mapFront.put(oKey, oValue) == null && nStrategy == 1) {
                        mapFront.remove(oKey);
                    }
                } else {
                    this.invalidateFront(oKey);
                }
                mapControl.remove(oKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validate(MapEvent evt) {
        ConcurrentMap mapControl = this.getControlMap();
        Object oKey = evt.getKey();
        long ldtStart = 0L;
        int i = 0;
        while (true) {
            List listEvents;
            if (mapControl.lock(oKey, 0L)) {
                try {
                    listEvents = (List)mapControl.get(oKey);
                    if (listEvents == null) {
                        this.invalidateFront(oKey);
                    } else {
                        listEvents.add(evt);
                    }
                    return;
                }
                finally {
                    mapControl.unlock(oKey);
                }
            }
            listEvents = (List)mapControl.get(oKey);
            if (listEvents == null && (listEvents = (List)mapControl.get(this.GLOBAL_KEY)) == null) {
                Thread.yield();
                long ldtNow = CachingMap.getSafeTimeMillis();
                if (ldtStart == 0L) {
                    ldtStart = ldtNow;
                } else if (i > 5000 && ldtNow - ldtStart > 5000L) {
                    CachingMap.err("Detected a state corruption on the key \"" + oKey + "\", of class " + oKey.getClass().getName() + " which is missing from the active key set " + mapControl.keySet() + ". This could be caused by a mutating or " + "inconsistent key implementation, or a " + "concurrent modification to the map passed to " + this.getClass().getName() + ".putAll()");
                    this.invalidateFront(oKey);
                    return;
                }
            } else {
                List list = listEvents;
                synchronized (list) {
                    List listKey = (List)mapControl.get(oKey);
                    if (listEvents == listKey || listKey == null && listEvents == mapControl.get(this.GLOBAL_KEY)) {
                        listEvents.add(evt);
                        return;
                    }
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object oKey) {
        Object v;
        ConcurrentMap mapControl;
        block5: {
            Map mapFront = this.getFrontMap();
            Map mapBack = this.getBackMap();
            int nStrategy = this.m_nStrategyTarget;
            mapControl = this.getControlMap();
            mapControl.lock(oKey, -1L);
            try {
                if (nStrategy != 0) {
                    mapControl.put(oKey, IGNORE_LIST);
                }
                if (mapFront.remove(oKey) != null) {
                    this.unregisterListener(oKey);
                }
                v = mapBack.remove(oKey);
                Object var8_7 = null;
                if (nStrategy == 0) break block5;
                mapControl.remove(oKey);
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (nStrategy != 0) {
                    mapControl.remove(oKey);
                }
                mapControl.unlock(oKey);
                throw throwable;
            }
        }
        mapControl.unlock(oKey);
        return v;
    }

    public int size() {
        return this.getBackMap().size();
    }

    public Collection values() {
        Collection values = this.getBackMap().values();
        if (!this.isCoherent()) {
            values = Collections.unmodifiableCollection(values);
        }
        return values;
    }

    public long getTotalGets() {
        return this.m_stats.getTotalGets();
    }

    public long getTotalGetsMillis() {
        return this.m_stats.getTotalGetsMillis();
    }

    public double getAverageGetMillis() {
        return this.m_stats.getAverageGetMillis();
    }

    public long getTotalPuts() {
        return this.m_stats.getTotalPuts();
    }

    public long getTotalPutsMillis() {
        return this.m_stats.getTotalPutsMillis();
    }

    public double getAveragePutMillis() {
        return this.m_stats.getAveragePutMillis();
    }

    public long getCacheHits() {
        return this.m_stats.getCacheHits();
    }

    public long getCacheHitsMillis() {
        return this.m_stats.getCacheHitsMillis();
    }

    public double getAverageHitMillis() {
        return this.m_stats.getAverageHitMillis();
    }

    public long getCacheMisses() {
        return this.m_stats.getCacheMisses();
    }

    public long getCacheMissesMillis() {
        return this.m_stats.getCacheMissesMillis();
    }

    public double getAverageMissMillis() {
        return this.m_stats.getAverageMissMillis();
    }

    public double getHitProbability() {
        return this.m_stats.getHitProbability();
    }

    public void resetHitStatistics() {
        this.m_stats.resetHitStatistics();
        this.m_cInvalidationHits = 0L;
        this.m_cInvalidationMisses = 0L;
        this.m_cRegisterListener = 0L;
    }

    public long getInvalidationHits() {
        return this.m_cInvalidationHits;
    }

    public long getInvalidationMisses() {
        return this.m_cInvalidationMisses;
    }

    public long getTotalRegisterListener() {
        return this.m_cRegisterListener;
    }

    public boolean equals(Object o) {
        return ((Object)this.getBackMap()).equals(o);
    }

    public int hashCode() {
        return ((Object)this.getBackMap()).hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("CachingMap");
        try {
            Map mapFront = this.getFrontMap();
            Map mapBack = this.getBackMap();
            String[] asStrategy = new String[]{"NONE", "PRESENT", "ALL", "AUTO"};
            sb.append("{FrontMap{class=").append(mapFront.getClass().getName()).append(", size=").append(mapFront.size()).append("}, BackMap{class=").append(mapBack.getClass().getName()).append(", size=").append(mapBack.size()).append("}, strategy=").append(asStrategy[this.getInvalidationStrategy()]).append(", CacheStatistics=").append(this.getCacheStatistics()).append(", invalidation hits=").append(this.getInvalidationHits()).append(", invalidation misses=").append(this.getInvalidationMisses()).append(", listener registrations=").append(this.getTotalRegisterListener()).append('}');
        }
        catch (IllegalStateException e) {
            sb.append(" not active");
        }
        return sb.toString();
    }

    protected void registerListener() {
        ((ObservableMap)this.getBackMap()).addMapListener(this.m_listener, null, true);
    }

    protected void unregisterListener() {
        ((ObservableMap)this.getBackMap()).removeMapListener(this.m_listener, null);
    }

    protected void registerListener(Object oKey) {
        if (this.ensureInvalidationStrategy() == 1) {
            ((ObservableMap)this.getBackMap()).addMapListener(this.m_listener, oKey, true);
            ++this.m_cRegisterListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterListener(Object oKey) {
        ConcurrentMap mapControl;
        if (this.m_nStrategyCurrent == 1 && (mapControl = this.getControlMap()).lock(oKey, 0L)) {
            try {
                ((ObservableMap)this.getBackMap()).removeMapListener(this.m_listener, oKey);
            }
            finally {
                mapControl.unlock(oKey);
            }
        }
    }

    protected void registerFrontListener() {
        FrontMapListener listener = this.m_listenerFront;
        if (listener != null) {
            listener.register();
        }
    }

    protected void unregisterFrontListener() {
        FrontMapListener listener = this.m_listenerFront;
        if (listener != null) {
            listener.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int ensureInvalidationStrategy() {
        switch (this.m_nStrategyTarget) {
            case 1: {
                if (this.m_nStrategyCurrent != 1) {
                    Object object = this.GLOBAL_KEY;
                    synchronized (object) {
                        if (this.m_nStrategyCurrent != 1) {
                            this.registerFrontListener();
                            this.m_nStrategyCurrent = 1;
                        }
                    }
                }
                return 1;
            }
            case 2: 
            case 3: {
                if (this.m_nStrategyCurrent != 2) {
                    Object object = this.GLOBAL_KEY;
                    synchronized (object) {
                        if (this.m_nStrategyCurrent != 2) {
                            this.registerListener();
                            this.m_nStrategyCurrent = 2;
                        }
                    }
                }
                return 2;
            }
        }
        return 0;
    }

    protected void resetInvalidationStrategy() {
        this.m_nStrategyCurrent = 0;
    }

    protected MapListener instantiateBackMapListener() {
        return new BackMapListener();
    }

    protected FrontMapListener instantiateFrontMapListener() {
        return new FrontMapListener();
    }

    protected class FrontMapListener
    extends AbstractMapListener
    implements MapListenerSupport.SynchronousListener {
        protected Filter m_filter = new MapEventFilter(4);

        protected FrontMapListener() {
        }

        public void entryDeleted(MapEvent evt) {
            if (evt instanceof CacheEvent) {
                if (((CacheEvent)evt).isSynthetic()) {
                    CachingMap.this.unregisterListener(evt.getKey());
                }
            } else {
                CachingMap.this.unregisterListener(evt.getKey());
            }
        }

        public void register() {
            ((ObservableMap)CachingMap.this.getFrontMap()).addMapListener((MapListener)this, this.m_filter, true);
        }

        public void unregister() {
            ((ObservableMap)CachingMap.this.getFrontMap()).removeMapListener((MapListener)this, this.m_filter);
        }
    }

    protected class BackMapListener
    extends MultiplexingMapListener
    implements MapListenerSupport.SynchronousListener {
        protected BackMapListener() {
        }

        public void onMapEvent(MapEvent evt) {
            CachingMap.this.validate(evt);
        }
    }
}

