/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.net.CacheService;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberListener;
import com.tangosol.net.NamedCache;
import com.tangosol.util.AbstractKeySetBasedMap;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.FilterEnumerator;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.MultiplexingMapListener;
import com.tangosol.util.ObservableHashMap;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.TaskDaemon;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.filter.AndFilter;
import com.tangosol.util.filter.KeyAssociatedFilter;
import com.tangosol.util.filter.LimitFilter;
import com.tangosol.util.filter.MapEventFilter;
import com.tangosol.util.filter.NotFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ContinuousQueryCache
extends AbstractKeySetBasedMap
implements NamedCache {
    public static final int STATE_INIT = 0;
    public static final int STATE_CONFIGURING = 1;
    public static final int STATE_CONFIGURED = 2;
    public static final int STATE_SYNCHRONIZED = 3;
    private NamedCache m_cache;
    private String m_sName;
    private Filter m_filter;
    private boolean m_fCacheValues;
    private boolean m_fReadOnly;
    private ObservableMap m_mapLocal;
    private volatile int m_nState;
    private volatile Map m_mapSyncReq;
    private TaskDaemon m_eventqueue;
    private boolean m_fListeners;
    private MapEventFilter m_filterAdd;
    private MapEventFilter m_filterRemove;
    private MapListener m_listenerAdd;
    private MapListener m_listenerRemove;
    protected MemberListener m_listenerService;

    public ContinuousQueryCache(NamedCache cache, Filter filter) {
        this(cache, filter, true, null);
    }

    public ContinuousQueryCache(NamedCache cache, Filter filter, boolean fCacheValues) {
        this(cache, filter, fCacheValues, null);
    }

    public ContinuousQueryCache(NamedCache cache, Filter filter, MapListener listener) {
        this(cache, filter, false, listener);
    }

    private ContinuousQueryCache(NamedCache cache, Filter filter, boolean fCacheValues, MapListener listener) {
        if (cache == null) {
            throw new IllegalArgumentException("NamedCache must be specified");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Filter must be specified");
        }
        if (filter instanceof LimitFilter) {
            throw new UnsupportedOperationException("LimitFilter may not be used");
        }
        this.m_cache = cache;
        this.m_filter = filter;
        this.m_fCacheValues = fCacheValues;
        this.m_nState = 0;
        this.m_sName = "ContinuousQueryCache{Cache=" + cache.getCacheName() + ", Filter=" + filter + "}";
        ObservableMap mapLocal = this.m_mapLocal = this.instantiateInternalCache();
        if (listener != null) {
            this.ensureEventQueue();
            mapLocal.addMapListener(this.instantiateEventRouter(listener));
            this.m_fListeners = true;
        }
        this.ensureSynchronized(false);
    }

    public NamedCache getCache() {
        NamedCache cache = this.m_cache;
        if (cache == null) {
            throw new IllegalStateException("NamedCache is not active");
        }
        CacheService service = cache.getCacheService();
        if (service != null && !service.isRunning()) {
            service.start();
        }
        return cache;
    }

    public Filter getFilter() {
        return this.m_filter;
    }

    public boolean isCacheValues() {
        return this.m_fCacheValues || this.isObserved();
    }

    public synchronized void setCacheValues(boolean fCacheValues) {
        if (fCacheValues != this.m_fCacheValues) {
            boolean fDidCacheValues = this.isCacheValues();
            this.m_fCacheValues = fCacheValues;
            if (this.isCacheValues() != fDidCacheValues) {
                this.configureSynchronization(false);
            }
        }
    }

    public boolean isReadOnly() {
        return this.m_fReadOnly;
    }

    public synchronized void setReadOnly(boolean fReadOnly) {
        if (fReadOnly != this.isReadOnly()) {
            this.checkReadOnly();
            this.m_fReadOnly = fReadOnly;
        }
    }

    protected ObservableMap instantiateInternalCache() {
        return new ObservableHashMap();
    }

    protected ObservableMap getInternalCache() {
        this.ensureSynchronized(true);
        return this.m_mapLocal;
    }

    protected boolean isObserved() {
        return this.m_fListeners;
    }

    protected synchronized void setObserved(boolean fObserved) {
        if (fObserved != this.isObserved()) {
            boolean fDidCacheValues = this.isCacheValues();
            this.m_fListeners = fObserved;
            if (this.isCacheValues() != fDidCacheValues) {
                this.configureSynchronization(false);
            }
        }
    }

    public int getState() {
        return this.m_nState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeState(int nState) {
        switch (nState) {
            case 0: {
                this.m_nState = 0;
                break;
            }
            case 1: {
                ContinuousQueryCache continuousQueryCache = this;
                synchronized (continuousQueryCache) {
                    int nStatePrev = this.m_nState;
                    ContinuousQueryCache.azzert(nStatePrev == 0 || nStatePrev == 3);
                    this.m_mapSyncReq = new SafeHashMap();
                    this.m_nState = 1;
                    break;
                }
            }
            case 2: {
                ContinuousQueryCache continuousQueryCache = this;
                synchronized (continuousQueryCache) {
                    if (this.m_nState != 1) {
                        throw new IllegalStateException(this.getCacheName() + " has been invalidated");
                    }
                    this.m_nState = 2;
                    break;
                }
            }
            case 3: {
                ContinuousQueryCache continuousQueryCache = this;
                synchronized (continuousQueryCache) {
                    if (this.m_nState != 2) {
                        throw new IllegalStateException(this.getCacheName() + " has been invalidated");
                    }
                    this.m_nState = 3;
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException("unknown state: " + nState);
            }
        }
    }

    public void clear() {
        this.checkReadOnly();
        this.getCache().keySet().removeAll(this.getInternalKeySet());
    }

    public Object get(Object oKey) {
        return this.containsKey(oKey) ? (this.isCacheValues() ? this.getInternalCache().get(oKey) : this.getCache().get(oKey)) : null;
    }

    public Object put(Object oKey, Object oValue) {
        Object oOrig;
        this.checkReadOnly();
        this.checkEntry(oKey, oValue);
        NamedCache cache = this.getCache();
        boolean fLocalCache = this.isCacheValues();
        boolean fPresent = this.containsKey(oKey);
        if (fLocalCache || !fPresent) {
            oOrig = fPresent ? (Object)this.getInternalCache().get(oKey) : null;
            cache.putAll(Collections.singletonMap(oKey, oValue));
        } else {
            oOrig = cache.put(oKey, oValue);
            if (!InvocableMapHelper.evaluateEntry(this.getFilter(), oKey, oOrig)) {
                oOrig = null;
            }
        }
        return oOrig;
    }

    public void putAll(Map map) {
        this.checkReadOnly();
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            this.checkEntry(iter.next());
        }
        this.getCache().putAll(map);
    }

    public Object remove(Object oKey) {
        this.checkReadOnly();
        Object oOrig = null;
        if (this.containsKey(oKey)) {
            NamedCache cache = this.getCache();
            if (this.isCacheValues()) {
                oOrig = this.getInternalCache().get(oKey);
                this.removeBlind(oKey);
            } else {
                oOrig = cache.remove(oKey);
            }
        }
        return oOrig;
    }

    public Map getAll(Collection colKeys) {
        Map mapResult;
        block4: {
            ObservableMap mapLocal;
            block5: {
                block3: {
                    mapLocal = this.getInternalCache();
                    if (!this.isCacheValues()) break block3;
                    mapResult = new ListMap();
                    Iterator iter = colKeys.iterator();
                    while (iter.hasNext()) {
                        Object oKey = iter.next();
                        Object oVal = mapLocal.get(oKey);
                        if (oVal == null && !this.containsKey(oKey)) continue;
                        mapResult.put(oKey, oVal);
                    }
                    break block4;
                }
                if (colKeys.size() > 1) break block5;
                mapResult = new ListMap();
                Iterator iter = colKeys.iterator();
                while (iter.hasNext()) {
                    Object oValue;
                    Object oKey = iter.next();
                    if (!mapLocal.containsKey(oKey) || (oValue = this.getCache().get(oKey)) == null && !mapLocal.containsKey(oKey) || !InvocableMapHelper.evaluateEntry(this.getFilter(), oKey, oValue)) continue;
                    mapResult.put(oKey, oValue);
                }
                break block4;
            }
            HashSet collView = new HashSet(colKeys);
            collView.retainAll(mapLocal.keySet());
            mapResult = this.getCache().getAll(collView);
            Filter filter = this.getFilter();
            if (mapResult.isEmpty() || !new FilterEnumerator(mapResult.values().iterator(), (Filter)new NotFilter(filter)).hasNext()) break block4;
            Iterator iter = mapResult.entrySet().iterator();
            mapResult = new HashMap();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (!InvocableMapHelper.evaluateEntry(filter, entry)) continue;
                mapResult.put(entry.getKey(), entry.getValue());
            }
        }
        return mapResult;
    }

    public Object put(Object oKey, Object oValue, long cMillis) {
        if (cMillis == 0L) {
            return this.put(oKey, oValue);
        }
        this.checkReadOnly();
        this.checkEntry(oKey, oValue);
        Object oOrig = this.getCache().put(oKey, oValue, cMillis);
        return InvocableMapHelper.evaluateEntry(this.getFilter(), oKey, oOrig) ? oOrig : null;
    }

    protected boolean removeBlind(Object oKey) {
        this.checkReadOnly();
        return this.containsKey(oKey) && this.getCache().keySet().remove(oKey);
    }

    protected Set getInternalKeySet() {
        return this.getInternalCache().keySet();
    }

    public synchronized void addMapListener(MapListener listener) {
        this.addMapListener(listener, null, false);
    }

    public synchronized void removeMapListener(MapListener listener) {
        this.removeMapListener(listener, null);
    }

    public synchronized void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        ContinuousQueryCache.azzert(listener != null);
        if (!fLite) {
            this.setObserved(true);
        }
        this.ensureEventQueue();
        this.getInternalCache().addMapListener((MapListener)this.instantiateEventRouter(listener), oKey, fLite);
    }

    public synchronized void removeMapListener(MapListener listener, Object oKey) {
        ContinuousQueryCache.azzert(listener != null);
        this.getInternalCache().removeMapListener((MapListener)this.instantiateEventRouter(listener), oKey);
    }

    public synchronized void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        ContinuousQueryCache.azzert(listener != null);
        if (filter != null || !fLite) {
            this.setObserved(true);
        }
        this.ensureEventQueue();
        this.getInternalCache().addMapListener((MapListener)this.instantiateEventRouter(listener), filter, fLite);
    }

    public synchronized void removeMapListener(MapListener listener, Filter filter) {
        ContinuousQueryCache.azzert(listener != null);
        this.getInternalCache().removeMapListener((MapListener)this.instantiateEventRouter(listener), filter);
    }

    public Set keySet(Filter filter) {
        return this.isCacheValues() ? InvocableMapHelper.query(this, filter, false, false, null) : this.getCache().keySet(this.mergeFilter(filter));
    }

    public Set entrySet(Filter filter) {
        return this.isCacheValues() ? InvocableMapHelper.query(this, filter, true, false, null) : this.getCache().entrySet(this.mergeFilter(filter));
    }

    public Set entrySet(Filter filter, Comparator comparator) {
        return this.isCacheValues() ? InvocableMapHelper.query(this, filter, true, true, comparator) : this.getCache().entrySet(this.mergeFilter(filter), comparator);
    }

    public void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
        this.getCache().addIndex(extractor, fOrdered, comparator);
    }

    public void removeIndex(ValueExtractor extractor) {
    }

    public Object invoke(Object oKey, InvocableMap.EntryProcessor agent) {
        NamedCache cache = this.getCache();
        if (this.containsKey(oKey) || !cache.containsKey(oKey)) {
            return cache.invoke(oKey, agent);
        }
        throw new IllegalStateException(this.getCacheName() + ": key=" + oKey + " is outside the ContinuousQueryCache");
    }

    public Map invokeAll(Collection collKeys, InvocableMap.EntryProcessor agent) {
        if (collKeys.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        NamedCache cache = this.getCache();
        Set setView = this.getInternalKeySet();
        Iterator iter = collKeys.iterator();
        while (iter.hasNext()) {
            Object oKey = iter.next();
            if (setView.contains(oKey) || !cache.containsKey(oKey)) continue;
            throw new IllegalStateException(this.getCacheName() + ": key=" + oKey + " is outside the ContinuousQueryCache");
        }
        return cache.invokeAll(collKeys, agent);
    }

    public Map invokeAll(Filter filter, InvocableMap.EntryProcessor agent) {
        return this.getCache().invokeAll(this.mergeFilter(filter), agent);
    }

    public Object aggregate(Collection collKeys, InvocableMap.EntryAggregator agent) {
        if (collKeys.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        NamedCache cache = this.getCache();
        Set setView = this.getInternalKeySet();
        Iterator iter = collKeys.iterator();
        while (iter.hasNext()) {
            Object oKey = iter.next();
            if (setView.contains(oKey) || !cache.containsKey(oKey)) continue;
            throw new IllegalStateException(this.getCacheName() + ": key=" + oKey + " is outside the ContinuousQueryCache");
        }
        return cache.aggregate(collKeys, agent);
    }

    public Object aggregate(Filter filter, InvocableMap.EntryAggregator agent) {
        return this.getCache().aggregate(this.mergeFilter(filter), agent);
    }

    public boolean lock(Object oKey, long cWait) {
        this.checkReadOnly();
        return this.getCache().lock(oKey, cWait);
    }

    public boolean lock(Object oKey) {
        return this.lock(oKey, 0L);
    }

    public boolean unlock(Object oKey) {
        return this.getCache().unlock(oKey);
    }

    public String getCacheName() {
        return this.m_sName;
    }

    public CacheService getCacheService() {
        return this.getCache().getCacheService();
    }

    public boolean isActive() {
        NamedCache cache = this.m_cache;
        return cache != null && cache.isActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        TaskDaemon eventQueue = this.getEventQueue();
        if (eventQueue != null) {
            eventQueue.stop(false);
        }
        ContinuousQueryCache continuousQueryCache = this;
        synchronized (continuousQueryCache) {
            NamedCache cache = this.m_cache;
            if (cache != null) {
                this.unregisterServiceListener();
                MapListener listenerAdd = this.m_listenerAdd;
                if (listenerAdd != null) {
                    try {
                        cache.removeMapListener(listenerAdd, this.m_filterAdd);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.m_listenerAdd = null;
                }
                this.m_filterAdd = null;
                MapListener listenerRemove = this.m_listenerRemove;
                if (listenerRemove != null) {
                    try {
                        cache.removeMapListener(listenerRemove, this.m_filterRemove);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.m_listenerRemove = null;
                }
                this.m_filterRemove = null;
                this.m_mapLocal = null;
                this.m_cache = null;
                this.m_nState = 0;
            }
        }
    }

    public void destroy() {
        this.release();
    }

    protected Filter mergeFilter(Filter filter) {
        Base filterMerged;
        KeyAssociatedFilter filterAssoc;
        Filter filterCQC = this.getFilter();
        boolean fKeyAssoc = false;
        Object oKeyAssoc = null;
        if (filterCQC instanceof KeyAssociatedFilter) {
            filterAssoc = (KeyAssociatedFilter)filterCQC;
            oKeyAssoc = filterAssoc.getHostKey();
            filterCQC = filterAssoc.getFilter();
            fKeyAssoc = true;
            if (filter instanceof KeyAssociatedFilter) {
                filter = ((KeyAssociatedFilter)filter).getFilter();
            }
        } else if (filter instanceof KeyAssociatedFilter) {
            filterAssoc = (KeyAssociatedFilter)filter;
            oKeyAssoc = filterAssoc.getHostKey();
            filter = filterAssoc.getFilter();
            fKeyAssoc = true;
        }
        if (filter instanceof LimitFilter) {
            LimitFilter filterNew;
            LimitFilter filterOrig = (LimitFilter)filter;
            int iPageSize = filterOrig.getPageSize();
            Object oCookie = filterOrig.getCookie();
            if (oCookie instanceof LimitFilter) {
                filterNew = (LimitFilter)oCookie;
                filterNew.setPageSize(iPageSize);
            } else {
                filterNew = new LimitFilter(new AndFilter(filterCQC, filterOrig.getFilter()), iPageSize);
                filterOrig.setCookie(filterNew);
            }
            filterNew.setPage(filterOrig.getPage());
            filterMerged = filterNew;
        } else {
            filterMerged = new AndFilter(filterCQC, filter);
        }
        if (fKeyAssoc) {
            filterMerged = new KeyAssociatedFilter((Filter)((Object)filterMerged), oKeyAssoc);
        }
        return filterMerged;
    }

    protected void checkReadOnly() {
        if (this.isReadOnly()) {
            throw new IllegalStateException(this.getCacheName() + " is read-only");
        }
    }

    protected void checkEntry(Map.Entry entry) {
        if (!InvocableMapHelper.evaluateEntry(this.getFilter(), entry)) {
            throw new IllegalArgumentException(this.getCacheName() + ": Attempted modification violates filter; key=\"" + entry.getKey() + "\", value=\"" + entry.getValue() + "\"");
        }
    }

    protected void checkEntry(Object oKey, Object oValue) {
        if (!InvocableMapHelper.evaluateEntry(this.getFilter(), oKey, oValue)) {
            throw new IllegalArgumentException(this.getCacheName() + ": Attempted modification violates filter; key=\"" + oKey + "\", value=\"" + oValue + "\"");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void configureSynchronization(boolean fReload) {
        NamedCache cache = this.getCache();
        this.changeState(1);
        try {
            int nMask;
            boolean fFirstTime;
            Filter filter = this.getFilter();
            boolean fCacheValues = this.isCacheValues();
            MapEventFilter filterAddPrev = this.m_filterAdd;
            MapListener listenerAddPrev = this.m_listenerAdd;
            boolean bl = fFirstTime = filterAddPrev == null;
            if (fFirstTime) {
                this.registerServiceListener();
                nMask = 20;
                MapEventFilter filterRemove = new MapEventFilter(nMask, filter);
                MapListener listenerRemove = this.instantiateRemoveListener();
                cache.addMapListener(listenerRemove, filterRemove, true);
                this.m_filterRemove = filterRemove;
                this.m_listenerRemove = listenerRemove;
            } else {
                cache.addMapListener(this.m_listenerRemove, this.m_filterRemove, true);
            }
            nMask = 9;
            if (fCacheValues) {
                nMask |= 0x20;
            }
            if (filterAddPrev == null || nMask != filterAddPrev.getEventMask()) {
                MapEventFilter filterAdd = new MapEventFilter(nMask, filter);
                MapListener listenerAdd = this.instantiateAddListener();
                cache.addMapListener(listenerAdd, filterAdd, !fCacheValues);
                this.m_filterAdd = filterAdd;
                this.m_listenerAdd = listenerAdd;
                if (listenerAddPrev != null) {
                    ContinuousQueryCache.azzert(filterAddPrev != null);
                    cache.removeMapListener(listenerAddPrev, filterAddPrev);
                }
            } else {
                cache.addMapListener(listenerAddPrev, filterAddPrev, !fCacheValues);
            }
            ObservableMap mapLocal = this.m_mapLocal;
            if (fFirstTime || fReload) {
                Iterator iter;
                if (this.isCacheValues()) {
                    Set set = cache.entrySet(filter);
                    if (!mapLocal.isEmpty()) {
                        HashSet setQueryKeys = new HashSet();
                        Iterator iter2 = set.iterator();
                        while (iter2.hasNext()) {
                            setQueryKeys.add(((Map.Entry)iter2.next()).getKey());
                        }
                        mapLocal.keySet().retainAll(setQueryKeys);
                    }
                    iter = set.iterator();
                    while (iter.hasNext()) {
                        Map.Entry entry = (Map.Entry)iter.next();
                        mapLocal.put(entry.getKey(), entry.getValue());
                    }
                } else {
                    Set setQueryKeys = cache.keySet(filter);
                    if (!mapLocal.isEmpty()) {
                        mapLocal.keySet().retainAll(setQueryKeys);
                    }
                    iter = setQueryKeys.iterator();
                    while (iter.hasNext()) {
                        mapLocal.put(iter.next(), null);
                    }
                }
            } else if (fCacheValues) {
                Map mapValues = cache.getAll(mapLocal.keySet());
                mapLocal.putAll(mapValues);
            } else {
                Iterator iter = mapLocal.entrySet().iterator();
                while (iter.hasNext()) {
                    iter.next().setValue(null);
                }
            }
            this.changeState(2);
            Map mapSyncReq = this.m_mapSyncReq;
            if (!mapSyncReq.isEmpty()) {
                Map mapSyncVals = cache.getAll(mapSyncReq.keySet());
                Map map = mapSyncReq;
                synchronized (map) {
                    Iterator iter = mapSyncReq.keySet().iterator();
                    while (iter.hasNext()) {
                        Object oKey = iter.next();
                        if (mapSyncVals.containsKey(oKey)) {
                            mapLocal.put(oKey, mapSyncVals.get(oKey));
                            continue;
                        }
                        mapLocal.remove(oKey);
                    }
                    mapSyncReq.clear();
                }
            }
            this.m_mapSyncReq = null;
            this.changeState(3);
        }
        catch (Throwable e) {
            this.changeState(0);
            throw ContinuousQueryCache.ensureRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureSynchronized(boolean fReload) {
        if (this.getState() != 3) {
            Throwable eConfig = null;
            for (int i = 0; i < 3; ++i) {
                ContinuousQueryCache continuousQueryCache = this;
                synchronized (continuousQueryCache) {
                    if (this.getState() == 0) {
                        try {
                            this.configureSynchronization(fReload);
                            return;
                        }
                        catch (Throwable e) {
                            eConfig = e;
                        }
                    } else {
                        ContinuousQueryCache.azzert(this.getState() == 3);
                        return;
                    }
                    continue;
                }
            }
            if (eConfig != null) {
                throw ContinuousQueryCache.ensureRuntimeException(eConfig);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isEventDeferred(Object oKey) {
        boolean fDeferred = false;
        Map mapSyncReq = this.m_mapSyncReq;
        if (mapSyncReq != null) {
            if (this.getState() <= 1) {
                mapSyncReq.put(oKey, null);
                fDeferred = true;
            } else if (mapSyncReq.keySet().remove(oKey) && mapSyncReq.isEmpty()) {
                ContinuousQueryCache continuousQueryCache = this;
                synchronized (continuousQueryCache) {
                    if (mapSyncReq == this.m_mapSyncReq) {
                        this.m_mapSyncReq = null;
                    }
                }
            }
        }
        return fDeferred;
    }

    protected MapListener instantiateAddListener() {
        return new AddListener();
    }

    protected MapListener instantiateRemoveListener() {
        return new RemoveListener();
    }

    protected void registerServiceListener() {
        CacheService service = this.getCacheService();
        if (service != null) {
            try {
                ServiceListener listener = new ServiceListener();
                service.addMemberListener(listener);
                this.m_listenerService = listener;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    protected void unregisterServiceListener() {
        try {
            this.getCacheService().removeMemberListener(this.m_listenerService);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    protected EventRouter instantiateEventRouter(MapListener listener) {
        return new EventRouter(listener);
    }

    protected TaskDaemon instantiateEventQueue() {
        return new TaskDaemon("EventQueue:" + this.getCacheName());
    }

    protected TaskDaemon getEventQueue() {
        return this.m_eventqueue;
    }

    protected synchronized TaskDaemon ensureEventQueue() {
        TaskDaemon queue = this.getEventQueue();
        if (queue == null) {
            this.m_eventqueue = queue = new TaskDaemon("EventQueue:" + this.getCacheName());
        }
        return queue;
    }

    protected class EventRouter
    extends MultiplexingMapListener {
        private MapListener m_listener;

        public EventRouter(MapListener listener) {
            this.m_listener = listener;
        }

        protected void onMapEvent(MapEvent evt) {
            MapListener listener = this.m_listener;
            MapEvent evtRoute = new MapEvent(ContinuousQueryCache.this, evt.getId(), evt.getKey(), evt.getOldValue(), evt.getNewValue());
            if (listener instanceof MapListenerSupport.SynchronousListener) {
                try {
                    evtRoute.dispatch(listener);
                }
                catch (RuntimeException e) {
                    EventRouter.err(e);
                }
            } else {
                Runnable task = new Runnable(this, evtRoute, listener){
                    private final /* synthetic */ MapEvent val$evtRoute;
                    private final /* synthetic */ MapListener val$listener;
                    private final /* synthetic */ EventRouter this$1;
                    {
                        this.this$1 = this$1;
                        this.val$evtRoute = val$evtRoute;
                        this.val$listener = val$listener;
                    }

                    public void run() {
                        this.val$evtRoute.dispatch(this.val$listener);
                    }
                };
                ContinuousQueryCache.this.getEventQueue().executeTask(task);
            }
        }

        public int hashCode() {
            return this.m_listener.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof EventRouter && this.m_listener.equals(((EventRouter)o).m_listener);
        }

        public String toString() {
            return "EventRouter[" + this.m_listener + "]";
        }
    }

    protected class ServiceListener
    implements MemberListener {
        protected ServiceListener() {
        }

        public void memberJoined(MemberEvent evt) {
            if (evt.isLocal()) {
                ContinuousQueryCache.this.changeState(0);
            }
        }

        public void memberLeaving(MemberEvent evt) {
        }

        public void memberLeft(MemberEvent evt) {
            if (evt.isLocal()) {
                ContinuousQueryCache.this.changeState(0);
            }
        }

        public String toString() {
            return "ServiceListener[" + ContinuousQueryCache.this.toString() + "]";
        }
    }

    public class RemoveListener
    extends MultiplexingMapListener
    implements MapListenerSupport.SynchronousListener {
        protected void onMapEvent(MapEvent evt) {
            Object oKey = evt.getKey();
            if (!ContinuousQueryCache.this.isEventDeferred(oKey)) {
                ContinuousQueryCache.this.m_mapLocal.remove(oKey);
            }
        }

        public String toString() {
            return "RemoveListener[" + ContinuousQueryCache.this.toString() + "]";
        }
    }

    public class AddListener
    extends MultiplexingMapListener
    implements MapListenerSupport.SynchronousListener {
        protected void onMapEvent(MapEvent evt) {
            Object oKey = evt.getKey();
            if (!ContinuousQueryCache.this.isEventDeferred(oKey)) {
                ContinuousQueryCache cqc = ContinuousQueryCache.this;
                cqc.m_mapLocal.put(oKey, cqc.isCacheValues() ? evt.getNewValue() : null);
            }
        }

        public String toString() {
            return "AddListener[" + ContinuousQueryCache.this.toString() + "]";
        }
    }
}

