/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.net.cache.AbstractCacheStore;
import com.tangosol.net.cache.CacheStore;
import com.tangosol.net.cache.IterableCacheLoader;
import com.tangosol.util.LiteMap;
import com.tangosol.util.SimpleEnumerator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class MapCacheStore
extends AbstractCacheStore
implements CacheStore,
IterableCacheLoader {
    private Map m_map;

    public MapCacheStore(Map map) {
        this.setMap(map);
    }

    public Object load(Object oKey) {
        return this.getMap().get(oKey);
    }

    public void store(Object oKey, Object oValue) {
        LiteMap mapTemp = new LiteMap();
        mapTemp.put(oKey, oValue);
        this.getMap().putAll(mapTemp);
    }

    public void storeAll(Map mapEntries) {
        this.getMap().putAll(mapEntries);
    }

    public void erase(Object oKey) {
        this.getMap().keySet().remove(oKey);
    }

    public void eraseAll(Collection colKeys) {
        this.getMap().keySet().removeAll(colKeys);
    }

    public Iterator keys() {
        return new SimpleEnumerator(this.getMap().keySet().toArray());
    }

    public Map getMap() {
        return this.m_map;
    }

    protected void setMap(Map map) {
        this.m_map = map;
    }
}

