/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.net.CacheService;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberListener;
import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.CachingMap;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.MapListener;
import com.tangosol.util.ValueExtractor;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

public class NearCache
extends CachingMap
implements NamedCache {
    protected MemberListener m_listenerBackService = this.registerBackServiceListener();

    public NearCache(Map mapFront, NamedCache mapBack) {
        this(mapFront, mapBack, 3);
    }

    public NearCache(Map mapFront, NamedCache mapBack, int nStrategy) {
        super(mapFront, mapBack, nStrategy);
    }

    public NamedCache getBackCache() {
        return (NamedCache)this.getBackMap();
    }

    public String getCacheName() {
        return this.getBackCache().getCacheName();
    }

    public CacheService getCacheService() {
        return this.getBackCache().getCacheService();
    }

    public boolean isActive() {
        try {
            return this.getBackCache().isActive();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public void release() {
        try {
            NamedCache cache = this.getBackCache();
            this.unregisterBackServiceListener();
            super.release();
            cache.release();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void destroy() {
        NamedCache cache = this.getBackCache();
        this.unregisterBackServiceListener();
        super.release();
        cache.destroy();
    }

    public void addMapListener(MapListener listener) {
        this.getBackCache().addMapListener(listener);
    }

    public void removeMapListener(MapListener listener) {
        this.getBackCache().removeMapListener(listener);
    }

    public void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        this.getBackCache().addMapListener(listener, oKey, fLite);
    }

    public void removeMapListener(MapListener listener, Object oKey) {
        this.getBackCache().removeMapListener(listener, oKey);
    }

    public void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        this.getBackCache().addMapListener(listener, filter, fLite);
    }

    public void removeMapListener(MapListener listener, Filter filter) {
        this.getBackCache().removeMapListener(listener, filter);
    }

    public Object put(Object oKey, Object oValue, long cMillis) {
        return super.put(oKey, oValue, true, cMillis);
    }

    public boolean lock(Object oKey) {
        return this.lock(oKey, 0L);
    }

    public boolean lock(Object oKey, long lMillis) {
        if (this.getBackCache().lock(oKey, lMillis)) {
            if (this.getInvalidationStrategy() == 0) {
                this.getFrontMap().remove(oKey);
            }
            return true;
        }
        return false;
    }

    public boolean unlock(Object oKey) {
        return this.getBackCache().unlock(oKey);
    }

    public Set keySet(Filter filter) {
        return this.getBackCache().keySet(filter);
    }

    public Set entrySet(Filter filter) {
        return this.getBackCache().entrySet(filter);
    }

    public Set entrySet(Filter filter, Comparator comparator) {
        return this.getBackCache().entrySet(filter, comparator);
    }

    public void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
        this.getBackCache().addIndex(extractor, fOrdered, comparator);
    }

    public void removeIndex(ValueExtractor extractor) {
        this.getBackCache().removeIndex(extractor);
    }

    public Object invoke(Object oKey, InvocableMap.EntryProcessor agent) {
        return this.getBackCache().invoke(oKey, agent);
    }

    public Map invokeAll(Collection collKeys, InvocableMap.EntryProcessor agent) {
        return this.getBackCache().invokeAll(collKeys, agent);
    }

    public Map invokeAll(Filter filter, InvocableMap.EntryProcessor agent) {
        return this.getBackCache().invokeAll(filter, agent);
    }

    public Object aggregate(Collection collKeys, InvocableMap.EntryAggregator agent) {
        return this.getBackCache().aggregate(collKeys, agent);
    }

    public Object aggregate(Filter filter, InvocableMap.EntryAggregator agent) {
        return this.getBackCache().aggregate(filter, agent);
    }

    protected MemberListener registerBackServiceListener() {
        CacheService service = this.getCacheService();
        if (service != null) {
            try {
                BackServiceListener listener = new BackServiceListener();
                service.addMemberListener(listener);
                return listener;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return null;
    }

    protected void unregisterBackServiceListener() {
        try {
            this.getCacheService().removeMemberListener(this.m_listenerBackService);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    protected class BackServiceListener
    implements MemberListener {
        protected BackServiceListener() {
        }

        public void memberJoined(MemberEvent evt) {
            if (evt.isLocal()) {
                try {
                    NearCache.this.unregisterFrontListener();
                    NearCache.this.getFrontMap().clear();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                NearCache.this.resetInvalidationStrategy();
            }
        }

        public void memberLeaving(MemberEvent evt) {
        }

        public void memberLeft(MemberEvent evt) {
            if (evt.isLocal()) {
                try {
                    NearCache.this.unregisterFrontListener();
                    NearCache.this.getFrontMap().clear();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                NearCache.this.resetInvalidationStrategy();
            }
        }
    }
}

