/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.net.cache.BinaryMemoryCalculator;
import com.tangosol.net.cache.CacheStatistics;
import com.tangosol.net.cache.SimpleCacheStatistics;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.FilterEnumerator;
import com.tangosol.util.LongArray;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SparseArray;
import java.lang.reflect.Array;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;

public class OldCache
extends SafeHashMap
implements ObservableMap {
    public static final int DEFAULT_UNITS = 1000;
    public static final int DEFAULT_EXPIRE = 3600000;
    public static final int DEFAULT_FLUSH = 60000;
    public static final double DEFAULT_PRUNE = 0.75;
    public static final int EVICTION_POLICY_HYBRID = 0;
    public static final int EVICTION_POLICY_LRU = 1;
    public static final int EVICTION_POLICY_LFU = 2;
    public static final int EVICTION_POLICY_EXTERNAL = 3;
    public static final int UNIT_CALCULATOR_FIXED = 0;
    public static final int UNIT_CALCULATOR_BINARY = 1;
    public static final int UNIT_CALCULATOR_EXTERNAL = 2;
    protected int m_cCurUnits;
    protected int m_cMaxUnits;
    protected int m_cPruneUnits;
    protected int m_cExpiryDelay;
    protected int m_cFlushDelay;
    protected volatile long m_lNextFlush;
    protected SimpleCacheStatistics m_stats = new SimpleCacheStatistics();
    protected MapListenerSupport m_listenerSupport;
    protected int m_nEvictionType;
    protected EvictionPolicy m_policy;
    protected int m_nCalculatorType;
    protected UnitCalculator m_calculator;

    public OldCache() {
        this(1000);
    }

    public OldCache(int cUnits) {
        this(cUnits, 3600000);
    }

    public OldCache(int cUnits, int cExpiryMillis) {
        this(cUnits, cExpiryMillis, 0.75);
    }

    public OldCache(int cUnits, int cExpiryMillis, double dflPruneLevel) {
        this.m_cMaxUnits = cUnits;
        this.m_cPruneUnits = (int)(Math.min(Math.max(dflPruneLevel, 0.0), 0.99) * (double)cUnits);
        this.m_cExpiryDelay = Math.max(cExpiryMillis, 0);
        this.scheduleFlush();
    }

    public int size() {
        this.checkFlush();
        return super.size();
    }

    public boolean containsKey(Object key) {
        this.checkFlush();
        return this.getEntryInternal(key) != null;
    }

    public Object get(Object oKey) {
        SafeHashMap.Entry entry = this.getEntry(oKey);
        return entry == null ? null : entry.getValue();
    }

    public SafeHashMap.Entry getEntry(Object oKey) {
        this.checkFlush();
        Entry entry = (Entry)this.getEntryInternal(oKey);
        if (entry == null) {
            this.m_stats.registerMiss();
        } else {
            this.m_stats.registerHit();
            entry.touch();
        }
        return entry;
    }

    public Object put(Object oKey, Object oValue) {
        return this.put(oKey, oValue, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object oKey, Object oValue, long cMillis) {
        Object oOrig;
        this.checkFlush();
        OldCache oldCache = this;
        synchronized (oldCache) {
            Entry entry = (Entry)this.getEntryInternal(oKey);
            if (entry == null) {
                oOrig = super.put(oKey, oValue);
            } else {
                entry.touch();
                oOrig = entry.setValue(oValue);
            }
            if (cMillis != 0L) {
                if (entry == null) {
                    entry = (Entry)this.getEntryInternal(oKey);
                }
                if (entry != null) {
                    entry.setExpiryMillis(cMillis > 0L ? Base.getSafeTimeMillis() + cMillis : 0L);
                    if (cMillis > 0L && this.getFlushDelay() == 0) {
                        this.setFlushDelay(60000);
                    }
                }
            }
            if (this.m_cCurUnits > this.m_cMaxUnits) {
                this.prune();
                if (this.getEntryInternal(oKey) == null) {
                    oOrig = null;
                }
            }
        }
        this.m_stats.registerPut(0L);
        return oOrig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object oKey) {
        this.checkFlush();
        OldCache oldCache = this;
        synchronized (oldCache) {
            Entry entry = (Entry)this.getEntryInternal(oKey);
            if (entry == null) {
                return null;
            }
            entry.discard();
            this.removeEntryInternal(entry);
            return entry.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.deferFlush();
        OldCache oldCache = this;
        synchronized (oldCache) {
            while (true) {
                try {
                    Iterator iter = this.entrySet().iterator();
                    while (iter.hasNext()) {
                        ((Entry)iter.next()).discard();
                    }
                    if (this.m_cCurUnits == 0) break;
                    Base.out("Invalid unit count after clear: " + this.m_cCurUnits);
                    this.m_cCurUnits = 0;
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    continue;
                }
                break;
            }
            super.clear();
            this.resetHitStatistics();
            this.scheduleFlush();
        }
    }

    public synchronized void addMapListener(MapListener listener) {
        this.addMapListener(listener, null, false);
    }

    public synchronized void removeMapListener(MapListener listener) {
        this.removeMapListener(listener, null);
    }

    public synchronized void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        Base.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support == null) {
            support = this.m_listenerSupport = new MapListenerSupport();
        }
        support.addListener(listener, oKey, fLite);
    }

    public synchronized void removeMapListener(MapListener listener, Object oKey) {
        Base.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support != null) {
            support.removeListener(listener, oKey);
            if (support.isEmpty()) {
                this.m_listenerSupport = null;
            }
        }
    }

    public synchronized void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        Base.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support == null) {
            support = this.m_listenerSupport = new MapListenerSupport();
        }
        support.addListener(listener, filter, fLite);
    }

    public synchronized void removeMapListener(MapListener listener, Filter filter) {
        Base.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support != null) {
            support.removeListener(listener, filter);
            if (support.isEmpty()) {
                this.m_listenerSupport = null;
            }
        }
    }

    public void evict(Object oKey) {
        Entry entry = (Entry)this.getEntryInternal(oKey);
        if (entry != null) {
            this.removeExpired(entry, true);
        }
    }

    public void evictAll(Collection colKeys) {
        Iterator iter = colKeys.iterator();
        while (iter.hasNext()) {
            Object oKey = iter.next();
            Entry entry = (Entry)this.getEntryInternal(oKey);
            if (entry == null) continue;
            this.removeExpired(entry, true);
        }
    }

    public synchronized void evict() {
        this.deferFlush();
        SafeHashMap.Entry[] aeBucket = this.m_aeBucket;
        int cBuckets = aeBucket.length;
        for (int iBucket = 0; iBucket < cBuckets; ++iBucket) {
            for (Entry entry = (Entry)aeBucket[iBucket]; entry != null; entry = entry.getNext()) {
                if (!entry.isExpired()) continue;
                this.removeExpired(entry, true);
            }
        }
        this.scheduleFlush();
    }

    public CacheStatistics getCacheStatistics() {
        return this.m_stats;
    }

    protected SafeHashMap.EntrySet instantiateEntrySet() {
        return new EntrySet();
    }

    protected SafeHashMap.KeySet instantiateKeySet() {
        return new KeySet();
    }

    protected SafeHashMap.ValuesCollection instantiateValuesCollection() {
        return new ValuesCollection();
    }

    public synchronized String toString() {
        while (true) {
            try {
                StringBuffer sb = new StringBuffer("Cache {\n");
                int i = 0;
                Iterator iter = this.entrySet().iterator();
                while (iter.hasNext()) {
                    sb.append('[').append(i++).append("]: ").append(iter.next()).append('\n');
                }
                sb.append('}');
                return sb.toString();
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
    }

    public int getUnits() {
        return this.m_cCurUnits;
    }

    public int getHighUnits() {
        return this.m_cMaxUnits;
    }

    public synchronized void setHighUnits(int cMax) {
        if (cMax < 0) {
            throw new IllegalArgumentException("high units out of bounds");
        }
        boolean fShrink = cMax < this.m_cMaxUnits;
        this.m_cMaxUnits = cMax;
        this.setLowUnits(this.getLowUnits());
        if (fShrink) {
            this.checkSize();
        }
    }

    public int getLowUnits() {
        return this.m_cPruneUnits;
    }

    public synchronized void setLowUnits(int cUnits) {
        if (cUnits < 0) {
            throw new IllegalArgumentException("low units out of bounds");
        }
        if (cUnits >= this.m_cMaxUnits) {
            cUnits = (int)(Math.min(Math.max(0.75, 0.0), 0.99) * (double)this.m_cMaxUnits);
        }
        this.m_cPruneUnits = cUnits;
    }

    public int getEvictionType() {
        return this.m_nEvictionType;
    }

    public synchronized void setEvictionType(int nType) {
        this.configureEviction(nType, null);
    }

    public EvictionPolicy getEvictionPolicy() {
        return this.m_policy;
    }

    public synchronized void setEvictionPolicy(EvictionPolicy policy) {
        int nType = policy == null ? 0 : 3;
        this.configureEviction(nType, policy);
    }

    public int getUnitCalculatorType() {
        return this.m_nCalculatorType;
    }

    public void setUnitCalculatorType(int nType) {
        this.configureUnitCalculator(nType, null);
    }

    public UnitCalculator getUnitCalculator() {
        return this.m_calculator;
    }

    public void setUnitCalculator(UnitCalculator calculator) {
        int nType = calculator == null ? 0 : 2;
        this.configureUnitCalculator(nType, calculator);
    }

    public int getExpiryDelay() {
        return this.m_cExpiryDelay;
    }

    public void setExpiryDelay(int cMillis) {
        this.m_cExpiryDelay = Math.max(cMillis, 0);
    }

    public int getFlushDelay() {
        return this.m_cFlushDelay;
    }

    public void setFlushDelay(int cMillis) {
        this.m_cFlushDelay = Math.max(cMillis, 0);
        this.scheduleFlush();
    }

    public long getFlushTime() {
        return this.m_lNextFlush;
    }

    public void setFlushTime(long lMillis) {
        this.m_lNextFlush = lMillis;
        this.checkFlush();
    }

    public long getCacheHits() {
        return this.m_stats.getCacheHits();
    }

    public long getCacheMisses() {
        return this.m_stats.getCacheMisses();
    }

    public double getHitProbability() {
        return this.m_stats.getHitProbability();
    }

    public void resetHitStatistics() {
        this.m_stats.resetHitStatistics();
    }

    protected synchronized void configureEviction(int nType, EvictionPolicy policy) {
        switch (nType) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                if (policy != null) break;
                throw new IllegalStateException("an attempt was made to set eviction type to EVICTION_POLICY_EXTERNAL without providing an external EvictionPolicy");
            }
            default: {
                throw new IllegalArgumentException("unknown eviction type: " + nType);
            }
        }
        EvictionPolicy policyPrev = this.m_policy;
        if (policyPrev instanceof MapListener) {
            this.removeMapListener((MapListener)((Object)policyPrev));
        }
        this.m_nEvictionType = nType;
        this.m_policy = policy;
        if (policy instanceof MapListener) {
            this.addMapListener((MapListener)((Object)policy));
        }
    }

    protected synchronized void configureUnitCalculator(int nType, UnitCalculator calculator) {
        switch (nType) {
            case 0: 
            case 1: {
                if (nType != this.m_nCalculatorType) break;
                return;
            }
            case 2: {
                if (calculator == null) {
                    throw new IllegalStateException("an attempt was made to set the unit calculator type to UNIT_CALCULATOR_EXTERNAL without providing an external UnitCalculator");
                }
                if (2 != this.m_nCalculatorType || !Base.equals(calculator, this.m_calculator)) break;
                return;
            }
            default: {
                throw new IllegalArgumentException("unknown unit calculator type: " + nType);
            }
        }
        this.m_nCalculatorType = nType;
        this.m_calculator = calculator;
        Iterator iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            Entry entry = (Entry)iter.next();
            int cUnits = entry.calculateUnits(entry.getValue());
            entry.setUnits(cUnits);
        }
    }

    protected SafeHashMap.Entry getEntryInternal(Object oKey) {
        Entry entry = (Entry)super.getEntryInternal(oKey);
        if (entry != null && entry.isExpired()) {
            this.removeExpired(entry, true);
            entry = null;
        }
        return entry;
    }

    protected synchronized void removeExpired(Entry entry, boolean fRemoveInternal) {
        entry.discard();
        if (fRemoveInternal) {
            super.removeEntryInternal(entry);
        }
    }

    protected synchronized void adjustUnits(int cDelta) {
        this.m_cCurUnits += cDelta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSize() {
        if (this.m_cCurUnits > this.m_cMaxUnits) {
            OldCache oldCache = this;
            synchronized (oldCache) {
                if (this.m_cCurUnits > this.m_cMaxUnits) {
                    this.prune();
                }
            }
        }
    }

    protected synchronized void prune() {
        int cMin;
        int cCur = this.getUnits();
        if (cCur < (cMin = this.getLowUnits())) {
            return;
        }
        int nType = this.getEvictionType();
        switch (nType) {
            default: {
                int nPrunePriority;
                int[] acUnits;
                while (true) {
                    try {
                        acUnits = new int[11];
                        Iterator iter = this.entrySet().iterator();
                        while (iter.hasNext()) {
                            Entry entry = (Entry)iter.next();
                            int cUnits = entry.getUnits();
                            try {
                                int n = entry.getPriority();
                                acUnits[n] = acUnits[n] + cUnits;
                            }
                            catch (IndexOutOfBoundsException e) {
                                int n = Math.max(0, Math.min(entry.getPriority(), 10));
                                acUnits[n] = acUnits[n] + cUnits;
                            }
                        }
                    }
                    catch (ConcurrentModificationException e) {
                        continue;
                    }
                    break;
                }
                int cTotal = 0;
                for (nPrunePriority = 0; nPrunePriority <= 10 && (cTotal += acUnits[nPrunePriority]) <= cMin; ++nPrunePriority) {
                }
                Entry entryDiscardHead = null;
                Entry entryDiscardTail = null;
                int cAdditional = Math.max(0, cTotal - cMin);
                while (cCur > cMin) {
                    try {
                        Iterator iter = this.entrySet().iterator();
                        while (iter.hasNext() && cCur > cMin) {
                            Entry entry = (Entry)iter.next();
                            int nPriority = entry.getPriority();
                            if (nPriority < nPrunePriority) continue;
                            int cUnits = entry.getUnits();
                            if (nPriority == nPrunePriority) {
                                if (cAdditional <= 0) continue;
                                cAdditional -= cUnits;
                            }
                            cCur -= cUnits;
                            super.removeEntryInternal(entry);
                            if (entryDiscardHead == null) {
                                entryDiscardHead = entry;
                            } else {
                                entryDiscardTail.setNext(entry);
                            }
                            entryDiscardTail = entry;
                        }
                        if (entryDiscardTail == null) break;
                        entryDiscardTail.setNext(null);
                        break;
                    }
                    catch (ConcurrentModificationException e) {
                    }
                }
                Entry entryDiscard = entryDiscardHead;
                while (entryDiscard != null) {
                    Entry entryNext = entryDiscard.getNext();
                    entryDiscard.setNext(null);
                    this.removeExpired(entryDiscard, false);
                    entryDiscard = entryNext;
                }
                break;
            }
            case 1: 
            case 2: {
                LongArray.Iterator iter;
                SparseArray array;
                boolean fLRU = nType == 1;
                while (true) {
                    try {
                        array = new SparseArray();
                        iter = this.entrySet().iterator();
                        while (iter.hasNext()) {
                            ArrayList<Entry> list;
                            Entry entry;
                            long lOrder = fLRU ? entry.getLastTouchMillis() : (long)entry.getTouchCount();
                            Object oPrev = array.set(lOrder, entry = (Entry)iter.next());
                            if (oPrev == null) continue;
                            if (oPrev instanceof List) {
                                list = (ArrayList<Entry>)oPrev;
                            } else {
                                list = new ArrayList<Entry>();
                                list.add((Entry)oPrev);
                            }
                            list.add(entry);
                            array.set(lOrder, list);
                        }
                    }
                    catch (ConcurrentModificationException e) {
                        continue;
                    }
                    break;
                }
                iter = array.iterator();
                while (this.getUnits() > cMin && iter.hasNext()) {
                    Object o = iter.next();
                    if (o instanceof Entry) {
                        Entry entry = (Entry)o;
                        this.removeExpired(entry, true);
                        continue;
                    }
                    List list = (List)o;
                    Iterator iterList = list.iterator();
                    while (this.getUnits() > cMin && iterList.hasNext()) {
                        Entry entry = (Entry)iterList.next();
                        this.removeExpired(entry, true);
                    }
                }
                break;
            }
            case 3: {
                this.getEvictionPolicy().requestEviction(cMin);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkFlush() {
        if (Base.getSafeTimeMillis() > this.m_lNextFlush) {
            OldCache oldCache = this;
            synchronized (oldCache) {
                if (Base.getSafeTimeMillis() > this.m_lNextFlush) {
                    this.evict();
                }
            }
        }
    }

    protected void deferFlush() {
        this.m_lNextFlush = Long.MAX_VALUE;
    }

    protected void scheduleFlush() {
        int cDelayMillis = this.m_cFlushDelay;
        this.m_lNextFlush = cDelayMillis == 0 ? Long.MAX_VALUE : Base.getSafeTimeMillis() + (long)cDelayMillis;
    }

    protected MapEvent instantiateMapEvent(int nId, Object oKey, Object oValueOld, Object oValueNew) {
        return new MapEvent(this, nId, oKey, oValueOld, oValueNew);
    }

    protected MapListenerSupport getMapListenerSupport() {
        return this.m_listenerSupport;
    }

    protected boolean hasListeners() {
        return this.m_listenerSupport != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvent(MapEvent evt) {
        MapListenerSupport listenerSupport = this.getMapListenerSupport();
        if (listenerSupport != null) {
            OldCache oldCache = this;
            synchronized (oldCache) {
                listenerSupport.fireEvent(evt, false);
            }
        }
    }

    protected SafeHashMap.Entry instantiateEntry() {
        return new Entry();
    }

    public static interface UnitCalculator {
        public int calculateUnits(Object var1, Object var2);
    }

    public static interface EvictionPolicy {
        public void entryTouched(Entry var1);

        public void requestEviction(int var1);
    }

    public class Entry
    extends SafeHashMap.Entry {
        private volatile long m_dtCreated;
        private volatile long m_dtLastUse;
        private volatile long m_dtExpiry;
        private int m_cUses;
        private int m_cUnits;

        public Entry() {
            this.m_dtLastUse = this.m_dtCreated = Entry.getSafeTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onAdd() {
            OldCache map;
            this.scheduleExpiry();
            int cNewUnits = this.calculateUnits(this.m_oValue);
            OldCache oldCache = map = OldCache.this;
            synchronized (oldCache) {
                int cOldUnits = this.m_cUnits;
                if (cOldUnits == -1) {
                    return;
                }
                if (cNewUnits != cOldUnits) {
                    map.adjustUnits(cNewUnits - cOldUnits);
                    this.m_cUnits = cNewUnits;
                }
            }
            if (map.hasListeners()) {
                map.dispatchEvent(map.instantiateMapEvent(1, this.getKey(), null, this.getValue()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object setValue(Object oValue) {
            Object oPrev;
            OldCache map;
            if (this.m_cUnits == -1) {
                super.setValue(oValue);
                return null;
            }
            int cNewUnits = this.calculateUnits(oValue);
            OldCache oldCache = map = OldCache.this;
            synchronized (oldCache) {
                int cOldUnits = this.m_cUnits;
                if (cOldUnits == -1) {
                    super.setValue(oValue);
                    return null;
                }
                if (cNewUnits != cOldUnits) {
                    map.adjustUnits(cNewUnits - cOldUnits);
                    this.m_cUnits = cNewUnits;
                }
                oPrev = super.setValue(oValue);
            }
            this.scheduleExpiry();
            if (map.hasListeners()) {
                map.dispatchEvent(map.instantiateMapEvent(2, this.getKey(), oPrev, oValue));
            }
            return oPrev;
        }

        protected void copyFrom(SafeHashMap.Entry entry) {
            Entry entryThat = (Entry)entry;
            super.copyFrom(entry);
            this.m_dtCreated = entryThat.m_dtCreated;
            this.m_dtLastUse = entryThat.m_dtLastUse;
            this.m_dtExpiry = entryThat.m_dtExpiry;
            this.m_cUses = entryThat.m_cUses;
            this.m_cUnits = entryThat.m_cUnits;
        }

        public int getPriority() {
            long dt = Entry.getSafeTimeMillis();
            long cMillisAge = dt - this.m_dtCreated;
            long cMillisDormant = dt - this.m_dtLastUse;
            int cUses = this.m_cUses;
            double dflRate = (cMillisAge == 0L ? 1L : cMillisAge) / (long)(cUses == 0 ? 1 : cUses);
            double dflRateScore = Math.log(Math.max(dflRate, 100.0) / 100.0);
            double dflDormantScore = Math.log((double)Math.max(cMillisDormant, 1000L) / 1000.0);
            int nPriority = (int)(dflRateScore + dflDormantScore) / 2;
            return Math.max(0, Math.min(10, nPriority));
        }

        public long getCreatedMillis() {
            return this.m_dtCreated;
        }

        public void touch() {
            ++this.m_cUses;
            this.m_dtLastUse = Entry.getSafeTimeMillis();
            EvictionPolicy policy = OldCache.this.getEvictionPolicy();
            if (policy != null) {
                policy.entryTouched(this);
            }
        }

        public long getLastTouchMillis() {
            return this.m_dtLastUse;
        }

        public int getTouchCount() {
            return this.m_cUses;
        }

        public long getExpiryMillis() {
            return this.m_dtExpiry;
        }

        public void setExpiryMillis(long lMillis) {
            this.m_dtExpiry = lMillis;
        }

        public boolean isExpired() {
            long dtExpiry = this.m_dtExpiry;
            return dtExpiry != 0L && dtExpiry < Entry.getSafeTimeMillis();
        }

        protected void scheduleExpiry() {
            long dtExpiry = 0L;
            int cDelay = OldCache.this.m_cExpiryDelay;
            if (cDelay > 0) {
                dtExpiry = Entry.getSafeTimeMillis() + (long)cDelay;
            }
            this.setExpiryMillis(dtExpiry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void discard() {
            if (!this.isDiscarded()) {
                OldCache map;
                OldCache oldCache = map = OldCache.this;
                synchronized (oldCache) {
                    int cUnits = this.m_cUnits;
                    if (cUnits == -1) {
                        return;
                    }
                    if (cUnits > 0) {
                        map.adjustUnits(-cUnits);
                    }
                    this.m_cUnits = -1;
                }
                if (map.hasListeners()) {
                    map.dispatchEvent(map.instantiateMapEvent(3, this.getKey(), this.getValue(), null));
                }
            }
        }

        protected boolean isDiscarded() {
            return this.m_cUnits == -1;
        }

        protected int calculateUnits(Object oValue) {
            OldCache map = OldCache.this;
            Object oKey = this.getKey();
            switch (map.getUnitCalculatorType()) {
                case 1: {
                    return BinaryMemoryCalculator.INSTANCE.calculateUnits(oKey, oValue);
                }
                case 2: {
                    return map.getUnitCalculator().calculateUnits(oKey, oValue);
                }
            }
            return 1;
        }

        public int getUnits() {
            return this.m_cUnits;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setUnits(int cUnits) {
            Entry.azzert(cUnits >= 0);
            OldCache oldCache = OldCache.this;
            synchronized (oldCache) {
                int cOldUnits = this.m_cUnits;
                if (cOldUnits == -1) {
                    return;
                }
                if (cUnits != cOldUnits) {
                    OldCache.this.adjustUnits(cUnits - cOldUnits);
                    this.m_cUnits = cUnits;
                }
            }
        }

        public String toString() {
            long dtExpiry = this.getExpiryMillis();
            return super.toString() + ", priority=" + this.getPriority() + ", created=" + new Time(this.getCreatedMillis()) + ", last-use=" + new Time(this.getLastTouchMillis()) + ", expiry=" + (dtExpiry == 0L ? "none" : new Time(dtExpiry) + (this.isExpired() ? " (expired)" : "")) + ", use-count=" + this.getTouchCount() + ", units=" + this.getUnits();
        }

        Entry getNext() {
            return (Entry)this.m_eNext;
        }

        void setNext(Entry entry) {
            this.m_eNext = entry;
        }
    }

    protected class ValuesCollection
    extends SafeHashMap.ValuesCollection {
        protected ValuesCollection() {
            super(OldCache.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray(Object[] ao) {
            Object[] aoAll;
            OldCache map;
            int cAll = 0;
            OldCache oldCache = map = OldCache.this;
            synchronized (oldCache) {
                int c = map.size();
                aoAll = new Object[c];
                if (c > 0) {
                    SafeHashMap.Entry[] aeBucket = map.m_aeBucket;
                    int cBuckets = aeBucket.length;
                    for (int iBucket = 0; iBucket < cBuckets; ++iBucket) {
                        for (Entry entry = (Entry)aeBucket[iBucket]; entry != null; entry = entry.getNext()) {
                            if (entry.isExpired()) {
                                OldCache.this.removeExpired(entry, true);
                                continue;
                            }
                            aoAll[cAll++] = entry.getValue();
                        }
                    }
                }
            }
            if (ao == null && cAll == aoAll.length) {
                return aoAll;
            }
            if (ao == null) {
                ao = new Object[cAll];
            } else if (ao.length < cAll) {
                ao = (Object[])Array.newInstance(ao.getClass().getComponentType(), cAll);
            } else if (ao.length > cAll) {
                ao[cAll] = null;
            }
            if (cAll > 0) {
                System.arraycopy(aoAll, 0, ao, 0, cAll);
            }
            return ao;
        }
    }

    protected class KeySet
    extends SafeHashMap.KeySet {
        protected KeySet() {
            super(OldCache.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] toArray(Object[] ao) {
            Object[] aoAll;
            OldCache map;
            int cAll = 0;
            OldCache oldCache = map = OldCache.this;
            synchronized (oldCache) {
                int c = map.size();
                aoAll = new Object[c];
                if (c > 0) {
                    SafeHashMap.Entry[] aeBucket = map.m_aeBucket;
                    int cBuckets = aeBucket.length;
                    for (int iBucket = 0; iBucket < cBuckets; ++iBucket) {
                        for (Entry entry = (Entry)aeBucket[iBucket]; entry != null; entry = entry.getNext()) {
                            if (entry.isExpired()) {
                                OldCache.this.removeExpired(entry, true);
                                continue;
                            }
                            aoAll[cAll++] = entry.getKey();
                        }
                    }
                }
            }
            if (ao == null && cAll == aoAll.length) {
                return aoAll;
            }
            if (ao == null) {
                ao = new Object[cAll];
            } else if (ao.length < cAll) {
                ao = (Object[])Array.newInstance(ao.getClass().getComponentType(), cAll);
            } else if (ao.length > cAll) {
                ao[cAll] = null;
            }
            if (cAll > 0) {
                System.arraycopy(aoAll, 0, ao, 0, cAll);
            }
            return ao;
        }
    }

    protected class EntrySet
    extends SafeHashMap.EntrySet {
        protected EntrySet() {
            super(OldCache.this);
        }

        public Iterator iterator() {
            if (OldCache.this.isEmpty()) {
                return NullImplementation.getIterator();
            }
            Iterator iter = super.instantiateIterator();
            Filter filter = new Filter(this){
                private final /* synthetic */ EntrySet this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean evaluate(Object o) {
                    Entry entry = (Entry)o;
                    boolean fExpired = entry.isExpired();
                    if (fExpired) {
                        EntrySet.access$000(this.this$1).removeExpired(entry, true);
                    }
                    return !fExpired;
                }
            };
            return new FilterEnumerator(iter, filter);
        }

        public Object[] toArray(Object[] ao) {
            Entry entry;
            int ofSrc;
            Object[] aoAll = super.toArray(ao);
            int cAll = aoAll.length;
            int ofDest = 0;
            for (ofSrc = 0; ofSrc < cAll && (entry = (Entry)aoAll[ofSrc]) != null; ++ofSrc) {
                if (entry.isExpired()) {
                    OldCache.this.removeExpired(entry, true);
                    continue;
                }
                if (ofSrc > ofDest) {
                    aoAll[ofDest] = aoAll[ofSrc];
                }
                ++ofDest;
            }
            if (ofSrc == ofDest) {
                return aoAll;
            }
            if (ao == aoAll) {
                ao[ofDest] = null;
                return ao;
            }
            ao = ao == null ? new Object[ofDest] : (Object[])Array.newInstance(ao.getClass().getComponentType(), ofDest);
            System.arraycopy(aoAll, 0, ao, 0, ofDest);
            return ao;
        }

        static /* synthetic */ OldCache access$000(EntrySet x0) {
            return x0.OldCache.this;
        }
    }
}

