/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.license.CoherenceApplicationEdition;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.cache.AbstractBundler;
import com.tangosol.net.cache.AbstractCacheStore;
import com.tangosol.net.cache.AbstractEntryBundler;
import com.tangosol.net.cache.AbstractKeyBundler;
import com.tangosol.net.cache.CacheEvent;
import com.tangosol.net.cache.CacheLoader;
import com.tangosol.net.cache.CacheStore;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.util.Base;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.Daemon;
import com.tangosol.util.Filter;
import com.tangosol.util.ListMap;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.RecyclingLinkedList;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.SimpleMapEntry;
import com.tangosol.util.WrapperConcurrentMap;
import com.tangosol.util.WrapperException;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReadWriteBackingMap
extends AbstractMap
implements ObservableMap {
    protected static final Object NO_VALUE = new Object();
    private BackingMapManagerContext m_ctxService;
    private boolean m_fActive = true;
    private ObservableMap m_mapInternal;
    private LocalCache m_cacheInternal;
    private Map m_mapMisses;
    private ConcurrentMap m_mapControl;
    private MapListener m_listenerInternal;
    private Map m_mapSyntheticEvents;
    private CacheStoreWrapper m_store;
    private boolean m_fReadOnly;
    private ReadQueue m_queueRead;
    private ReadThread m_daemonRead;
    private WriteQueue m_queueWrite;
    private WriteThread m_daemonWrite;
    protected MapListenerSupport m_listenerSupport;
    private EntrySet m_entryset;
    private KeySet m_keyset;
    private ValuesCollection m_values;
    private int m_cWriteBehindSeconds;
    private volatile double m_dflRefreshAheadFactor;
    private volatile boolean m_fRethrowExceptions;
    private volatile double m_dflWriteBatchFactor;
    private volatile int m_cWriteRequeueThreshold;

    public ReadWriteBackingMap(BackingMapManagerContext ctxService, ObservableMap mapInternal, Map mapMisses, CacheLoader loader) {
        this.init(ctxService, mapInternal, mapMisses, this.instantiateCacheLoaderCacheStore(loader), true, 0, 0.0);
    }

    public ReadWriteBackingMap(BackingMapManagerContext ctxService, ObservableMap mapInternal, Map mapMisses, CacheStore store, boolean fReadOnly, int cWriteBehindSeconds) {
        this.init(ctxService, mapInternal, mapMisses, store, fReadOnly, cWriteBehindSeconds, 0.0);
    }

    public ReadWriteBackingMap(BackingMapManagerContext ctxService, ObservableMap mapInternal, Map mapMisses, CacheStore store, boolean fReadOnly, int cWriteBehindSeconds, double dflRefreshAheadFactor) {
        this.init(ctxService, mapInternal, mapMisses, store, fReadOnly, cWriteBehindSeconds, dflRefreshAheadFactor);
    }

    private void init(BackingMapManagerContext ctxService, ObservableMap mapInternal, Map mapMisses, CacheStore store, boolean fReadOnly, int cWriteBehindSeconds, double dflRefreshAheadFactor) {
        this.m_ctxService = ctxService;
        this.configureInternalCache(mapInternal);
        if (store != null) {
            this.m_mapMisses = mapMisses;
            this.configureCacheStore(store, fReadOnly);
            if (mapInternal instanceof LocalCache) {
                this.m_cacheInternal = (LocalCache)mapInternal;
            }
            this.configureWriteThread(cWriteBehindSeconds);
            this.configureReadThread(dflRefreshAheadFactor);
        }
    }

    public BackingMapManagerContext getContext() {
        return this.m_ctxService;
    }

    public boolean isRethrowExceptions() {
        return this.m_fRethrowExceptions;
    }

    public void setRethrowExceptions(boolean fRethrow) {
        this.m_fRethrowExceptions = fRethrow;
    }

    public double getRefreshAheadFactor() {
        return this.m_dflRefreshAheadFactor;
    }

    public void setRefreshAheadFactor(double dflRefreshAheadFactor) {
        if (this.isRefreshAhead()) {
            if (dflRefreshAheadFactor >= 0.0 && dflRefreshAheadFactor <= 1.0) {
                this.m_dflRefreshAheadFactor = dflRefreshAheadFactor;
            } else {
                throw new IllegalArgumentException("Invalid refresh-ahead factor: " + dflRefreshAheadFactor);
            }
        }
    }

    public boolean isReadOnly() {
        return this.m_fReadOnly;
    }

    public boolean isRefreshAhead() {
        return this.getCacheStore() != null && this.getReadQueue() != null;
    }

    public double getWriteBatchFactor() {
        return this.m_dflWriteBatchFactor;
    }

    public void setWriteBatchFactor(double dflWriteBatchFactor) {
        if (this.isWriteBehind()) {
            if (dflWriteBatchFactor >= 0.0 && dflWriteBatchFactor <= 1.0) {
                this.m_dflWriteBatchFactor = dflWriteBatchFactor;
            } else {
                throw new IllegalArgumentException("Invalid write-batch factor: " + dflWriteBatchFactor);
            }
        }
    }

    public boolean isWriteBehind() {
        return !this.isReadOnly() && this.getCacheStore() != null && this.getWriteQueue() != null;
    }

    public int getWriteBehindSeconds() {
        return this.m_cWriteBehindSeconds;
    }

    public void setWriteBehindSeconds(int cSecs) {
        if (this.isWriteBehind()) {
            if (cSecs > 0) {
                this.m_cWriteBehindSeconds = cSecs;
                this.getWriteQueue().setDelaySeconds(cSecs);
            } else {
                throw new IllegalArgumentException("Invalid write-behind delay: " + cSecs);
            }
        }
    }

    public int getWriteRequeueThreshold() {
        return this.m_cWriteRequeueThreshold;
    }

    public void setWriteRequeueThreshold(int cThreshold) {
        if (this.isWriteBehind()) {
            if (cThreshold >= 0) {
                this.m_cWriteRequeueThreshold = cThreshold;
            } else {
                throw new IllegalArgumentException("Invalid write requeue threshold: " + cThreshold);
            }
        }
    }

    public boolean isWriteThrough() {
        return !this.isReadOnly() && this.getCacheStore() != null && this.getWriteQueue() == null;
    }

    public void clear() {
        Iterator iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    public boolean containsKey(Object oKey) {
        return this.getInternalCache().containsKey(oKey);
    }

    public boolean containsValue(Object oValue) {
        return this.getInternalCache().containsValue(oValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get(Object oKey) {
        ConcurrentMap mapControl = this.getControlMap();
        ObservableMap mapInternal = this.getInternalCache();
        Map mapMisses = this.getMissesCache();
        mapControl.lock(oKey, -1L);
        try {
            CacheStoreWrapper store;
            Object oValue;
            block34: {
                block32: {
                    ReadLatch latch;
                    long lInterval;
                    long lTimeMillis;
                    LocalCache.Entry entry;
                    LocalCache cache;
                    block33: {
                        if (mapMisses != null && mapMisses.containsKey(oKey)) {
                            Object var5_5 = null;
                            return var5_5;
                        }
                        oValue = null;
                        if (!this.isRefreshAhead()) break block32;
                        cache = this.getInternalLocalCache();
                        entry = (LocalCache.Entry)cache.getEntry(oKey);
                        if (entry != null) break block33;
                        ReadLatch latch2 = (ReadLatch)mapControl.get(oKey);
                        if (latch2 == null) {
                            this.getReadQueue().remove(oKey);
                            break block34;
                        } else {
                            Object object;
                            try {
                                object = latch2;
                                synchronized (object) {
                                    while (!latch2.isComplete()) {
                                        latch2.wait();
                                    }
                                }
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                            finally {
                                mapControl.remove(oKey);
                            }
                            oValue = latch2.getValue();
                            if (oValue != null) {
                                Map mapSynthetic = this.getSyntheticEventsMap();
                                mapSynthetic.put(oKey, oKey);
                                try {
                                    mapInternal.put(oKey, oValue);
                                }
                                finally {
                                    mapSynthetic.remove(oKey);
                                }
                            } else if (mapMisses != null) {
                                mapMisses.put(oKey, oKey);
                            }
                            object = oValue;
                            return object;
                        }
                    }
                    long lExpiryMillis = entry.getExpiryMillis();
                    if (lExpiryMillis != 0L && (lTimeMillis = Base.getSafeTimeMillis()) >= lExpiryMillis - (lInterval = (long)((double)cache.getExpiryDelay() * this.getRefreshAheadFactor())) && (latch = (ReadLatch)mapControl.get(oKey)) == null) {
                        this.getReadQueue().add(oKey);
                    }
                    Object object = entry.getValue();
                    return object;
                }
                oValue = mapInternal.get(oKey);
            }
            if (oValue == null && (store = this.getCacheStore()) != null) {
                oValue = store.loadInternal(oKey);
                if (oValue != null) {
                    Map mapSynthetic = this.getSyntheticEventsMap();
                    mapSynthetic.put(oKey, oKey);
                    try {
                        mapInternal.put(oKey, oValue);
                    }
                    finally {
                        mapSynthetic.remove(oKey);
                    }
                } else if (mapMisses != null) {
                    mapMisses.put(oKey, oKey);
                }
            }
            Object object = oValue;
            return object;
        }
        finally {
            mapControl.unlock(oKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object oKey, Object oValue) {
        ConcurrentMap mapControl = this.getControlMap();
        Map mapMisses = this.getMissesCache();
        mapControl.lock(oKey, -1L);
        try {
            if (mapMisses != null) {
                mapMisses.remove(oKey);
            }
            if (this.isRefreshAhead()) {
                this.getReadQueue().remove(oKey);
                ReadLatch latch = (ReadLatch)mapControl.get(oKey);
                if (latch != null) {
                    latch.cancel();
                    mapControl.remove(oKey);
                }
            }
            BackingMapManagerContext ctx = this.getContext();
            CacheStoreWrapper store = this.getCacheStore();
            WriteQueue queue = this.getWriteQueue();
            if (store != null && !this.isReadOnly()) {
                boolean fOwned = ctx.isKeyOwned(oKey);
                if (queue == null) {
                    if (fOwned) {
                        store.storeInternal(oKey, oValue);
                    }
                } else if (fOwned) {
                    oValue = ctx.addInternalValueDecoration(oValue, 2, Boolean.FALSE);
                } else if (!ctx.isInternalValueDecorated(oValue, 2)) {
                    queue = null;
                }
            }
            Object oValueOld = this.getInternalCache().put(oKey, oValue);
            if (queue != null) {
                queue.add(oKey, oValue);
            }
            Object object = oValueOld;
            return object;
        }
        finally {
            mapControl.unlock(oKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object oKey) {
        ConcurrentMap mapControl = this.getControlMap();
        Map mapMisses = this.getMissesCache();
        mapControl.lock(oKey, -1L);
        try {
            if (mapMisses != null) {
                mapMisses.remove(oKey);
            }
            if (this.isRefreshAhead() && !this.isReadOnly()) {
                this.getReadQueue().remove(oKey);
                ReadLatch latch = (ReadLatch)mapControl.get(oKey);
                if (latch != null) {
                    latch.cancel();
                    mapControl.remove(oKey);
                }
            }
            ObservableMap mapInternal = this.getInternalCache();
            Object oValue = mapInternal.get(oKey);
            CacheStoreWrapper store = this.getCacheStore();
            if (store != null) {
                if (oValue == null && (oValue = store.loadInternal(oKey)) == null) {
                    Object var7_7 = null;
                    return var7_7;
                }
                if (!this.isReadOnly()) {
                    WriteQueue queue = this.getWriteQueue();
                    if (queue != null) {
                        if (this.getWriteRequeueThreshold() == 0) {
                            queue.remove(oKey);
                        } else {
                            queue.add(oKey, NO_VALUE);
                        }
                    }
                    if (this.getContext().isKeyOwned(oKey)) {
                        store.eraseInternal(oKey);
                    }
                }
            }
            mapInternal.remove(oKey);
            Object v = oValue;
            return v;
        }
        finally {
            mapControl.unlock(oKey);
        }
    }

    public int size() {
        return this.getInternalCache().size();
    }

    public Set entrySet() {
        EntrySet set = this.m_entryset;
        if (set == null) {
            this.m_entryset = set = this.instantiateEntrySet();
        }
        return set;
    }

    public Set keySet() {
        KeySet set = this.m_keyset;
        if (set == null) {
            this.m_keyset = set = this.instantiateKeySet();
        }
        return set;
    }

    public Collection values() {
        ValuesCollection values = this.m_values;
        if (values == null) {
            this.m_values = values = this.instantiateValuesCollection();
        }
        return values;
    }

    protected void updateOnGet(Map.Entry entryReal) {
    }

    protected void updateOnPut(Map.Entry entryReal) {
    }

    protected EntrySet instantiateEntrySet() {
        return new EntrySet();
    }

    protected KeySet instantiateKeySet() {
        return new KeySet();
    }

    protected ValuesCollection instantiateValuesCollection() {
        return new ValuesCollection();
    }

    public void addMapListener(MapListener listener) {
        this.addMapListener(listener, null, false);
    }

    public void removeMapListener(MapListener listener) {
        this.removeMapListener(listener, null);
    }

    public synchronized void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        Base.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support == null) {
            support = this.m_listenerSupport = new MapListenerSupport();
        }
        support.addListener(listener, oKey, fLite);
    }

    public synchronized void removeMapListener(MapListener listener, Object oKey) {
        Base.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support != null) {
            support.removeListener(listener, oKey);
            if (support.isEmpty()) {
                this.m_listenerSupport = null;
            }
        }
    }

    public synchronized void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        Base.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support == null) {
            support = this.m_listenerSupport = new MapListenerSupport();
        }
        support.addListener(listener, filter, fLite);
    }

    public synchronized void removeMapListener(MapListener listener, Filter filter) {
        Base.azzert(listener != null);
        MapListenerSupport support = this.m_listenerSupport;
        if (support != null) {
            support.removeListener(listener, filter);
            if (support.isEmpty()) {
                this.m_listenerSupport = null;
            }
        }
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Map && this.getInternalCache().equals(o);
    }

    public int hashCode() {
        return this.getInternalCache().hashCode();
    }

    public String toString() {
        return this.getInternalCache().toString();
    }

    public ObservableMap getInternalCache() {
        return this.m_mapInternal;
    }

    protected LocalCache getInternalLocalCache() {
        return this.m_cacheInternal;
    }

    protected void configureInternalCache(ObservableMap mapInternal) {
        this.m_mapInternal = mapInternal;
        this.m_mapControl = this.instantiateControlMap();
        this.m_listenerInternal = this.instantiateInternalListener();
        mapInternal.addMapListener(this.getInternalListener());
    }

    public Map getMissesCache() {
        return this.m_mapMisses;
    }

    public ConcurrentMap getControlMap() {
        return this.m_mapControl;
    }

    protected ConcurrentMap instantiateControlMap() {
        return new WrapperConcurrentMap(new SafeHashMap(), false, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getSyntheticEventsMap() {
        Map map = this.m_mapSyntheticEvents;
        if (map == null) {
            ReadWriteBackingMap readWriteBackingMap = this;
            synchronized (readWriteBackingMap) {
                map = this.m_mapSyntheticEvents;
                if (map == null) {
                    map = this.m_mapSyntheticEvents = new SafeHashMap();
                }
            }
        }
        return map;
    }

    protected MapListener getInternalListener() {
        return this.m_listenerInternal;
    }

    protected MapListener instantiateInternalListener() {
        return new InternalMapListener();
    }

    public void release() {
        if (this.isActive()) {
            try {
                this.getInternalCache().removeMapListener(this.getInternalListener());
            }
            catch (Exception e) {
                Base.err("An exception occurred while removing an internal listener during release:");
                Base.err(e);
            }
            if (this.isRefreshAhead()) {
                this.terminateReadThread();
            }
            if (this.isWriteBehind()) {
                this.terminateWriteThread();
            }
            this.m_store = null;
            this.m_fActive = false;
        }
    }

    public boolean isActive() {
        return this.m_fActive;
    }

    protected ReadLatch instantiateReadLatch(Object oKey) {
        return new ReadLatch(oKey);
    }

    public ReadQueue getReadQueue() {
        return this.m_queueRead;
    }

    protected ReadQueue instantiateReadQueue() {
        return new ReadQueue();
    }

    public WriteQueue getWriteQueue() {
        return this.m_queueWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        WriteQueue queue = this.getWriteQueue();
        CacheStoreWrapper store = this.getCacheStore();
        if (queue != null && store != null && !this.isReadOnly()) {
            ConcurrentMap mapControl = this.getControlMap();
            mapControl.lock(queue, -1L);
            try {
                if (queue == this.getWriteQueue()) {
                    this.flush(queue, store);
                }
            }
            finally {
                mapControl.unlock(queue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flush(WriteQueue queue, CacheStoreWrapper store) {
        Base.azzert(queue != null && store != null);
        ConcurrentMap mapControl = this.getControlMap();
        BackingMapManagerContext ctx = this.getContext();
        Map.Entry entry = queue.removeImmediate();
        while (entry != null && this.isActive()) {
            Object oKey = entry.getKey();
            Object oValue = entry.getValue();
            if (oValue != NO_VALUE && ctx.isKeyOwned(oKey)) {
                mapControl.lock(oKey, -1L);
                try {
                    try {
                        store.storeInternal(oKey, oValue);
                    }
                    catch (WrapperException e) {
                        Base.err(e);
                    }
                }
                finally {
                    mapControl.unlock(oKey);
                }
            }
            entry = queue.removeImmediate();
        }
    }

    protected WriteQueue instantiateWriteQueue() {
        return new WriteQueue();
    }

    protected ReadThread getReadThread() {
        return this.m_daemonRead;
    }

    protected void configureReadThread(double dflRefreshAheadFactor) {
        Base.azzert(dflRefreshAheadFactor >= 0.0 && dflRefreshAheadFactor <= 1.0, "Invalid refresh-ahead factor: " + dflRefreshAheadFactor);
        LocalCache cache = this.getInternalLocalCache();
        if (dflRefreshAheadFactor > 0.0 && cache != null) {
            int cWriteDelay;
            int cExpiry;
            int cReadDelay;
            int cExpiryMillis = cache.getExpiryDelay();
            if (cExpiryMillis == 0) {
                dflRefreshAheadFactor = 0.0;
            } else if (this.isWriteBehind() && (cReadDelay = (int)((double)(cExpiry = cExpiryMillis / 1000) * (1.0 - dflRefreshAheadFactor))) < (cWriteDelay = this.getWriteBehindSeconds())) {
                cReadDelay = (cExpiry + cWriteDelay) / 2;
                StringBuffer sb = new StringBuffer().append("ReadWriteBackingMap refresh-ahead factor of ").append(dflRefreshAheadFactor).append(" is too aggressive for the write-delay of ").append(cWriteDelay).append(" seconds; ");
                double d = dflRefreshAheadFactor = cExpiry == 0 ? 0.0 : 1.0 - (double)cReadDelay / (double)cExpiry;
                if (dflRefreshAheadFactor > 0.0) {
                    sb.append("reducing the factor to ").append(dflRefreshAheadFactor).append('.');
                } else {
                    sb.append("disabling refresh-ahead.");
                }
                Base.log(sb.toString());
            }
            if (dflRefreshAheadFactor > 0.0) {
                this.m_dflRefreshAheadFactor = dflRefreshAheadFactor;
                this.m_queueRead = this.instantiateReadQueue();
                this.m_daemonRead = this.instantiateReadThread();
                this.m_daemonRead.start();
            }
        }
    }

    protected ReadThread instantiateReadThread() {
        return new ReadThread();
    }

    protected void terminateReadThread() {
        if (this.isActive()) {
            ReadThread daemon = this.m_daemonRead;
            ReadQueue queue = this.m_queueRead;
            this.m_daemonRead = null;
            this.m_queueRead = null;
            if (daemon != null) {
                daemon.stop();
            }
            if (queue != null) {
                queue.clear();
            }
        }
    }

    protected WriteThread getWriteThread() {
        return this.m_daemonWrite;
    }

    protected void configureWriteThread(int cWriteBehindSeconds) {
        if (cWriteBehindSeconds > 0 && !this.isReadOnly()) {
            LocalCache cache = this.getInternalLocalCache();
            if (cache != null) {
                int cExpiryMillis = cache.getExpiryDelay();
                long cDelayMillis = (long)cWriteBehindSeconds * 1000L;
                if (cExpiryMillis > 0 && (long)cExpiryMillis < cDelayMillis) {
                    StringBuffer sb = new StringBuffer().append("ReadWriteBackingMap internal cache expiry of ").append(cExpiryMillis).append(" milliseconds is less than the write-delay of ").append(cWriteBehindSeconds).append(" seconds; ");
                    cWriteBehindSeconds = cExpiryMillis / 1000;
                    if (cWriteBehindSeconds > 0) {
                        sb.append("decreasing the write-delay to ").append(cWriteBehindSeconds).append(" seconds.");
                    } else {
                        sb.append("disabling write-behind.");
                    }
                    Base.log(sb.toString());
                }
            }
            if (cWriteBehindSeconds > 0) {
                WriteQueue queue = this.instantiateWriteQueue();
                queue.setDelaySeconds(cWriteBehindSeconds);
                this.m_cWriteBehindSeconds = cWriteBehindSeconds;
                this.m_queueWrite = queue;
                this.m_daemonWrite = this.instantiateWriteThread();
                this.m_daemonWrite.start();
            }
        }
    }

    protected WriteThread instantiateWriteThread() {
        return new WriteThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void terminateWriteThread() {
        if (this.isActive()) {
            CacheStoreWrapper store = this.getCacheStore();
            WriteQueue queue = this.getWriteQueue();
            if (store != null && queue != null) {
                ConcurrentMap mapControl = this.getControlMap();
                mapControl.lock(ConcurrentMap.LOCK_ALL, -1L);
                try {
                    WriteThread daemon = this.m_daemonWrite;
                    this.m_daemonWrite = null;
                    this.m_queueWrite = null;
                    this.flush(queue, store);
                    if (daemon != null) {
                        daemon.stop();
                    }
                }
                catch (Exception e) {
                    Base.err("An exception occurred while flushing the write-behind queue while terminating the write-behind thread:");
                    Base.err(e);
                    Base.err("(The write-behind thread is exiting.)");
                }
                finally {
                    mapControl.unlock(ConcurrentMap.LOCK_ALL);
                }
            }
        }
    }

    public CacheStoreWrapper getCacheStore() {
        return this.m_store;
    }

    protected void configureCacheStore(CacheStore store, boolean fReadOnly) {
        Base.azzert(store != null && this.m_store == null);
        this.m_fReadOnly = fReadOnly;
        this.m_store = this.instantiateCacheStoreWrapper(store);
    }

    protected CacheStoreWrapper instantiateCacheStoreWrapper(CacheStore store) {
        return store == null ? null : new CacheStoreWrapper(store);
    }

    protected CacheLoaderCacheStore instantiateCacheLoaderCacheStore(CacheLoader loader) {
        return loader == null ? null : new CacheLoaderCacheStore(loader);
    }

    public class CacheLoaderCacheStore
    extends AbstractCacheStore {
        private CacheLoader m_loader;

        public CacheLoaderCacheStore(CacheLoader loader) {
            CacheLoaderCacheStore.azzert(loader != null);
            this.m_loader = loader;
        }

        public Object load(Object oKey) {
            return this.getCacheLoader().load(oKey);
        }

        public Map loadAll(Collection colKeys) {
            return this.getCacheLoader().loadAll(colKeys);
        }

        protected CacheLoader getCacheLoader() {
            return this.m_loader;
        }
    }

    public class CacheStoreWrapper
    extends AbstractCacheStore {
        private CacheStore m_store;
        private volatile long m_cLoadOps;
        private volatile long m_cLoadFailures;
        private volatile long m_cLoadMillis;
        private volatile long m_cStoreOps;
        private volatile long m_cStoreEntries;
        private volatile long m_cStoreFailures;
        private volatile long m_cStoreMillis;
        private volatile long m_cEraseOps;
        private volatile long m_cEraseFailures;
        private volatile long m_cEraseMillis;
        private boolean m_fStoreSupported = true;
        private boolean m_fStoreAllSupported = true;
        private boolean m_fEraseSupported = true;
        private boolean m_fEraseAllSupported = true;
        private LoadBundler m_loadBundler;
        private StoreBundler m_storeBundler;
        private EraseBundler m_eraseBundler;

        public CacheStoreWrapper(CacheStore store) {
            CacheStoreWrapper.azzert(store != null);
            this.m_store = store;
        }

        public synchronized AbstractBundler ensureLoadBundler(int cBundleThreshold) {
            if (cBundleThreshold > 0) {
                LoadBundler bundler = this.m_loadBundler;
                if (bundler == null) {
                    this.m_loadBundler = bundler = new LoadBundler();
                }
                bundler.setSizeThreshold(cBundleThreshold);
                return bundler;
            }
            this.m_loadBundler = null;
            return null;
        }

        public synchronized AbstractBundler ensureStoreBundler(int cBundleThreshold) {
            if (cBundleThreshold > 0) {
                StoreBundler bundler = this.m_storeBundler;
                if (bundler == null) {
                    this.m_storeBundler = bundler = new StoreBundler();
                }
                bundler.setSizeThreshold(cBundleThreshold);
                return bundler;
            }
            this.m_storeBundler = null;
            return null;
        }

        public synchronized AbstractBundler ensureEraseBundler(int cBundleThreshold) {
            if (cBundleThreshold > 0) {
                EraseBundler bundler = this.m_eraseBundler;
                if (bundler == null) {
                    this.m_eraseBundler = bundler = new EraseBundler();
                }
                bundler.setSizeThreshold(cBundleThreshold);
                return bundler;
            }
            this.m_eraseBundler = null;
            return null;
        }

        public AbstractBundler getLoadBundler() {
            return this.m_loadBundler;
        }

        public AbstractBundler getStoreBundler() {
            return this.m_storeBundler;
        }

        public AbstractBundler getEraseBundler() {
            return this.m_eraseBundler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object loadInternal(Object oKey) {
            Object object;
            long lStart = CacheStoreWrapper.getSafeTimeMillis();
            BackingMapManagerContext ctx = ReadWriteBackingMap.this.getContext();
            Object oKeyReal = ctx.getKeyFromInternalConverter().convert(oKey);
            try {
                Object oValueReal = this.load(oKeyReal);
                object = oValueReal == null ? null : ctx.getValueToInternalConverter().convert(oValueReal);
                Object var9_9 = null;
                ++this.m_cLoadOps;
            }
            catch (RuntimeException e) {
                Object var7_8;
                try {
                    ++this.m_cLoadFailures;
                    this.onLoadFailure(oKeyReal, e);
                    var7_8 = null;
                    Object var9_10 = null;
                    ++this.m_cLoadOps;
                }
                catch (Throwable throwable) {
                    block6: {
                        Object var9_11 = null;
                        ++this.m_cLoadOps;
                        long lElapsed = CacheStoreWrapper.getSafeTimeMillis() - lStart;
                        if (lElapsed == 0L) break block6;
                        this.m_cLoadMillis += lElapsed;
                    }
                    throw throwable;
                }
                long lElapsed = CacheStoreWrapper.getSafeTimeMillis() - lStart;
                if (lElapsed != 0L) {
                    this.m_cLoadMillis += lElapsed;
                }
                return var7_8;
            }
            long lElapsed = CacheStoreWrapper.getSafeTimeMillis() - lStart;
            if (lElapsed != 0L) {
                this.m_cLoadMillis += lElapsed;
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Map loadAllInternal(Collection colKeys) {
            Map map;
            long lStart = CacheStoreWrapper.getSafeTimeMillis();
            BackingMapManagerContext ctx = ReadWriteBackingMap.this.getContext();
            ConverterCollections.ConverterCollection colKeysReal = ConverterCollections.getCollection(colKeys, ctx.getKeyFromInternalConverter(), ctx.getKeyToInternalConverter());
            try {
                map = this.loadAll(colKeysReal);
                Object var9_7 = null;
                ++this.m_cLoadOps;
            }
            catch (RuntimeException e) {
                Map map2;
                try {
                    ++this.m_cLoadFailures;
                    this.onLoadAllFailure(colKeysReal, e);
                    map2 = null;
                    Object var9_8 = null;
                    ++this.m_cLoadOps;
                }
                catch (Throwable throwable) {
                    block6: {
                        Object var9_9 = null;
                        ++this.m_cLoadOps;
                        long lElapsed = CacheStoreWrapper.getSafeTimeMillis() - lStart;
                        if (lElapsed == 0L) break block6;
                        this.m_cLoadMillis += lElapsed;
                    }
                    throw throwable;
                }
                long lElapsed = CacheStoreWrapper.getSafeTimeMillis() - lStart;
                if (lElapsed != 0L) {
                    this.m_cLoadMillis += lElapsed;
                }
                return map2;
            }
            long lElapsed = CacheStoreWrapper.getSafeTimeMillis() - lStart;
            if (lElapsed != 0L) {
                this.m_cLoadMillis += lElapsed;
            }
            return map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void storeInternal(Object oKey, Object oValue) {
            boolean fSuccess;
            BackingMapManagerContext ctx;
            block8: {
                long lStart = CacheStoreWrapper.getSafeTimeMillis();
                ctx = ReadWriteBackingMap.this.getContext();
                Object oKeyReal = ctx.getKeyFromInternalConverter().convert(oKey);
                Object oValueReal = ctx.getValueFromInternalConverter().convert(oValue);
                fSuccess = true;
                try {
                    try {
                        this.store(oKeyReal, oValueReal);
                    }
                    catch (RuntimeException e) {
                        fSuccess = false;
                        ++this.m_cStoreFailures;
                        this.onStoreFailure(oKeyReal, oValueReal, e);
                        Object var11_9 = null;
                        ++this.m_cStoreOps;
                        ++this.m_cStoreEntries;
                        long lElapsed = CacheStoreWrapper.getSafeTimeMillis() - lStart;
                        if (lElapsed != 0L) {
                            this.m_cStoreMillis += lElapsed;
                        }
                        break block8;
                    }
                    Object var11_8 = null;
                    ++this.m_cStoreOps;
                    ++this.m_cStoreEntries;
                }
                catch (Throwable throwable) {
                    Object var11_10 = null;
                    ++this.m_cStoreOps;
                    ++this.m_cStoreEntries;
                    long lElapsed = CacheStoreWrapper.getSafeTimeMillis() - lStart;
                    if (lElapsed != 0L) {
                        this.m_cStoreMillis += lElapsed;
                    }
                    throw throwable;
                }
                long lElapsed = CacheStoreWrapper.getSafeTimeMillis() - lStart;
                if (lElapsed != 0L) {
                    this.m_cStoreMillis += lElapsed;
                }
            }
            if (fSuccess && ReadWriteBackingMap.this.getWriteQueue() != null) {
                this.replaceInternal(oKey, oValue, ctx.removeInternalValueDecoration(oValue, 2));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void storeAllInternal(Map mapEntries) {
            boolean fSuccess;
            HashMap mapTemp;
            boolean fAsynch;
            BackingMapManagerContext ctx;
            block12: {
                long lElapsed2;
                int cEntries = mapEntries.size();
                if (cEntries == 0) {
                    return;
                }
                long lStart = CacheStoreWrapper.getSafeTimeMillis();
                ctx = ReadWriteBackingMap.this.getContext();
                fAsynch = ReadWriteBackingMap.this.getWriteQueue() != null;
                mapTemp = null;
                if (fAsynch) {
                    mapTemp = new HashMap(mapEntries);
                }
                fSuccess = true;
                ConverterCollections.ConverterMap mapEntriesReal = ConverterCollections.getMap(mapEntries, ctx.getKeyFromInternalConverter(), ctx.getKeyToInternalConverter(), ctx.getValueFromInternalConverter(), ctx.getValueToInternalConverter());
                try {
                    Object var12_9;
                    try {
                        this.storeAll(mapEntriesReal);
                    }
                    catch (RuntimeException e) {
                        fSuccess = false;
                        ++this.m_cStoreFailures;
                        this.onStoreAllFailure(mapEntriesReal, e);
                        var12_9 = null;
                        ++this.m_cStoreOps;
                        this.m_cStoreEntries += (long)cEntries;
                        lElapsed2 = CacheStoreWrapper.getSafeTimeMillis() - lStart;
                        if (lElapsed2 != 0L) {
                            this.m_cStoreMillis += lElapsed2;
                        }
                        break block12;
                    }
                    var12_9 = null;
                    ++this.m_cStoreOps;
                }
                catch (Throwable throwable) {
                    Object var12_10 = null;
                    ++this.m_cStoreOps;
                    this.m_cStoreEntries += (long)cEntries;
                    long lElapsed2 = CacheStoreWrapper.getSafeTimeMillis() - lStart;
                    if (lElapsed2 != 0L) {
                        this.m_cStoreMillis += lElapsed2;
                    }
                    throw throwable;
                }
                this.m_cStoreEntries += (long)cEntries;
                lElapsed2 = CacheStoreWrapper.getSafeTimeMillis() - lStart;
                if (lElapsed2 != 0L) {
                    this.m_cStoreMillis += lElapsed2;
                }
            }
            if (fAsynch) {
                if (!fSuccess) {
                    mapTemp.keySet().removeAll(mapEntries.keySet());
                }
                Iterator iter = mapTemp.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    Object oValue = entry.getValue();
                    this.replaceInternal(entry.getKey(), oValue, ctx.removeInternalValueDecoration(oValue, 2));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void eraseInternal(Object oKey) {
            long lStart = CacheStoreWrapper.getSafeTimeMillis();
            BackingMapManagerContext ctx = ReadWriteBackingMap.this.getContext();
            Object oKeyReal = ctx.getKeyFromInternalConverter().convert(oKey);
            try {
                try {
                    this.erase(oKeyReal);
                }
                catch (RuntimeException e) {
                    ++this.m_cEraseFailures;
                    this.onEraseFailure(oKeyReal, e);
                    Object var8_6 = null;
                    ++this.m_cEraseOps;
                    long lElapsed = CacheStoreWrapper.getSafeTimeMillis() - lStart;
                    if (lElapsed == 0L) return;
                    this.m_cEraseMillis += lElapsed;
                    return;
                }
                Object var8_5 = null;
                ++this.m_cEraseOps;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                ++this.m_cEraseOps;
                long lElapsed = CacheStoreWrapper.getSafeTimeMillis() - lStart;
                if (lElapsed == 0L) throw throwable;
                this.m_cEraseMillis += lElapsed;
                throw throwable;
            }
            long lElapsed = CacheStoreWrapper.getSafeTimeMillis() - lStart;
            if (lElapsed == 0L) return;
            this.m_cEraseMillis += lElapsed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void eraseAllInternal(Collection colKeys) {
            long lStart = CacheStoreWrapper.getSafeTimeMillis();
            BackingMapManagerContext ctx = ReadWriteBackingMap.this.getContext();
            ConverterCollections.ConverterCollection colKeysReal = ConverterCollections.getCollection(colKeys, ctx.getKeyFromInternalConverter(), ctx.getKeyToInternalConverter());
            try {
                try {
                    this.eraseAll(colKeysReal);
                }
                catch (RuntimeException e) {
                    ++this.m_cEraseFailures;
                    this.onEraseAllFailure(colKeysReal, e);
                    Object var8_6 = null;
                    ++this.m_cEraseOps;
                    long lElapsed = CacheStoreWrapper.getSafeTimeMillis() - lStart;
                    if (lElapsed == 0L) return;
                    this.m_cEraseMillis += lElapsed;
                    return;
                }
                Object var8_5 = null;
                ++this.m_cEraseOps;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                ++this.m_cEraseOps;
                long lElapsed = CacheStoreWrapper.getSafeTimeMillis() - lStart;
                if (lElapsed == 0L) throw throwable;
                this.m_cEraseMillis += lElapsed;
                throw throwable;
            }
            long lElapsed = CacheStoreWrapper.getSafeTimeMillis() - lStart;
            if (lElapsed == 0L) return;
            this.m_cEraseMillis += lElapsed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void replaceInternal(Object oKey, Object oValueOld, Object oValueNew) {
            ObservableMap mapInternal = ReadWriteBackingMap.this.getInternalCache();
            ConcurrentMap mapControl = ReadWriteBackingMap.this.getControlMap();
            for (int i = 0; i < 2; ++i) {
                if (!mapControl.lock(oKey, i * 20)) continue;
                try {
                    if (Base.equals(oValueOld, mapInternal.get(oKey))) {
                        mapInternal.put(oKey, oValueNew);
                    }
                }
                finally {
                    mapControl.unlock(oKey);
                }
                return;
            }
        }

        public Object load(Object oKey) {
            LoadBundler bundler = this.m_loadBundler;
            return bundler == null ? this.getCacheStore().load(oKey) : bundler.process(oKey);
        }

        public Map loadAll(Collection colKeys) {
            LoadBundler bundler = this.m_loadBundler;
            return bundler == null ? this.getCacheStore().loadAll(colKeys) : bundler.processAll(colKeys);
        }

        public void store(Object oKey, Object oValue) {
            CacheStoreWrapper.azzert(!ReadWriteBackingMap.this.isReadOnly());
            StoreBundler bundler = this.m_storeBundler;
            if (bundler == null) {
                this.getCacheStore().store(oKey, oValue);
            } else {
                bundler.process(oKey, oValue);
            }
        }

        public void storeAll(Map mapEntries) {
            CacheStoreWrapper.azzert(!ReadWriteBackingMap.this.isReadOnly());
            StoreBundler bundler = this.m_storeBundler;
            if (bundler == null) {
                this.getCacheStore().storeAll(mapEntries);
            } else {
                bundler.processAll(mapEntries);
            }
        }

        public void erase(Object oKey) {
            CacheStoreWrapper.azzert(!ReadWriteBackingMap.this.isReadOnly());
            EraseBundler bundler = this.m_eraseBundler;
            if (bundler == null) {
                this.getCacheStore().erase(oKey);
            } else {
                bundler.process(oKey);
            }
        }

        public void eraseAll(Collection colKeys) {
            CacheStoreWrapper.azzert(!ReadWriteBackingMap.this.isReadOnly());
            EraseBundler bundler = this.m_eraseBundler;
            if (bundler == null) {
                this.getCacheStore().eraseAll(colKeys);
            } else {
                bundler.processAll(colKeys);
            }
        }

        public long getLoadOps() {
            return this.m_cLoadOps;
        }

        public long getLoadFailures() {
            return this.m_cLoadFailures;
        }

        public long getLoadMillis() {
            return this.m_cLoadMillis;
        }

        public long getStoreOps() {
            return this.m_cStoreOps;
        }

        public long getStoreFailures() {
            return this.m_cStoreFailures;
        }

        public long getStoreMillis() {
            return this.m_cStoreMillis;
        }

        public long getEraseOps() {
            return this.m_cEraseOps;
        }

        public long getEraseFailures() {
            return this.m_cEraseFailures;
        }

        public long getEraseMillis() {
            return this.m_cEraseMillis;
        }

        public long getAverageBatchSize() {
            long cOps = this.m_cStoreOps;
            return cOps > 0L ? this.m_cStoreEntries / cOps : 0L;
        }

        public long getAverageLoadMillis() {
            long cOps = this.m_cLoadOps;
            return cOps > 0L ? this.m_cLoadMillis / cOps : 0L;
        }

        public long getAverageStoreMillis() {
            long cOps = this.m_cStoreOps;
            return cOps > 0L ? this.m_cStoreMillis / cOps : 0L;
        }

        public long getAverageEraseMillis() {
            long cOps = this.m_cEraseOps;
            return cOps > 0L ? this.m_cEraseMillis / cOps : 0L;
        }

        public void resetStatistics() {
            this.m_cLoadOps = 0L;
            this.m_cLoadFailures = 0L;
            this.m_cLoadMillis = 0L;
            this.m_cStoreOps = 0L;
            this.m_cStoreEntries = 0L;
            this.m_cStoreFailures = 0L;
            this.m_cStoreMillis = 0L;
            this.m_cEraseOps = 0L;
            this.m_cEraseFailures = 0L;
            this.m_cEraseMillis = 0L;
        }

        public CacheStore getCacheStore() {
            return this.m_store;
        }

        public boolean isStoreSupported() {
            return this.m_fStoreSupported;
        }

        public void setStoreSupported(boolean fSupported) {
            this.m_fStoreSupported = fSupported;
        }

        public boolean isStoreAllSupported() {
            return this.m_fStoreAllSupported;
        }

        public void setStoreAllSupported(boolean fSupported) {
            this.m_fStoreAllSupported = fSupported;
        }

        public boolean isEraseSupported() {
            return this.m_fEraseSupported;
        }

        public void setEraseSupported(boolean fSupported) {
            this.m_fEraseSupported = fSupported;
        }

        public boolean isEraseAllSupported() {
            return this.m_fEraseAllSupported;
        }

        public void setEraseAllSupported(boolean fSupported) {
            this.m_fEraseAllSupported = fSupported;
        }

        protected void onLoadFailure(Object oKeyReal, Exception e) {
            if (ReadWriteBackingMap.this.isRethrowExceptions()) {
                throw CacheStoreWrapper.ensureRuntimeException(e, "Failed to load key=\"" + oKeyReal + "\"");
            }
            CacheStoreWrapper.err("Failed to load key=\"" + oKeyReal + "\":");
            CacheStoreWrapper.err(e);
        }

        protected void onLoadAllFailure(Collection colKeys, Exception e) {
            if (ReadWriteBackingMap.this.isRethrowExceptions()) {
                throw CacheStoreWrapper.ensureRuntimeException(e, "Failed to load keys=\"" + colKeys + "\"");
            }
            CacheStoreWrapper.err("Failed to load keys=\"" + colKeys + "\":");
            CacheStoreWrapper.err(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onStoreFailure(Object oKeyReal, Object oValueReal, Exception e) {
            WriteQueue queue = ReadWriteBackingMap.this.getWriteQueue();
            WriteThread writeThread = ReadWriteBackingMap.this.getWriteThread();
            int cThreshold = ReadWriteBackingMap.this.getWriteRequeueThreshold();
            if (e instanceof UnsupportedOperationException) {
                if (this.isStoreSupported()) {
                    this.setStoreSupported(false);
                    CacheStoreWrapper.log("The CacheStore \"" + this.getCacheStore() + "\" does not support the store() operation.");
                }
                cThreshold = Integer.MAX_VALUE;
            }
            String sMsg = "Failed to store key=\"" + oKeyReal + "\"";
            if (queue == null || Thread.currentThread() != writeThread.getThread()) {
                if (ReadWriteBackingMap.this.isRethrowExceptions()) {
                    throw CacheStoreWrapper.ensureRuntimeException(e, sMsg);
                }
                CacheStoreWrapper.err(sMsg);
                CacheStoreWrapper.err(e);
            } else {
                CacheStoreWrapper.err(sMsg);
                CacheStoreWrapper.err(e);
                BackingMapManagerContext ctx = ReadWriteBackingMap.this.getContext();
                WriteQueue writeQueue = queue;
                synchronized (writeQueue) {
                    Object oKey;
                    if (cThreshold != 0 && queue.size() <= cThreshold && !queue.containsKey(oKey = ctx.getKeyToInternalConverter().convert(oKeyReal))) {
                        Object oValue = ctx.getValueToInternalConverter().convert(oValueReal);
                        queue.add(oKey, oValue);
                        CacheStoreWrapper.log("Requeued store for key=\"" + oKeyReal + "\"");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onStoreAllFailure(Map mapEntries, Exception e) {
            WriteQueue queue = ReadWriteBackingMap.this.getWriteQueue();
            WriteThread writeThread = ReadWriteBackingMap.this.getWriteThread();
            int cThreshold = ReadWriteBackingMap.this.getWriteRequeueThreshold();
            Set setKeys = mapEntries.keySet();
            if (e instanceof UnsupportedOperationException) {
                if (this.isStoreAllSupported()) {
                    this.setStoreAllSupported(false);
                    CacheStoreWrapper.log("The CacheStore \"" + this.getCacheStore() + "\" does not support the storeAll() operation.");
                }
                cThreshold = Integer.MAX_VALUE;
            }
            String sMsg = "Failed to store keys=\"" + setKeys + "\"";
            if (queue == null || Thread.currentThread() != writeThread.getThread()) {
                if (ReadWriteBackingMap.this.isRethrowExceptions()) {
                    throw CacheStoreWrapper.ensureRuntimeException(e, sMsg);
                }
                CacheStoreWrapper.err(sMsg);
                CacheStoreWrapper.err(e);
            } else {
                CacheStoreWrapper.err(sMsg);
                CacheStoreWrapper.err(e);
                if (cThreshold != 0) {
                    BackingMapManagerContext ctx = ReadWriteBackingMap.this.getContext();
                    Iterator iterEntries = mapEntries.entrySet().iterator();
                    while (iterEntries.hasNext()) {
                        Map.Entry entry = iterEntries.next();
                        Object oKeyReal = entry.getKey();
                        Object oValueReal = entry.getValue();
                        WriteQueue writeQueue = queue;
                        synchronized (writeQueue) {
                            Object oKey;
                            if (queue.size() <= cThreshold && !queue.containsKey(oKey = ctx.getKeyToInternalConverter().convert(oKeyReal))) {
                                Object oValue = ctx.getValueToInternalConverter().convert(oValueReal);
                                queue.add(oKey, oValue);
                                CacheStoreWrapper.log("Requeued store for key=\"" + oKeyReal + "\"");
                            }
                        }
                    }
                }
            }
        }

        protected void onEraseFailure(Object oKeyReal, Exception e) {
            if (e instanceof UnsupportedOperationException) {
                if (this.isEraseSupported()) {
                    this.setEraseSupported(false);
                    CacheStoreWrapper.log("The CacheStore \"" + this.getCacheStore() + "\" does not support the erase() operation.");
                }
            } else {
                String sMsg = "Failed to erase key=\"" + oKeyReal + "\"";
                if (ReadWriteBackingMap.this.isRethrowExceptions()) {
                    throw CacheStoreWrapper.ensureRuntimeException(e, sMsg);
                }
                CacheStoreWrapper.err(sMsg);
                CacheStoreWrapper.err(e);
            }
        }

        protected void onEraseAllFailure(Collection colKeys, Exception e) {
            if (e instanceof UnsupportedOperationException) {
                if (this.isEraseAllSupported()) {
                    this.setEraseAllSupported(false);
                    CacheStoreWrapper.log("The CacheStore \"" + this.getCacheStore() + "\" does not support the eraseAll() operation.");
                }
            } else {
                String sMsg = "Failed to erase keys=\"" + colKeys + "\"";
                if (ReadWriteBackingMap.this.isRethrowExceptions()) {
                    throw CacheStoreWrapper.ensureRuntimeException(e, sMsg);
                }
                CacheStoreWrapper.err(sMsg);
                CacheStoreWrapper.err(e);
            }
        }

        public String toString() {
            return "CacheStoreWrapper(" + this.m_store.getClass().getName() + ')';
        }

        protected class EraseBundler
        extends AbstractKeyBundler {
            protected EraseBundler() {
            }

            protected Map bundle(Collection colKeys) {
                CacheStoreWrapper.this.getCacheStore().eraseAll(colKeys);
                return null;
            }

            protected Object unbundle(Object oKey) {
                CacheStoreWrapper.this.getCacheStore().erase(oKey);
                return null;
            }
        }

        protected class StoreBundler
        extends AbstractEntryBundler {
            protected StoreBundler() {
            }

            protected void bundle(Map map) {
                CacheStoreWrapper.this.getCacheStore().storeAll(map);
            }
        }

        protected class LoadBundler
        extends AbstractKeyBundler {
            protected LoadBundler() {
            }

            protected Map bundle(Collection colKeys) {
                return CacheStoreWrapper.this.getCacheStore().loadAll(colKeys);
            }

            protected Object unbundle(Object oKey) {
                return CacheStoreWrapper.this.getCacheStore().load(oKey);
            }
        }
    }

    public class WriteThread
    extends Daemon {
        public WriteThread() {
            super("WriteBehindThread:" + ReadWriteBackingMap.this.getCacheStore().toString(), 5, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block18: {
                block13: while (true) {
                    while (ReadWriteBackingMap.this.isActive() && !this.isStopping()) {
                        WriteQueue queue = ReadWriteBackingMap.this.getWriteQueue();
                        CacheStoreWrapper store = ReadWriteBackingMap.this.getCacheStore();
                        if (queue == null || store == null) continue;
                        try {
                            Map.Entry entry;
                            if (store.isStoreAllSupported()) {
                                entry = queue.remove();
                                Object oKeyFirst = null;
                                Object oValueFirst = null;
                                ListMap mapEntries = null;
                                int cEntries = 0;
                                while (entry != null) {
                                    Object oKey = entry.getKey();
                                    Object oValue = entry.getValue();
                                    if (oValue != NO_VALUE) {
                                        switch (cEntries++) {
                                            case 0: {
                                                oKeyFirst = oKey;
                                                oValueFirst = oValue;
                                                break;
                                            }
                                            case 1: {
                                                mapEntries = new ListMap();
                                                mapEntries.put(oKeyFirst, oValueFirst);
                                            }
                                            default: {
                                                mapEntries.put(oKey, oValue);
                                            }
                                        }
                                    }
                                    entry = queue.removeNoWait();
                                }
                                switch (cEntries) {
                                    case 0: {
                                        break;
                                    }
                                    case 1: {
                                        store.storeInternal(oKeyFirst, oValueFirst);
                                        break;
                                    }
                                    default: {
                                        store.storeAllInternal(mapEntries);
                                        break;
                                    }
                                }
                                continue block13;
                            }
                            entry = queue.remove();
                            if (entry == null) continue block13;
                            Object oKey = entry.getKey();
                            Object oValue = entry.getValue();
                            if (oValue == NO_VALUE) continue block13;
                            store.storeInternal(oKey, oValue);
                            continue block13;
                        }
                        catch (Throwable e) {
                            WriteThread.err("An exception occurred on the write-behind thread");
                            WriteThread.err(e);
                            WriteThread.err("(The exception will be ignored. The write-behind thread will continue.)");
                        }
                    }
                    break block18;
                    {
                        continue block13;
                        break;
                    }
                    break;
                }
                finally {
                    ReadWriteBackingMap.this.terminateWriteThread();
                }
            }
        }
    }

    public class ReadThread
    extends Daemon {
        public ReadThread() {
            super("ReadThread:" + ReadWriteBackingMap.this.getCacheStore().toString(), 5, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ConcurrentMap mapControl = ReadWriteBackingMap.this.getControlMap();
            LocalCache cacheInternal = ReadWriteBackingMap.this.getInternalLocalCache();
            Map mapMisses = ReadWriteBackingMap.this.getMissesCache();
            Map mapSynthetic = ReadWriteBackingMap.this.getSyntheticEventsMap();
            ReadQueue queue = ReadWriteBackingMap.this.getReadQueue();
            long cWaitMillis = 0L;
            try {
                while (ReadWriteBackingMap.this.isActive() && !this.isStopping()) {
                    CacheStoreWrapper store = ReadWriteBackingMap.this.getCacheStore();
                    if (store == null) continue;
                    ReadLatch latch = queue.select(cWaitMillis);
                    if (latch == null) {
                        cWaitMillis += 10L;
                        continue;
                    }
                    cWaitMillis = 0L;
                    Object oKey = latch.getKey();
                    Object oValue = null;
                    Throwable exception = null;
                    try {
                        oValue = store.loadInternal(oKey);
                    }
                    catch (Throwable e) {
                        exception = e;
                    }
                    if (mapControl.lock(oKey, 0L)) {
                        try {
                            if (exception != null || latch.isCanceled() || !ReadWriteBackingMap.this.getContext().isKeyOwned(oKey)) continue;
                            if (oValue == null) {
                                if (mapMisses == null) continue;
                                mapMisses.put(oKey, oKey);
                                continue;
                            }
                            mapSynthetic.put(oKey, oKey);
                            try {
                                cacheInternal.put(oKey, oValue);
                                continue;
                            }
                            finally {
                                mapSynthetic.remove(oKey);
                                continue;
                            }
                        }
                        finally {
                            mapControl.remove(oKey);
                            mapControl.unlock(oKey);
                            continue;
                        }
                    }
                    if (exception == null) {
                        latch.complete(oValue);
                        continue;
                    }
                    latch.cancel(exception);
                }
            }
            finally {
                ReadWriteBackingMap.this.terminateReadThread();
            }
        }
    }

    public class WriteQueue
    extends CoherenceApplicationEdition {
        private Map m_mapQueued = new SafeHashMap();
        private List m_listQueued = new RecyclingLinkedList();
        private int m_cSecsDelay = 60;

        protected WriteQueue() {
        }

        public int getDelaySeconds() {
            return this.m_cSecsDelay;
        }

        public synchronized void setDelaySeconds(int cSeconds) {
            this.m_cSecsDelay = Math.max(0, cSeconds);
            this.notify();
        }

        public synchronized Object add(Object oKey, Object oValue) {
            Object oValueOld = null;
            Map map = this.getEntryMap();
            Entry entry = (Entry)map.get(oKey);
            if (entry == null) {
                entry = this.instantiateEntry(oKey);
                entry.setValue(oValue);
                entry.setQueuedMillis(WriteQueue.getSafeTimeMillis());
                map.put(oKey, entry);
                List list = this.getKeyList();
                boolean fWasEmpty = list.isEmpty();
                list.add(oKey);
                if (fWasEmpty) {
                    this.notify();
                }
            } else {
                oValueOld = entry.setValue(oValue);
            }
            return oValueOld;
        }

        public synchronized Map.Entry remove(Object oKey) {
            Entry entry = (Entry)this.getEntryMap().remove(oKey);
            if (entry != null) {
                this.getKeyList().remove(oKey);
            }
            return entry;
        }

        public synchronized Map.Entry removeImmediate() {
            if (!ReadWriteBackingMap.this.isActive()) {
                return null;
            }
            List list = this.getKeyList();
            if (list.isEmpty()) {
                return null;
            }
            Object oKey = list.remove(0);
            Map map = this.getEntryMap();
            return (Entry)map.remove(oKey);
        }

        /*
         * Unable to fully structure code
         */
        public synchronized Map.Entry remove() {
            list = this.getKeyList();
            map = this.getEntryMap();
            while (true) lbl-1000:
            // 5 sources

            {
                if (!ReadWriteBackingMap.this.isActive()) {
                    return null;
                }
                if (list.isEmpty()) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        if (!ReadWriteBackingMap.this.isActive()) ** GOTO lbl-1000
                        throw new WrapperException(e);
                    }
                }
                oKey = list.get(0);
                entry = (Entry)map.get(oKey);
                lAdded = entry.getQueuedMillis();
                lCutoff = this.getCutoffMillis();
                if (lCutoff >= lAdded) {
                    map.remove(oKey);
                    list.remove(0);
                    return entry;
                }
                lWait = Math.max(1L, lAdded - lCutoff);
                try {
                    this.wait(lWait);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    if (ReadWriteBackingMap.this.isActive()) ** break;
                    continue;
                    throw new WrapperException(e);
                }
                break;
            }
        }

        public synchronized Map.Entry removeNoWait() {
            if (!ReadWriteBackingMap.this.isActive()) {
                return null;
            }
            List list = this.getKeyList();
            if (!list.isEmpty()) {
                Object oKey = list.get(0);
                Map map = this.getEntryMap();
                Entry entry = (Entry)map.get(oKey);
                if (this.getCutoffMillis() >= entry.getQueuedMillis() - (long)(ReadWriteBackingMap.this.getWriteBatchFactor() * (double)ReadWriteBackingMap.this.getWriteBehindSeconds() * 1000.0)) {
                    map.remove(oKey);
                    list.remove(0);
                    return entry;
                }
            }
            return null;
        }

        public int size() {
            return this.getKeyList().size();
        }

        public boolean isEmpty() {
            return this.getKeyList().isEmpty();
        }

        public boolean containsKey(Object oKey) {
            return this.getEntryMap().containsKey(oKey);
        }

        protected Map getEntryMap() {
            return this.m_mapQueued;
        }

        protected List getKeyList() {
            return this.m_listQueued;
        }

        protected long getCutoffMillis() {
            return WriteQueue.getSafeTimeMillis() - (long)this.getDelaySeconds() * 1000L;
        }

        protected Entry instantiateEntry(Object oKey) {
            return new Entry(oKey);
        }

        public class Entry
        extends SimpleMapEntry {
            private long m_lQueuedMillis;

            public Entry(Object oKey) {
                super(oKey);
            }

            public long getQueuedMillis() {
                return this.m_lQueuedMillis;
            }

            protected void setQueuedMillis(long lMillis) {
                if (this.m_lQueuedMillis != 0L) {
                    throw new IllegalStateException("cannot change entry-added time");
                }
                this.m_lQueuedMillis = lMillis;
            }
        }
    }

    public class ReadQueue
    extends CoherenceApplicationEdition {
        private List m_listQueued = new RecyclingLinkedList();
        private Map m_mapQueued = new HashMap();

        protected ReadQueue() {
        }

        public synchronized boolean add(Object oKey) {
            Map map = this.getKeyMap();
            if (map.get(oKey) == null) {
                map.put(oKey, oKey);
                List list = this.getKeyList();
                boolean fWasEmpty = list.isEmpty();
                list.add(oKey);
                if (fWasEmpty) {
                    this.notify();
                }
                return true;
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public synchronized Object peek() {
            List list = this.getKeyList();
            while (ReadWriteBackingMap.this.isActive()) {
                if (!list.isEmpty()) return list.get(0);
                try {
                    this.wait(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    if (ReadWriteBackingMap.this.isActive()) throw new WrapperException(e);
                    continue;
                }
                break;
            }
            return null;
        }

        public synchronized boolean remove(Object oKey) {
            if (this.getKeyMap().remove(oKey) != null) {
                this.getKeyList().remove(oKey);
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ReadLatch select(long cWaitMillis) {
            List listKeys = this.getKeyList();
            ConcurrentMap mapControl = ReadWriteBackingMap.this.getControlMap();
            ReadLatch latch = null;
            int index = 0;
            Object oKey = this.peek();
            while (oKey != null) {
                boolean fRemoved = false;
                if (mapControl.lock(oKey, cWaitMillis)) {
                    try {
                        if (this.remove(oKey)) {
                            latch = ReadWriteBackingMap.this.instantiateReadLatch(oKey);
                            mapControl.put(oKey, latch);
                            break;
                        }
                        fRemoved = true;
                    }
                    finally {
                        mapControl.unlock(oKey);
                    }
                }
                try {
                    oKey = listKeys.get(fRemoved ? index : ++index);
                }
                catch (IndexOutOfBoundsException e) {
                    break;
                }
            }
            return latch;
        }

        public synchronized void clear() {
            this.getKeyMap().clear();
            this.getKeyList().clear();
        }

        public String toString() {
            return "ReadQueue: " + this.getKeyList();
        }

        protected List getKeyList() {
            return this.m_listQueued;
        }

        protected Map getKeyMap() {
            return this.m_mapQueued;
        }
    }

    protected class ReadLatch {
        private Object m_oKey;
        private Object m_oValue;
        private boolean m_fComplete;
        private boolean m_fCanceled;
        private Throwable m_throwable;

        protected ReadLatch(Object oKey) {
            this.m_oKey = oKey;
        }

        public synchronized void cancel() {
            this.cancel(null);
        }

        public synchronized void cancel(Throwable t) {
            if (!this.m_fCanceled && !this.m_fComplete) {
                this.m_oValue = null;
                this.m_throwable = t;
                this.m_fCanceled = true;
                this.m_fComplete = true;
                this.notifyAll();
            }
        }

        public synchronized void complete(Object oValue) {
            if (!this.m_fCanceled && !this.m_fComplete) {
                this.m_oValue = oValue;
                this.m_fComplete = true;
                this.notifyAll();
            }
        }

        public boolean isComplete() {
            return this.m_fComplete;
        }

        public boolean isCanceled() {
            return this.m_fCanceled;
        }

        public Object getKey() {
            return this.m_oKey;
        }

        public synchronized Object getValue() {
            Throwable throwable = this.m_throwable;
            if (throwable != null && this.m_fCanceled) {
                throw new WrapperException(throwable);
            }
            return this.m_oValue;
        }
    }

    protected class InternalMapListener
    extends Base
    implements MapListener {
        private Map m_mapIgnore = new SafeHashMap();

        protected InternalMapListener() {
        }

        public void entryInserted(MapEvent evt) {
            MapListenerSupport support = ReadWriteBackingMap.this.m_listenerSupport;
            if (support != null && !this.getIgnoreMap().containsKey(evt.getKey())) {
                this.dispatch(evt);
            }
        }

        public void entryUpdated(MapEvent evt) {
            MapListenerSupport support = ReadWriteBackingMap.this.m_listenerSupport;
            if (support != null && !this.getIgnoreMap().containsKey(evt.getKey())) {
                this.dispatch(evt);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void entryDeleted(MapEvent evt) {
            Object oKey;
            Map mapIgnore = this.getIgnoreMap();
            if (mapIgnore.containsKey(oKey = evt.getKey())) {
                return;
            }
            ConcurrentMap mapControl = ReadWriteBackingMap.this.getControlMap();
            if (mapControl.lock(oKey, 500L)) {
                try {
                    if (ReadWriteBackingMap.this.getContext().isKeyOwned(oKey)) {
                        this.processDeletedEntry(oKey);
                    }
                    this.dispatch(evt);
                }
                finally {
                    mapControl.unlock(oKey);
                }
            }
            mapIgnore.put(oKey, Thread.currentThread());
            try {
                Object oValueOld = evt.getOldValue();
                Object oValue = ReadWriteBackingMap.this.getInternalCache().put(oKey, oValueOld);
                if (oValue != null && !InternalMapListener.equals(oValue, oValueOld)) {
                    String sCulprit = ReadWriteBackingMap.this.getCacheStore() == null ? "backing map" : "cache store";
                    InternalMapListener.err("Due to an exceptionally long " + sCulprit + " operation an eviction event cannot be processed" + " in order. Canceling the eviction: " + evt);
                }
            }
            finally {
                mapIgnore.remove(oKey);
            }
        }

        protected void processDeletedEntry(Object oKey) {
            WriteQueue queue;
            CacheStoreWrapper store = ReadWriteBackingMap.this.getCacheStore();
            if (store != null && !ReadWriteBackingMap.this.isReadOnly() && (queue = ReadWriteBackingMap.this.getWriteQueue()) != null) {
                Object oValue = null;
                if (ReadWriteBackingMap.this.getWriteRequeueThreshold() == 0) {
                    Map.Entry entry = queue.remove(oKey);
                    if (entry != null) {
                        oValue = entry.getValue();
                    }
                } else {
                    oValue = queue.add(oKey, NO_VALUE);
                }
                if (oValue != null && oValue != NO_VALUE) {
                    try {
                        store.storeInternal(oKey, oValue);
                    }
                    catch (WrapperException e) {
                        InternalMapListener.log(e);
                    }
                }
            }
        }

        protected void dispatch(MapEvent evt) {
            MapListenerSupport support = ReadWriteBackingMap.this.m_listenerSupport;
            if (support != null) {
                Object oKey = evt.getKey();
                CacheEvent evtNew = new CacheEvent(this, ReadWriteBackingMap.this, evt.getId(), oKey, null, null, ReadWriteBackingMap.this.getSyntheticEventsMap().containsKey(oKey), evt){
                    private final /* synthetic */ MapEvent val$evt;
                    private final /* synthetic */ InternalMapListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$evt = val$evt;
                        super(x0, x1, x2, x3, x4, x5);
                    }

                    public Object getOldValue() {
                        return this.val$evt.getOldValue();
                    }

                    public Object getNewValue() {
                        return this.val$evt.getNewValue();
                    }
                };
                support.fireEvent(evtNew, true);
            }
        }

        protected Map getIgnoreMap() {
            return this.m_mapIgnore;
        }
    }

    protected class ValuesCollection
    extends AbstractCollection {
        protected ValuesCollection() {
        }

        public Iterator iterator() {
            return new Iterator(this){
                private Iterator m_iter;
                private final /* synthetic */ ValuesCollection this$1;
                {
                    this.this$1 = this$1;
                    this.m_iter = ValuesCollection.access$200(this.this$1).keySet().iterator();
                }

                public boolean hasNext() {
                    return this.m_iter.hasNext();
                }

                public Object next() {
                    return ValuesCollection.access$200(this.this$1).get(this.m_iter.next());
                }

                public void remove() {
                    this.m_iter.remove();
                }
            };
        }

        public int size() {
            return ReadWriteBackingMap.this.size();
        }

        public void clear() {
            ReadWriteBackingMap.this.clear();
        }

        public Object[] toArray() {
            return ReadWriteBackingMap.this.getInternalCache().values().toArray();
        }

        public Object[] toArray(Object[] ao) {
            return ReadWriteBackingMap.this.getInternalCache().values().toArray(ao);
        }

        static /* synthetic */ ReadWriteBackingMap access$200(ValuesCollection x0) {
            return x0.ReadWriteBackingMap.this;
        }
    }

    protected class KeySet
    extends AbstractSet {
        protected KeySet() {
        }

        public Iterator iterator() {
            return new Iterator(this){
                private Iterator m_iter;
                private Object m_oKeyPrev;
                private final /* synthetic */ KeySet this$1;
                {
                    this.this$1 = this$1;
                    this.m_iter = KeySet.access$100(this.this$1).getInternalCache().keySet().iterator();
                }

                public boolean hasNext() {
                    return this.m_iter.hasNext();
                }

                public Object next() {
                    E oKey = this.m_iter.next();
                    this.m_oKeyPrev = oKey;
                    return oKey;
                }

                public void remove() {
                    if (this.m_oKeyPrev == null) {
                        throw new IllegalStateException();
                    }
                    KeySet.access$100(this.this$1).remove(this.m_oKeyPrev);
                    this.m_oKeyPrev = null;
                }
            };
        }

        public int size() {
            return ReadWriteBackingMap.this.size();
        }

        public boolean contains(Object oKey) {
            return ReadWriteBackingMap.this.containsKey(oKey);
        }

        public boolean remove(Object o) {
            ReadWriteBackingMap map = ReadWriteBackingMap.this;
            if (map.containsKey(o)) {
                map.remove(o);
                return true;
            }
            return false;
        }

        public void clear() {
            ReadWriteBackingMap.this.clear();
        }

        public Object[] toArray() {
            return ReadWriteBackingMap.this.getInternalCache().keySet().toArray();
        }

        public Object[] toArray(Object[] ao) {
            return ReadWriteBackingMap.this.getInternalCache().keySet().toArray(ao);
        }

        static /* synthetic */ ReadWriteBackingMap access$100(KeySet x0) {
            return x0.ReadWriteBackingMap.this;
        }
    }

    protected class EntrySet
    extends AbstractSet {
        protected EntrySet() {
        }

        public Iterator iterator() {
            if (ReadWriteBackingMap.this.isEmpty()) {
                return NullImplementation.getIterator();
            }
            return new SimpleEnumerator(this, ReadWriteBackingMap.this.getInternalCache().keySet().toArray()){
                private Map.Entry m_entryPrev;
                private final /* synthetic */ EntrySet this$1;
                {
                    this.this$1 = this$1;
                    super(x0);
                }

                public Object next() {
                    this.m_entryPrev = this.this$1.instantiateEntry(super.next());
                    return this.m_entryPrev;
                }

                public void remove() {
                    if (this.m_entryPrev == null) {
                        throw new IllegalStateException();
                    }
                    EntrySet.access$000(this.this$1).remove(this.m_entryPrev.getKey());
                    this.m_entryPrev = null;
                }
            };
        }

        public int size() {
            return ReadWriteBackingMap.this.size();
        }

        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                ReadWriteBackingMap map = ReadWriteBackingMap.this;
                Map.Entry entry = (Map.Entry)o;
                Object oKey = entry.getKey();
                return map.containsKey(oKey) && Base.equals(entry.getValue(), map.get(oKey)) && map.containsKey(oKey);
            }
            return false;
        }

        public boolean remove(Object o) {
            Object oValue = ReadWriteBackingMap.this.remove(((Map.Entry)o).getKey());
            return oValue != null;
        }

        public void clear() {
            ReadWriteBackingMap.this.clear();
        }

        public Object[] toArray() {
            return this.toArray((Object[])null);
        }

        public Object[] toArray(Object[] ao) {
            Object[] aoKey = ReadWriteBackingMap.this.getInternalCache().keySet().toArray();
            int cKeys = aoKey.length;
            if (ao == null) {
                ao = new Object[cKeys];
            } else if (ao.length < cKeys) {
                ao = (Object[])Array.newInstance(ao.getClass().getComponentType(), cKeys);
            } else if (ao.length > cKeys) {
                ao[cKeys] = null;
            }
            for (int i = 0; i < cKeys; ++i) {
                ao[i] = this.instantiateEntry(aoKey[i]);
            }
            return ao;
        }

        protected Map.Entry instantiateEntry(Object oKey) {
            return new SimpleMapEntry(this, oKey){
                private final /* synthetic */ EntrySet this$1;
                {
                    this.this$1 = this$1;
                    super(x0);
                }

                public Object getValue() {
                    return EntrySet.access$000(this.this$1).get(this.getKey());
                }

                public Object setValue(Object oValue) {
                    return EntrySet.access$000(this.this$1).put(this.getKey(), oValue);
                }
            };
        }

        static /* synthetic */ ReadWriteBackingMap access$000(EntrySet x0) {
            return x0.ReadWriteBackingMap.this;
        }
    }
}

