/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.io.BinaryStore;
import com.tangosol.net.cache.AbstractSerializationCache;
import com.tangosol.net.cache.CacheMap;
import com.tangosol.util.Base;
import com.tangosol.util.LiteSet;
import com.tangosol.util.LongArray;
import com.tangosol.util.SparseArray;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SerializationCache
extends AbstractSerializationCache
implements CacheMap {
    private int m_cMax;
    private int m_cDefaultTTLMillis;
    private long m_cTouches;
    private LongArray m_arrayLRU;
    private LongArray m_arrayExpiry;

    public SerializationCache(BinaryStore store, int cMax) {
        this(store, cMax, null);
    }

    public SerializationCache(BinaryStore store, int cMax, ClassLoader loader) {
        super(store, loader);
        this.setMaximumSize(cMax);
    }

    public SerializationCache(BinaryStore store, int cMax, boolean fBinaryMap) {
        super(store, fBinaryMap);
        this.setMaximumSize(cMax);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        try {
            super.clear();
        }
        finally {
            this.getLruArray().clear();
            this.getExpiryArray().clear();
        }
    }

    public boolean containsKey(Object oKey) {
        this.checkExpiry();
        boolean fContains = super.containsKey(oKey);
        if (fContains) {
            this.touch(oKey);
        }
        return fContains;
    }

    public boolean containsValue(Object oValue) {
        this.checkExpiry();
        return super.containsValue(oValue);
    }

    public Object get(Object oKey) {
        this.checkExpiry();
        this.touch(oKey);
        return super.get(oKey);
    }

    public boolean isEmpty() {
        this.checkExpiry();
        return super.isEmpty();
    }

    public Object put(Object oKey, Object oValue) {
        this.checkExpiry();
        Object oOrig = super.put(oKey, oValue);
        this.checkSize();
        return oOrig;
    }

    public void putAll(Map map) {
        this.checkExpiry();
        super.putAll(map);
        this.checkSize();
    }

    public Object remove(Object oKey) {
        this.checkExpiry();
        return super.remove(oKey);
    }

    public int size() {
        this.checkExpiry();
        return super.size();
    }

    protected boolean removeBlind(Object oKey) {
        this.checkExpiry();
        return super.removeBlind(oKey);
    }

    public Object put(Object oKey, Object oValue, long cMillis) {
        if (cMillis > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("TTL value (" + cMillis + ") is out of range (0.." + Integer.MAX_VALUE + ")");
        }
        Object oOrig = this.put(oKey, oValue);
        if (cMillis != 0L && cMillis != (long)this.getExpiryDelay()) {
            this.registerKey(oKey, (int)cMillis);
        }
        return oOrig;
    }

    public void flush() {
        this.checkExpiry();
    }

    public void evict() {
        this.checkExpiry();
    }

    public void evict(Object oKey) {
        if (this.getKeyMap().containsKey(oKey)) {
            if (this.hasListeners()) {
                this.dispatchPendingEvent(oKey, 3, null, true);
            }
            this.getBinaryStore().erase(this.toBinary(oKey));
            this.unregisterKey(oKey);
        }
    }

    public String toString() {
        return "SerializationCache {" + this.getDescription() + "}";
    }

    protected synchronized void setBinaryStore(BinaryStore store) {
        BinaryStore storeOrig = this.getBinaryStore();
        if (store != storeOrig) {
            this.getLruArray().clear();
            this.getExpiryArray().clear();
            super.setBinaryStore(store);
        }
    }

    public int getMaximumSize() {
        return this.m_cMax;
    }

    public synchronized void setMaximumSize(int cMax) {
        if (cMax != this.m_cMax) {
            if (cMax < 0) {
                cMax = 0;
            }
            this.m_cMax = cMax;
            this.checkSize();
        }
    }

    public int getExpiryDelay() {
        return this.m_cDefaultTTLMillis;
    }

    public synchronized void setExpiryDelay(int cMillis) {
        if (cMillis != this.m_cDefaultTTLMillis) {
            if (cMillis < 0) {
                cMillis = 0;
            }
            this.m_cDefaultTTLMillis = cMillis;
        }
    }

    protected long getTouchCounter() {
        long c;
        this.m_cTouches = c = this.m_cTouches + 1L;
        return c;
    }

    protected LongArray getLruArray() {
        LongArray array = this.m_arrayLRU;
        if (array == null) {
            this.m_arrayLRU = array = new SparseArray();
        }
        return array;
    }

    protected LongArray getExpiryArray() {
        LongArray array = this.m_arrayExpiry;
        if (array == null) {
            this.m_arrayExpiry = array = new SparseArray();
        }
        return array;
    }

    protected String getDescription() {
        return super.getDescription() + ", MaximumSize=" + this.getMaximumSize() + ", ExpiryDelay=" + this.getExpiryDelay();
    }

    protected void registerKey(Object oKey) {
        this.registerKey(oKey, this.getExpiryDelay());
    }

    protected synchronized void registerKey(Object oKey, int cMillis) {
        LongArray arrayLRU = this.getLruArray();
        LongArray arrayExpiry = this.getExpiryArray();
        Map mapKeys = this.getKeyMap();
        EntryAttributes attr = (EntryAttributes)mapKeys.get(oKey);
        if (attr != null) {
            Set setKeys;
            arrayLRU.remove(attr.getTouchCount());
            long ldtExpires = attr.getExpiryTime();
            if (ldtExpires != 0L && (setKeys = (Set)arrayExpiry.get(ldtExpires)) != null) {
                setKeys.remove(oKey);
                if (setKeys.isEmpty()) {
                    arrayExpiry.remove(ldtExpires);
                }
            }
        }
        long nTouch = this.getTouchCounter();
        arrayLRU.set(nTouch, oKey);
        long ldtExpires = 0L;
        if (cMillis > 0) {
            ldtExpires = SerializationCache.getSafeTimeMillis() + (long)cMillis & 0xFFFFFFFFFFFFFF00L;
            Set setKeys = (Set)arrayExpiry.get(ldtExpires);
            if (setKeys == null) {
                setKeys = new LiteSet();
                arrayExpiry.set(ldtExpires, setKeys);
            }
            setKeys.add(oKey);
        }
        attr = this.instantiateEntryAttributes(attr, ldtExpires, nTouch);
        mapKeys.put(oKey, attr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void touch(Object oKey) {
        LongArray arrayLRU = this.getLruArray();
        Map mapKeys = this.getKeyMap();
        SerializationCache serializationCache = this;
        synchronized (serializationCache) {
            if (mapKeys.containsKey(oKey)) {
                EntryAttributes attr = (EntryAttributes)mapKeys.get(oKey);
                if (attr != null) {
                    arrayLRU.remove(attr.getTouchCount());
                }
                long nTouch = this.getTouchCounter();
                arrayLRU.set(nTouch, oKey);
                attr = this.instantiateEntryAttributes(attr, attr.getExpiryTime(), nTouch);
                mapKeys.put(oKey, attr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterKey(Object oKey) {
        LongArray arrayLRU = this.getLruArray();
        LongArray arrayExpiry = this.getExpiryArray();
        Map mapKeys = this.getKeyMap();
        SerializationCache serializationCache = this;
        synchronized (serializationCache) {
            EntryAttributes attr = (EntryAttributes)mapKeys.remove(oKey);
            if (attr != null) {
                Set setKeys;
                arrayLRU.remove(attr.getTouchCount());
                long ldtPrevExpires = attr.getExpiryTime();
                if (ldtPrevExpires != 0L && (setKeys = (Set)arrayExpiry.get(ldtPrevExpires)) != null) {
                    setKeys.remove(oKey);
                    if (setKeys.isEmpty()) {
                        arrayExpiry.remove(ldtPrevExpires);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSize() {
        Map mapKeys;
        int cMax = this.getMaximumSize();
        if (cMax > 0 && (mapKeys = this.getKeyMap()).size() > cMax) {
            SerializationCache serializationCache = this;
            synchronized (serializationCache) {
                LongArray arrayLRU = this.getLruArray();
                do {
                    Object oKey;
                    if ((oKey = arrayLRU.get(arrayLRU.getFirstIndex())) == null) continue;
                    this.evict(oKey);
                } while (this.size() > this.getMaximumSize());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkExpiry() {
        LongArray arrayExpiry = this.getExpiryArray();
        if (arrayExpiry.isEmpty()) {
            return;
        }
        long ldtCurrent = SerializationCache.getSafeTimeMillis();
        if (ldtCurrent > arrayExpiry.getFirstIndex()) {
            SerializationCache serializationCache = this;
            synchronized (serializationCache) {
                Set setKeys;
                LongArray.Iterator iterKeySets = arrayExpiry.iterator();
                while (iterKeySets.hasNext() && (setKeys = (Set)iterKeySets.next()) != null && ldtCurrent > iterKeySets.getIndex()) {
                    iterKeySets.remove();
                    Iterator iterKeys = setKeys.iterator();
                    while (iterKeys.hasNext()) {
                        Object oKey = iterKeys.next();
                        this.evict(oKey);
                    }
                }
            }
        }
    }

    public EntryAttributes instantiateEntryAttributes(EntryAttributes attrOrig, long ldtExpires, long nTouch) {
        return new EntryAttributes(ldtExpires, nTouch);
    }

    protected class EntryAttributes
    extends Base {
        private long m_ldtExpires;
        private long m_nTouch;

        public EntryAttributes(long ldtExpires, long nTouch) {
            this.m_ldtExpires = ldtExpires;
            this.m_nTouch = nTouch;
        }

        public long getExpiryTime() {
            return this.m_ldtExpires;
        }

        public long getTouchCount() {
            return this.m_nTouch;
        }
    }
}

