/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.io.BinaryStore;
import com.tangosol.net.cache.CacheStatistics;
import com.tangosol.net.cache.SimpleCacheStatistics;
import com.tangosol.util.AbstractKeySetBasedMap;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.SafeHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SerializationMap
extends AbstractKeySetBasedMap {
    private BinaryStore m_store;
    private ClassLoader m_loader;
    private boolean m_fBinaryMap;
    private Map m_mapKeys = new SafeHashMap();
    private SimpleCacheStatistics m_stats = new SimpleCacheStatistics();

    public SerializationMap(BinaryStore store) {
        this.setBinaryStore(store);
    }

    public SerializationMap(BinaryStore store, ClassLoader loader) {
        this.setClassLoader(loader);
        this.setBinaryStore(store);
    }

    public SerializationMap(BinaryStore store, boolean fBinaryMap) {
        this.setBinaryMap(fBinaryMap);
        this.setBinaryStore(store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        try {
            this.eraseStore();
        }
        finally {
            this.getKeyMap().clear();
        }
    }

    public boolean containsValue(Object oValue) {
        BinaryStore store = this.getBinaryStore();
        Binary binValue = this.toBinary(oValue);
        Iterator iter = this.keySet().iterator();
        while (iter.hasNext()) {
            if (!SerializationMap.equals(binValue, store.load(this.toBinary(iter.next())))) continue;
            return true;
        }
        return false;
    }

    public Object get(Object oKey) {
        Binary binValue;
        Object oValue = null;
        long ldtStart = SerializationMap.getSafeTimeMillis();
        boolean fContains = false;
        if (this.getKeyMap().containsKey(oKey) && (binValue = this.getBinaryStore().load(this.toBinary(oKey))) != null) {
            oValue = this.fromBinary(binValue);
            fContains = true;
        }
        if (fContains) {
            this.m_stats.registerHit(ldtStart);
        } else {
            this.m_stats.registerMiss(ldtStart);
        }
        return oValue;
    }

    public Object put(Object oKey, Object oValue) {
        Object oOrig = null;
        long ldtStart = SerializationMap.getSafeTimeMillis();
        Binary binKey = this.toBinary(oKey);
        Binary binValue = this.toBinary(oValue);
        BinaryStore store = this.getBinaryStore();
        Binary binOrig = null;
        boolean fContains = this.getKeyMap().containsKey(oKey);
        if (fContains) {
            binOrig = store.load(binKey);
        }
        if (SerializationMap.equals(binValue, binOrig)) {
            oOrig = oValue;
        } else {
            store.store(binKey, binValue);
            this.registerKey(oKey);
            if (binOrig != null) {
                oOrig = this.fromBinary(binOrig);
            }
        }
        this.m_stats.registerPut(ldtStart);
        return oOrig;
    }

    public void putAll(Map map) {
        long ldtStart = SerializationMap.getSafeTimeMillis();
        BinaryStore store = this.getBinaryStore();
        int cPuts = 0;
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object oKey = entry.getKey();
            store.store(this.toBinary(oKey), this.toBinary(entry.getValue()));
            if (!this.getKeyMap().containsKey(oKey)) {
                this.registerKey(oKey);
            }
            ++cPuts;
        }
        this.m_stats.registerPuts(cPuts, ldtStart);
    }

    public Object remove(Object oKey) {
        Object oOrig = null;
        if (this.getKeyMap().containsKey(oKey)) {
            Binary binKey;
            BinaryStore store = this.getBinaryStore();
            Binary binOrig = store.load(binKey = this.toBinary(oKey));
            if (binOrig != null) {
                store.erase(binKey);
                oOrig = this.fromBinary(binOrig);
            }
            this.unregisterKey(oKey);
        }
        return oOrig;
    }

    protected Set getInternalKeySet() {
        return this.getKeyMap().keySet();
    }

    protected boolean removeBlind(Object oKey) {
        boolean fRemoved = false;
        if (this.getKeyMap().containsKey(oKey)) {
            this.getBinaryStore().erase(this.toBinary(oKey));
            this.unregisterKey(oKey);
            fRemoved = true;
        }
        return fRemoved;
    }

    public String toString() {
        return "SerializationMap {" + this.getDescription() + "}";
    }

    public BinaryStore getBinaryStore() {
        return this.m_store;
    }

    protected void setBinaryStore(BinaryStore store) {
        BinaryStore storeOrig = this.m_store;
        if (store != storeOrig) {
            this.m_store = store;
            this.getKeyMap().clear();
            if (store != null) {
                Iterator iter;
                try {
                    iter = store.keys();
                }
                catch (UnsupportedOperationException e) {
                    iter = NullImplementation.getIterator();
                }
                while (iter.hasNext()) {
                    this.registerKey(this.fromBinary((Binary)iter.next()));
                }
            }
        }
    }

    public ClassLoader getClassLoader() {
        return this.m_loader;
    }

    protected void setClassLoader(ClassLoader loader) {
        this.m_loader = loader;
    }

    public boolean isBinaryMap() {
        return this.m_fBinaryMap;
    }

    protected void setBinaryMap(boolean fBinary) {
        this.m_fBinaryMap = fBinary;
    }

    protected Map getKeyMap() {
        return this.m_mapKeys;
    }

    public CacheStatistics getCacheStatistics() {
        return this.m_stats;
    }

    protected String getDescription() {
        return "BinaryStore=" + this.getBinaryStore() + ", size=" + this.size() + ", CacheStatistics=" + this.getCacheStatistics();
    }

    protected synchronized void registerKey(Object oKey) {
        this.getKeyMap().put(oKey, null);
    }

    protected synchronized void unregisterKey(Object oKey) {
        this.getKeyMap().remove(oKey);
    }

    protected Binary toBinary(Object o) {
        return this.isBinaryMap() ? (Binary)o : ExternalizableHelper.toBinary(o);
    }

    protected Object fromBinary(Binary bin) {
        return this.isBinaryMap() ? bin : ExternalizableHelper.fromBinary(bin, this.getClassLoader());
    }

    protected void eraseStore() {
        BinaryStore store = this.getBinaryStore();
        try {
            store.eraseAll();
            return;
        }
        catch (UnsupportedOperationException e) {
            try {
                Iterator iter = store.keys();
                while (iter.hasNext()) {
                    store.erase((Binary)iter.next());
                }
                return;
            }
            catch (UnsupportedOperationException e2) {
                Iterator iter = this.getKeyMap().keySet().iterator();
                while (iter.hasNext()) {
                    store.erase(this.toBinary(iter.next()));
                }
                return;
            }
        }
    }
}

