/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.net.cache.CacheStatistics;
import com.tangosol.util.Base;
import java.io.Serializable;

public class SimpleCacheStatistics
extends Base
implements CacheStatistics,
Serializable {
    protected volatile long m_cCacheHits;
    protected volatile long m_cCacheMisses;
    protected volatile long m_cHitsMillis;
    protected volatile long m_cMissesMillis;
    protected volatile long m_cCachePuts;
    protected volatile long m_cPutsMillis;

    public long getTotalGets() {
        return this.m_cCacheHits + this.m_cCacheMisses;
    }

    public long getTotalGetsMillis() {
        return this.m_cHitsMillis + this.m_cMissesMillis;
    }

    public double getAverageGetMillis() {
        double cMillis = this.m_cHitsMillis + this.m_cMissesMillis;
        double cGets = this.m_cCacheHits + this.m_cCacheMisses;
        return cGets == 0.0 ? 0.0 : cMillis / cGets;
    }

    public long getTotalPuts() {
        return this.m_cCachePuts;
    }

    public long getTotalPutsMillis() {
        return this.m_cPutsMillis;
    }

    public double getAveragePutMillis() {
        double cMillis = this.m_cPutsMillis;
        double cPuts = this.m_cCachePuts;
        return cPuts == 0.0 ? 0.0 : cMillis / cPuts;
    }

    public long getCacheHits() {
        return this.m_cCacheHits;
    }

    public long getCacheHitsMillis() {
        return this.m_cHitsMillis;
    }

    public double getAverageHitMillis() {
        double cMillis = this.m_cHitsMillis;
        double cGets = this.m_cCacheHits;
        return cGets == 0.0 ? 0.0 : cMillis / cGets;
    }

    public long getCacheMisses() {
        return this.m_cCacheMisses;
    }

    public long getCacheMissesMillis() {
        return this.m_cMissesMillis;
    }

    public double getAverageMissMillis() {
        double cMillis = this.m_cMissesMillis;
        double cGets = this.m_cCacheMisses;
        return cGets == 0.0 ? 0.0 : cMillis / cGets;
    }

    public double getHitProbability() {
        double cHits = this.m_cCacheHits;
        double cTotal = cHits + (double)this.m_cCacheMisses;
        return cTotal == 0.0 ? 0.0 : cHits / cTotal;
    }

    public void resetHitStatistics() {
        this.m_cCacheHits = 0L;
        this.m_cCacheMisses = 0L;
        this.m_cHitsMillis = 0L;
        this.m_cMissesMillis = 0L;
        this.m_cPutsMillis = 0L;
        this.m_cCachePuts = 0L;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CacheStatistics {TotalGets=").append(this.getTotalGets()).append(", TotalGetsMillis=").append(this.getTotalGetsMillis()).append(", AverageGetMillis=").append(this.getAverageGetMillis()).append(", TotalPuts=").append(this.getTotalPuts()).append(", TotalPutsMillis=").append(this.getTotalPutsMillis()).append(", AveragePutMillis=").append(this.getAveragePutMillis()).append(", CacheHits=").append(this.getCacheHits()).append(", CacheHitsMillis=").append(this.getCacheHitsMillis()).append(", AverageHitMillis=").append(this.getAverageHitMillis()).append(", CacheMisses=").append(this.getCacheMisses()).append(", CacheMissesMillis=").append(this.getCacheMissesMillis()).append(", AverageMissMillis=").append(this.getAverageMissMillis()).append(", HitProbability=").append(this.getHitProbability()).append('}');
        return sb.toString();
    }

    public void registerHit() {
        ++this.m_cCacheHits;
    }

    public void registerHit(long lStartMillis) {
        ++this.m_cCacheHits;
        long lStopMillis = SimpleCacheStatistics.getSafeTimeMillis();
        if (lStopMillis > lStartMillis) {
            this.m_cHitsMillis += lStopMillis - lStartMillis;
        }
    }

    public void registerHits(int cHits, long lStartMillis) {
        long lStopMillis;
        this.m_cCacheHits += (long)cHits;
        if (lStartMillis > 0L && (lStopMillis = SimpleCacheStatistics.getSafeTimeMillis()) > lStartMillis) {
            this.m_cHitsMillis += lStopMillis - lStartMillis;
        }
    }

    public void registerMiss() {
        ++this.m_cCacheMisses;
    }

    public void registerMiss(long lStartMillis) {
        ++this.m_cCacheMisses;
        long lStopMillis = SimpleCacheStatistics.getSafeTimeMillis();
        if (lStopMillis > lStartMillis) {
            this.m_cMissesMillis += lStopMillis - lStartMillis;
        }
    }

    public void registerMisses(int cMisses, long lStartMillis) {
        long lStopMillis;
        this.m_cCacheMisses += (long)cMisses;
        if (lStartMillis > 0L && (lStopMillis = SimpleCacheStatistics.getSafeTimeMillis()) > lStartMillis) {
            this.m_cMissesMillis += lStopMillis - lStartMillis;
        }
    }

    public void registerPut(long lStartMillis) {
        long lStopMillis;
        ++this.m_cCachePuts;
        if (lStartMillis > 0L && (lStopMillis = SimpleCacheStatistics.getSafeTimeMillis()) > lStartMillis) {
            this.m_cPutsMillis += lStopMillis - lStartMillis;
        }
    }

    public void registerPuts(int cPuts, long lStartMillis) {
        long lStopMillis;
        this.m_cCachePuts += (long)cPuts;
        if (lStartMillis > 0L && (lStopMillis = SimpleCacheStatistics.getSafeTimeMillis()) > lStartMillis) {
            this.m_cPutsMillis += lStopMillis - lStartMillis;
        }
    }
}

