/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.net.cache.LocalCache;
import com.tangosol.net.cache.OldCache;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SimpleMemoryCalculator
extends Base
implements OldCache.UnitCalculator {
    public static final int SIZE_OBJECT_REF;
    public static final int SIZE_OBJECT;
    public static final int SIZE_BOOLEAN;
    public static final int SIZE_BYTE;
    public static final int SIZE_SHORT;
    public static final int SIZE_CHARACTER;
    public static final int SIZE_INTEGER;
    public static final int SIZE_FLOAT;
    public static final int SIZE_LONG;
    public static final int SIZE_DOUBLE;
    public static final int SIZE_STRING;
    public static final int SIZE_BINARY;
    public static final int SIZE_ENTRY;
    public static final Map MAP_FIXED_SIZES;

    public int calculateUnits(Object oKey, Object oValue) {
        return this.padMemorySize(SIZE_ENTRY + this.sizeOf(oKey) + this.sizeOf(oValue));
    }

    protected int sizeOf(Object o) {
        Base.azzert(o != null);
        Class<?> clz = o.getClass();
        Integer IBytes = (Integer)MAP_FIXED_SIZES.get(clz);
        if (IBytes == null) {
            if (clz.equals(String.class)) {
                return SIZE_STRING + 2 * ((String)o).length();
            }
            if (clz.equals(Binary.class)) {
                return SIZE_BINARY + ((Binary)o).length();
            }
            if (clz.isArray()) {
                int cBytes = 16;
                int cElements = Array.getLength(o);
                Class<?> clzElement = clz.getComponentType();
                IBytes = (Integer)MAP_FIXED_SIZES.get(clzElement);
                if (IBytes == null) {
                    try {
                        for (int i = 0; i < cElements; ++i) {
                            cBytes += this.sizeOf(Array.get(o, i));
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException e) {}
                } else {
                    cBytes += cElements * IBytes;
                }
                return cBytes;
            }
            throw new IllegalArgumentException("Unsupported type: " + clz.getName());
        }
        return IBytes;
    }

    protected int sizeOf(Class clz) {
        Base.azzert(clz != null);
        Integer IBytes = (Integer)MAP_FIXED_SIZES.get(clz);
        if (IBytes == null) {
            throw new IllegalArgumentException("Unsupported type: " + clz.getName());
        }
        return IBytes;
    }

    protected int padMemorySize(int cb) {
        return (int)SimpleMemoryCalculator.pad(cb, 8L);
    }

    protected static int calculateShallowSize(Class clz) {
        Base.azzert(clz != null);
        Integer IBytes = (Integer)MAP_FIXED_SIZES.get(clz);
        if (IBytes == null) {
            int nBytes = SIZE_OBJECT;
            try {
                do {
                    Field[] aField;
                    int cField = (aField = clz.getDeclaredFields()) == null ? 0 : aField.length;
                    for (int i = 0; i < cField; ++i) {
                        Field field = aField[i];
                        if (Modifier.isStatic(field.getModifiers()) || (IBytes = (Integer)MAP_FIXED_SIZES.get(field.getType())) == null) continue;
                        nBytes += IBytes.intValue();
                    }
                } while ((clz = clz.getSuperclass()) != null);
            }
            catch (SecurityException e) {
                throw SimpleMemoryCalculator.ensureRuntimeException(e, "Error calculating the shallow size of: " + clz);
            }
            return nBytes;
        }
        return IBytes;
    }

    public static void main(String[] asArg) {
        if (asArg.length > 0) {
            String sClass = asArg[0];
            try {
                SimpleMemoryCalculator.log(sClass + "=" + SimpleMemoryCalculator.calculateShallowSize(Class.forName(sClass)));
            }
            catch (Exception e) {
                SimpleMemoryCalculator.log("Could not load class: " + sClass);
            }
        } else {
            SimpleMemoryCalculator.log("SIZE_OBJECT_REF=" + SIZE_OBJECT_REF);
            SimpleMemoryCalculator.log("SIZE_OBJECT    =" + SIZE_OBJECT);
            SimpleMemoryCalculator.log("SIZE_STRING    =" + SIZE_STRING);
            SimpleMemoryCalculator.log("SIZE_BINARY    =" + SIZE_BINARY);
            SimpleMemoryCalculator.log("SIZE_ENTRY     =" + SIZE_ENTRY);
        }
    }

    static {
        String sValue = System.getProperty("sun.arch.data.model");
        int nBits = 32;
        try {
            nBits = Integer.parseInt(sValue);
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        SIZE_OBJECT_REF = nBits / 8;
        SIZE_OBJECT = SIZE_OBJECT_REF + 4;
        SIZE_BOOLEAN = SIZE_OBJECT + 1;
        SIZE_BYTE = SIZE_OBJECT + 1;
        SIZE_SHORT = SIZE_OBJECT + 2;
        SIZE_CHARACTER = SIZE_OBJECT + 2;
        SIZE_INTEGER = SIZE_OBJECT + 4;
        SIZE_FLOAT = SIZE_OBJECT + 4;
        SIZE_LONG = SIZE_OBJECT + 8;
        SIZE_DOUBLE = SIZE_OBJECT + 8;
        HashMap<Class, Integer> map = new HashMap<Class, Integer>();
        map.put(Boolean.TYPE, SimpleMemoryCalculator.makeInteger(1));
        map.put(Byte.TYPE, SimpleMemoryCalculator.makeInteger(1));
        map.put(Short.TYPE, SimpleMemoryCalculator.makeInteger(2));
        map.put(Character.TYPE, SimpleMemoryCalculator.makeInteger(2));
        map.put(Integer.TYPE, SimpleMemoryCalculator.makeInteger(4));
        map.put(Float.TYPE, SimpleMemoryCalculator.makeInteger(4));
        map.put(Long.TYPE, SimpleMemoryCalculator.makeInteger(8));
        map.put(Double.TYPE, SimpleMemoryCalculator.makeInteger(8));
        map.put(Object.class, SimpleMemoryCalculator.makeInteger(SIZE_OBJECT));
        map.put(Boolean.class, SimpleMemoryCalculator.makeInteger(SIZE_BOOLEAN));
        map.put(Byte.class, SimpleMemoryCalculator.makeInteger(SIZE_BYTE));
        map.put(Short.class, SimpleMemoryCalculator.makeInteger(SIZE_SHORT));
        map.put(Character.class, SimpleMemoryCalculator.makeInteger(SIZE_CHARACTER));
        map.put(Integer.class, SimpleMemoryCalculator.makeInteger(SIZE_INTEGER));
        map.put(Float.class, SimpleMemoryCalculator.makeInteger(SIZE_FLOAT));
        map.put(Long.class, SimpleMemoryCalculator.makeInteger(SIZE_LONG));
        map.put(Double.class, SimpleMemoryCalculator.makeInteger(SIZE_DOUBLE));
        MAP_FIXED_SIZES = Collections.unmodifiableMap(map);
        SIZE_STRING = SimpleMemoryCalculator.calculateShallowSize(String.class) + 16;
        SIZE_BINARY = SimpleMemoryCalculator.calculateShallowSize(Binary.class) + 16;
        SIZE_ENTRY = SimpleMemoryCalculator.calculateShallowSize(LocalCache.Entry.class);
    }
}

