/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.io.BinaryStore;
import com.tangosol.net.cache.CacheStatistics;
import com.tangosol.net.cache.SimpleCacheStatistics;
import com.tangosol.util.AbstractKeyBasedMap;
import com.tangosol.util.AbstractStableIterator;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import java.util.Iterator;
import java.util.Map;

public class SimpleSerializationMap
extends AbstractKeyBasedMap {
    private BinaryStore m_store;
    private ClassLoader m_loader;
    private boolean m_fBinaryMap;
    private SimpleCacheStatistics m_stats = new SimpleCacheStatistics();

    public SimpleSerializationMap(BinaryStore store) {
        this.setBinaryStore(store);
    }

    public SimpleSerializationMap(BinaryStore store, ClassLoader loader) {
        this.setClassLoader(loader);
        this.setBinaryStore(store);
    }

    public SimpleSerializationMap(BinaryStore store, boolean fBinaryMap) {
        this.setBinaryMap(fBinaryMap);
        this.setBinaryStore(store);
    }

    public void clear() {
        BinaryStore store = this.getBinaryStore();
        try {
            store.eraseAll();
        }
        catch (UnsupportedOperationException e) {
            Iterator iter = store.keys();
            while (iter.hasNext()) {
                store.erase((Binary)iter.next());
            }
        }
    }

    public boolean containsKey(Object oKey) {
        return this.getBinaryStore().load(this.toBinary(oKey)) != null;
    }

    public boolean containsValue(Object oValue) {
        BinaryStore store = this.getBinaryStore();
        Binary binValue = this.toBinary(oValue);
        Iterator iter = store.keys();
        while (iter.hasNext()) {
            if (!SimpleSerializationMap.equals(binValue, store.load((Binary)iter.next()))) continue;
            return true;
        }
        return false;
    }

    public Object get(Object oKey) {
        Object oValue = null;
        long ldtStart = SimpleSerializationMap.getSafeTimeMillis();
        Binary binValue = this.getBinaryStore().load(this.toBinary(oKey));
        if (binValue == null) {
            this.m_stats.registerMiss(ldtStart);
        } else {
            oValue = this.fromBinary(binValue);
            this.m_stats.registerHit(ldtStart);
        }
        return oValue;
    }

    public boolean isEmpty() {
        return !this.getBinaryStore().keys().hasNext();
    }

    public Object put(Object oKey, Object oValue) {
        Object oOrig = null;
        long ldtStart = SimpleSerializationMap.getSafeTimeMillis();
        BinaryStore store = this.getBinaryStore();
        Binary binKey = this.toBinary(oKey);
        Binary binOrig = store.load(binKey);
        Binary binValue = this.toBinary(oValue);
        if (SimpleSerializationMap.equals(binValue, binOrig)) {
            oOrig = oValue;
        } else {
            store.store(binKey, binValue);
            if (binOrig != null) {
                oOrig = this.fromBinary(binOrig);
            }
        }
        this.m_stats.registerPut(ldtStart);
        return oOrig;
    }

    public void putAll(Map map) {
        long ldtStart = SimpleSerializationMap.getSafeTimeMillis();
        BinaryStore store = this.getBinaryStore();
        int cPuts = 0;
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            store.store(this.toBinary(entry.getKey()), this.toBinary(entry.getValue()));
            ++cPuts;
        }
        this.m_stats.registerPuts(cPuts, ldtStart);
    }

    public Object remove(Object oKey) {
        Binary binKey;
        Object oOrig = null;
        BinaryStore store = this.getBinaryStore();
        Binary binOrig = store.load(binKey = this.toBinary(oKey));
        if (binOrig != null) {
            store.erase(binKey);
            oOrig = this.fromBinary(binOrig);
        }
        return oOrig;
    }

    public int size() {
        int c = 0;
        Iterator iter = this.getBinaryStore().keys();
        while (iter.hasNext()) {
            iter.next();
            ++c;
        }
        return c;
    }

    protected Iterator iterateKeys() {
        return new AbstractStableIterator(){
            Iterator m_iter;
            Binary m_binPrev;
            {
                this.m_iter = SimpleSerializationMap.this.getBinaryStore().keys();
            }

            protected void advance() {
                Iterator iter = this.m_iter;
                if (iter.hasNext()) {
                    Binary bin;
                    this.m_binPrev = bin = (Binary)this.m_iter.next();
                    this.setNext(SimpleSerializationMap.this.fromBinary(bin));
                }
            }

            protected void remove(Object oPrev) {
                SimpleSerializationMap.this.getBinaryStore().erase(this.m_binPrev);
            }
        };
    }

    protected boolean removeBlind(Object oKey) {
        Binary binKey;
        boolean fRemoved = false;
        BinaryStore store = this.getBinaryStore();
        Binary binOrig = store.load(binKey = this.toBinary(oKey));
        if (binOrig != null) {
            store.erase(binKey);
            fRemoved = true;
        }
        return fRemoved;
    }

    public String toString() {
        return "SimpleSerializationMap {BinaryStore=" + this.getBinaryStore() + ", CacheStatistics=" + this.getCacheStatistics() + '}';
    }

    public BinaryStore getBinaryStore() {
        return this.m_store;
    }

    protected void setBinaryStore(BinaryStore store) {
        this.m_store = store;
    }

    public ClassLoader getClassLoader() {
        return this.m_loader;
    }

    protected void setClassLoader(ClassLoader loader) {
        this.m_loader = loader;
    }

    public boolean isBinaryMap() {
        return this.m_fBinaryMap;
    }

    protected void setBinaryMap(boolean fBinary) {
        this.m_fBinaryMap = fBinary;
    }

    public CacheStatistics getCacheStatistics() {
        return this.m_stats;
    }

    protected Binary toBinary(Object o) {
        return this.isBinaryMap() ? (Binary)o : ExternalizableHelper.toBinary(o);
    }

    protected Object fromBinary(Binary bin) {
        return this.isBinaryMap() ? bin : ExternalizableHelper.fromBinary(bin, this.getClassLoader());
    }
}

