/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.cache;

import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.NearCache;
import com.tangosol.util.AbstractMapListener;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.Versionable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class VersionedNearCache
extends NearCache {
    private NamedCache m_mapVersion;

    public VersionedNearCache(Map mapLocal, NamedCache mapDist, NamedCache mapVersion) {
        super(mapLocal, mapDist, 0);
        VersionedNearCache.azzert(mapVersion != null);
        this.m_mapVersion = mapVersion;
        this.m_mapVersion.addMapListener(this.instantiateVersionCacheListener());
    }

    public void release() {
        super.release();
        this.m_mapVersion = null;
    }

    public Object get(Object oKey) {
        Object oValue = super.get(oKey);
        this.updateVersion(oKey, oValue);
        return oValue;
    }

    public Map getAll(Collection colKeys) {
        Map map = super.getAll(colKeys);
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.updateVersion(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public Object remove(Object oKey) {
        this.getVersionCache().remove(oKey);
        return super.remove(oKey);
    }

    public Object put(Object oKey, Object oValue, boolean fReturn, long cMillis) {
        this.incrementVersion(oKey, oValue);
        return super.put(oKey, oValue, fReturn, cMillis);
    }

    public void putAll(Map map) {
        RuntimeException exception = null;
        if (map.size() > 1) {
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                try {
                    this.incrementVersion(entry.getKey(), entry.getValue());
                }
                catch (RuntimeException e) {
                    exception = e;
                    iter.remove();
                }
            }
        }
        super.putAll(map);
        if (exception != null) {
            throw exception;
        }
    }

    protected void updateVersion(Object oKey, Object oValue) {
        if (oValue != null) {
            NamedCache map = this.getVersionCache();
            Comparable verOld = (Comparable)map.get(oKey);
            Comparable verNew = ((Versionable)oValue).getVersionIndicator();
            if (verOld == null || verNew.compareTo(verOld) > 0) {
                try {
                    map.put(oKey, verNew);
                }
                catch (Exception e) {
                    VersionedNearCache.err(e);
                }
            }
        }
    }

    protected void incrementVersion(Object oKey, Object oValue) {
        if (!(oValue instanceof Versionable)) {
            throw new IllegalArgumentException("Value must implement Versionable interface: " + oValue);
        }
        Versionable oLocalValue = (Versionable)oValue;
        oLocalValue.incrementVersion();
        this.getVersionCache().put(oKey, oLocalValue.getVersionIndicator());
    }

    public boolean lock(Object oKey, long lMillis) {
        NamedCache mapVersion = this.getVersionCache();
        if (mapVersion.lock(oKey, lMillis)) {
            Map mapLocal = this.getFrontMap();
            Versionable oLocalValue = (Versionable)mapLocal.get(oKey);
            if (oLocalValue != null) {
                Comparable verCurrent = (Comparable)mapVersion.get(oKey);
                if (verCurrent == null) {
                    mapLocal.remove(oKey);
                } else {
                    Comparable verLocal = oLocalValue.getVersionIndicator();
                    if (verLocal.compareTo(verCurrent) < 0) {
                        mapLocal.remove(oKey);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean unlock(Object oKey) {
        return this.getVersionCache().unlock(oKey);
    }

    protected MapListener instantiateVersionCacheListener() {
        return new VersionCacheListener();
    }

    public NamedCache getVersionCache() {
        return this.m_mapVersion;
    }

    public class VersionCacheListener
    extends AbstractMapListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void entryUpdated(MapEvent evt) {
            Map mapLocal;
            Object oKey = evt.getKey();
            Map map = mapLocal = VersionedNearCache.this.getFrontMap();
            synchronized (map) {
                Comparable verCurrent;
                Comparable verLocal;
                Versionable oLocalValue = (Versionable)mapLocal.get(oKey);
                if (oLocalValue != null && (verLocal = oLocalValue.getVersionIndicator()).compareTo(verCurrent = (Comparable)evt.getNewValue()) < 0) {
                    mapLocal.remove(oKey);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void entryDeleted(MapEvent evt) {
            Map mapLocal;
            Object oKey = evt.getKey();
            Map map = mapLocal = VersionedNearCache.this.getFrontMap();
            synchronized (map) {
                mapLocal.remove(oKey);
            }
        }
    }
}

