/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.management;

import com.tangosol.net.CacheFactory;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import java.rmi.registry.LocateRegistry;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public abstract class MBeanHelper
extends Base {
    private static final String MANAGEABLE = "com.tangosol.coherence.component.manageable.";
    public static final String NETWORK_HEALTH = "NetworkHealth";

    public static String getDefaultDomain() {
        return CacheFactory.getManagementConfig().getSafeElement("default-domain-name").getString();
    }

    public static MBeanServer findMBeanServer() {
        return MBeanHelper.findMBeanServer(MBeanHelper.getDefaultDomain());
    }

    public static MBeanServer findMBeanServer(String sDefaultDomain) {
        try {
            Iterator<MBeanServer> iter = MBeanServerFactory.findMBeanServer(null).iterator();
            while (iter.hasNext()) {
                MBeanServer server = iter.next();
                if (sDefaultDomain.length() != 0 && !server.getDefaultDomain().equals(sDefaultDomain)) continue;
                return server;
            }
            return MBeanServerFactory.createMBeanServer(sDefaultDomain);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "Failed to locate the server");
        }
    }

    public static double calculateAverage(MBeanServer server, String sPattern, String sAttribute) {
        try {
            double dSum = 0.0;
            int cnt = 0;
            Set<ObjectName> setName = server.queryNames(new ObjectName(sPattern), null);
            Iterator<ObjectName> iter = setName.iterator();
            while (iter.hasNext()) {
                ObjectName name = iter.next();
                dSum += ((Number)server.getAttribute(name, sAttribute)).doubleValue();
                ++cnt;
            }
            return cnt > 1 ? dSum / (double)cnt : dSum;
        }
        catch (Exception e) {
            throw MBeanHelper.ensureRuntimeException(e);
        }
    }

    public static ObjectName ensureNetworkHealthMBean() {
        return MBeanHelper.ensureSingletonMBean(NETWORK_HEALTH);
    }

    public static ObjectName ensureSingletonMBean(String sName) {
        try {
            MBeanServer server = MBeanHelper.findMBeanServer();
            ObjectName name = new ObjectName("Coherence:type=" + sName);
            if (!server.isRegistered(name)) {
                Object oBean = Class.forName(MANAGEABLE + sName + "MBean").newInstance();
                server.registerMBean(oBean, name);
            }
            return name;
        }
        catch (Throwable e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    public static JMXConnectorServer startRmiConnector(String sHost, int nRegPort, int nConPort, MBeanServer mbs, Map mapEnv) {
        try {
            LocateRegistry.createRegistry(nRegPort);
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi://" + sHost + ":" + nConPort + "/jndi/rmi://" + sHost + ":" + nRegPort + "/server");
            JMXConnectorServer connector = JMXConnectorServerFactory.newJMXConnectorServer(url, mapEnv, mbs);
            connector.start();
            return connector;
        }
        catch (Exception e) {
            throw MBeanHelper.ensureRuntimeException(e, "Could not start JMXConnectorServer");
        }
    }

    public static Object startHttpConnector(int nPort, MBeanServer mbs) {
        try {
            String sAdapter = "HttpAdapter:port=" + nPort;
            ObjectName nameAdapter = new ObjectName(sAdapter);
            Object adaptorServer = ClassHelper.newInstance(Class.forName("com.sun.jdmk.comm.HtmlAdaptorServer"), new Object[]{Base.makeInteger(nPort)});
            mbs.registerMBean(adaptorServer, nameAdapter);
            mbs.invoke(nameAdapter, "start", null, null);
            return adaptorServer;
        }
        catch (Exception e) {
            throw MBeanHelper.ensureRuntimeException(e, "Please ensure that JMX RI (jmxtools.jar, jmxri.jar) is in the classpath");
        }
    }
}

