/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.messaging;

import com.tangosol.net.messaging.Connection;
import com.tangosol.net.messaging.ConnectionListener;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.Listeners;
import java.util.EventListener;
import java.util.EventObject;

public class ConnectionEvent
extends EventObject {
    public static final int CONNECTION_INITIATED = 0;
    public static final int CONNECTION_ACCEPTED = 1;
    public static final int CONNECTION_CLOSED = 2;
    public static final int CONNECTION_ERROR = 3;
    private static final String[] DESCRIPTIONS = new String[]{"INITIATED", "ACCEPTED", "CLOSED", "ERROR"};
    private int m_nId;
    private Throwable m_err;

    public ConnectionEvent(Connection connection, int nId) {
        this(connection, nId, null);
    }

    public ConnectionEvent(Connection connection, int nId, Throwable err) {
        super(connection);
        if (nId < 0 || nId > 3) {
            throw new IllegalArgumentException();
        }
        this.m_nId = nId;
        this.m_err = err;
    }

    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + '{' + this.getDescription() + '}';
    }

    public void dispatch(Listeners listeners) {
        if (listeners != null) {
            EventListener[] targets = listeners.listeners();
            int i = targets.length;
            while (--i >= 0) {
                ConnectionListener target = (ConnectionListener)targets[i];
                switch (this.getId()) {
                    case 0: {
                        target.connectionInitiated(this);
                        break;
                    }
                    case 1: {
                        target.connectionAccepted(this);
                        break;
                    }
                    case 2: {
                        target.connectionClosed(this);
                        break;
                    }
                    case 3: {
                        target.connectionError(this);
                    }
                }
            }
        }
    }

    protected String getDescription() {
        StringBuffer sb = new StringBuffer("Connection=").append(this.getConnection()).append(", Id=").append(DESCRIPTIONS[this.getId()]);
        Throwable err = this.getThrowable();
        if (err != null) {
            sb.append(", Throwable=").append(err);
        }
        return sb.toString();
    }

    public Connection getConnection() {
        return (Connection)this.getSource();
    }

    public int getId() {
        return this.m_nId;
    }

    public Throwable getThrowable() {
        return this.m_err;
    }
}

