/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.partition;

import com.tangosol.net.Member;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.partition.PartitionSet;
import java.util.EventObject;

public class PartitionEvent
extends EventObject {
    public static final int PARTITION_LOST = 1;
    protected int m_nId;
    protected PartitionSet m_setPartitions;
    protected Member m_memberFrom;
    protected Member m_memberTo;

    public PartitionEvent(PartitionedService svc, int nId, PartitionSet setPartitions, Member memberFrom, Member memberTo) {
        super(svc);
        this.m_nId = nId;
        this.m_setPartitions = setPartitions;
        this.m_memberFrom = memberFrom;
        this.m_memberTo = memberTo;
    }

    public PartitionedService getService() {
        return (PartitionedService)this.getSource();
    }

    public int getId() {
        return this.m_nId;
    }

    public PartitionSet getPartitionSet() {
        return this.m_setPartitions;
    }

    public Member getFromMember() {
        return this.m_memberFrom;
    }

    public Member getToMember() {
        return this.m_memberTo;
    }

    protected String getDescription() {
        Member memberFrom = this.getFromMember();
        Member memberTo = this.getToMember();
        switch (this.getId()) {
            case 1: {
                StringBuffer sb = new StringBuffer();
                sb.append(this.getPartitionSet());
                if (memberFrom != null) {
                    sb.append(" lost by ").append(memberFrom);
                }
                if (memberTo != null) {
                    sb.append(" ownership reassigned to ").append(memberTo);
                }
                return sb.toString();
            }
        }
        throw new IllegalStateException();
    }

    public static String getDescription(int nId) {
        switch (nId) {
            case 1: {
                return "lost";
            }
        }
        return "<unknown>";
    }

    public String toString() {
        String sEvt = this.getClass().getName();
        return sEvt.substring(sEvt.lastIndexOf(46) + 1) + "{Service=" + this.getService().getInfo().getServiceName() + ", " + this.getDescription() + '}';
    }
}

