/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.partition;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.util.BitHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class PartitionSet
extends BitHelper
implements ExternalizableLite {
    private static final byte[] s_aiTrailingZeroCount = new byte[]{8, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};
    private int m_cPartitions;
    private byte[] m_abParts;
    private transient byte m_bTailMask;

    public PartitionSet() {
    }

    public PartitionSet(int cPartitions) {
        PartitionSet.azzert(cPartitions > 0);
        this.m_cPartitions = cPartitions;
        this.m_abParts = new byte[(cPartitions >>> 3) + 1];
        this.m_bTailMask = PartitionSet.calculateTailMask(cPartitions);
    }

    public PartitionSet(PartitionSet partitions) {
        this.m_cPartitions = partitions.m_cPartitions;
        this.m_abParts = (byte[])partitions.m_abParts.clone();
        this.m_bTailMask = partitions.m_bTailMask;
    }

    public boolean add(int nPartition) {
        PartitionSet.azzert(nPartition >= 0 && nPartition < this.m_cPartitions);
        byte[] abParts = this.m_abParts;
        int ofByte = nPartition >>> 3;
        byte bPart = abParts[ofByte];
        byte bMask = (byte)(1 << (nPartition & 7));
        if ((bPart & bMask) == 0) {
            abParts[ofByte] = (byte)(bPart | bMask);
            return true;
        }
        return false;
    }

    public boolean add(PartitionSet partitions) {
        int cPartitions = this.m_cPartitions;
        PartitionSet.azzert(cPartitions == partitions.m_cPartitions);
        byte[] abPartsThis = this.m_abParts;
        byte[] abPartsThat = partitions.m_abParts;
        boolean fResult = true;
        int c = abPartsThis.length;
        for (int i = 0; i < c; ++i) {
            byte bPartThis = abPartsThis[i];
            byte bPartThat = abPartsThat[i];
            fResult &= (bPartThis & bPartThat) == 0;
            abPartsThis[i] = (byte)(bPartThis | bPartThat);
        }
        return fResult;
    }

    public boolean remove(int nPartition) {
        PartitionSet.azzert(nPartition >= 0 && nPartition < this.m_cPartitions);
        byte[] abParts = this.m_abParts;
        int ofByte = nPartition >>> 3;
        byte bPart = abParts[ofByte];
        byte bMask = (byte)(1 << (nPartition & 7));
        if ((bPart & bMask) != 0) {
            abParts[ofByte] = (byte)(bPart & ~bMask);
            return true;
        }
        return false;
    }

    public boolean remove(PartitionSet partitions) {
        int cPartitions = this.m_cPartitions;
        PartitionSet.azzert(cPartitions == partitions.m_cPartitions);
        byte[] abPartsThis = this.m_abParts;
        byte[] abPartsThat = partitions.m_abParts;
        boolean fResult = true;
        int c = abPartsThis.length;
        for (int i = 0; i < c; ++i) {
            byte bPartThis = abPartsThis[i];
            byte bPartThat = abPartsThat[i];
            fResult &= (bPartThis & bPartThat) == bPartThat;
            abPartsThis[i] = (byte)(bPartThis & ~bPartThat);
        }
        return fResult;
    }

    public boolean retain(PartitionSet partitions) {
        int cPartitions = this.m_cPartitions;
        PartitionSet.azzert(cPartitions == partitions.m_cPartitions);
        byte[] abPartsThis = this.m_abParts;
        byte[] abPartsThat = partitions.m_abParts;
        boolean fResult = false;
        int c = abPartsThis.length;
        for (int i = 0; i < c; ++i) {
            byte bPartThis = abPartsThis[i];
            byte bPartThat = abPartsThat[i];
            byte bIntrsctn = (byte)(bPartThis & bPartThat);
            if (bIntrsctn == bPartThis) continue;
            abPartsThis[i] = bIntrsctn;
            fResult = true;
        }
        return fResult;
    }

    public boolean contains(int nPartition) {
        PartitionSet.azzert(nPartition >= 0 && nPartition < this.m_cPartitions);
        int ofByte = nPartition >>> 3;
        byte bPart = this.m_abParts[ofByte];
        byte bMask = (byte)(1 << (nPartition & 7));
        return (bPart & bMask) != 0;
    }

    public boolean contains(PartitionSet partitions) {
        int cPartitions = this.m_cPartitions;
        PartitionSet.azzert(cPartitions == partitions.m_cPartitions);
        byte[] abPartsThis = this.m_abParts;
        byte[] abPartsThat = partitions.m_abParts;
        int c = abPartsThis.length;
        for (int i = 0; i < c; ++i) {
            byte bPartThis = abPartsThis[i];
            byte bPartThat = abPartsThat[i];
            byte bIntrsctn = (byte)(bPartThis & bPartThat);
            if (bIntrsctn == bPartThat) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        byte[] abParts = this.m_abParts;
        int c = abParts.length;
        for (int i = 0; i < c; ++i) {
            if (abParts[i] == 0) continue;
            return false;
        }
        return true;
    }

    public boolean isFull() {
        byte[] abParts = this.m_abParts;
        int iLast = abParts.length - 1;
        for (int i = 0; i < iLast; ++i) {
            if (abParts[i] == -1) continue;
            return false;
        }
        return abParts[iLast] == this.m_bTailMask;
    }

    public void clear() {
        byte[] abParts = this.m_abParts;
        int c = abParts.length;
        for (int i = 0; i < c; ++i) {
            abParts[i] = 0;
        }
    }

    public void fill() {
        byte[] abParts = this.m_abParts;
        int iLast = abParts.length - 1;
        for (int i = 0; i < iLast; ++i) {
            abParts[i] = -1;
        }
        abParts[iLast] = this.m_bTailMask;
    }

    public int next(int nPartition) {
        int cPartitions = this.m_cPartitions;
        if (nPartition < 0 || nPartition > cPartitions) {
            throw new IndexOutOfBoundsException("invalid partition: " + nPartition);
        }
        if (nPartition == cPartitions) {
            return -1;
        }
        byte[] abParts = this.m_abParts;
        int ofByte = nPartition >>> 3;
        int ofBit = nPartition & 7;
        byte bPart = (byte)(abParts[ofByte] >> ofBit);
        if (bPart == 0) {
            ofBit = 0;
            int iLast = abParts.length - 1;
            while (bPart == 0 && ofByte < iLast) {
                bPart = abParts[++ofByte];
            }
        }
        if (bPart == 0) {
            return -1;
        }
        return ofByte * 8 + (ofBit += s_aiTrailingZeroCount[bPart & 0xFF]);
    }

    public int cardinality() {
        byte[] abParts = this.m_abParts;
        int cnt = 0;
        int c = abParts.length;
        for (int i = 0; i < c; ++i) {
            cnt += PartitionSet.countBits(abParts[i]);
        }
        return cnt;
    }

    public void readExternal(DataInput in) throws IOException {
        int cPartitions = in.readUnsignedShort();
        byte[] abParts = new byte[(cPartitions >>> 3) + 1];
        in.readFully(abParts);
        this.m_cPartitions = cPartitions;
        this.m_abParts = abParts;
        this.m_bTailMask = PartitionSet.calculateTailMask(cPartitions);
    }

    public void writeExternal(DataOutput out) throws IOException {
        byte[] abParts = this.m_abParts;
        out.writeShort(this.m_cPartitions);
        out.write(abParts, 0, abParts.length);
    }

    private static byte calculateTailMask(int cPartitions) {
        int cTailBits = cPartitions % 8;
        byte bTailMask = 0;
        for (int i = 0; i < cTailBits; ++i) {
            bTailMask = (byte)((bTailMask << 1) + 1);
        }
        return bTailMask;
    }

    public boolean equals(Object o) {
        if (o instanceof PartitionSet) {
            if (o == this) {
                return true;
            }
            PartitionSet that = (PartitionSet)o;
            if (this.m_cPartitions == that.m_cPartitions) {
                byte[] abPartsThis = this.m_abParts;
                byte[] abPartsThat = that.m_abParts;
                int c = abPartsThis.length;
                for (int i = 0; i < c; ++i) {
                    if (abPartsThis[i] == abPartsThat[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("PartitionSet[");
        byte[] abParts = this.m_abParts;
        boolean fAppend = false;
        int c = abParts.length;
        for (int i = 0; i < c; ++i) {
            int nPartition = i << 3;
            byte bPart = abParts[i];
            for (int j = 0; j < 8; ++j) {
                if ((bPart & 1 << j) <= 0) continue;
                if (fAppend) {
                    sb.append(", ");
                } else {
                    fAppend = true;
                }
                sb.append(nPartition + j);
            }
        }
        return sb.append("]").toString();
    }
}

