/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.security;

import com.tangosol.io.WrapperStreamFactory;
import com.tangosol.run.xml.XmlConfigurable;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import java.io.File;
import java.io.FileInputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;

public abstract class AbstractEncryptionFilter
extends Base
implements WrapperStreamFactory,
XmlConfigurable {
    protected String m_sTransformation;
    protected AlgorithmParameterSpec m_specCipherParams;
    protected ThreadLocal m_tlsCipher = new ThreadLocal();
    public static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    public static final String DEFAULT_KEYSTORE_PATH = ".keystore";

    protected void setCipherParams(AlgorithmParameterSpec spec) {
        this.m_specCipherParams = spec;
    }

    protected AlgorithmParameterSpec getCipherParams() {
        return this.m_specCipherParams;
    }

    protected void setCipherTransformation(String sTransformation) {
        this.m_sTransformation = sTransformation;
    }

    protected String getCipherTransformation() {
        return this.m_sTransformation;
    }

    protected Cipher makeCipher(int nMode, Key key) {
        try {
            Cipher cipher = Cipher.getInstance(this.getCipherTransformation());
            cipher.init(nMode, key, this.getCipherParams());
            return cipher;
        }
        catch (Exception e) {
            throw AbstractEncryptionFilter.ensureRuntimeException(e);
        }
    }

    protected Cipher getCipher(int nMode, Key key) {
        try {
            Cipher cipher = (Cipher)this.m_tlsCipher.get();
            if (cipher == null) {
                cipher = this.makeCipher(nMode, key);
                this.m_tlsCipher.set(cipher);
            } else {
                cipher.init(nMode, key, this.getCipherParams());
            }
            return cipher;
        }
        catch (Exception e) {
            throw AbstractEncryptionFilter.ensureRuntimeException(e);
        }
    }

    public static KeyStore getKeyStore(String sType, String sPath, char[] acPassword) {
        try {
            KeyStore keyStore = KeyStore.getInstance(sType);
            if (new File(sPath).exists()) {
                FileInputStream streamStore = new FileInputStream(sPath);
                keyStore.load(streamStore, acPassword);
                streamStore.close();
            } else {
                keyStore.load(null, acPassword);
            }
            return keyStore;
        }
        catch (Exception e) {
            throw AbstractEncryptionFilter.ensureRuntimeException(e, "Error accessing KeyStore " + sPath);
        }
    }

    public static SecurityException ensureSecurityException(Throwable e) {
        return AbstractEncryptionFilter.ensureSecurityException(e, null);
    }

    public static SecurityException ensureSecurityException(Throwable e, String s) {
        if (e instanceof SecurityException && s == null) {
            return (SecurityException)e;
        }
        SecurityException se = s == null ? new SecurityException() : new SecurityException(s);
        se.initCause(e);
        return se;
    }

    public XmlElement getConfig() {
        return null;
    }
}

