/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.security;

import com.tangosol.net.security.AbstractEncryptionFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.Cipher;

public class BlockCipherInputStream
extends FilterInputStream {
    protected Cipher m_cipher;
    protected int m_nBlockSize;
    protected byte[] m_abBlockEncrypted;
    protected byte[] m_abBlockClear;
    protected int m_nBlockIndex;
    protected boolean m_fEof;
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public BlockCipherInputStream(InputStream stream, Cipher cipher) {
        super(stream);
        this.m_cipher = cipher;
        this.m_nBlockSize = cipher.getBlockSize();
        this.m_abBlockEncrypted = new byte[this.m_nBlockSize];
        this.m_abBlockClear = EMPTY_BYTE_ARRAY;
    }

    public int read() throws IOException {
        if (this.ensureData() == -1) {
            return -1;
        }
        return this.m_abBlockClear[this.m_nBlockIndex++] & 0xFF;
    }

    public int read(byte[] abData) throws IOException {
        return this.read(abData, 0, abData.length);
    }

    public int read(byte[] abData, int nOffset, int nLength) throws IOException {
        int nAvailable = this.ensureData();
        if (nAvailable == -1) {
            return -1;
        }
        int nCopied = 0;
        while (nLength > 0 && nAvailable > 0) {
            int nCopy = Math.min(nLength, nAvailable);
            System.arraycopy(this.m_abBlockClear, this.m_nBlockIndex, abData, nOffset, nCopy);
            this.m_nBlockIndex += nCopy;
            nCopied += nCopy;
            nOffset += nCopy;
            nLength -= nCopy;
            nAvailable = this.available();
        }
        return nCopied;
    }

    public long skip(long lBytes) throws IOException {
        long lSkip = Math.min((long)this.available(), lBytes);
        this.m_nBlockIndex = (int)((long)this.m_nBlockIndex + lSkip);
        return lSkip;
    }

    public int available() throws IOException {
        int nBuffered = this.m_abBlockClear.length - this.m_nBlockIndex;
        if (nBuffered > 0) {
            return nBuffered;
        }
        if (super.available() >= this.m_nBlockSize) {
            return this.ensureData();
        }
        return 0;
    }

    public boolean markSupported() {
        return false;
    }

    protected int ensureData() throws IOException {
        int nStart;
        int nRead;
        int nBuffered = this.m_abBlockClear.length - this.m_nBlockIndex;
        if (nBuffered > 0) {
            return nBuffered;
        }
        if (this.m_fEof) {
            return -1;
        }
        int nBlockSize = this.m_nBlockSize;
        byte[] abBlockEncrypted = this.m_abBlockEncrypted;
        for (nStart = 0; nStart < nBlockSize; nStart += nRead) {
            nRead = this.in.read(abBlockEncrypted, nStart, nBlockSize - nStart);
            if (nRead != -1) continue;
            this.m_fEof = true;
            break;
        }
        if (nStart > 0) {
            try {
                this.m_abBlockClear = this.m_cipher.doFinal(abBlockEncrypted);
                this.m_nBlockIndex = 0;
                return this.m_abBlockClear.length;
            }
            catch (Exception e) {
                throw AbstractEncryptionFilter.ensureSecurityException(e);
            }
        }
        return -1;
    }
}

