/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.security;

import com.tangosol.io.WrapperInputStream;
import com.tangosol.io.WrapperOutputStream;
import com.tangosol.io.WrapperStreamFactory;
import com.tangosol.net.Member;
import com.tangosol.net.internal.ProtocolAwareStream;
import com.tangosol.net.security.AsymmetricEncryptionFilter;
import com.tangosol.net.security.SymmetricEncryptionFilter;
import com.tangosol.run.xml.XmlConfigurable;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class ClusterEncryptionFilter
extends Base
implements WrapperStreamFactory,
XmlConfigurable {
    protected String m_sSharedKeyAlgorithm;
    protected int m_nSharedKeySize;
    protected SymmetricEncryptionFilter m_wrapperSymmetric;
    protected AsymmetricEncryptionFilter m_wrapperAsymmetric;

    protected WrapperStreamFactory selectWrapper(ProtocolAwareStream.ProtocolContext context) {
        if (context.isClusterService()) {
            return this.m_wrapperAsymmetric;
        }
        return this.m_wrapperSymmetric;
    }

    protected void readSharedKey(DataInputStream stream) {
        try {
            SecretKeySpec key = new SecretKeySpec(this.m_wrapperAsymmetric.decryptPrivate(ExternalizableHelper.readByteArray(stream)), this.m_sSharedKeyAlgorithm);
            this.setSharedKey(key);
        }
        catch (Exception e) {
            throw ClusterEncryptionFilter.ensureRuntimeException(e);
        }
    }

    protected void writeSharedKey(DataOutputStream stream, Member memberTo) {
        try {
            ExternalizableHelper.writeByteArray(stream, this.m_wrapperAsymmetric.encryptPrivate(this.getSharedKey().getEncoded(), memberTo));
        }
        catch (Exception e) {
            throw ClusterEncryptionFilter.ensureRuntimeException(e);
        }
    }

    public SecretKey getSharedKey() {
        SymmetricEncryptionFilter wrapperSymmetric = this.m_wrapperSymmetric;
        SecretKey key = wrapperSymmetric.getKey();
        if (key == null) {
            key = SymmetricEncryptionFilter.generateKey(this.m_sSharedKeyAlgorithm, this.m_nSharedKeySize);
            this.setSharedKey(key);
        }
        return key;
    }

    public void setSharedKey(SecretKey key) {
        SymmetricEncryptionFilter wrapperSymmetric = this.m_wrapperSymmetric;
        SecretKey keyCurrent = wrapperSymmetric.getKey();
        if (keyCurrent == null) {
            wrapperSymmetric.setKey(key);
        } else if (!keyCurrent.equals(key)) {
            throw new IllegalStateException("mismatched shared secret from trusted peer");
        }
    }

    public InputStream getInputStream(InputStream stream) {
        return new DemultiplexingInputStream(stream);
    }

    public OutputStream getOutputStream(OutputStream stream) {
        return new MultiplexingOutputStream(stream);
    }

    public XmlElement getConfig() {
        return null;
    }

    public void setConfig(XmlElement xml) {
        try {
            AsymmetricEncryptionFilter wrapperAsymmetric;
            this.m_sSharedKeyAlgorithm = xml.getSafeElement("sharedKeyType").getString("DESede");
            this.m_nSharedKeySize = Integer.parseInt(xml.getSafeElement("sharedKeySize").getString(Integer.toString(112)));
            String sAsymmClass = xml.getSafeElement("asymmetricFilterClassName").getString();
            if (sAsymmClass == null || sAsymmClass.trim().length() == 0) {
                wrapperAsymmetric = new AsymmetricEncryptionFilter();
            } else {
                Class<?> clazz = Class.forName(sAsymmClass);
                wrapperAsymmetric = (AsymmetricEncryptionFilter)clazz.newInstance();
            }
            wrapperAsymmetric.setConfig(xml);
            this.m_wrapperAsymmetric = wrapperAsymmetric;
            this.m_wrapperSymmetric = new SymmetricEncryptionFilter();
        }
        catch (Exception e) {
            throw ClusterEncryptionFilter.ensureRuntimeException(e, "error during configuration");
        }
    }

    public class MultiplexingOutputStream
    extends WrapperOutputStream
    implements ProtocolAwareStream {
        protected OutputStream m_streamInner;

        public MultiplexingOutputStream(OutputStream stream) {
            this.m_streamInner = stream;
        }

        public void setProtocolContext(ProtocolAwareStream.ProtocolContext context) {
            OutputStream streamOuter = ClusterEncryptionFilter.this.selectWrapper(context).getOutputStream(this.m_streamInner);
            if (streamOuter instanceof ProtocolAwareStream) {
                ((ProtocolAwareStream)((Object)streamOuter)).setProtocolContext(context);
            }
            if (context.isInductionMessage()) {
                Set setMemberTo = context.getToMemberSet();
                if (setMemberTo == null || setMemberTo.size() != 1) {
                    throw new IllegalStateException("unexpected recipient count");
                }
                if (!(streamOuter instanceof DataOutputStream)) {
                    streamOuter = new DataOutputStream(streamOuter);
                }
                Member memberTo = (Member)setMemberTo.iterator().next();
                ClusterEncryptionFilter.this.writeSharedKey((DataOutputStream)streamOuter, memberTo);
            }
            this.setOutputStream(streamOuter);
        }
    }

    public class DemultiplexingInputStream
    extends WrapperInputStream
    implements ProtocolAwareStream {
        protected InputStream m_streamInner;

        public DemultiplexingInputStream(InputStream stream) {
            this.m_streamInner = stream;
        }

        public void setProtocolContext(ProtocolAwareStream.ProtocolContext context) {
            InputStream streamOuter = ClusterEncryptionFilter.this.selectWrapper(context).getInputStream(this.m_streamInner);
            if (streamOuter instanceof ProtocolAwareStream) {
                ((ProtocolAwareStream)((Object)streamOuter)).setProtocolContext(context);
            }
            if (context.isInductionMessage()) {
                if (!(streamOuter instanceof DataInputStream)) {
                    streamOuter = new DataInputStream(streamOuter);
                }
                ClusterEncryptionFilter.this.readSharedKey((DataInputStream)streamOuter);
            }
            this.setInputStream(streamOuter);
        }
    }
}

