/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.security;

import com.tangosol.net.security.SymmetricEncryptionFilter;
import com.tangosol.run.xml.XmlElement;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class PasswordBasedEncryptionFilter
extends SymmetricEncryptionFilter {
    public void setConfig(XmlElement xml) {
        String sPassword = xml.getSafeElement("password").getString();
        if (sPassword.length() == 0) {
            throw new IllegalArgumentException("no password specified");
        }
        char[] acPassword = new char[sPassword.length()];
        sPassword.getChars(0, acPassword.length, acPassword, 0);
        byte[] abSalt = xml.getSafeElement("salt").getString("nosecret").getBytes();
        int cIters = xml.getSafeElement("iterations").getInt(32);
        String sAlgorithm = xml.getSafeElement("algorithm").getString("PBEWithMD5AndDES");
        try {
            PBEKeySpec pbeKeySpec = new PBEKeySpec(acPassword);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(sAlgorithm);
            this.setCipherParams(new PBEParameterSpec(abSalt, cIters));
            this.setKey(keyFactory.generateSecret(pbeKeySpec));
        }
        catch (Exception e) {
            throw PasswordBasedEncryptionFilter.ensureRuntimeException(e);
        }
    }
}

