/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.net.security;

import com.tangosol.net.security.SimpleHandler;
import com.tangosol.util.Base;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;

public abstract class Security
extends Base {
    private static final String SECURITY = "com.tangosol.coherence.component.net.Security";
    private static Class s_clzSecurity;
    private static Method s_methLogin;
    private static Method s_methRunAs;
    private static Throwable s_eState;

    public static Subject login(String sName, char[] acPassword) {
        return Security.login(new SimpleHandler(sName, acPassword));
    }

    public static Subject login(CallbackHandler handler) {
        if (s_eState != null) {
            throw Security.ensureRuntimeException(s_eState);
        }
        try {
            return (Subject)s_methLogin.invoke(null, handler);
        }
        catch (InvocationTargetException e) {
            throw Security.ensureRuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw Security.ensureRuntimeException(e);
        }
    }

    public static Object runAs(Subject subject, PrivilegedAction action) {
        if (s_eState != null) {
            throw Security.ensureRuntimeException(s_eState);
        }
        Security.azzert(action != null, "Action is null");
        try {
            return s_methRunAs.invoke(null, subject, action);
        }
        catch (InvocationTargetException e) {
            throw Security.ensureRuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw Security.ensureRuntimeException(e);
        }
    }

    public static Object runAs(Subject subject, PrivilegedExceptionAction action) throws PrivilegedActionException {
        if (s_eState != null) {
            throw Security.ensureRuntimeException(s_eState);
        }
        Security.azzert(action != null, "Action is null");
        try {
            return s_methRunAs.invoke(null, subject, action);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof PrivilegedActionException) {
                throw (PrivilegedActionException)te;
            }
            throw Security.ensureRuntimeException(te);
        }
        catch (Exception e) {
            throw Security.ensureRuntimeException(e);
        }
    }

    static {
        try {
            s_clzSecurity = Class.forName(SECURITY);
            s_methLogin = s_clzSecurity.getMethod("login", Object.class);
            s_methRunAs = s_clzSecurity.getMethod("runAs", Object.class, Object.class);
        }
        catch (Throwable e) {
            s_eState = e;
        }
    }
}

