/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.run.jca;

import com.tangosol.util.Base;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.TransactionMap;
import com.tangosol.util.Versionable;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SimpleValidator
extends Base
implements TransactionMap.Validator {
    private TransactionMap.Validator m_validatorNext;
    protected Map m_mapVersion = new HashMap();

    public Map getVersionMap() {
        return this.m_mapVersion;
    }

    public void enlist(TransactionMap mapTx, Object oKey) {
        Map mapVersion = this.getVersionMap();
        if (!mapVersion.containsKey(oKey)) {
            mapVersion.put(oKey, this.calculateVersion(mapTx.getBaseMap().get(oKey)));
            TransactionMap.Validator validatorNext = this.getNextValidator();
            if (validatorNext != null) {
                validatorNext.enlist(mapTx, oKey);
            }
        }
    }

    public void validate(TransactionMap mapTx, Set setInsert, Set setUpdate, Set setDelete, Set setRead, Set setPhantom) throws ConcurrentModificationException {
        TransactionMap.Validator validatorNext = this.getNextValidator();
        if (validatorNext != null) {
            validatorNext.validate(mapTx, setInsert, setUpdate, setDelete, setRead, setPhantom);
        }
        if (!setInsert.isEmpty()) {
            this.validateInsert(mapTx, setInsert);
        }
        if (!setUpdate.isEmpty()) {
            this.validateVersion(mapTx, setUpdate);
        }
        if (!setDelete.isEmpty()) {
            this.validateVersion(mapTx, setDelete);
        }
        if (!setRead.isEmpty()) {
            this.validateValue(mapTx, setRead);
        }
        if (!setPhantom.isEmpty()) {
            throw new ConcurrentModificationException("Phantom set is not empty: " + setPhantom);
        }
    }

    public TransactionMap.Validator getNextValidator() {
        return this.m_validatorNext;
    }

    public void setNextValidator(TransactionMap.Validator validator) {
        this.m_validatorNext = validator;
    }

    protected void validateInsert(TransactionMap mapTx, Set setKey) {
        ConcurrentMap mapBase = mapTx.getBaseMap();
        Iterator iter = setKey.iterator();
        while (iter.hasNext()) {
            Object oKey = iter.next();
            if (mapBase.containsKey(oKey)) continue;
            iter.remove();
        }
        if (!setKey.isEmpty()) {
            throw new ConcurrentModificationException("Insert conflict for: " + setKey);
        }
    }

    protected void validateVersion(TransactionMap mapTx, Set setKey) {
        ConcurrentMap mapBase = mapTx.getBaseMap();
        Map mapVersion = this.getVersionMap();
        Iterator iter = setKey.iterator();
        while (iter.hasNext()) {
            Object oKey = iter.next();
            Comparable oOrig = (Comparable)mapVersion.get(oKey);
            Comparable oCurr = this.calculateVersion(mapBase.get(oKey));
            if (oCurr.compareTo(oOrig) != 0) continue;
            iter.remove();
        }
        if (!setKey.isEmpty()) {
            throw new ConcurrentModificationException("Version conflict for: " + setKey);
        }
    }

    protected void validateValue(TransactionMap mapTx, Set setKey) {
        ConcurrentMap mapBase = mapTx.getBaseMap();
        Iterator iter = setKey.iterator();
        while (iter.hasNext()) {
            Object oValCurr;
            Object oKey = iter.next();
            Object oValBase = mapBase.get(oKey);
            if (!SimpleValidator.equals(oValBase, oValCurr = mapTx.get(oKey))) continue;
            iter.remove();
        }
        if (!setKey.isEmpty()) {
            throw new ConcurrentModificationException("Value conflict for: " + setKey);
        }
    }

    protected Comparable calculateVersion(Object oValue) {
        return oValue == null ? SimpleValidator.makeInteger(0) : (oValue instanceof Versionable ? ((Versionable)oValue).getVersionIndicator() : (oValue instanceof Serializable ? SimpleValidator.makeInteger(ExternalizableHelper.toBinary(oValue).hashCode()) : SimpleValidator.makeInteger(oValue.hashCode())));
    }
}

