/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.run.sql;

import com.tangosol.run.sql.WrapperConnection;
import com.tangosol.util.Base;
import com.tangosol.util.WrapperException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;

public abstract class WrapperDriver
extends Base
implements Driver {
    private Driver m_driver;
    public static final String JDBC_PREFIX = "jdbc:";

    public WrapperDriver(Driver driver) {
        this.m_driver = driver;
    }

    protected Driver getDriver() {
        return this.m_driver;
    }

    public abstract String getProtocol();

    public Connection connect(String sUrl, Properties info) throws SQLException {
        if (!this.acceptsURL(sUrl)) {
            return null;
        }
        Connection con = this.getDriver().connect(this.getRemainder(sUrl), info);
        return this.instantiateConnection(con);
    }

    public boolean acceptsURL(String sUrl) throws SQLException {
        if (!sUrl.startsWith(this.getProtocol() + ':') && !sUrl.startsWith(JDBC_PREFIX + this.getProtocol() + ':')) {
            return false;
        }
        return this.getDriver().acceptsURL(this.getRemainder(sUrl));
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return this.getDriver().getPropertyInfo(url, info);
    }

    public int getMajorVersion() {
        return this.getDriver().getMajorVersion();
    }

    public int getMinorVersion() {
        return this.getDriver().getMinorVersion();
    }

    public boolean jdbcCompliant() {
        return this.getDriver().jdbcCompliant();
    }

    public void register() {
        try {
            DriverManager.registerDriver(this);
        }
        catch (SQLException e) {
            throw new WrapperException(e);
        }
    }

    public String getRemainder(String sUrl) {
        if (sUrl.startsWith(JDBC_PREFIX)) {
            return JDBC_PREFIX + this.getRemainder(sUrl.substring(JDBC_PREFIX.length()));
        }
        String sProtocol = this.getProtocol();
        WrapperDriver.azzert(sUrl.startsWith(sProtocol + ':'));
        return sUrl.substring(sProtocol.length() + 1);
    }

    public String wrapUrl(String sUrl) {
        if (sUrl.startsWith(JDBC_PREFIX)) {
            return JDBC_PREFIX + this.wrapUrl(sUrl.substring(JDBC_PREFIX.length()));
        }
        return this.getProtocol() + ':' + sUrl;
    }

    protected WrapperConnection instantiateConnection(Connection con) {
        return new WrapperConnection(this, con);
    }
}

