/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.run.xml;

import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.ParserFactory;

public class SaxParser
extends Base {
    private static Parser s_parser;

    public SaxParser() {
        this(false);
    }

    public SaxParser(boolean fAllowComments) {
        if (fAllowComments) {
            throw new UnsupportedOperationException("XML comments are not supported");
        }
    }

    public static void main(String[] asParam) {
        if (asParam.length > 0) {
            SaxParser parser = new SaxParser();
            try {
                FileInputStream in = new FileInputStream(asParam[0]);
                XmlElement root = parser.parseXml(in);
                root.writeXml(SaxParser.getOut(), true);
                SaxParser.out();
            }
            catch (Exception e) {
                SaxParser.out(e);
            }
        }
    }

    public XmlElement parseXml(String sXml) throws SAXException {
        return this.parseXml(new InputSource(new StringReader(sXml)), null);
    }

    public XmlElement parseXml(String sXml, XmlElement elRoot) throws SAXException {
        return this.parseXml(new InputSource(new StringReader(sXml)), elRoot);
    }

    public XmlElement parseXml(InputStream input) throws SAXException {
        return this.parseXml(new InputSource(input), null);
    }

    public XmlElement parseXml(Reader input) throws SAXException {
        return this.parseXml(new InputSource(input), null);
    }

    public XmlElement parseXml(InputSource input) throws SAXException {
        return this.parseXml(input, null);
    }

    protected XmlElement parseXml(InputSource input, XmlElement xmlRoot) throws SAXException {
        try {
            Parser parser = SaxParser.getParser();
            SimpleHandler handler = new SimpleHandler(xmlRoot);
            parser.setDocumentHandler(handler);
            parser.setErrorHandler(handler);
            parser.parse(input);
            xmlRoot = handler.m_root;
            if (xmlRoot == null) {
                throw new SAXException("Empty document");
            }
            return xmlRoot;
        }
        catch (Exception e) {
            throw e instanceof SAXException ? (SAXException)e : new SAXException(e);
        }
    }

    protected XmlElement instantiateRoot(String sRoot) {
        return new SimpleElement(sRoot, null);
    }

    protected static Parser getParser() throws Exception {
        Parser parser = s_parser;
        if (parser == null) {
            try {
                Class<?> clzFactory = Class.forName("javax.xml.parsers.SAXParserFactory");
                Object factory = ClassHelper.invokeStatic(clzFactory, "newInstance", ClassHelper.VOID);
                ClassHelper.invoke(factory, "setValidating", new Object[]{Boolean.FALSE});
                Object SAXParser = ClassHelper.invoke(factory, "newSAXParser", ClassHelper.VOID);
                parser = (Parser)ClassHelper.invoke(SAXParser, "getParser", ClassHelper.VOID);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (parser == null) {
                parser = ParserFactory.makeParser();
            }
            s_parser = parser;
        }
        return parser;
    }

    class SimpleHandler
    implements DocumentHandler,
    ErrorHandler {
        private XmlElement m_root;
        private XmlElement m_current;

        SimpleHandler(XmlElement root) {
            Base.azzert(root == null || root.isMutable());
            this.m_root = root;
        }

        public void setDocumentLocator(Locator l) {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
            Base.azzert(this.m_current == null);
        }

        public void startElement(String sTag, AttributeList attrs) throws SAXException {
            XmlElement el = this.m_current;
            if (el == null) {
                if (this.m_root == null) {
                    this.m_root = SaxParser.this.instantiateRoot(sTag);
                } else {
                    this.m_root.setName(sTag);
                }
                el = this.m_root;
            } else {
                el = el.addElement(sTag);
            }
            int cAttrs = attrs.getLength();
            for (int i = 0; i < cAttrs; ++i) {
                String sName = attrs.getName(i);
                String sValue = attrs.getValue(i);
                el.addAttribute(sName).setString(sValue);
            }
            this.m_current = el;
        }

        public void endElement(String sTag) throws SAXException {
            String sText;
            XmlElement el = this.m_current;
            if (!el.getElementList().isEmpty() && (sText = el.getString()) != null) {
                el.setString(sText.trim());
            }
            this.m_current = el.getParent();
        }

        public void characters(char[] ach, int offset, int cnt) throws SAXException {
            if (cnt > 0) {
                XmlElement el = this.m_current;
                String sValue = el.getString();
                String sText = new String(ach, offset, cnt);
                el.setString(sValue + sText);
            }
        }

        public void ignorableWhitespace(char[] buf, int offset, int len) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void warning(SAXParseException exception) throws SAXException {
        }

        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    }
}

