/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.run.xml;

import com.tangosol.io.Base64InputStream;
import com.tangosol.io.Base64OutputStream;
import com.tangosol.run.xml.PropertyAdapter;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlBean;
import com.tangosol.run.xml.XmlElement;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public abstract class SimpleAdapter
extends PropertyAdapter {
    private static final char[] HEX = "0123456789ABCDEF".toCharArray();
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$util$Date;

    public SimpleAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
        super(infoBean, clzType, sName, sXml, xml);
    }

    public boolean isCloneRequired() {
        return false;
    }

    public Object fromXml(XmlElement xml) {
        return xml.getValue();
    }

    public XmlElement toXml(Object o) {
        return o == null ? null : new SimpleElement(this.getXmlName(), o);
    }

    public Object fromUri(String sUri) {
        byte[] abValue = Base64InputStream.decode(sUri.toCharArray());
        SimpleElement xmlValue = new SimpleElement(this.getXmlName(), new String(abValue));
        return this.fromXml(xmlValue);
    }

    public String toUri(Object o) {
        XmlElement xmlValue = this.toXml(o);
        char[] achValue = Base64OutputStream.encode(xmlValue.getString("").getBytes());
        return new String(achValue);
    }

    protected static String parseNumber(String sValue) {
        int cch = sValue.length();
        if (cch > 2 && sValue.charAt(0) == '(' && sValue.charAt(cch - 1) == ')') {
            sValue = '-' + sValue.substring(1, sValue.length() - 1);
        }
        return sValue;
    }

    public static String decodeString(String sUri) {
        if (sUri.length() == 0) {
            return sUri;
        }
        StringBuffer sb = null;
        char[] ach = sUri.toCharArray();
        int cch = ach.length;
        int ofPrev = 0;
        for (int of = 0; of < cch; ++of) {
            switch (ach[of]) {
                case '%': 
                case 'u': {
                    if (sb == null) {
                        sb = new StringBuffer(cch);
                    }
                    if (of > ofPrev) {
                        sb.append(ach, ofPrev, of - ofPrev);
                    }
                    int n = 0;
                    if (ach[of] == 'u') {
                        n = SimpleAdapter.parseHex(ach[++of]);
                        n = (n << 4) + SimpleAdapter.parseHex(ach[++of]);
                    }
                    n = (n << 4) + SimpleAdapter.parseHex(ach[++of]);
                    n = (n << 4) + SimpleAdapter.parseHex(ach[++of]);
                    sb.append((char)n);
                    ofPrev = of + 1;
                }
            }
        }
        if (sb == null) {
            return sUri;
        }
        if (ofPrev < cch) {
            sb.append(ach, ofPrev, cch - ofPrev);
        }
        return sb.toString();
    }

    public static String encodeString(String s) {
        StringBuffer sb = null;
        char[] ach = s.toCharArray();
        int cch = ach.length;
        int ofPrev = 0;
        for (int of = 0; of < cch; ++of) {
            char n;
            char ch = ach[of];
            if (ch > '\u00ff') {
                if (sb == null) {
                    sb = new StringBuffer();
                }
                if (of > ofPrev) {
                    sb.append(ach, ofPrev, of - ofPrev);
                }
                n = ch;
                sb.append('u').append(HEX[(n & 0xF000) >> 12]).append(HEX[(n & 0xF00) >> 8]).append(HEX[(n & 0xF0) >> 4]).append(HEX[n & 0xF]);
                ofPrev = of + 1;
                continue;
            }
            switch (ch) {
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': 
                case ' ': 
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '`': 
                case 'u': 
                case '{': 
                case '|': 
                case '}': {
                    if (sb == null) {
                        sb = new StringBuffer();
                    }
                    if (of > ofPrev) {
                        sb.append(ach, ofPrev, of - ofPrev);
                    }
                    n = ch;
                    sb.append('%').append(HEX[(n & 0xF0) >> 4]).append(HEX[n & 0xF]);
                    ofPrev = of + 1;
                }
            }
        }
        if (sb != null && ofPrev < cch) {
            sb.append(ach, ofPrev, cch - ofPrev);
        }
        return sb == null ? s : sb.toString();
    }

    public static class SystemTimeAdapter
    extends LongAdapter {
        public SystemTimeAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
            super(infoBean, clzType, sName, sXml, xml);
            SystemTimeAdapter.azzert(clzType == Long.TYPE || clzType == (class$java$lang$Long == null ? (class$java$lang$Long = SimpleAdapter.class$("java.lang.Long")) : class$java$lang$Long));
        }

        public Object fromXml(XmlElement xml) {
            Timestamp ts;
            Object o = xml.getValue();
            if (o != null && (ts = xml.getDateTime()) != null) {
                o = SystemTimeAdapter.makeLong(ts.getTime());
            }
            return o;
        }

        public XmlElement toXml(Object o) {
            Timestamp ts = null;
            if (o != null) {
                ts = new Timestamp((Long)o);
            }
            return super.toXml(ts);
        }

        public Object fromUri(String sUri) {
            return SystemTimeAdapter.makeLong(TimestampAdapter.toTimestamp(sUri).getTime());
        }

        public String toUri(Object o) {
            Timestamp ts = null;
            if (o != null) {
                ts = new Timestamp((Long)o);
            }
            return TimestampAdapter.toString(ts);
        }
    }

    public static class OldDateAdapter
    extends SimpleAdapter {
        public OldDateAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
            super(infoBean, clzType, sName, sXml, xml);
            OldDateAdapter.azzert(clzType == (class$java$util$Date == null ? (class$java$util$Date = SimpleAdapter.class$("java.util.Date")) : class$java$util$Date));
        }

        public boolean isCloneRequired() {
            return true;
        }

        public Object fromXml(XmlElement xml) {
            Object o = xml.getValue();
            if (o != null) {
                Timestamp ts = xml.getDateTime();
                long lTime = ts.getTime();
                if (lTime % 1000L == 0L) {
                    lTime += (long)(ts.getNanos() / 1000000);
                }
                o = new java.util.Date(lTime);
            }
            return o;
        }

        public XmlElement toXml(Object o) {
            if (o == null) {
                return null;
            }
            o = new Timestamp(((java.util.Date)o).getTime());
            return new SimpleElement(this.getXmlName(), o);
        }

        public Object fromUri(String sUri) {
            Timestamp ts = TimestampAdapter.toTimestamp(sUri);
            return new java.util.Date(ts.getTime() + (long)(ts.getNanos() / 1000000));
        }

        public String toUri(Object o) {
            Timestamp ts = new Timestamp(((java.util.Date)o).getTime());
            return TimestampAdapter.toString(ts);
        }

        public Object readExternal(DataInput in) throws IOException {
            return new java.util.Date(OldDateAdapter.readLong(in));
        }

        public void writeExternal(DataOutput out, Object o) throws IOException {
            OldDateAdapter.writeLong(out, ((java.util.Date)o).getTime());
        }
    }

    public static class TimestampAdapter
    extends SimpleAdapter {
        public TimestampAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
            super(infoBean, clzType, sName, sXml, xml);
            TimestampAdapter.azzert(clzType == (class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = SimpleAdapter.class$("java.sql.Timestamp")) : class$java$sql$Timestamp));
        }

        public boolean isCloneRequired() {
            return true;
        }

        public Object fromXml(XmlElement xml) {
            Object o = xml.getValue();
            if (o != null) {
                o = xml.getDateTime();
            }
            return o;
        }

        public Object fromUri(String sUri) {
            return TimestampAdapter.toTimestamp(sUri);
        }

        public String toUri(Object o) {
            return TimestampAdapter.toString((Timestamp)o);
        }

        protected static Timestamp toTimestamp(String sUri) {
            if (sUri.length() >= 14) {
                String sDateTime = sUri.substring(0, 4) + '-' + sUri.substring(4, 6) + '-' + sUri.substring(6, 8) + ' ' + sUri.substring(8, 10) + ':' + sUri.substring(10, 12) + ':' + sUri.substring(12, 14);
                if (sUri.length() > 14) {
                    sDateTime = sDateTime + '.' + sUri.substring(14);
                }
                return Timestamp.valueOf(sDateTime);
            }
            throw new IllegalArgumentException("illegal date/time value: " + sUri);
        }

        protected static String toString(Timestamp ts) {
            char[] ach = ts.toString().toCharArray();
            int cch = ach.length;
            TimestampAdapter.azzert(cch >= 19);
            ach[4] = ach[5];
            ach[5] = ach[6];
            ach[6] = ach[8];
            ach[7] = ach[9];
            ach[8] = ach[11];
            ach[9] = ach[12];
            ach[10] = ach[14];
            ach[11] = ach[15];
            ach[12] = ach[17];
            ach[13] = ach[18];
            if (cch > 20) {
                int of;
                for (of = 20; of < cch; ++of) {
                    ach[of - 6] = ach[of];
                }
                for (of = cch - 7; of > 13 && ach[of] == '0'; --of) {
                }
                return new String(ach, 0, of + 1);
            }
            return new String(ach, 0, 14);
        }

        public Object readExternal(DataInput in) throws IOException {
            return TimestampAdapter.readTimestamp(in);
        }

        public void writeExternal(DataOutput out, Object o) throws IOException {
            TimestampAdapter.writeTimestamp(out, (Timestamp)o);
        }
    }

    public static class TimeAdapter
    extends SimpleAdapter {
        public TimeAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
            super(infoBean, clzType, sName, sXml, xml);
            TimeAdapter.azzert(clzType == (class$java$sql$Time == null ? (class$java$sql$Time = SimpleAdapter.class$("java.sql.Time")) : class$java$sql$Time));
        }

        public boolean isCloneRequired() {
            return true;
        }

        public Object fromXml(XmlElement xml) {
            Object o = xml.getValue();
            if (o != null) {
                o = xml.getTime();
            }
            return o;
        }

        public Object fromUri(String sUri) {
            if (sUri.length() == 6) {
                return Time.valueOf(sUri.substring(0, 2) + ':' + sUri.substring(2, 4) + ':' + sUri.substring(4, 6));
            }
            throw new IllegalArgumentException("illegal time value: " + sUri);
        }

        public String toUri(Object o) {
            char[] ach = o.toString().toCharArray();
            TimeAdapter.azzert(ach.length == 8);
            ach[2] = ach[3];
            ach[3] = ach[4];
            ach[4] = ach[6];
            ach[5] = ach[7];
            return new String(ach, 0, 6);
        }

        public Object readExternal(DataInput in) throws IOException {
            return TimeAdapter.readTime(in);
        }

        public void writeExternal(DataOutput out, Object o) throws IOException {
            TimeAdapter.writeTime(out, (Time)o);
        }
    }

    public static class DateAdapter
    extends SimpleAdapter {
        public DateAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
            super(infoBean, clzType, sName, sXml, xml);
            DateAdapter.azzert(clzType == (class$java$sql$Date == null ? (class$java$sql$Date = SimpleAdapter.class$("java.sql.Date")) : class$java$sql$Date));
        }

        public boolean isCloneRequired() {
            return true;
        }

        public Object fromXml(XmlElement xml) {
            return xml.getDate(null);
        }

        public Object readExternal(DataInput in) throws IOException {
            return DateAdapter.readDate(in);
        }

        public void writeExternal(DataOutput out, Object o) throws IOException {
            DateAdapter.writeDate(out, (Date)o);
        }
    }

    public static class BigIntegerAdapter
    extends SimpleAdapter {
        public BigIntegerAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
            super(infoBean, clzType, sName, sXml, xml);
            BigIntegerAdapter.azzert(clzType == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = SimpleAdapter.class$("java.math.BigInteger")) : class$java$math$BigInteger));
        }

        public Object fromXml(XmlElement xml) {
            Object o = xml.getValue();
            if (o != null) {
                o = ((BigDecimal)o).toBigInteger();
            }
            return o;
        }

        public XmlElement toXml(Object o) {
            if (o == null) {
                return null;
            }
            o = new BigDecimal((BigInteger)o);
            return new SimpleElement(this.getXmlName(), o);
        }

        public Object fromUri(String sUri) {
            return new BigInteger(BigIntegerAdapter.parseNumber(sUri));
        }

        public String toUri(Object o) {
            String sInt = ((BigInteger)o).toString();
            if (sInt.charAt(0) == '-') {
                return '(' + sInt.substring(1) + ')';
            }
            return sInt;
        }

        public Object readExternal(DataInput in) throws IOException {
            return BigIntegerAdapter.readBigInteger(in);
        }

        public void writeExternal(DataOutput out, Object o) throws IOException {
            BigIntegerAdapter.writeBigInteger(out, (BigInteger)o);
        }
    }

    public static class BigDecimalAdapter
    extends SimpleAdapter {
        public BigDecimalAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
            super(infoBean, clzType, sName, sXml, xml);
            BigDecimalAdapter.azzert(clzType == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SimpleAdapter.class$("java.math.BigDecimal")) : class$java$math$BigDecimal));
        }

        public Object fromXml(XmlElement xml) {
            Object o = xml.getValue();
            if (o != null) {
                o = xml.getDecimal();
            }
            return o;
        }

        public Object fromUri(String sUri) {
            int of = sUri.indexOf(42);
            BigInteger IUnscaled = new BigInteger(BigDecimalAdapter.parseNumber(sUri.substring(0, of)));
            int nScale = Integer.parseInt(BigDecimalAdapter.parseNumber(sUri.substring(of + 1)));
            return new BigDecimal(IUnscaled, nScale);
        }

        public String toUri(Object o) {
            StringBuffer sb = new StringBuffer();
            BigDecimal dec = (BigDecimal)o;
            String sInt = dec.unscaledValue().toString();
            if (sInt.charAt(0) == '-') {
                sb.append('(').append(sInt.substring(1)).append(')');
            } else {
                sb.append(sInt);
            }
            sb.append('*');
            int n = dec.scale();
            if (n < 0) {
                sb.append('(').append(-n).append(')');
            } else {
                sb.append(n);
            }
            return sb.toString();
        }

        public Object readExternal(DataInput in) throws IOException {
            return BigDecimalAdapter.readBigDecimal(in);
        }

        public void writeExternal(DataOutput out, Object o) throws IOException {
            BigDecimalAdapter.writeBigDecimal(out, (BigDecimal)o);
        }
    }

    public static class StringAdapter
    extends SimpleAdapter {
        public StringAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
            super(infoBean, clzType, sName, sXml, xml);
            StringAdapter.azzert(clzType == (class$java$lang$String == null ? (class$java$lang$String = SimpleAdapter.class$("java.lang.String")) : class$java$lang$String));
        }

        public Object fromUri(String sUri) {
            return StringAdapter.decodeString(sUri);
        }

        public String toUri(Object o) {
            return StringAdapter.encodeString((String)o);
        }

        public Object readExternal(DataInput in) throws IOException {
            return StringAdapter.readUTF(in);
        }

        public void writeExternal(DataOutput out, Object o) throws IOException {
            StringAdapter.writeUTF(out, o.toString());
        }
    }

    public static class DoubleAdapter
    extends SimpleAdapter {
        public DoubleAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
            super(infoBean, clzType, sName, sXml, xml);
            DoubleAdapter.azzert(clzType == Double.TYPE || clzType == (class$java$lang$Double == null ? (class$java$lang$Double = SimpleAdapter.class$("java.lang.Double")) : class$java$lang$Double));
        }

        public Object fromXml(XmlElement xml) {
            Object o = xml.getValue();
            if (o != null) {
                o = new Double(xml.getDouble());
            }
            return o;
        }

        public Object fromUri(String sUri) {
            return new Double(Double.longBitsToDouble(Long.parseLong(DoubleAdapter.parseNumber(sUri))));
        }

        public String toUri(Object o) {
            double dfl = (Double)o;
            long n = Double.doubleToLongBits(dfl);
            if (n < 0L) {
                return "(" + -n + ")";
            }
            return String.valueOf(n);
        }

        public Object readExternal(DataInput in) throws IOException {
            return new Double(in.readDouble());
        }

        public void writeExternal(DataOutput out, Object o) throws IOException {
            out.writeDouble(((Number)o).doubleValue());
        }
    }

    public static class FloatAdapter
    extends SimpleAdapter {
        public FloatAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
            super(infoBean, clzType, sName, sXml, xml);
            FloatAdapter.azzert(clzType == Float.TYPE || clzType == (class$java$lang$Float == null ? (class$java$lang$Float = SimpleAdapter.class$("java.lang.Float")) : class$java$lang$Float));
        }

        public Object fromXml(XmlElement xml) {
            Object o = xml.getValue();
            if (o != null) {
                o = new Float((float)xml.getDouble());
            }
            return o;
        }

        public XmlElement toXml(Object o) {
            if (o == null) {
                return null;
            }
            o = new Double(((Number)o).doubleValue());
            return new SimpleElement(this.getXmlName(), o);
        }

        public Object fromUri(String sUri) {
            return new Float(Float.intBitsToFloat(Integer.parseInt(FloatAdapter.parseNumber(sUri))));
        }

        public String toUri(Object o) {
            float fl = ((Float)o).floatValue();
            int n = Float.floatToIntBits(fl);
            if (n < 0) {
                return "(" + -n + ")";
            }
            return String.valueOf(n);
        }

        public Object readExternal(DataInput in) throws IOException {
            return new Float(in.readFloat());
        }

        public void writeExternal(DataOutput out, Object o) throws IOException {
            out.writeFloat(((Number)o).floatValue());
        }
    }

    public static class LongAdapter
    extends SimpleAdapter {
        public LongAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
            super(infoBean, clzType, sName, sXml, xml);
            LongAdapter.azzert(clzType == Long.TYPE || clzType == (class$java$lang$Long == null ? (class$java$lang$Long = SimpleAdapter.class$("java.lang.Long")) : class$java$lang$Long));
        }

        public Object fromXml(XmlElement xml) {
            Object o = xml.getValue();
            if (o != null) {
                o = LongAdapter.makeLong(xml.getLong());
            }
            return o;
        }

        public Object fromUri(String sUri) {
            return Long.valueOf(LongAdapter.parseNumber(sUri));
        }

        public String toUri(Object o) {
            long n = (Long)o;
            if (n < 0L) {
                return "(" + -n + ")";
            }
            return String.valueOf(n);
        }

        public Object readExternal(DataInput in) throws IOException {
            return LongAdapter.makeLong(LongAdapter.readLong(in));
        }

        public void writeExternal(DataOutput out, Object o) throws IOException {
            LongAdapter.writeLong(out, ((Number)o).longValue());
        }
    }

    public static class IntAdapter
    extends SimpleAdapter {
        public IntAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
            super(infoBean, clzType, sName, sXml, xml);
            IntAdapter.azzert(clzType == Integer.TYPE || clzType == (class$java$lang$Integer == null ? (class$java$lang$Integer = SimpleAdapter.class$("java.lang.Integer")) : class$java$lang$Integer));
        }

        public Object fromXml(XmlElement xml) {
            Object o = xml.getValue();
            if (o != null) {
                o = IntAdapter.makeInteger(xml.getInt());
            }
            return o;
        }

        public Object fromUri(String sUri) {
            return Integer.valueOf(IntAdapter.parseNumber(sUri));
        }

        public String toUri(Object o) {
            int n = (Integer)o;
            if (n < 0) {
                return "(" + -n + ")";
            }
            return String.valueOf(n);
        }

        public Object readExternal(DataInput in) throws IOException {
            return IntAdapter.makeInteger(IntAdapter.readInt(in));
        }

        public void writeExternal(DataOutput out, Object o) throws IOException {
            IntAdapter.writeInt(out, ((Number)o).intValue());
        }
    }

    public static class ShortAdapter
    extends SimpleAdapter {
        public ShortAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
            super(infoBean, clzType, sName, sXml, xml);
            ShortAdapter.azzert(clzType == Short.TYPE || clzType == (class$java$lang$Short == null ? (class$java$lang$Short = SimpleAdapter.class$("java.lang.Short")) : class$java$lang$Short));
        }

        public Object fromXml(XmlElement xml) {
            Object o = xml.getValue();
            if (o != null) {
                o = new Short((short)xml.getInt());
            }
            return o;
        }

        public XmlElement toXml(Object o) {
            if (o == null) {
                return null;
            }
            o = ShortAdapter.makeInteger(((Number)o).intValue());
            return new SimpleElement(this.getXmlName(), o);
        }

        public Object fromUri(String sUri) {
            return Short.valueOf(ShortAdapter.parseNumber(sUri));
        }

        public String toUri(Object o) {
            int n = ((Number)o).intValue();
            if (n < 0) {
                return "(" + -n + ")";
            }
            return String.valueOf(n);
        }

        public Object readExternal(DataInput in) throws IOException {
            return new Short(in.readShort());
        }

        public void writeExternal(DataOutput out, Object o) throws IOException {
            out.writeShort(((Number)o).shortValue());
        }
    }

    public static class CharAdapter
    extends SimpleAdapter {
        public CharAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
            super(infoBean, clzType, sName, sXml, xml);
            CharAdapter.azzert(clzType == Character.TYPE || clzType == (class$java$lang$Character == null ? (class$java$lang$Character = SimpleAdapter.class$("java.lang.Character")) : class$java$lang$Character));
        }

        public Object fromXml(XmlElement xml) {
            Object o = xml.getValue();
            if (o != null) {
                o = new Character((char)xml.getInt());
            }
            return o;
        }

        public XmlElement toXml(Object o) {
            if (o == null) {
                return null;
            }
            o = CharAdapter.makeInteger(((Character)o).charValue());
            return new SimpleElement(this.getXmlName(), o);
        }

        public Object fromUri(String sUri) {
            String s = CharAdapter.decodeString(sUri);
            if (s.length() != 1) {
                throw new IllegalArgumentException("Illegal character URI: " + sUri);
            }
            return new Character(s.charAt(0));
        }

        public String toUri(Object o) {
            char ch = ((Character)o).charValue();
            return CharAdapter.encodeString(new String(new char[]{ch}));
        }

        public Object readExternal(DataInput in) throws IOException {
            return new Character(in.readChar());
        }

        public void writeExternal(DataOutput out, Object o) throws IOException {
            out.writeChar(((Character)o).charValue());
        }
    }

    public static class ByteAdapter
    extends SimpleAdapter {
        public ByteAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
            super(infoBean, clzType, sName, sXml, xml);
            ByteAdapter.azzert(clzType == Byte.TYPE || clzType == (class$java$lang$Byte == null ? (class$java$lang$Byte = SimpleAdapter.class$("java.lang.Byte")) : class$java$lang$Byte));
        }

        public Object fromXml(XmlElement xml) {
            Object o = xml.getValue();
            if (o != null) {
                o = new Byte((byte)xml.getInt());
            }
            return o;
        }

        public XmlElement toXml(Object o) {
            if (o == null) {
                return null;
            }
            o = ByteAdapter.makeInteger(((Number)o).intValue());
            return new SimpleElement(this.getXmlName(), o);
        }

        public Object fromUri(String sUri) {
            return Byte.valueOf(ByteAdapter.parseNumber(sUri));
        }

        public String toUri(Object o) {
            int n = ((Number)o).intValue();
            if (n < 0) {
                return "(" + -n + ")";
            }
            return String.valueOf(n);
        }

        public Object readExternal(DataInput in) throws IOException {
            return new Byte(in.readByte());
        }

        public void writeExternal(DataOutput out, Object o) throws IOException {
            out.writeByte(((Number)o).byteValue());
        }
    }

    public static class BooleanAdapter
    extends SimpleAdapter {
        public BooleanAdapter(XmlBean.BeanInfo infoBean, Class clzType, String sName, String sXml, XmlElement xml) {
            super(infoBean, clzType, sName, sXml, xml);
            BooleanAdapter.azzert(clzType == Boolean.TYPE || clzType == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = SimpleAdapter.class$("java.lang.Boolean")) : class$java$lang$Boolean));
        }

        public Object fromXml(XmlElement xml) {
            Object o = xml.getValue();
            if (o != null) {
                o = xml.getBoolean() ? Boolean.TRUE : Boolean.FALSE;
            }
            return o;
        }

        public Object fromUri(String sUri) {
            if (sUri.equals("false")) {
                return Boolean.FALSE;
            }
            if (sUri.equals("true")) {
                return Boolean.TRUE;
            }
            throw new IllegalArgumentException("Illegal boolean value: " + sUri);
        }

        public String toUri(Object o) {
            return (Boolean)o != false ? "true" : "false";
        }

        public Object readExternal(DataInput in) throws IOException {
            return in.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
        }

        public void writeExternal(DataOutput out, Object o) throws IOException {
            out.writeBoolean((Boolean)o);
        }
    }
}

