/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.run.xml;

import com.tangosol.io.Utf8Reader;
import com.tangosol.io.Utf8Writer;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import java.io.CharArrayWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.PrintWriter;

public class SimpleDocument
extends SimpleElement
implements XmlDocument,
Externalizable {
    private String m_sDtdUri;
    private String m_sDtdName;
    private String m_sEncoding;
    private String m_sComment;

    public SimpleDocument() {
    }

    public SimpleDocument(String sName) {
        super(sName);
    }

    public SimpleDocument(String sName, String sDtdUri, String sDtdName) {
        super(sName);
        this.setDtdUri(sDtdUri);
        this.setDtdName(sDtdName);
    }

    public String getDtdUri() {
        return this.m_sDtdUri;
    }

    public void setDtdUri(String sUri) {
        this.checkMutable();
        this.m_sDtdUri = sUri;
    }

    public String getDtdName() {
        return this.m_sDtdName;
    }

    public void setDtdName(String sName) {
        this.checkMutable();
        if (sName != null && sName.length() == 0) {
            sName = null;
        }
        if (sName != null && !XmlHelper.isPublicIdentifierValid(sName)) {
            throw new IllegalArgumentException("illegal xml dtd public id: " + sName);
        }
        this.m_sDtdName = sName;
    }

    public String getEncoding() {
        return this.m_sEncoding;
    }

    public void setEncoding(String sEncoding) {
        this.checkMutable();
        if (sEncoding != null && sEncoding.length() == 0) {
            sEncoding = null;
        }
        if (sEncoding != null && !XmlHelper.isEncodingValid(sEncoding)) {
            throw new IllegalArgumentException("illegal xml document encoding: " + sEncoding);
        }
        this.m_sEncoding = sEncoding;
    }

    public String getDocumentComment() {
        return this.m_sComment;
    }

    public void setDocumentComment(String sComment) {
        this.checkMutable();
        if (sComment != null && sComment.length() == 0) {
            sComment = null;
        }
        if (sComment != null && !XmlHelper.isCommentValid(sComment)) {
            throw new IllegalArgumentException("illegal xml comment: " + sComment);
        }
        this.m_sComment = sComment;
    }

    public void writeXml(PrintWriter out, boolean fPretty) {
        String sDtdUri = this.getDtdUri();
        String sDtdName = this.getDtdName();
        String sEncoding = this.getEncoding();
        String sComment = this.getDocumentComment();
        out.print("<?xml version='1.0'");
        if (sEncoding != null && sEncoding.length() > 0) {
            out.print(" encoding=" + XmlHelper.quote(sEncoding));
        }
        out.print("?>");
        if (fPretty) {
            out.println();
        }
        if (sDtdUri != null && sDtdUri.length() > 0) {
            out.print("<!DOCTYPE " + this.getName() + ' ');
            if (sDtdName != null && sDtdName.length() > 0) {
                out.print("PUBLIC");
                if (fPretty) {
                    out.println();
                }
                out.print(' ');
                out.print(XmlHelper.quote(sDtdName));
            } else {
                out.print("SYSTEM");
            }
            if (fPretty) {
                out.println();
            }
            out.print(' ');
            out.print(XmlHelper.quote(XmlHelper.encodeUri(sDtdUri)));
            out.print('>');
            if (fPretty) {
                out.println();
            } else {
                out.print(' ');
            }
        }
        if (sComment != null && sComment.length() > 0) {
            out.print("<!--");
            if (fPretty) {
                out.println();
                out.println(SimpleDocument.breakLines(sComment, 78, ""));
            } else {
                out.print(sComment);
            }
            out.print("-->");
            if (fPretty) {
                out.println();
            } else {
                out.print(' ');
            }
        }
        super.writeXml(out, fPretty);
        if (fPretty) {
            out.println();
        }
    }

    public int hashCode() {
        int n = super.hashCode();
        String sUri = this.getDtdUri();
        if (sUri != null && sUri.length() > 0) {
            n ^= sUri.hashCode();
            String sName = this.getDtdName();
            if (sName != null && sName.length() > 0) {
                n ^= sName.hashCode();
            }
        }
        return n;
    }

    public boolean equals(Object o) {
        if (o instanceof XmlDocument) {
            XmlDocument that = (XmlDocument)o;
            if (!super.equals(that)) {
                return false;
            }
            return SimpleDocument.equals(this.getDtdUri(), that.getDtdUri()) && SimpleDocument.equals(this.getDtdName(), that.getDtdName()) && SimpleDocument.equals(this.getEncoding(), that.getEncoding()) && SimpleDocument.equals(this.getDocumentComment(), that.getDocumentComment());
        }
        return false;
    }

    public Object clone() {
        return super.clone();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        CharArrayWriter cw = new CharArrayWriter(1024);
        PrintWriter pw = new PrintWriter(cw);
        this.writeXml(pw, false);
        pw.flush();
        out.writeInt(cw.size());
        cw.writeTo(new Utf8Writer((OutputStream)((Object)out)));
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int cchBlock;
        int cch = in.readInt();
        char[] ach = new char[cch];
        Utf8Reader reader = new Utf8Reader((InputStream)((Object)in));
        for (int of = 0; of < cch; of += cchBlock) {
            cchBlock = reader.read(ach, of, cch - of);
            if (cchBlock >= 0) continue;
            throw new EOFException();
        }
        XmlHelper.loadXml(new String(ach), this);
    }

    public void readExternal(DataInput in) throws IOException {
        if (this.m_sDtdUri != null || this.m_sDtdName != null || this.m_sEncoding != null || this.m_sComment != null) {
            throw new NotActiveException();
        }
        super.readExternal(in);
        if (in.readBoolean()) {
            this.m_sDtdUri = SimpleDocument.readUTF(in);
        }
        if (in.readBoolean()) {
            this.m_sDtdName = SimpleDocument.readUTF(in);
        }
        if (in.readBoolean()) {
            this.m_sEncoding = SimpleDocument.readUTF(in);
        }
        if (in.readBoolean()) {
            this.m_sComment = SimpleDocument.readUTF(in);
        }
    }

    public void writeExternal(DataOutput out) throws IOException {
        super.writeExternal(out);
        String sDtdUri = this.m_sDtdUri;
        String sDtdName = this.m_sDtdName;
        String sEncoding = this.m_sEncoding;
        String sComment = this.m_sComment;
        boolean fDtdUri = sDtdUri != null;
        boolean fDtdName = sDtdName != null;
        boolean fEncoding = sEncoding != null;
        boolean fComment = sComment != null;
        out.writeBoolean(fDtdUri);
        if (fDtdUri) {
            SimpleDocument.writeUTF(out, this.m_sDtdUri);
        }
        out.writeBoolean(fDtdName);
        if (fDtdName) {
            SimpleDocument.writeUTF(out, this.m_sDtdName);
        }
        out.writeBoolean(fEncoding);
        if (fEncoding) {
            SimpleDocument.writeUTF(out, this.m_sEncoding);
        }
        out.writeBoolean(fComment);
        if (fComment) {
            SimpleDocument.writeUTF(out, this.m_sComment);
        }
    }

    public XmlElement toXml() {
        return super.toXml();
    }

    public void fromXml(XmlElement xml) {
        super.fromXml(xml);
        if (xml instanceof XmlDocument) {
            XmlDocument xmlDoc = (XmlDocument)xml;
            this.m_sDtdUri = xmlDoc.getDtdUri();
            this.m_sDtdName = xmlDoc.getDtdName();
            this.m_sEncoding = xmlDoc.getEncoding();
            this.m_sComment = xmlDoc.getComment();
        }
    }

    protected void checkMutable() {
        if (!this.isMutable()) {
            throw new UnsupportedOperationException("document \"" + this.getName() + "\" is not mutable");
        }
    }
}

