/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.run.xml;

import com.tangosol.io.Base64InputStream;
import com.tangosol.io.Base64OutputStream;
import com.tangosol.run.xml.SimpleParser;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlSerializable;
import com.tangosol.run.xml.XmlValue;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.Filter;
import com.tangosol.util.FilterEnumerator;
import com.tangosol.util.WrapperException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class XmlHelper
extends Base {
    private static final char[] HEX = "0123456789ABCDEF".toCharArray();

    public static XmlDocument loadXml(Class clz) {
        return XmlHelper.loadXml(clz, null);
    }

    public static XmlDocument loadXml(Class clz, String sCharset) {
        String sName = clz.getName();
        sName = sName.substring(sName.lastIndexOf(46) + 1);
        return XmlHelper.loadXml(clz, sName + ".xml", sCharset);
    }

    public static XmlDocument loadXml(Class clz, String sName, String sCharset) {
        InputStream stream = clz.getResourceAsStream(sName);
        if (stream == null) {
            return null;
        }
        return sCharset == null ? XmlHelper.loadXml(stream) : XmlHelper.loadXml(stream, sCharset);
    }

    public static XmlDocument loadXml(InputStream stream) {
        try {
            return new SimpleParser().parseXml(stream);
        }
        catch (IOException e) {
            throw new WrapperException(e);
        }
    }

    public static XmlDocument loadXml(InputStream stream, String sCharset) {
        try {
            return new SimpleParser().parseXml(stream, sCharset);
        }
        catch (IOException e) {
            throw new WrapperException(e);
        }
    }

    public static XmlDocument loadXml(String sXml) {
        try {
            return new SimpleParser().parseXml(sXml);
        }
        catch (IOException e) {
            throw new WrapperException(e);
        }
    }

    public static void loadXml(String sXml, XmlDocument xmlRoot) {
        try {
            new SimpleParser().parseXml(sXml, xmlRoot);
        }
        catch (IOException e) {
            throw new WrapperException(e);
        }
    }

    public static boolean isEncodingValid(String sEncoding) {
        if (sEncoding == null) {
            return false;
        }
        char[] ach = sEncoding.toCharArray();
        int cch = ach.length;
        if (cch == 0) {
            return false;
        }
        char ch = ach[0];
        if (!(ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z')) {
            return false;
        }
        block3: for (int of = 1; of < cch; ++of) {
            ch = ach[of];
            switch (ch) {
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isSystemIdentifierValid(String sName) {
        return true;
    }

    public static boolean isPublicIdentifierValid(String sName) {
        char[] ach = sName.toCharArray();
        int cch = ach.length;
        block3: for (int of = 0; of < cch; ++of) {
            switch (ach[of]) {
                case '\n': 
                case '\r': 
                case ' ': 
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case ':': 
                case ';': 
                case '=': 
                case '?': 
                case '@': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isCommentValid(String sComment) {
        return sComment.indexOf("--") == -1;
    }

    public static boolean isNameValid(String sName) {
        if (sName == null) {
            return false;
        }
        char[] ach = sName.toCharArray();
        int cch = ach.length;
        if (cch == 0) {
            return false;
        }
        char ch = ach[0];
        if (!Character.isLetter(ch) && ch != '_' && ch != ':') {
            return false;
        }
        block3: for (int of = 1; of < cch; ++of) {
            ch = ach[of];
            switch (ch) {
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case ':': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    continue block3;
                }
                default: {
                    if (Character.isLetter(ch) || Character.isDigit(ch)) continue block3;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isWhitespace(char ch) {
        switch (ch) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public static String trim(String s) {
        int ofStart;
        char[] ach = s.toCharArray();
        int cch = ach.length;
        int ofEnd = cch;
        for (ofStart = 0; ofStart < cch && XmlHelper.isWhitespace(ach[ofStart]); ++ofStart) {
        }
        if (ofStart >= cch) {
            return "";
        }
        while (XmlHelper.isWhitespace(ach[ofEnd - 1])) {
            --ofEnd;
        }
        return ofStart > 0 || ofEnd < cch ? s.substring(ofStart, ofEnd) : s;
    }

    public static String trimf(String s) {
        int of;
        char[] ach = s.toCharArray();
        int cch = ach.length;
        for (of = 0; of < cch && XmlHelper.isWhitespace(ach[of]); ++of) {
        }
        if (of >= cch) {
            return "";
        }
        if (of == 0) {
            return s;
        }
        return s.substring(of);
    }

    public static String trimb(String s) {
        int of;
        char[] ach = s.toCharArray();
        int cch = ach.length;
        for (of = cch - 1; of >= 0 && XmlHelper.isWhitespace(ach[of]); --of) {
        }
        if (of < 0) {
            return "";
        }
        if (of == cch - 1) {
            return s;
        }
        return s.substring(0, of + 1);
    }

    public static String encodeAttribute(String sValue, char chQuote) {
        XmlHelper.azzert(chQuote == '\'' || chQuote == '\"', "Invalid quote character");
        char[] ach = sValue.toCharArray();
        int cch = ach.length;
        if (cch == 0) {
            return sValue;
        }
        StringBuffer sb = null;
        int ofPrev = 0;
        block11: for (int of = 0; of < cch; ++of) {
            char ch = ach[of];
            switch (ch) {
                case '\"': 
                case '\'': {
                    if (ch != chQuote) continue block11;
                }
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': 
                case '&': 
                case '<': 
                case '>': {
                    if (sb == null) {
                        sb = new StringBuffer(cch + 16);
                    }
                    if (of > ofPrev) {
                        sb.append(ach, ofPrev, of - ofPrev);
                    }
                    switch (ch) {
                        case '>': {
                            sb.append("&gt;");
                            break;
                        }
                        case '<': {
                            sb.append("&lt;");
                            break;
                        }
                        case '&': {
                            sb.append("&amp;");
                            break;
                        }
                        case '\'': {
                            sb.append("&apos;");
                            break;
                        }
                        case '\"': {
                            sb.append("&quot;");
                            break;
                        }
                        default: {
                            sb.append("&#x");
                            char n = ch;
                            if ((n & 0xF000) != 0) {
                                sb.append(HEX[n >>> 24]);
                            }
                            if ((n & 0xFF00) != 0) {
                                sb.append(HEX[n >>> 16 & 0xF]);
                            }
                            if ((n & 0xFFF0) != 0) {
                                sb.append(HEX[n >>> 8 & 0xF]);
                            }
                            sb.append(HEX[n & 0xF]);
                            sb.append(';');
                        }
                    }
                    ofPrev = of + 1;
                }
            }
        }
        if (sb != null && ofPrev < cch) {
            sb.append(ach, ofPrev, cch - ofPrev);
        }
        return sb == null ? sValue : sb.toString();
    }

    public static String decodeAttribute(String sValue) {
        if (sValue.indexOf(38) == -1) {
            return sValue;
        }
        char[] ach = sValue.toCharArray();
        int cch = ach.length;
        StringBuffer sb = new StringBuffer(cch);
        int ofPrev = 0;
        for (int of = 0; of < cch; ++of) {
            int ofSemi;
            if (ach[of] != '&') continue;
            for (ofSemi = of + 1; ofSemi < cch && ach[ofSemi] != ';'; ++ofSemi) {
            }
            if (ofSemi >= cch || ofSemi == of + 1) {
                throw new IllegalArgumentException("The XML attribute (" + sValue + ") contains an unescaped '&'");
            }
            if (of > ofPrev) {
                sb.append(ach, ofPrev, of - ofPrev);
                ofPrev = of;
            }
            if (ach[of + 1] == '#') {
                boolean fHex = ach[of + 2] == 'x';
                String sEsc = sValue.substring(of + (fHex ? 3 : 2), ofSemi);
                try {
                    if (sEsc.length() < 1) {
                        throw new IllegalArgumentException("not a number");
                    }
                    int n = Integer.parseInt(sEsc, fHex ? 16 : 10);
                    if (n < 0 || n > 65535) {
                        throw new IllegalArgumentException("out of range");
                    }
                    sb.append((char)n);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("The XML attribute (" + sValue + ") contains an illegal escape (" + (fHex ? "hex" : "decimal") + ' ' + sEsc + ')');
                }
            } else {
                String sEsc = sValue.substring(of + 1, ofSemi);
                if (sEsc.equals("amp")) {
                    sb.append('&');
                } else if (sEsc.equals("apos")) {
                    sb.append('\'');
                } else if (sEsc.equals("gt")) {
                    sb.append('>');
                } else if (sEsc.equals("lt")) {
                    sb.append('<');
                } else {
                    if (!sEsc.equals("quot")) continue;
                    sb.append('\"');
                }
            }
            of = ofSemi;
            ofPrev = of + 1;
        }
        if (ofPrev < cch) {
            sb.append(ach, ofPrev, cch - ofPrev);
        }
        return sb.toString();
    }

    public static String encodeContent(String sValue, boolean fPreferBlockEscape) {
        int cchNonWhite;
        int of;
        char[] ach = sValue.toCharArray();
        int cch = ach.length;
        if (cch == 0) {
            return sValue;
        }
        if (fPreferBlockEscape) {
            boolean fUseCdataEscape = true;
            boolean fRequiresEscape = XmlHelper.isWhitespace(ach[0]) || XmlHelper.isWhitespace(ach[cch - 1]);
            block26: for (int of2 = 0; of2 < cch; ++of2) {
                char nch = ach[of2];
                switch (nch) {
                    case '&': 
                    case '<': {
                        fRequiresEscape = true;
                        continue block26;
                    }
                    case ']': {
                        if (of2 + 2 >= cch || ach[of2 + 1] != ']' || ach[of2 + 2] != '>') continue block26;
                        fUseCdataEscape = false;
                    }
                }
            }
            if (!fRequiresEscape) {
                return sValue;
            }
            if (fUseCdataEscape) {
                return "<![CDATA[" + sValue + "]]>";
            }
        }
        StringBuffer sb = new StringBuffer(cch + 16);
        block27: for (of = 0; of < cch; ++of) {
            switch (ach[of]) {
                case '\t': {
                    sb.append("&#x09;");
                    continue block27;
                }
                case '\n': {
                    sb.append("&#x0A;");
                    continue block27;
                }
                case '\r': {
                    sb.append("&#x0D;");
                    continue block27;
                }
                case ' ': {
                    sb.append("&#x20;");
                    continue block27;
                }
            }
        }
        for (cchNonWhite = cch; cchNonWhite > of && XmlHelper.isWhitespace(ach[cchNonWhite - 1]); --cchNonWhite) {
        }
        int ofPrev = of;
        int cBrackets = 0;
        while (of < cchNonWhite) {
            char ch = ach[of];
            switch (ch) {
                case ']': {
                    ++cBrackets;
                    break;
                }
                case '>': {
                    if (cBrackets < 2) {
                        cBrackets = 0;
                        break;
                    }
                }
                case '&': 
                case '<': {
                    if (of > ofPrev) {
                        sb.append(ach, ofPrev, of - ofPrev);
                    }
                    switch (ch) {
                        case '>': {
                            sb.append("&gt;");
                            break;
                        }
                        case '<': {
                            sb.append("&lt;");
                            break;
                        }
                        case '&': {
                            sb.append("&amp;");
                            break;
                        }
                        default: {
                            XmlHelper.azzert();
                        }
                    }
                    ofPrev = of + 1;
                    cBrackets = 0;
                    break;
                }
                default: {
                    cBrackets = 0;
                }
            }
            ++of;
        }
        if (ofPrev < cchNonWhite) {
            sb.append(ach, ofPrev, cchNonWhite - ofPrev);
        }
        while (of < cch) {
            switch (ach[of]) {
                case '\t': {
                    sb.append("&#x09;");
                    break;
                }
                case '\n': {
                    sb.append("&#x0A;");
                    break;
                }
                case '\r': {
                    sb.append("&#x0D;");
                    break;
                }
                case ' ': {
                    sb.append("&#x20;");
                    break;
                }
                default: {
                    XmlHelper.azzert();
                }
            }
            ++of;
        }
        return sb.toString();
    }

    public static String decodeContent(String sValue) {
        return XmlHelper.decodeAttribute(sValue);
    }

    public static String encodeUri(String sUri) {
        int ofPrev;
        char[] ach = sUri.toCharArray();
        int cch = ach.length;
        boolean fEsc = false;
        block8: for (int of = 0; of < cch; ++of) {
            char ch = ach[of];
            switch (ch) {
                case ' ': 
                case '\"': 
                case '%': 
                case '\'': 
                case '<': 
                case '>': 
                case '\\': 
                case '^': 
                case '`': 
                case '{': 
                case '|': 
                case '}': {
                    fEsc = true;
                    break block8;
                }
                default: {
                    if (ch > '\u001f' && ch < '\u007f') continue block8;
                    fEsc = true;
                    break block8;
                }
            }
        }
        if (!fEsc) {
            return sUri;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream(cch + 32);
        try {
            new DataOutputStream(stream).writeUTF(sUri);
        }
        catch (IOException e) {
            throw XmlHelper.ensureRuntimeException(e);
        }
        ach = stream.toString(0).toCharArray();
        cch = ach.length;
        StringBuffer sb = new StringBuffer(cch + 32);
        block9: for (int ofCur = ofPrev = 2; ofCur < cch; ++ofCur) {
            char ch = ach[ofCur];
            switch (ch) {
                default: {
                    if (ch > '\u001f' && ch < '\u007f') continue block9;
                }
                case ' ': 
                case '\"': 
                case '%': 
                case '\'': 
                case '<': 
                case '>': 
                case '\\': 
                case '^': 
                case '`': 
                case '{': 
                case '|': 
                case '}': {
                    if (ofCur > ofPrev) {
                        sb.append(ach, ofPrev, ofCur - ofPrev);
                    }
                    sb.append('%').append(XmlHelper.toHex(ch));
                    ofPrev = ofCur + 1;
                }
            }
        }
        if (sb != null && ofPrev < cch) {
            sb.append(ach, ofPrev, cch - ofPrev);
        }
        return sb.toString();
    }

    public static String decodeUri(String sUri) {
        String sOrig = sUri;
        if (sUri.indexOf(37) != -1) {
            char[] ach = sUri.toCharArray();
            int cch = ach.length;
            StringBuffer sb = new StringBuffer(cch + 16);
            int ofPrev = 0;
            for (int of = 0; of < cch; ++of) {
                if (ach[of] != '%') continue;
                if (of + 2 >= cch) {
                    throw new IllegalArgumentException("The URI (" + sOrig + ") contains an unescaped '%'");
                }
                if (of > ofPrev) {
                    sb.append(ach, ofPrev, of - ofPrev);
                }
                try {
                    int n = Integer.parseInt(sUri.substring(of + 1, of + 3), 16);
                    if (n < 0 || n > 255) {
                        throw new IllegalArgumentException("out of range");
                    }
                    sb.append((char)n);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("The URI (" + sOrig + ") contains an illegal escape");
                }
                ofPrev = (of += 2) + 1;
            }
            if (ofPrev < cch) {
                sb.append(ach, ofPrev, cch - ofPrev);
            }
            sUri = sb.toString();
        }
        int cch = sUri.length();
        int cb = cch + 2;
        byte[] ab = new byte[cb];
        ab[0] = (byte)(cch >>> 8 & 0xFF);
        ab[1] = (byte)(cch & 0xFF);
        sUri.getBytes(0, cch, ab, 2);
        try {
            return new DataInputStream(new ByteArrayInputStream(ab)).readUTF();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid URI: " + sUri);
        }
    }

    public static String quote(String s) {
        return '\'' + XmlHelper.encodeAttribute(s, '\'') + '\'';
    }

    public static String getAbsolutePath(XmlElement xml) {
        XmlHelper.azzert(xml != null, "Null element");
        StringBuffer sb = new StringBuffer();
        do {
            sb.insert(0, "/" + xml.getName());
        } while ((xml = xml.getParent()) != null);
        return sb.toString();
    }

    public static boolean isEmpty(XmlElement xml) {
        if (!xml.isEmpty()) {
            return false;
        }
        Map mapAttr = xml.getAttributeMap();
        if (!mapAttr.isEmpty()) {
            return false;
        }
        List listEl = xml.getElementList();
        if (!listEl.isEmpty()) {
            return false;
        }
        Iterator iter = listEl.iterator();
        while (iter.hasNext()) {
            XmlElement xmlEl = (XmlElement)iter.next();
            if (XmlHelper.isEmpty(xmlEl)) continue;
            return false;
        }
        return true;
    }

    public static XmlElement getElement(XmlElement xml, String sName) {
        XmlHelper.azzert(xml != null && sName != null && XmlHelper.isNameValid(sName), "Null element or invalid name");
        List list = xml.getElementList();
        if (list.isEmpty()) {
            return null;
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            xml = (XmlElement)iter.next();
            if (!xml.getName().equals(sName)) continue;
            return xml;
        }
        return null;
    }

    public static XmlElement findElement(XmlElement xml, String sPath) {
        XmlHelper.azzert(xml != null && sPath != null, "Null element or path");
        if (sPath.startsWith("/")) {
            xml = xml.getRoot();
        }
        StringTokenizer tokens = new StringTokenizer(sPath, "/");
        while (xml != null && tokens.hasMoreTokens()) {
            String sName = tokens.nextToken();
            if (sName.equals("..")) {
                if ((xml = xml.getParent()) != null) continue;
                throw new IllegalArgumentException("Invalid path " + sPath);
            }
            xml = xml.getElement(sName);
        }
        return xml;
    }

    public static XmlElement findElement(XmlElement xml, String sPath, Object oValue) {
        String sName;
        XmlHelper.azzert(xml != null && sPath != null, "Null element or path");
        while (sPath.startsWith("/")) {
            xml = xml.getRoot();
            sPath = sPath.substring(1);
        }
        int ofNext = sPath.indexOf("/");
        if (ofNext == -1) {
            sName = sPath;
            sPath = "";
        } else {
            sName = sPath.substring(0, ofNext);
            sPath = sPath.substring(ofNext + 1);
            while (sPath.startsWith("/")) {
                sPath = sPath.substring(1);
            }
        }
        if (sPath.length() == 0) {
            if (sName.equals("..")) {
                return (xml = xml.getParent()) != null && XmlHelper.equals(xml.getValue(), oValue) ? xml : null;
            }
            Iterator iter = xml.getElements(sName);
            while (iter.hasNext()) {
                xml = (XmlElement)iter.next();
                if (!XmlHelper.equals(xml.getValue(), oValue)) continue;
                return xml;
            }
            return null;
        }
        if (sName.equals("..")) {
            return (xml = xml.getParent()) == null ? null : XmlHelper.findElement(xml, sPath, oValue);
        }
        Iterator iter = xml.getElements(sName);
        while (iter.hasNext()) {
            xml = XmlHelper.findElement((XmlElement)iter.next(), sPath, oValue);
            if (xml == null) continue;
            return xml;
        }
        return null;
    }

    public static XmlElement ensureElement(XmlElement xml, String sPath) {
        XmlHelper.azzert(xml != null && sPath != null, "Null element or path");
        if (sPath.startsWith("/")) {
            xml = xml.getRoot();
        }
        StringTokenizer tokens = new StringTokenizer(sPath, "/");
        while (tokens.hasMoreTokens()) {
            String sName = tokens.nextToken();
            if (sName.equals("..")) {
                if ((xml = xml.getParent()) != null) continue;
                throw new IllegalArgumentException("Invalid path " + sPath);
            }
            XmlElement child = xml.getElement(sName);
            xml = child == null ? xml.addElement(sName) : child;
        }
        return xml;
    }

    public static void addElements(XmlElement xml, Iterator iter) {
        List list = xml.getElementList();
        while (iter.hasNext()) {
            list.add((XmlElement)iter.next());
        }
    }

    public static int removeElement(XmlElement xml, String sName) {
        int cnt = 0;
        Iterator iter = xml.getElementList().iterator();
        while (iter.hasNext()) {
            xml = (XmlElement)iter.next();
            if (!xml.getName().equals(sName)) continue;
            iter.remove();
            ++cnt;
        }
        return cnt;
    }

    public static boolean replaceElement(XmlElement xmlParent, XmlElement xmlReplace) {
        List list = xmlParent.getElementList();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            XmlElement xml = (XmlElement)iter.next();
            if (!xml.getName().equals(xmlReplace.getName())) continue;
            list.set(list.indexOf(xml), xmlReplace.clone());
            return true;
        }
        list.add(xmlReplace.clone());
        return false;
    }

    public static void overrideElement(XmlElement xmlBase, XmlElement xmlOverride) {
        Iterator iterOver = xmlOverride.getElementList().iterator();
        while (iterOver.hasNext()) {
            XmlElement xmlOver = (XmlElement)iterOver.next();
            if (XmlHelper.isEmpty(xmlOver)) continue;
            String sName = xmlOver.getName();
            Iterator iter = xmlOverride.getElements(sName);
            while (iter.hasNext()) {
                XmlElement xmlTest = (XmlElement)iter.next();
                if (xmlTest == xmlOver || !((Object)xmlTest.getAttributeMap()).equals(xmlOver.getAttributeMap())) continue;
                throw new UnsupportedOperationException("Override element is not unique:\n" + xmlOver);
            }
            XmlValue xmlMatch = null;
            Iterator iterBase = xmlBase.getElements(sName);
            while (iterBase.hasNext()) {
                XmlElement xmlTest = (XmlElement)iterBase.next();
                if (!((Object)xmlOver.getAttributeMap()).equals(xmlTest.getAttributeMap())) continue;
                if (xmlMatch == null) {
                    xmlMatch = xmlTest;
                    continue;
                }
                throw new UnsupportedOperationException("Override element is ambiguous:\n" + xmlOver);
            }
            if (xmlMatch == null) {
                xmlBase.getElementList().add(xmlOver.clone());
                continue;
            }
            if (xmlOver.getValue() != null) {
                xmlMatch.setString(xmlOver.getString());
            }
            XmlHelper.overrideElement(xmlMatch, xmlOver);
        }
    }

    public static void replaceSystemProperties(XmlElement xml, String sPropertyAttribute) {
        XmlValue attr = xml.getAttribute(sPropertyAttribute);
        if (attr != null) {
            xml.setAttribute(sPropertyAttribute, null);
            try {
                String sValue = System.getProperty(attr.getString());
                if (sValue != null) {
                    xml.setString(sValue);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Iterator iter = xml.getElementList().iterator();
        while (iter.hasNext()) {
            XmlHelper.replaceSystemProperties((XmlElement)iter.next(), sPropertyAttribute);
        }
    }

    public static String getNamespaceUri(XmlElement xml, String sPrefix) {
        String sAttrName = "xmlns:" + sPrefix;
        while (xml != null) {
            XmlValue attrXmlns = xml.getAttribute(sAttrName);
            if (attrXmlns != null) {
                return attrXmlns.getString();
            }
            xml = xml.getParent();
        }
        return null;
    }

    public static String getNamespacePrefix(XmlElement xml, String sUri) {
        while (xml != null) {
            Iterator iter = xml.getAttributeMap().entrySet().iterator();
            while (iter.hasNext()) {
                String sAttr;
                Map.Entry entry = iter.next();
                if (!sUri.equals(((XmlValue)entry.getValue()).getString()) || !(sAttr = (String)entry.getKey()).startsWith("xmlns:")) continue;
                return sAttr.substring(6);
            }
            xml = xml.getParent();
        }
        return null;
    }

    public static void ensureNamespace(XmlElement xml, String sPrefix, String sUri) {
        String sNmsUri = XmlHelper.getNamespaceUri(xml, sPrefix);
        if (sNmsUri == null) {
            xml.addAttribute("xmlns:" + sPrefix).setString(sUri);
        } else if (!sNmsUri.equals(sUri)) {
            throw new IllegalStateException("Namespace conflict: prefix=" + sPrefix + ", current URI=" + sNmsUri + ", new URI=" + sUri);
        }
    }

    public static String getUniversalName(String sLocal, String sPrefix) {
        return sPrefix == null || sLocal == null || sLocal.length() == 0 ? sLocal : sPrefix + ':' + sLocal;
    }

    public static boolean isNameMatch(XmlElement xml, String sName, String sLocal, String sUri) {
        if (sUri == null) {
            return sName.equals(sLocal);
        }
        String sSuffix = ':' + sLocal;
        if (sName.endsWith(sSuffix)) {
            String sPrefix = sName.substring(0, sName.length() - sSuffix.length());
            return sUri.equals(XmlHelper.getNamespaceUri(xml, sPrefix));
        }
        return sName.equals(sLocal);
    }

    public static boolean isElementMatch(XmlElement xml, String sLocal, String sUri) {
        return XmlHelper.isNameMatch(xml, xml.getName(), sLocal, sUri);
    }

    public static XmlElement getElement(XmlElement xml, String sLocal, String sUri) {
        if (sUri == null) {
            return xml.getElement(sLocal);
        }
        Iterator iter = xml.getElementList().iterator();
        while (iter.hasNext()) {
            XmlElement el = (XmlElement)iter.next();
            if (!XmlHelper.isElementMatch(el, sLocal, sUri)) continue;
            return el;
        }
        return null;
    }

    public static XmlValue getAttribute(XmlElement xml, String sLocal, String sUri) {
        if (sUri == null) {
            return xml.getAttribute(sLocal);
        }
        Iterator iter = xml.getAttributeMap().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String sAttr = (String)entry.getKey();
            if (!XmlHelper.isNameMatch(xml, sAttr, sLocal, sUri)) continue;
            return (XmlValue)entry.getValue();
        }
        return null;
    }

    public static Iterator getElements(XmlElement xml, final String sLocal, final String sUri) {
        if (sUri == null) {
            return xml.getElements(sLocal);
        }
        Filter filter = new Filter(){

            public boolean evaluate(Object o) {
                return o instanceof XmlElement && XmlHelper.isElementMatch((XmlElement)o, sLocal, sUri);
            }
        };
        return new FilterEnumerator(xml.getElementList().iterator(), filter);
    }

    public static void purgeNamespace(XmlElement xml) {
        XmlElement xmlParent = xml.getParent();
        if (xmlParent == null) {
            return;
        }
        Iterator iter = xml.getAttributeMap().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String sAttr = (String)entry.getKey();
            if (!sAttr.startsWith("xmlns:")) continue;
            String sPrefix = sAttr.substring(6);
            String sUri = ((XmlValue)entry.getValue()).getString();
            if (!sUri.equals(XmlHelper.getNamespaceUri(xmlParent, sPrefix))) continue;
            iter.remove();
        }
    }

    public static void purgeChildrenNamespace(XmlElement xml) {
        Iterator iter = xml.getElementList().iterator();
        while (iter.hasNext()) {
            XmlHelper.purgeNamespace((XmlElement)iter.next());
        }
    }

    public static Object[] parseInitParams(XmlElement xmlParams) {
        return XmlHelper.parseInitParams(xmlParams, null);
    }

    public static Object[] parseInitParams(XmlElement xmlParams, ParameterResolver resolver) {
        ArrayList<Object> listParam = new ArrayList<Object>();
        Iterator iter = xmlParams.getElements("init-param");
        while (iter.hasNext()) {
            XmlElement xmlParam = (XmlElement)iter.next();
            String sType = xmlParam.getSafeElement("param-type").getString();
            XmlElement xmlValue = xmlParam.getSafeElement("param-value");
            String sValue = xmlValue.getString();
            if (resolver != null && sValue.indexOf(123) >= 0 && sValue.lastIndexOf(125) > sValue.indexOf(123)) {
                listParam.add(resolver.resolveParameter(sType, sValue));
                continue;
            }
            if (sType.length() == 0) {
                throw new RuntimeException("missing parameter type:\n" + xmlParam);
            }
            if (sType.equalsIgnoreCase("string") || sType.equals("java.lang.String")) {
                listParam.add(sValue);
                continue;
            }
            if (sType.equals("int") || sType.equals("java.lang.Integer")) {
                listParam.add(XmlHelper.makeInteger(xmlValue.getInt()));
                continue;
            }
            if (sType.equals("long") || sType.equals("java.lang.Long")) {
                listParam.add(XmlHelper.makeLong(xmlValue.getLong()));
                continue;
            }
            if (sType.equals("boolean") || sType.equals("java.lang.Boolean")) {
                listParam.add(xmlValue.getBoolean());
                continue;
            }
            if (sType.equals("double") || sType.equals("java.lang.Double")) {
                listParam.add(new Double(xmlValue.getDouble()));
                continue;
            }
            if (sType.equals("float") || sType.equals("java.lang.Float")) {
                listParam.add(new Float(xmlValue.getDouble()));
                continue;
            }
            if (sType.equals("decimal") || sType.equals("java.math.BigDecimal")) {
                listParam.add(xmlValue.getDecimal());
                continue;
            }
            if (sType.equals("file") || sType.equals("java.io.File")) {
                listParam.add(new File(xmlValue.getString()));
                continue;
            }
            if (sType.equals("date") || sType.equals("java.sql.Date")) {
                listParam.add(xmlValue.getDate());
                continue;
            }
            if (sType.equals("time") || sType.equals("java.sql.Time")) {
                listParam.add(xmlValue.getTime());
                continue;
            }
            if (sType.equals("datetime") || sType.equals("java.sql.Timestamp")) {
                listParam.add(xmlValue.getDateTime());
                continue;
            }
            if (sType.equals("xml") || sType.equals("com.tangosol.run.xml.XmlElement")) {
                listParam.add(xmlValue.clone());
                continue;
            }
            listParam.add(xmlParam.clone());
        }
        return listParam.toArray();
    }

    public static void transformInitParams(XmlElement xmlParent, XmlElement xmlParams) {
        Iterator iter = xmlParams.getElements("init-param");
        while (iter.hasNext()) {
            XmlElement xmlParam = (XmlElement)iter.next();
            String sName = xmlParam.getSafeElement("param-name").getString();
            String sValue = xmlParam.getSafeElement("param-value").getString();
            if (sName.length() == 0) continue;
            xmlParent.ensureElement(sName).setString(sValue);
        }
    }

    public static int hashElement(XmlElement xml) {
        int n = XmlHelper.hashValue(xml);
        Iterator iter = xml.getAttributeMap().entrySet().iterator();
        while (iter.hasNext()) {
            n ^= ((Object)iter.next()).hashCode();
        }
        iter = xml.getElementList().iterator();
        while (iter.hasNext()) {
            n ^= ((Object)iter.next()).hashCode();
        }
        return n;
    }

    public static int hashValue(XmlValue val) {
        Object o = val.getValue();
        if (o == null) {
            return 0;
        }
        String s = o instanceof String ? (String)o : (String)XmlHelper.convert(o, 6);
        return s.hashCode();
    }

    public static boolean equalsElement(XmlElement xml1, XmlElement xml2) {
        XmlHelper.azzert(xml1 != null && xml2 != null, "Null element");
        if (!XmlHelper.equals(xml1.getName(), xml2.getName())) {
            return false;
        }
        if (!XmlHelper.equals(xml1.getComment(), xml2.getComment())) {
            return false;
        }
        if (!XmlHelper.equalsValue(xml1, xml2)) {
            return false;
        }
        if (!XmlHelper.equals(xml1.getAttributeMap(), xml2.getAttributeMap())) {
            return false;
        }
        return XmlHelper.equals(xml1.getElementList(), xml2.getElementList());
    }

    public static boolean equalsValue(XmlValue val1, XmlValue val2) {
        XmlHelper.azzert(val1 != null && val2 != null, "Null value");
        boolean fEmpty1 = val1.isEmpty();
        boolean fEmpty2 = val2.isEmpty();
        if (fEmpty1 || fEmpty2) {
            return fEmpty1 && fEmpty2;
        }
        Object o1 = val1.getValue();
        Object o2 = val2.getValue();
        XmlHelper.azzert(o1 != null && o2 != null);
        if (o1.getClass() == o2.getClass()) {
            return o1.equals(o2);
        }
        return XmlHelper.convert(o1, 6).equals(XmlHelper.convert(o2, 6));
    }

    public static String toString(XmlSerializable xml) {
        CharArrayWriter writer = new CharArrayWriter();
        PrintWriter out = new PrintWriter(writer);
        xml.toXml().writeXml(out, true);
        out.flush();
        out.close();
        return ((Object)writer).toString();
    }

    public static Object convert(Object o, int nType) {
        if (o == null) {
            return null;
        }
        switch (nType) {
            case 1: {
                if (o instanceof Boolean) {
                    return o;
                }
                String s = (String)XmlHelper.convert(o, 6);
                if (s != null && s.length() > 0) {
                    switch (XmlHelper.trim(s).charAt(0)) {
                        case 'T': 
                        case 'Y': 
                        case 't': 
                        case 'y': {
                            return Boolean.TRUE;
                        }
                        case '1': {
                            if (s.length() != 1) break;
                            return Boolean.TRUE;
                        }
                        case 'F': 
                        case 'N': 
                        case 'f': 
                        case 'n': {
                            return Boolean.FALSE;
                        }
                        case '0': {
                            if (s.length() != 1) break;
                            return Boolean.FALSE;
                        }
                    }
                }
                return null;
            }
            case 2: {
                if (o instanceof Integer) {
                    return o;
                }
                String s = (String)XmlHelper.convert(o, 6);
                if (s != null && s.length() > 0) {
                    try {
                        return Integer.valueOf(XmlHelper.trim(s));
                    }
                    catch (RuntimeException e) {
                        // empty catch block
                    }
                }
                return null;
            }
            case 3: {
                if (o instanceof Long) {
                    return o;
                }
                String s = (String)XmlHelper.convert(o, 6);
                if (s != null && s.length() > 0) {
                    try {
                        return Long.valueOf(XmlHelper.trim(s));
                    }
                    catch (RuntimeException e) {
                        // empty catch block
                    }
                }
                return null;
            }
            case 4: {
                if (o instanceof Double) {
                    return o;
                }
                String s = (String)XmlHelper.convert(o, 6);
                if (s != null && s.length() > 0) {
                    try {
                        return Double.valueOf(XmlHelper.trim(s));
                    }
                    catch (RuntimeException e) {
                        // empty catch block
                    }
                }
                return null;
            }
            case 5: {
                if (o instanceof BigDecimal) {
                    return o;
                }
                String s = (String)XmlHelper.convert(o, 6);
                if (s != null && s.length() > 0) {
                    try {
                        return new BigDecimal(XmlHelper.trim(s));
                    }
                    catch (RuntimeException e) {
                        // empty catch block
                    }
                }
                return null;
            }
            case 6: {
                if (o instanceof String) {
                    return o;
                }
                if (o instanceof Binary) {
                    Binary bin = (Binary)o;
                    try {
                        CharArrayWriter writer = new CharArrayWriter((int)((double)bin.length() * 1.35 + 2.0));
                        Base64OutputStream stream = new Base64OutputStream(writer);
                        bin.writeTo(stream);
                        ((OutputStream)stream).close();
                        return writer.toString();
                    }
                    catch (IOException e) {
                        throw XmlHelper.ensureRuntimeException(e);
                    }
                }
                return o.toString();
            }
            case 7: {
                if (o instanceof Binary) {
                    return o;
                }
                String s = (String)XmlHelper.convert(o, 6);
                if (s != null) {
                    if (s.length() == 0) {
                        return Binary.NO_BINARY;
                    }
                    try {
                        return new Binary(Base64InputStream.decode(s.toCharArray()));
                    }
                    catch (RuntimeException e) {
                        // empty catch block
                    }
                }
                return null;
            }
            case 8: {
                if (o instanceof Date) {
                    return o;
                }
                String s = (String)XmlHelper.convert(o, 6);
                if (s != null && s.length() > 0) {
                    try {
                        return Date.valueOf(XmlHelper.trim(s));
                    }
                    catch (RuntimeException e) {
                        // empty catch block
                    }
                }
                return null;
            }
            case 9: {
                if (o instanceof Time) {
                    return o;
                }
                String s = (String)XmlHelper.convert(o, 6);
                if (s != null && s.length() > 0) {
                    try {
                        return Time.valueOf(XmlHelper.trim(s));
                    }
                    catch (RuntimeException e) {
                        // empty catch block
                    }
                }
                return null;
            }
            case 10: {
                if (o instanceof Timestamp) {
                    return o;
                }
                String s = (String)XmlHelper.convert(o, 6);
                if (s != null && s.length() > 0) {
                    try {
                        s = XmlHelper.trim(s);
                        int ofDelim = s.indexOf(84);
                        if (ofDelim >= 0) {
                            s = s.substring(0, ofDelim) + ' ' + s.substring(ofDelim + 1);
                        }
                        return Timestamp.valueOf(s);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                return null;
            }
        }
        XmlHelper.azzert();
        return o;
    }

    public static interface ParameterResolver {
        public Object resolveParameter(String var1, String var2);
    }
}

