/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.SimpleMapEntry;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractKeyBasedMap
extends Base
implements Map {
    private transient Set m_setKeys;
    private transient Set m_setEntries;
    private transient Collection m_collValues;

    public void clear() {
        Iterator iter = this.iterateKeys();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    public boolean containsKey(Object oKey) {
        Iterator iter = this.iterateKeys();
        while (iter.hasNext()) {
            if (!AbstractKeyBasedMap.equals(oKey, iter.next())) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(Object oValue) {
        return this.values().contains(oValue);
    }

    public Set entrySet() {
        Set set = this.m_setEntries;
        if (set == null) {
            this.m_setEntries = set = this.instantiateEntrySet();
        }
        return set;
    }

    public abstract Object get(Object var1);

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        Set set = this.m_setKeys;
        if (set == null) {
            this.m_setKeys = set = this.instantiateKeySet();
        }
        return set;
    }

    public Object put(Object oKey, Object oValue) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map map) {
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object oKey) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        int c = 0;
        Iterator iter = this.iterateKeys();
        while (iter.hasNext()) {
            iter.next();
            ++c;
        }
        return c;
    }

    public Collection values() {
        Collection coll = this.m_collValues;
        if (coll == null) {
            this.m_collValues = coll = this.instantiateValues();
        }
        return coll;
    }

    public Map getAll(Collection colKeys) {
        ListMap map = new ListMap();
        Iterator iter = colKeys.iterator();
        while (iter.hasNext()) {
            Object oKey = iter.next();
            Object oVal = this.get(oKey);
            if (oVal == null && !this.containsKey(oKey)) continue;
            map.put(oKey, oVal);
        }
        return map;
    }

    protected abstract Iterator iterateKeys();

    protected boolean removeBlind(Object oKey) {
        if (this.containsKey(oKey)) {
            this.remove(oKey);
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o instanceof Map) {
            Map that = (Map)o;
            if (this == that) {
                return true;
            }
            if (this.size() == that.size()) {
                Iterator iter = this.entrySet().iterator();
                while (iter.hasNext()) {
                    Object oThatValue;
                    Map.Entry entry = (Map.Entry)iter.next();
                    Object oKey = entry.getKey();
                    Object oThisValue = entry.getValue();
                    try {
                        oThatValue = that.get(oKey);
                    }
                    catch (ClassCastException e) {
                        return false;
                    }
                    catch (NullPointerException e) {
                        return false;
                    }
                    if (!(oThisValue == this || oThisValue == that ? oThatValue != this && oThatValue != that : !AbstractKeyBasedMap.equals(oThisValue, oThatValue) || oThatValue == null && !that.containsKey(oKey))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int nHash = 0;
        Iterator iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            nHash += iter.next().hashCode();
        }
        return nHash;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100 + (this.size() << 3));
        sb.append('{');
        boolean fFirst = true;
        Iterator iter = this.entrySet().iterator();
        while (iter.hasNext()) {
            if (fFirst) {
                fFirst = false;
            } else {
                sb.append(", ");
            }
            Map.Entry entry = (Map.Entry)iter.next();
            Object oKey = entry.getKey();
            Object oValue = entry.getValue();
            sb.append(oKey == this ? "(this Map)" : String.valueOf(oKey)).append('=').append(oValue == this ? "(this Map)" : String.valueOf(oValue));
        }
        sb.append('}');
        return sb.toString();
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractKeyBasedMap that = (AbstractKeyBasedMap)super.clone();
        that.m_setKeys = null;
        that.m_setEntries = null;
        that.m_collValues = null;
        return that;
    }

    protected Set instantiateKeySet() {
        return new KeySet();
    }

    protected Set instantiateEntrySet() {
        return new EntrySet();
    }

    protected Collection instantiateValues() {
        return new ValuesCollection();
    }

    protected class ValuesCollection
    extends AbstractCollection {
        protected ValuesCollection() {
        }

        public void clear() {
            AbstractKeyBasedMap.this.clear();
        }

        public boolean contains(Object o) {
            if (o == null) {
                Iterator iter = this.iterator();
                while (iter.hasNext()) {
                    if (iter.next() != null) continue;
                    return true;
                }
            } else {
                Iterator iter = this.iterator();
                while (iter.hasNext()) {
                    if (!Base.equals(o, iter.next())) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isEmpty() {
            return AbstractKeyBasedMap.this.isEmpty();
        }

        public Iterator iterator() {
            if (this.isEmpty()) {
                return NullImplementation.getIterator();
            }
            return this.instantiateIterator();
        }

        public boolean remove(Object o) {
            if (o == null) {
                Iterator iter = this.iterator();
                while (iter.hasNext()) {
                    if (iter.next() != null) continue;
                    iter.remove();
                    return true;
                }
            } else {
                Iterator iter = this.iterator();
                while (iter.hasNext()) {
                    if (!Base.equals(o, iter.next())) continue;
                    iter.remove();
                    return true;
                }
            }
            return false;
        }

        public int size() {
            return AbstractKeyBasedMap.this.size();
        }

        public Object[] toArray() {
            return this.toArray((Object[])null);
        }

        public Object[] toArray(Object[] ao) {
            return SimpleEnumerator.toArray(this.iterator(), ao);
        }

        protected Iterator instantiateIterator() {
            return new ValuesIterator();
        }

        protected class ValuesIterator
        implements Iterator {
            protected Iterator m_iterKeys;

            protected ValuesIterator() {
                this.m_iterKeys = AbstractKeyBasedMap.this.iterateKeys();
            }

            public boolean hasNext() {
                return this.m_iterKeys.hasNext();
            }

            public Object next() {
                return AbstractKeyBasedMap.this.get(this.m_iterKeys.next());
            }

            public void remove() {
                this.m_iterKeys.remove();
            }
        }
    }

    public class EntrySet
    extends AbstractSet {
        public void clear() {
            AbstractKeyBasedMap.this.clear();
        }

        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                AbstractKeyBasedMap map;
                Map.Entry entry = (Map.Entry)o;
                Object oKey = entry.getKey();
                Object oValue = entry.getValue();
                return Base.equals(oValue, (map = AbstractKeyBasedMap.this).get(oKey)) && (oValue != null || map.containsKey(oKey));
            }
            return false;
        }

        public boolean isEmpty() {
            return AbstractKeyBasedMap.this.isEmpty();
        }

        public Iterator iterator() {
            if (this.isEmpty()) {
                return NullImplementation.getIterator();
            }
            return this.instantiateIterator();
        }

        public boolean remove(Object o) {
            if (this.contains(o)) {
                AbstractKeyBasedMap.this.remove(((Map.Entry)o).getKey());
                return true;
            }
            return false;
        }

        public int size() {
            return AbstractKeyBasedMap.this.size();
        }

        public Object[] toArray() {
            return this.toArray((Object[])null);
        }

        public Object[] toArray(Object[] ao) {
            return SimpleEnumerator.toArray(this.iterator(), ao);
        }

        protected Map.Entry instantiateEntry(Object oKey, Object oValue) {
            return new Entry(oKey, oValue);
        }

        protected Iterator instantiateIterator() {
            return new EntrySetIterator();
        }

        protected class EntrySetIterator
        implements Iterator {
            protected Iterator m_iterKeys;

            protected EntrySetIterator() {
                this.m_iterKeys = AbstractKeyBasedMap.this.iterateKeys();
            }

            public boolean hasNext() {
                return this.m_iterKeys.hasNext();
            }

            public Object next() {
                return EntrySet.this.instantiateEntry(this.m_iterKeys.next(), null);
            }

            public void remove() {
                this.m_iterKeys.remove();
            }
        }

        protected class Entry
        extends SimpleMapEntry {
            public Entry(Object oKey, Object oValue) {
                super(oKey, oValue);
            }

            public Object getValue() {
                Object oValue = super.getValue();
                if (oValue == null) {
                    oValue = AbstractKeyBasedMap.this.get(this.getKey());
                    super.setValue(oValue);
                }
                return oValue;
            }

            public Object setValue(Object oValue) {
                Object oValueOrig = AbstractKeyBasedMap.this.put(this.getKey(), oValue);
                super.setValue(oValue);
                return oValueOrig;
            }

            public int hashCode() {
                Object oKey = this.getKey();
                Object oValue = this.getValue();
                AbstractKeyBasedMap map = AbstractKeyBasedMap.this;
                return (oKey == null || oKey == map ? 0 : oKey.hashCode()) ^ (oValue == null || oValue == map ? 0 : oValue.hashCode());
            }
        }
    }

    protected class KeySet
    extends AbstractSet {
        protected KeySet() {
        }

        public void clear() {
            AbstractKeyBasedMap.this.clear();
        }

        public boolean contains(Object o) {
            return AbstractKeyBasedMap.this.containsKey(o);
        }

        public boolean isEmpty() {
            return AbstractKeyBasedMap.this.isEmpty();
        }

        public Iterator iterator() {
            if (this.isEmpty()) {
                return NullImplementation.getIterator();
            }
            return AbstractKeyBasedMap.this.iterateKeys();
        }

        public boolean remove(Object o) {
            return AbstractKeyBasedMap.this.removeBlind(o);
        }

        public int size() {
            return AbstractKeyBasedMap.this.size();
        }

        public Object[] toArray() {
            return this.toArray((Object[])null);
        }

        public Object[] toArray(Object[] ao) {
            return SimpleEnumerator.toArray(this.iterator(), ao);
        }
    }
}

