/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.AbstractKeyBasedMap;
import com.tangosol.util.AbstractStableIterator;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractKeySetBasedMap
extends AbstractKeyBasedMap {
    public boolean containsKey(Object oKey) {
        return this.getInternalKeySet().contains(oKey);
    }

    public boolean isEmpty() {
        return this.getInternalKeySet().isEmpty();
    }

    public int size() {
        return this.getInternalKeySet().size();
    }

    protected Iterator iterateKeys() {
        return this.instantiateKeyIterator();
    }

    protected abstract Set getInternalKeySet();

    protected boolean isInternalKeySetIteratorMutable() {
        return false;
    }

    protected Set instantiateKeySet() {
        return new KeySet();
    }

    protected Set instantiateEntrySet() {
        return new EntrySet();
    }

    protected Collection instantiateValues() {
        return new ValuesCollection();
    }

    protected Iterator instantiateKeyIterator() {
        KeyIterator iter = this.getInternalKeySet().iterator();
        if (!this.isInternalKeySetIteratorMutable()) {
            iter = new KeyIterator(iter);
        }
        return iter;
    }

    public class KeyIterator
    extends AbstractStableIterator {
        private Iterator m_iter;

        protected KeyIterator(Iterator iter) {
            this.m_iter = iter;
        }

        protected void advance() {
            Iterator iter = this.m_iter;
            if (iter.hasNext()) {
                this.setNext(iter.next());
            }
        }

        protected void remove(Object oPrev) {
            AbstractKeySetBasedMap.this.removeBlind(oPrev);
        }
    }

    protected class ValuesCollection
    extends AbstractKeyBasedMap.ValuesCollection {
        protected ValuesCollection() {
        }

        public Object[] toArray() {
            AbstractKeySetBasedMap map = AbstractKeySetBasedMap.this;
            Object[] ao = map.keySet().toArray();
            int c = ao.length;
            for (int i = 0; i < c; ++i) {
                ao[i] = map.get(ao[i]);
            }
            return ao;
        }

        public Object[] toArray(Object[] ao) {
            Object[] aoRaw = this.toArray();
            if (ao == null) {
                ao = aoRaw;
            } else {
                int cDest = ao.length;
                int cRaw = aoRaw.length;
                if (cDest < cRaw) {
                    ao = (Object[])Array.newInstance(ao.getClass().getComponentType(), cRaw);
                }
                System.arraycopy(aoRaw, 0, ao, 0, cRaw);
                if (cDest > cRaw) {
                    ao[cRaw] = null;
                }
            }
            return ao;
        }
    }

    public class EntrySet
    extends AbstractKeyBasedMap.EntrySet {
        public Object[] toArray() {
            AbstractKeySetBasedMap map = AbstractKeySetBasedMap.this;
            Object[] ao = map.keySet().toArray();
            int c = ao.length;
            for (int i = 0; i < c; ++i) {
                Object oKey = ao[i];
                ao[i] = this.instantiateEntry(oKey, map.get(oKey));
            }
            return ao;
        }

        public Object[] toArray(Object[] ao) {
            Object[] aoRaw = this.toArray();
            if (ao == null) {
                ao = aoRaw;
            } else {
                int cDest = ao.length;
                int cRaw = aoRaw.length;
                if (cDest < cRaw) {
                    ao = (Object[])Array.newInstance(ao.getClass().getComponentType(), cRaw);
                }
                System.arraycopy(aoRaw, 0, ao, 0, cRaw);
                if (cDest > cRaw) {
                    ao[cRaw] = null;
                }
            }
            return ao;
        }
    }

    protected class KeySet
    extends AbstractKeyBasedMap.KeySet {
        protected KeySet() {
        }

        public Object[] toArray() {
            return AbstractKeySetBasedMap.this.getInternalKeySet().toArray();
        }

        public Object[] toArray(Object[] ao) {
            return AbstractKeySetBasedMap.this.getInternalKeySet().toArray(ao);
        }
    }
}

