/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Base;

public abstract class AtomicCounter
extends Base {
    protected static Class s_clzImplementation;

    public long increment() {
        return this.increment(1L);
    }

    public long increment(long c) {
        return this.adjust(c);
    }

    public long postIncrement() {
        return this.postIncrement(1L);
    }

    public long postIncrement(long c) {
        return this.postAdjust(c);
    }

    public long decrement() {
        return this.decrement(1L);
    }

    public long decrement(long c) {
        return this.adjust(-c);
    }

    public long postDecrement() {
        return this.postDecrement(1L);
    }

    public long postDecrement(long c) {
        return this.postAdjust(-c);
    }

    public abstract long getCount();

    public abstract boolean setCount(long var1, long var3);

    public abstract long setCount(long var1);

    public String toString() {
        return Long.toString(this.getCount());
    }

    protected abstract long adjust(long var1);

    protected abstract long postAdjust(long var1);

    public static AtomicCounter newAtomicCounter() {
        AtomicCounter counter = null;
        Class clazz = s_clzImplementation;
        if (clazz == null) {
            ClassLoader loader = AtomicCounter.class.getClassLoader();
            try {
                counter = (AtomicCounter)Class.forName("com.tangosol.util.internal.ConcurrentCounter", false, loader).newInstance();
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (counter == null) {
                try {
                    counter = (AtomicCounter)Class.forName("com.tangosol.util.internal.SunMiscCounter", false, loader).newInstance();
                }
                catch (Throwable e) {
                    String sReason = e.getMessage();
                    AtomicCounter.log("sun.misc.AtomicLong is not supported on this JVM; using a synchronized counter" + (sReason == null ? "." : ".  " + sReason));
                }
            }
            if (counter == null) {
                try {
                    counter = (AtomicCounter)Class.forName("com.tangosol.util.internal.SynchronizedCounter", false, loader).newInstance();
                }
                catch (Throwable e) {
                    throw AtomicCounter.ensureRuntimeException(e);
                }
            }
            s_clzImplementation = counter.getClass();
        } else {
            try {
                counter = (AtomicCounter)clazz.newInstance();
            }
            catch (Exception e) {
                throw AtomicCounter.ensureRuntimeException(e);
            }
        }
        return counter;
    }

    public static AtomicCounter newAtomicCounter(long l) {
        AtomicCounter counter = AtomicCounter.newAtomicCounter();
        counter.setCount(l);
        return counter;
    }
}

