/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.io.WriterPrintStream;
import com.tangosol.net.CacheFactory;
import com.tangosol.util.AssertionException;
import com.tangosol.util.Binary;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ThreadFactory;
import com.tangosol.util.WrapperException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public abstract class Base {
    private static final RuntimeException DEFAULT_EXCEPTION;
    private static final char[] HEX;
    private static final int KB = 1024;
    private static final int KB_MASK = 1023;
    private static final String[] MEM_SUFFIX;
    private static final int CRC32_BASE = -306674912;
    private static final int[] CRC32_TABLE;
    public static final int UNIT_NS = -1000000;
    public static final int UNIT_US = -1000;
    public static final int UNIT_MS = 1;
    public static final int UNIT_S = 1000;
    public static final int UNIT_M = 60000;
    public static final int UNIT_H = 3600000;
    public static final int UNIT_D = 86400000;
    public static final int POWER_0 = 0;
    public static final int POWER_K = 10;
    public static final int POWER_M = 20;
    public static final int POWER_G = 30;
    public static final int POWER_T = 40;
    private static final Integer[] INTEGERS;
    private static final Long[] LONGS;
    private static final Object[] MONITORS;
    private static PrintWriter s_out;
    private static PrintWriter s_err;
    private static PrintWriter s_log;
    private static boolean s_fEchoLog;
    private static long s_ldtLastTime;
    private static long s_lTimeCorrection;
    private static Random s_rnd;
    private static ThreadFactory s_threadFactory;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void trace(boolean fVal) {
        Base.traceImpl(String.valueOf(fVal));
    }

    public static void trace(char chVal) {
        Base.traceImpl(String.valueOf(chVal));
    }

    public static void trace(int nVal) {
        Base.traceImpl(String.valueOf(nVal));
    }

    public static void trace(long lVal) {
        Base.traceImpl(String.valueOf(lVal));
    }

    public static void trace(float flVal) {
        Base.traceImpl(String.valueOf(flVal));
    }

    public static void trace(double dflVal) {
        Base.traceImpl(String.valueOf(dflVal));
    }

    public static void trace(byte[] ab) {
        if (ab == null) {
            Base.traceImpl(null);
        } else {
            Base.traceImpl("length=" + ab.length + ", binary=" + Base.toHexEscape(ab));
        }
    }

    public static void trace(String sVal) {
        Base.traceImpl(sVal == null ? "null" : Base.toQuotedStringEscape(sVal));
    }

    public static void trace(Object oVal) {
        Base.traceImpl(String.valueOf(oVal));
    }

    private static void traceImpl(String sVal) {
        String sExpr = Base.getExpression("trace");
        Base.out((sExpr == null ? "?" : sExpr) + '=' + (sVal == null ? "null" : sVal));
    }

    public static RuntimeException azzert() {
        Base.azzert(false, "Assertion:  Unexpected execution of code at:");
        return null;
    }

    public static void azzert(boolean f) {
        if (!f) {
            Base.azzertFailed(null);
        }
    }

    public static void azzert(boolean f, String s) {
        if (!f) {
            Base.azzertFailed(s);
        }
    }

    public static void azzertFailed(String sMsg) {
        if (sMsg == null) {
            sMsg = "Assertion failed:";
            String sSource = Base.getExpression("azzert");
            if (sSource != null) {
                sMsg = sMsg + "  " + sSource;
            }
        }
        Base.err(sMsg);
        String sStack = Base.getStackTrace();
        Base.err(sStack.substring(sStack.indexOf(10, sStack.lastIndexOf(".azzert(")) + 1));
        throw new AssertionException(sMsg);
    }

    private static String getExpression(String sMethod) {
        int of;
        StackFrame[] aframe = Base.getStackFrames();
        int i = 0;
        while (!aframe[i].getMethodName().equals(sMethod)) {
            ++i;
        }
        while (aframe[i].getMethodName().equals(sMethod)) {
            ++i;
        }
        String sLine = aframe[i].getLine();
        if (sLine != null && (of = sLine.indexOf(sMethod)) >= 0) {
            int ofLParen = sLine.indexOf(40, of);
            int ofRParen = sLine.lastIndexOf(41);
            if (ofLParen > of && ofRParen > ofLParen) {
                return sLine.substring(ofLParen + 1, ofRParen);
            }
        }
        return null;
    }

    public static RuntimeException ensureRuntimeException(Throwable e) {
        return Base.ensureRuntimeException(e, null);
    }

    public static RuntimeException ensureRuntimeException(Throwable e, String s) {
        if (e == null) {
            return s == null ? DEFAULT_EXCEPTION : new WrapperException(DEFAULT_EXCEPTION, s);
        }
        if (e instanceof RuntimeException && s == null) {
            return (RuntimeException)e;
        }
        return new WrapperException(e, s);
    }

    public static Throwable getOriginalException(RuntimeException e) {
        Throwable t = e;
        while (true) {
            if (t instanceof WrapperException) {
                t = ((WrapperException)t).getOriginalException();
                continue;
            }
            if (t instanceof RemoteException) {
                t = ((RemoteException)t).detail;
                continue;
            }
            if (!t.getClass().getName().equals("javax.ejb.EJBException")) break;
            try {
                t = (Throwable)ClassHelper.invoke(t, "getCausedByException", ClassHelper.VOID);
            }
            catch (Exception x) {
                return t;
            }
        }
        return t;
    }

    public static void out() {
        s_out.println();
    }

    public static void out(Object o) {
        s_out.println(String.valueOf(o));
    }

    public static void out(String s) {
        s_out.println(s);
    }

    public static void out(Class clz) {
        s_out.println(Base.toString(clz));
    }

    public static void out(Throwable e) {
        s_out.println(Base.printStackTrace(e));
    }

    public static void err() {
        s_err.println();
    }

    public static void err(Object o) {
        s_err.println(String.valueOf(o));
    }

    public static void err(String s) {
        s_err.println(s);
    }

    public static void err(Class clz) {
        s_err.println(Base.toString(clz));
    }

    public static void err(Throwable e) {
        s_err.println(Base.printStackTrace(e));
    }

    public static void log() {
        s_log.println();
        if (s_fEchoLog) {
            s_out.println();
        }
    }

    public static void log(Object o) {
        Base.log(String.valueOf(o));
    }

    public static void log(String s) {
        s_log.println(s);
        if (s_fEchoLog) {
            s_out.println(s);
        }
    }

    public static void log(Class clz) {
        Base.log(Base.toString(clz));
    }

    public static void log(Throwable e) {
        String s = Base.printStackTrace(e);
        s_log.println(s);
        if (s_fEchoLog) {
            s_out.println(s);
        }
    }

    public static ClassLoader getContextClassLoader() {
        return Base.getContextClassLoader(null);
    }

    public static ClassLoader getContextClassLoader(Object o) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            if (o != null) {
                loader = o.getClass().getClassLoader();
            }
            if (loader == null && (loader = Base.class.getClassLoader()) == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
        }
        return loader;
    }

    public static StackFrame getCallerStackFrame() {
        String sStack = Base.getStackTrace();
        int of = sStack.indexOf(10, sStack.lastIndexOf(".getCallerStackFrame(")) + 1;
        of = sStack.indexOf(10, of) + 1;
        try {
            return new StackFrame(sStack.substring(of, sStack.indexOf(10, of)));
        }
        catch (RuntimeException e) {
            return StackFrame.UNKNOWN;
        }
    }

    public static StackFrame getStackFrame() {
        String sStack = Base.getStackTrace();
        int of = sStack.indexOf(10, sStack.lastIndexOf(".getStackFrame(")) + 1;
        try {
            return new StackFrame(sStack.substring(of, sStack.indexOf(10, of)));
        }
        catch (RuntimeException e) {
            return StackFrame.UNKNOWN;
        }
    }

    public static StackFrame[] getStackFrames() {
        String sStack = Base.getStackTrace();
        LineNumberReader reader = new LineNumberReader(new StringReader(sStack.substring(sStack.indexOf(10, sStack.lastIndexOf(".getStackFrames(")) + 1)));
        try {
            ArrayList<StackFrame> list = new ArrayList<StackFrame>();
            String sLine = reader.readLine();
            while (sLine != null && sLine.length() > 0) {
                StackFrame frame = StackFrame.UNKNOWN;
                try {
                    frame = new StackFrame(sLine);
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
                list.add(frame);
                sLine = reader.readLine();
            }
            return list.toArray(new StackFrame[list.size()]);
        }
        catch (IOException e) {
            throw new WrapperException(e);
        }
    }

    public static String getStackTrace() {
        String s = Base.getStackTrace(new Exception());
        return s.substring(s.indexOf(10, s.indexOf(".getStackTrace(")) + 1);
    }

    public static String getStackTrace(Throwable e) {
        String s = Base.printStackTrace(e);
        if (s.startsWith(e.getClass().getName())) {
            s = s.substring(s.indexOf(10) + 1);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String printStackTrace(Throwable e) {
        String string;
        CharArrayWriter writerRaw = new CharArrayWriter(1024);
        try {
            PrintWriter writerOut = new PrintWriter(writerRaw);
            try {
                e.printStackTrace(writerOut);
            }
            finally {
                writerOut.close();
            }
            ((Writer)writerRaw).flush();
            string = ((Object)writerRaw).toString();
        }
        catch (Throwable throwable) {
            try {
                ((Writer)writerRaw).close();
                throw throwable;
            }
            catch (IOException eIO) {
                throw new WrapperException(eIO);
            }
        }
        ((Writer)writerRaw).close();
        return string;
    }

    public static Thread makeThread(ThreadGroup group, Runnable runnable, String sName) {
        ThreadFactory factory = s_threadFactory;
        if (factory == null) {
            return sName == null ? new Thread(group, runnable) : new Thread(group, runnable, sName);
        }
        return factory.makeThread(group, runnable, sName);
    }

    private static ThreadFactory instantiateThreadFactory() {
        String sFactory = System.getProperty("tangosol.coherence.threadfactory");
        if (sFactory == null) {
            return null;
        }
        try {
            return (ThreadFactory)Class.forName(sFactory).newInstance();
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    public static Object getCommonMonitor(int i) {
        Object[] aoMonitors = MONITORS;
        return aoMonitors[(i & Integer.MAX_VALUE) % aoMonitors.length];
    }

    public static Object getCommonMonitor(long l) {
        Object[] aoMonitors = MONITORS;
        return aoMonitors[(int)((l & Long.MAX_VALUE) % (long)aoMonitors.length)];
    }

    public static String toString(Class clz) {
        if (clz.isPrimitive()) {
            return clz.toString();
        }
        if (clz.isArray()) {
            return "Array of " + Base.toString(clz.getComponentType());
        }
        if (clz.isInterface()) {
            return Base.toInterfaceString(clz, "");
        }
        return Base.toClassString(clz, "");
    }

    private static String toClassString(Class clz, String sIndent) {
        StringBuffer sb = new StringBuffer();
        sb.append(sIndent).append("Class ").append(clz.getName()).append("  (").append(Base.toString(clz.getClassLoader())).append(')');
        sIndent = sIndent + "  ";
        Class<?>[] aclz = clz.getInterfaces();
        int c = aclz.length;
        for (int i = 0; i < c; ++i) {
            sb.append('\n').append(Base.toInterfaceString(aclz[i], sIndent));
        }
        if ((clz = clz.getSuperclass()) != null) {
            sb.append('\n').append(Base.toClassString(clz, sIndent));
        }
        return sb.toString();
    }

    private static String toInterfaceString(Class clz, String sIndent) {
        StringBuffer sb = new StringBuffer();
        sb.append(sIndent).append("Interface ").append(clz.getName()).append("  (").append(Base.toString(clz.getClassLoader())).append(')');
        Class<?>[] aclz = clz.getInterfaces();
        int c = aclz.length;
        for (int i = 0; i < c; ++i) {
            clz = aclz[i];
            sb.append('\n').append(Base.toInterfaceString(clz, sIndent + "  "));
        }
        return sb.toString();
    }

    private static String toString(ClassLoader loader) {
        if (loader == null) {
            return "System ClassLoader";
        }
        return "ClassLoader class=" + loader.getClass().getName() + ", hashCode=" + loader.hashCode();
    }

    public static boolean isDecimal(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static int decimalValue(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        throw new IllegalArgumentException("Character \"" + ch + "\" is not a valid decimal digit.");
    }

    public static int getMaxDecDigits(int n) {
        int cDigits = 0;
        do {
            ++cDigits;
        } while ((n /= 10) != 0);
        return cDigits;
    }

    public static String toDecString(int n, int cDigits) {
        char[] ach = new char[cDigits];
        while (cDigits > 0) {
            ach[--cDigits] = (char)(48 + n % 10);
            n /= 10;
        }
        return new String(ach);
    }

    public static long pad(long lMin, long lMultiple) {
        return (lMin + lMultiple - 1L) / lMultiple * lMultiple;
    }

    public static boolean isOctal(char ch) {
        return ch >= '0' && ch <= '7';
    }

    public static int octalValue(char ch) {
        if (ch >= '0' && ch <= '7') {
            return ch - 48;
        }
        throw new IllegalArgumentException("Character \"" + ch + "\" is not a valid octal digit.");
    }

    public static boolean isHex(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f';
    }

    public static int hexValue(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        throw new IllegalArgumentException("Character \"" + ch + "\" is not a valid hexidecimal digit.");
    }

    public static int getMaxHexDigits(int n) {
        int cDigits = 0;
        do {
            ++cDigits;
        } while ((n >>>= 4) != 0);
        return cDigits;
    }

    public static String toHexString(int n, int cDigits) {
        char[] ach = new char[cDigits];
        while (cDigits > 0) {
            ach[--cDigits] = HEX[n & 0xF];
            n >>>= 4;
        }
        return new String(ach);
    }

    public static String toHex(int b) {
        int n = b & 0xFF;
        char[] ach = new char[]{HEX[n >> 4], HEX[n & 0xF]};
        return new String(ach);
    }

    public static String toHex(byte[] ab) {
        int cb = ab.length;
        char[] ach = new char[cb * 2];
        int ofch = 0;
        for (int ofb = 0; ofb < cb; ++ofb) {
            int n = ab[ofb] & 0xFF;
            ach[ofch++] = HEX[n >> 4];
            ach[ofch++] = HEX[n & 0xF];
        }
        return new String(ach);
    }

    public static String toHexEscape(byte b) {
        int n = b & 0xFF;
        char[] ach = new char[]{'0', 'x', HEX[n >> 4], HEX[n & 0xF]};
        return new String(ach);
    }

    public static String toHexEscape(byte[] ab) {
        return Base.toHexEscape(ab, 0, ab.length);
    }

    public static String toHexEscape(byte[] ab, int of, int cb) {
        char[] ach = new char[2 + cb * 2];
        ach[0] = 48;
        ach[1] = 120;
        int ofch = 2;
        int ofStop = of + cb;
        for (int ofb = of; ofb < ofStop; ++ofb) {
            int n = ab[ofb] & 0xFF;
            ach[ofch++] = HEX[n >> 4];
            ach[ofch++] = HEX[n & 0xF];
        }
        return new String(ach);
    }

    public static String toHexDump(byte[] ab, int cBytesPerLine) {
        int cb = ab.length;
        if (cb == 0) {
            return "";
        }
        int cDigits = 0;
        int cbTemp = cb - 1;
        do {
            cDigits += 2;
        } while ((cbTemp /= 256) > 0);
        int cLines = (cb + cBytesPerLine - 1) / cBytesPerLine;
        int cCharsPerLine = cDigits + 4 * cBytesPerLine + 5;
        int cch = cLines * cCharsPerLine;
        char[] ach = new char[cch];
        int ofColon = cDigits;
        int ofLF = cCharsPerLine - 1;
        int ofHexInLine = ofColon + 3;
        int ofCharInLine = ofLF - cBytesPerLine;
        int ofByte = 0;
        int ofLine = 0;
        for (int iLine = 0; iLine < cLines; ++iLine) {
            int nOffset = ofByte;
            int ofDigit = ofLine + cDigits;
            for (int i = 0; i < cDigits; ++i) {
                ach[--ofDigit] = HEX[nOffset & 0xF];
                nOffset >>= 4;
            }
            int ofFmt = ofLine + cDigits;
            ach[ofFmt++] = 58;
            ach[ofFmt++] = 32;
            ach[ofFmt++] = 32;
            int ofHex = ofLine + ofHexInLine;
            int ofChar = ofLine + ofCharInLine;
            for (int i = 0; i < cBytesPerLine; ++i) {
                try {
                    int n = ab[ofByte++] & 0xFF;
                    ach[ofHex++] = HEX[(n & 0xF0) >> 4];
                    ach[ofHex++] = HEX[n & 0xF];
                    ach[ofHex++] = 32;
                    ach[ofChar++] = (char)(n < 32 ? 46 : (char)n);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    ach[ofHex++] = 32;
                    ach[ofHex++] = 32;
                    ach[ofHex++] = 32;
                    ach[ofChar++] = 32;
                }
            }
            ach[ofHex] = 32;
            ach[ofChar] = 10;
            ofLine += cCharsPerLine;
        }
        return new String(ach, 0, cch - 1);
    }

    public static byte[] parseHex(String s) {
        char[] ach = s.toCharArray();
        int cch = ach.length;
        if (cch == 0) {
            return new byte[0];
        }
        if ((cch & 1) != 0) {
            throw new IllegalArgumentException("invalid length hex string");
        }
        int ofch = 0;
        if (ach[1] == 'x' || ach[1] == 'X') {
            ofch = 2;
        }
        int cb = (cch - ofch) / 2;
        byte[] ab = new byte[cb];
        for (int ofb = 0; ofb < cb; ++ofb) {
            ab[ofb] = (byte)(Base.parseHex(ach[ofch++]) << 4 | Base.parseHex(ach[ofch++]));
        }
        return ab;
    }

    public static int parseHex(char ch) {
        switch (ch) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return ch - 48;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return ch - 65 + 10;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return ch - 97 + 10;
            }
        }
        throw new IllegalArgumentException("illegal hex char: " + ch);
    }

    public static String toUnicodeEscape(char ch) {
        char n = ch;
        char[] ach = new char[]{'\\', 'u', HEX[n >> 12], HEX[n >> 8 & 0xF], HEX[n >> 4 & 0xF], HEX[n & 0xF]};
        return new String(ach);
    }

    public static String toCharEscape(char ch) {
        char[] ach = new char[6];
        int cch = Base.escape(ch, ach, 0);
        return new String(ach, 0, cch);
    }

    public static String toQuotedCharEscape(char ch) {
        char[] ach = new char[8];
        ach[0] = 39;
        int cch = Base.escape(ch, ach, 1);
        ach[cch + 1] = 39;
        return new String(ach, 0, cch + 2);
    }

    public static String toStringEscape(String s) {
        char[] achSrc = s.toCharArray();
        int cchSrc = achSrc.length;
        int ofSrc = 0;
        int cchDest = cchSrc * 6;
        char[] achDest = new char[cchDest];
        int ofDest = 0;
        while (ofSrc < cchSrc) {
            ofDest += Base.escape(achSrc[ofSrc++], achDest, ofDest);
        }
        return new String(achDest, 0, ofDest);
    }

    public static String toQuotedStringEscape(String s) {
        char[] achSrc = s.toCharArray();
        int cchSrc = achSrc.length;
        int ofSrc = 0;
        int cchDest = cchSrc * 6 + 2;
        char[] achDest = new char[cchDest];
        int ofDest = 0;
        achDest[ofDest++] = 34;
        while (ofSrc < cchSrc) {
            ofDest += Base.escape(achSrc[ofSrc++], achDest, ofDest);
        }
        achDest[ofDest++] = 34;
        return new String(achDest, 0, ofDest);
    }

    public static int escape(char ch, char[] ach, int of) {
        switch (ch) {
            case '\b': {
                ach[of++] = 92;
                ach[of] = 98;
                return 2;
            }
            case '\t': {
                ach[of++] = 92;
                ach[of] = 116;
                return 2;
            }
            case '\n': {
                ach[of++] = 92;
                ach[of] = 110;
                return 2;
            }
            case '\f': {
                ach[of++] = 92;
                ach[of] = 102;
                return 2;
            }
            case '\r': {
                ach[of++] = 92;
                ach[of] = 114;
                return 2;
            }
            case '\"': {
                ach[of++] = 92;
                ach[of] = 34;
                return 2;
            }
            case '\'': {
                ach[of++] = 92;
                ach[of] = 39;
                return 2;
            }
            case '\\': {
                ach[of++] = 92;
                ach[of] = 92;
                return 2;
            }
            case '\u0000': 
            case '\u0001': 
            case '\u0002': 
            case '\u0003': 
            case '\u0004': 
            case '\u0005': 
            case '\u0006': 
            case '\u0007': 
            case '\u000b': 
            case '\u000e': 
            case '\u000f': 
            case '\u0010': 
            case '\u0011': 
            case '\u0012': 
            case '\u0013': 
            case '\u0014': 
            case '\u0015': 
            case '\u0016': 
            case '\u0017': 
            case '\u0018': 
            case '\u0019': 
            case '\u001a': 
            case '\u001b': 
            case '\u001c': 
            case '\u001d': 
            case '\u001e': 
            case '\u001f': {
                ach[of++] = 92;
                ach[of++] = 48;
                ach[of++] = (char)(ch / 8 + 48);
                ach[of] = (char)(ch % 8 + 48);
                return 4;
            }
        }
        switch (Character.getType(ch)) {
            case 0: 
            case 15: 
            case 18: {
                char n = ch;
                ach[of++] = 92;
                ach[of++] = 117;
                ach[of++] = HEX[n >> 12];
                ach[of++] = HEX[n >> 8 & 0xF];
                ach[of++] = HEX[n >> 4 & 0xF];
                ach[of] = HEX[n & 0xF];
                return 6;
            }
        }
        ach[of] = ch;
        return 1;
    }

    public static String toSqlString(String s) {
        if (s == null) {
            return "NULL";
        }
        if (s.length() == 0) {
            return "''";
        }
        if (s.indexOf(39) < 0) {
            return '\'' + s + '\'';
        }
        char[] ach = s.toCharArray();
        int cch = ach.length;
        StringBuffer sb = new StringBuffer(cch + 16);
        sb.append('\'');
        int ofPrev = 0;
        for (int ofCur = 0; ofCur < cch; ++ofCur) {
            char ch = ach[ofCur];
            switch (ch) {
                case '\n': 
                case '\'': {
                    if (ofCur > ofPrev) {
                        sb.append(ach, ofPrev, ofCur - ofPrev);
                    }
                    switch (ch) {
                        case '\n': {
                            sb.append("'\n'");
                            break;
                        }
                        case '\'': {
                            sb.append("''");
                        }
                    }
                    ofPrev = ofCur + 1;
                }
            }
        }
        if (ofPrev < cch) {
            sb.append(ach, ofPrev, cch - ofPrev);
        }
        sb.append('\'');
        return sb.toString();
    }

    public static String indentString(String sText, String sIndent) {
        return Base.indentString(sText, sIndent, true);
    }

    public static String indentString(String sText, String sIndent, boolean fFirstLine) {
        char[] ach = sText.toCharArray();
        int cch = ach.length;
        StringBuffer sb = new StringBuffer();
        int iLine = 0;
        int of = 0;
        int ofPrev = 0;
        while (of < cch) {
            if (ach[of++] != '\n' && of != cch) continue;
            if (iLine++ > 0 || fFirstLine) {
                sb.append(sIndent);
            }
            sb.append(sText.substring(ofPrev, of));
            ofPrev = of;
        }
        return sb.toString();
    }

    public static String breakLines(String sText, int nWidth, String sIndent) {
        return Base.breakLines(sText, nWidth, sIndent, true);
    }

    public static String breakLines(String sText, int nWidth, String sIndent, boolean fFirstLine) {
        if (sIndent == null) {
            sIndent = "";
        }
        if ((nWidth -= sIndent.length()) <= 0) {
            throw new IllegalArgumentException("The width and indent are incompatible");
        }
        char[] ach = sText.toCharArray();
        int cch = ach.length;
        StringBuffer sb = new StringBuffer(cch);
        int ofPrev = 0;
        int of = 0;
        while (of < cch) {
            char c = ach[of++];
            boolean fBreak = false;
            int ofBreak = of;
            int ofNext = of;
            if (c == '\n') {
                fBreak = true;
                --ofBreak;
            } else if (of == cch) {
                fBreak = true;
            } else if (of == ofPrev + nWidth) {
                fBreak = true;
                while (!Character.isWhitespace(ach[--ofBreak]) && ofBreak > ofPrev) {
                }
                if (ofBreak == ofPrev) {
                    ofBreak = of;
                } else {
                    ofNext = ofBreak + 1;
                }
            }
            if (!fBreak) continue;
            if (ofPrev > 0) {
                sb.append('\n').append(sIndent);
            } else if (fFirstLine) {
                sb.append(sIndent);
            }
            sb.append(sText.substring(ofPrev, ofBreak));
            ofPrev = ofNext;
        }
        return sb.toString();
    }

    public static String dup(char ch, int cch) {
        char[] ach = new char[cch];
        for (int of = 0; of < cch; ++of) {
            ach[of] = ch;
        }
        return new String(ach);
    }

    public static String dup(String s, int c) {
        if (c < 1) {
            return "";
        }
        if (c == 1) {
            return s;
        }
        char[] achPat = s.toCharArray();
        int cchPat = achPat.length;
        int cchBuf = cchPat * c;
        char[] achBuf = new char[cchBuf];
        int i = 0;
        int of = 0;
        while (i < c) {
            System.arraycopy(achPat, 0, achBuf, of, cchPat);
            ++i;
            of += cchPat;
        }
        return new String(achBuf);
    }

    public static String replace(String sText, String sFrom, String sTo) {
        if (sFrom.length() == 0) {
            return sText;
        }
        StringBuffer sbTextNew = new StringBuffer();
        int iTextLen = sText.length();
        int iStart = 0;
        while (iStart < iTextLen) {
            int iPos = sText.indexOf(sFrom, iStart);
            if (iPos != -1) {
                sbTextNew.append(sText.substring(iStart, iPos));
                sbTextNew.append(sTo);
                iStart = iPos + sFrom.length();
                continue;
            }
            sbTextNew.append(sText.substring(iStart));
            break;
        }
        return sbTextNew.toString();
    }

    public static String[] parseDelimitedString(String s, char chDelim) {
        if (s == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        int ofPrev = -1;
        while (true) {
            int ofNext;
            if ((ofNext = s.indexOf(chDelim, ofPrev + 1)) < 0) break;
            list.add(s.substring(ofPrev + 1, ofNext));
            ofPrev = ofNext;
        }
        list.add(s.substring(ofPrev + 1));
        return list.toArray(new String[list.size()]);
    }

    public static String toDelimitedString(int[] an, String sDelim) {
        int c = an.length;
        if (c > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < c; ++i) {
                sb.append(sDelim).append(an[i]);
            }
            return sb.substring(sDelim.length());
        }
        return "";
    }

    public static String toDelimitedString(long[] al, String sDelim) {
        int c = al.length;
        if (c > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < c; ++i) {
                sb.append(sDelim).append(al[i]);
            }
            return sb.substring(sDelim.length());
        }
        return "";
    }

    public static String toDelimitedString(Object[] ao, String sDelim) {
        int c = ao.length;
        if (c > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < c; ++i) {
                sb.append(sDelim).append(ao[i]);
            }
            return sb.substring(sDelim.length());
        }
        return "";
    }

    public static String toDelimitedString(Iterator iter, String sDelim) {
        StringBuffer sb = new StringBuffer();
        while (iter.hasNext()) {
            sb.append(sDelim).append(iter.next());
        }
        return sb.length() == 0 ? "" : sb.substring(sDelim.length());
    }

    public static long parseBandwidth(String s) {
        return Base.parseBandwidth(s, 0);
    }

    public static long parseBandwidth(String s, int nDefaultPower) {
        char ch;
        if (s == null) {
            throw new IllegalArgumentException("passed String must not be null");
        }
        switch (nDefaultPower) {
            case 0: 
            case 10: 
            case 20: 
            case 30: 
            case 40: {
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal default power: " + nDefaultPower);
            }
        }
        int cch = s.length();
        if (cch >= 2 && ((ch = s.charAt(cch - 1)) == 'S' || ch == 's')) {
            ch = s.charAt(cch - 2);
            if (ch == 'P' || ch == 'p') {
                cch -= 2;
            } else {
                throw new IllegalArgumentException("invalid bandwidth: \"" + s + "\" (illegal bandwidth unit)");
            }
        }
        int cBitShift = -3;
        boolean fDefault = true;
        if (cch >= 1) {
            switch (s.charAt(cch - 1)) {
                case 'B': {
                    cBitShift = 0;
                }
                case 'b': {
                    --cch;
                    fDefault = false;
                }
            }
        }
        if (cch >= 1) {
            switch (s.charAt(--cch)) {
                case 'K': 
                case 'k': {
                    cBitShift += 10;
                    break;
                }
                case 'M': 
                case 'm': {
                    cBitShift += 20;
                    break;
                }
                case 'G': 
                case 'g': {
                    cBitShift += 30;
                    break;
                }
                case 'T': 
                case 't': {
                    cBitShift += 40;
                    break;
                }
                default: {
                    if (fDefault) {
                        cBitShift += nDefaultPower;
                    }
                    ++cch;
                }
            }
        }
        if (cch == 0) {
            throw new NumberFormatException("passed String (\"" + s + "\") must contain a number");
        }
        long cb = 0L;
        boolean fDecimal = false;
        int nDivisor = 1;
        block17: for (int of = 0; of < cch; ++of) {
            char ch2 = s.charAt(of);
            switch (ch2) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    cb = cb * 10L + (long)(ch2 - 48);
                    if (!fDecimal) continue block17;
                    nDivisor *= 10;
                    continue block17;
                }
                case '.': {
                    if (fDecimal) {
                        throw new NumberFormatException("invalid bandwidth: \"" + s + "\" (illegal second decimal point)");
                    }
                    fDecimal = true;
                    continue block17;
                }
                default: {
                    throw new NumberFormatException("invalid bandwidth: \"" + s + "\" (illegal digit: \"" + ch2 + "\")");
                }
            }
        }
        cb = cBitShift < 0 ? (cb >>>= -cBitShift) : (cb <<= cBitShift);
        if (fDecimal) {
            if (nDivisor == 1) {
                throw new NumberFormatException("invalid bandwidth: \"" + s + "\" (illegal trailing decimal point)");
            }
            cb /= (long)nDivisor;
        }
        return cb;
    }

    public static String toBandwidthString(long cbps) {
        return Base.toBandwidthString(cbps, true);
    }

    public static String toBandwidthString(long cbps, boolean fExact) {
        int ofLast;
        StringBuffer sb;
        boolean fBits;
        boolean bl = fBits = (cbps & 0xF00000000000000L) == 0L;
        if (fBits) {
            cbps <<= 3;
        }
        if ((sb = new StringBuffer(Base.toMemorySizeString(cbps, fExact))).charAt(ofLast = sb.length() - 1) == 'B') {
            if (fBits) {
                sb.setCharAt(ofLast, 'b');
            }
        } else {
            sb.append(fBits ? (char)'b' : 'B');
        }
        sb.append("ps");
        return sb.toString();
    }

    public static long parseMemorySize(String s) {
        return Base.parseMemorySize(s, 0);
    }

    public static long parseMemorySize(String s, int nDefaultPower) {
        if (s == null) {
            throw new IllegalArgumentException("passed String must not be null");
        }
        switch (nDefaultPower) {
            case 0: 
            case 10: 
            case 20: 
            case 30: 
            case 40: {
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal default power: " + nDefaultPower);
            }
        }
        int cBitShift = 0;
        int cch = s.length();
        if (cch > 0) {
            boolean fDefault;
            char ch = s.charAt(cch - 1);
            if (ch == 'B' || ch == 'b') {
                --cch;
                fDefault = false;
            } else {
                fDefault = true;
            }
            if (cch > 0) {
                switch (s.charAt(--cch)) {
                    case 'K': 
                    case 'k': {
                        cBitShift = 10;
                        break;
                    }
                    case 'M': 
                    case 'm': {
                        cBitShift = 20;
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        cBitShift = 30;
                        break;
                    }
                    case 'T': 
                    case 't': {
                        cBitShift = 40;
                        break;
                    }
                    default: {
                        if (fDefault) {
                            cBitShift = nDefaultPower;
                        }
                        ++cch;
                    }
                }
            }
        }
        if (cch == 0) {
            throw new NumberFormatException("passed String (\"" + s + "\") must contain a number");
        }
        long cb = 0L;
        boolean fDecimal = false;
        int nDivisor = 1;
        block13: for (int of = 0; of < cch; ++of) {
            char ch = s.charAt(of);
            switch (ch) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    cb = cb * 10L + (long)(ch - 48);
                    if (!fDecimal) continue block13;
                    nDivisor *= 10;
                    continue block13;
                }
                case '.': {
                    if (fDecimal) {
                        throw new NumberFormatException("invalid memory size: \"" + s + "\" (illegal second decimal point)");
                    }
                    fDecimal = true;
                    continue block13;
                }
                default: {
                    throw new NumberFormatException("invalid memory size: \"" + s + "\" (illegal digit: \"" + ch + "\")");
                }
            }
        }
        cb <<= cBitShift;
        if (fDecimal) {
            if (nDivisor == 1) {
                throw new NumberFormatException("invalid memory size: \"" + s + "\" (illegal trailing decimal point)");
            }
            cb /= (long)nDivisor;
        }
        return cb;
    }

    public static String toMemorySizeString(long cb) {
        return Base.toMemorySizeString(cb, true);
    }

    public static String toMemorySizeString(long cb, boolean fExact) {
        int cDivs;
        if (cb < 0L) {
            throw new IllegalArgumentException("negative quantity: " + cb);
        }
        if (cb < 1024L) {
            return String.valueOf(cb);
        }
        int cMaxDivs = MEM_SUFFIX.length - 1;
        if (fExact) {
            for (cDivs = 0; ((int)cb & 0x3FF) == 0 && cDivs < cMaxDivs; ++cDivs) {
                cb >>>= 10;
            }
            return cb + MEM_SUFFIX[cDivs];
        }
        int cbRem = 0;
        while (cb >= 1024L && cDivs < cMaxDivs) {
            cbRem = (int)cb & 0x3FF;
            cb >>>= 10;
            ++cDivs;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(cb));
        int cch = sb.length();
        if (cch < 3 && cbRem != 0) {
            String sDec = String.valueOf((int)((double)cbRem / 10.24 + 100.0));
            sb.append('.').append(sDec.substring(1, 4 - cch));
        }
        sb.append(MEM_SUFFIX[cDivs]);
        return sb.toString();
    }

    public static long parseTime(String s) {
        return Base.parseTime(s, 1);
    }

    public static long parseTime(String s, int nDefaultUnit) {
        return Base.parseTimeNanos(s, nDefaultUnit) / 1000000L;
    }

    public static long parseTimeNanos(String s) {
        return Base.parseTimeNanos(s, -1000000);
    }

    public static long parseTimeNanos(String s, int nDefaultUnit) {
        if (s == null) {
            throw new IllegalArgumentException("passed String must not be null");
        }
        switch (nDefaultUnit) {
            case -1000000: 
            case -1000: 
            case 1: 
            case 1000: 
            case 60000: 
            case 3600000: 
            case 86400000: {
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal default unit: " + nDefaultUnit);
            }
        }
        long nMultiplier = nDefaultUnit;
        int cch = s.length();
        if (cch > 0) {
            switch (s.charAt(--cch)) {
                case 'S': 
                case 's': {
                    nMultiplier = 1000L;
                    if (cch <= 1) break;
                    char c = s.charAt(cch - 1);
                    switch (c) {
                        case 'N': 
                        case 'n': {
                            --cch;
                            nMultiplier = -1000000L;
                            break;
                        }
                        case 'U': 
                        case 'u': {
                            --cch;
                            nMultiplier = -1000L;
                            break;
                        }
                        case 'M': 
                        case 'm': {
                            --cch;
                            nMultiplier = 1L;
                        }
                    }
                    break;
                }
                case 'M': 
                case 'm': {
                    nMultiplier = 60000L;
                    break;
                }
                case 'H': 
                case 'h': {
                    nMultiplier = 3600000L;
                    break;
                }
                case 'D': 
                case 'd': {
                    nMultiplier = 86400000L;
                    break;
                }
                default: {
                    ++cch;
                }
            }
        }
        long l = nMultiplier = nMultiplier < 0L ? 1000000L / -nMultiplier : 1000000L * nMultiplier;
        if (cch == 0) {
            throw new NumberFormatException("passed String (\"" + s + "\") must contain a number");
        }
        long cNanos = 0L;
        boolean fDecimal = false;
        int nDivisor = 1;
        block18: for (int of = 0; of < cch; ++of) {
            char ch = s.charAt(of);
            switch (ch) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    cNanos = cNanos * 10L + (long)(ch - 48);
                    if (!fDecimal) continue block18;
                    nDivisor *= 10;
                    continue block18;
                }
                case '.': {
                    if (fDecimal) {
                        throw new NumberFormatException("invalid time: \"" + s + "\" (illegal second decimal point)");
                    }
                    fDecimal = true;
                    continue block18;
                }
                default: {
                    throw new NumberFormatException("invalid time: \"" + s + "\" (illegal digit: \"" + ch + "\")");
                }
            }
        }
        cNanos *= nMultiplier;
        if (fDecimal) {
            if (nDivisor == 1) {
                throw new NumberFormatException("invalid time: \"" + s + "\" (illegal trailing decimal point)");
            }
            cNanos /= (long)nDivisor;
        }
        return cNanos;
    }

    public static String formatDateTime(long ldt) {
        return ldt == 0L ? "none" : new Timestamp(ldt).toString();
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        try {
            return o1.equals(o2);
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static boolean equalsDeep(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.getClass().isArray()) {
            if (o1 instanceof byte[]) {
                return o2 instanceof byte[] && Arrays.equals((byte[])o1, (byte[])o2);
            }
            if (o1 instanceof Object[]) {
                Object[] ao2;
                Object[] ao1;
                int c;
                if (o2 instanceof Object[] && (c = (ao1 = (Object[])o1).length) == (ao2 = (Object[])o2).length) {
                    for (int i = 0; i < c; ++i) {
                        if (Base.equalsDeep(ao1[i], ao2[i])) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            if (o1 instanceof int[]) {
                return o2 instanceof int[] && Arrays.equals((int[])o1, (int[])o2);
            }
            if (o1 instanceof char[]) {
                return o2 instanceof char[] && Arrays.equals((char[])o1, (char[])o2);
            }
            if (o1 instanceof long[]) {
                return o2 instanceof long[] && Arrays.equals((long[])o1, (long[])o2);
            }
            if (o1 instanceof double[]) {
                return o2 instanceof double[] && Arrays.equals((double[])o1, (double[])o2);
            }
            if (o1 instanceof boolean[]) {
                return o2 instanceof boolean[] && Arrays.equals((boolean[])o1, (boolean[])o2);
            }
            if (o1 instanceof short[]) {
                return o2 instanceof short[] && Arrays.equals((short[])o1, (short[])o2);
            }
            if (o1 instanceof float[]) {
                return o2 instanceof float[] && Arrays.equals((float[])o1, (float[])o2);
            }
        }
        try {
            return o1.equals(o2);
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static int toCrc(byte[] ab) {
        return Base.toCrc(ab, 0, ab.length);
    }

    public static int toCrc(byte[] ab, int of, int cb) {
        return Base.toCrc(ab, of, cb, -1);
    }

    public static int toCrc(byte[] ab, int of, int cb, int nCrc) {
        while (cb > 0) {
            nCrc = nCrc >>> 8 ^ CRC32_TABLE[(nCrc ^ ab[of++]) & 0xFF];
            --cb;
        }
        return nCrc;
    }

    public static long getSafeTimeMillis() {
        long ldtAssumed = System.currentTimeMillis();
        long ldtSafe = ldtAssumed + s_lTimeCorrection;
        return ldtSafe == s_ldtLastTime ? ldtSafe : Base.updateSafeTimeMillis(ldtAssumed);
    }

    protected static synchronized long updateSafeTimeMillis(long ldtAssumed) {
        long lCorrection = s_lTimeCorrection;
        long ldtSafe = ldtAssumed + lCorrection;
        long ldtLast = s_ldtLastTime;
        long lDelta = ldtSafe - ldtLast;
        if (lDelta == 0L) {
            return ldtSafe;
        }
        if (lDelta > 0L) {
            if (lCorrection > 0L) {
                long lCompensation = lDelta > 2000L ? lDelta - 1000L : Math.min(Math.min(lCorrection, lDelta >>> 1), 10L);
                s_lTimeCorrection = lCorrection - lCompensation;
                ldtSafe -= lCompensation;
            }
            s_ldtLastTime = ldtSafe;
            return s_ldtLastTime;
        }
        s_lTimeCorrection = lCorrection - lDelta;
        return ldtLast;
    }

    public static Integer makeInteger(int n) {
        return (n & 0xFFFFFF00) == 0 ? INTEGERS[n] : new Integer(n);
    }

    public static Long makeLong(long n) {
        return (n & 0xFFFFFFFFFFFFFF00L) == 0L ? LONGS[(int)n] : new Long(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Random getRandom() {
        Random rnd = s_rnd;
        if (rnd == null) {
            Class clazz = Random.class;
            synchronized (clazz) {
                rnd = s_rnd;
                if (rnd == null) {
                    rnd = new Random();
                    long lStop = Base.getSafeTimeMillis() + 31L + (long)rnd.nextInt(31);
                    long cMin = 1021 + rnd.nextInt(Math.max(1, (int)(lStop % 1021L)));
                    while (Base.getSafeTimeMillis() < lStop || --cMin > 0L) {
                        cMin += rnd.nextBoolean() ? 1L : -1L;
                        rnd.setSeed(rnd.nextLong());
                    }
                    long lStart = Base.getSafeTimeMillis();
                    do {
                        if (!rnd.nextBoolean() || (rnd.nextLong() & 1L) != (Base.getSafeTimeMillis() & 1L)) continue;
                        rnd.nextBoolean();
                    } while (Base.getSafeTimeMillis() == lStart);
                    s_rnd = rnd;
                }
            }
        }
        return rnd;
    }

    public static List randomize(List list) {
        return new ImmutableArrayList(Base.randomize(list.toArray()));
    }

    public static Object[] randomize(Object[] a) {
        int c;
        if (a == null || (c = a.length) <= 1) {
            return a;
        }
        Random rnd = Base.getRandom();
        for (int i1 = 0; i1 < c; ++i1) {
            int i2 = rnd.nextInt(c);
            Object o = a[i2];
            a[i2] = a[i1];
            a[i1] = o;
        }
        return a;
    }

    public static int[] randomize(int[] a) {
        int c;
        if (a == null || (c = a.length) <= 1) {
            return a;
        }
        Random rnd = Base.getRandom();
        for (int i1 = 0; i1 < c; ++i1) {
            int i2 = rnd.nextInt(c);
            int n = a[i2];
            a[i2] = a[i1];
            a[i1] = n;
        }
        return a;
    }

    public static Binary getRandomBinary(int cbMin, int cbMax) {
        if (!$assertionsDisabled && cbMin < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && cbMax < cbMin) {
            throw new AssertionError();
        }
        Random rnd = Base.getRandom();
        int cbDif = cbMax - cbMin;
        int cb = cbDif <= 0 ? cbMax : cbMin + rnd.nextInt(cbDif);
        byte[] ab = new byte[cb];
        rnd.nextBytes(ab);
        return new Binary(ab);
    }

    public static String getRandomString(int cchMin, int cchMax, boolean fAscii) {
        int cch;
        if (!$assertionsDisabled && cchMin < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && cchMax < cchMin) {
            throw new AssertionError();
        }
        Random rnd = Base.getRandom();
        int cchDif = cchMax - cchMin;
        int n = cch = cchDif <= 0 ? cchMax : cchMin + rnd.nextInt(cchDif);
        if (fAscii) {
            byte[] ab = new byte[cch];
            rnd.nextBytes(ab);
            for (int of = 0; of < cch; ++of) {
                int b = ab[of] & 0x7F;
                if (b < 32) {
                    b = 32 + rnd.nextInt(95);
                }
                ab[of] = (byte)b;
            }
            return new String(ab, 0);
        }
        char[] ach = new char[cch];
        int nLimit = 65536;
        for (int of = 0; of < cch; ++of) {
            ach[of] = (char)rnd.nextInt(nLimit);
        }
        return new String(ach);
    }

    public static PrintWriter getOut() {
        return s_out;
    }

    public static void setOut(PrintWriter writer) {
        s_out = writer == null ? new PrintWriter(NullImplementation.getWriter(), true) : writer;
    }

    public static PrintWriter getErr() {
        return s_err;
    }

    public static void setErr(PrintWriter writer) {
        s_err = writer == null ? new PrintWriter(NullImplementation.getWriter(), true) : writer;
    }

    public static PrintWriter getLog() {
        return s_log;
    }

    public static void setLog(PrintWriter writer) {
        s_log = writer == null ? new PrintWriter(NullImplementation.getWriter(), true) : writer;
    }

    public static boolean isLogEcho() {
        return s_fEchoLog;
    }

    public static void setLogEcho(boolean fEcho) {
        s_fEchoLog = fEcho;
    }

    public static void redirectAll(PrintWriter out) {
        Base.setOut(out);
        out = Base.getOut();
        Base.setErr(out);
        Base.setLog(out);
        Base.setLogEcho(false);
        WriterPrintStream stream = new WriterPrintStream(out);
        try {
            System.setOut(stream);
        }
        catch (SecurityException e) {
            Base.err(e);
        }
        try {
            System.setErr(stream);
        }
        catch (SecurityException e) {
            Base.err(e);
        }
    }

    public static int read(InputStream stream, byte[] ab) throws IOException {
        int MAX = ab.length;
        int cb = 0;
        boolean fEOF = false;
        while (!fEOF && cb < MAX) {
            int cbBlock = stream.read(ab, cb, MAX - cb);
            if (cbBlock < 0) {
                fEOF = true;
                continue;
            }
            cb += cbBlock;
        }
        return cb;
    }

    public static byte[] read(InputStream stream) throws IOException {
        int BLOCK = 1024;
        byte[] ab = new byte[BLOCK];
        ByteArrayOutputStream streamBuf = new ByteArrayOutputStream(BLOCK);
        try {
            int cb;
            while ((cb = stream.read(ab, 0, BLOCK)) >= 0) {
                if (cb <= 0) continue;
                streamBuf.write(ab, 0, cb);
            }
        }
        catch (EOFException e) {
            // empty catch block
        }
        stream.close();
        return streamBuf.toByteArray();
    }

    public static String read(Reader reader) throws IOException {
        int BLOCK = 1024;
        char[] ach = new char[BLOCK];
        CharArrayWriter writer = new CharArrayWriter(BLOCK);
        try {
            int cch;
            while ((cch = reader.read(ach, 0, BLOCK)) >= 0) {
                if (cch <= 0) continue;
                writer.write(ach, 0, cch);
            }
        }
        catch (EOFException e) {
            // empty catch block
        }
        reader.close();
        return writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] read(File file) throws IOException {
        if (file == null || !file.exists() || !file.isFile()) {
            return null;
        }
        long cbFile = file.length();
        Base.azzert(cbFile < Integer.MAX_VALUE);
        int cb = (int)cbFile;
        byte[] ab = new byte[cb];
        FileInputStream in = new FileInputStream(file);
        try {
            int cbRead = Base.read(in, ab);
            Base.azzert(cb == cbRead);
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (Exception e) {}
        }
        return ab;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] read(URL url) throws IOException {
        if (url == null) {
            return null;
        }
        URLConnection con = url.openConnection();
        int cb = con.getContentLength();
        byte[] ab = null;
        InputStream in = con.getInputStream();
        try {
            if (cb == -1) {
                ab = Base.read(in);
            } else {
                ab = new byte[cb];
                int cbRead = Base.read(in, ab);
                Base.azzert(cb == cbRead);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
        return ab;
    }

    static {
        int i;
        $assertionsDisabled = !Base.class.desiredAssertionStatus();
        DEFAULT_EXCEPTION = new WrapperException();
        HEX = "0123456789ABCDEF".toCharArray();
        MEM_SUFFIX = new String[]{"", "KB", "MB", "GB", "TB"};
        CRC32_TABLE = new int[256];
        int c = CRC32_TABLE.length;
        for (i = 0; i < c; ++i) {
            int nCrc = i;
            for (int n = 0; n < 8; ++n) {
                if ((nCrc & 1) == 1) {
                    nCrc = nCrc >>> 1 ^ 0xEDB88320;
                    continue;
                }
                nCrc >>>= 1;
            }
            Base.CRC32_TABLE[i] = nCrc;
        }
        INTEGERS = new Integer[256];
        c = INTEGERS.length;
        for (i = 0; i < c; ++i) {
            Base.INTEGERS[i] = new Integer(i);
        }
        LONGS = new Long[256];
        c = LONGS.length;
        for (i = 0; i < c; ++i) {
            Base.LONGS[i] = new Long(i);
        }
        String sMonitors = System.getProperty("tangosol.coherence.commonmonitors");
        int cMonitors = Runtime.getRuntime().availableProcessors() * 512;
        if (sMonitors != null) {
            int c2 = Integer.parseInt(sMonitors);
            if (c2 < cMonitors / 8) {
                System.err.println("The specified number of " + c2 + " common monitors is significantly lower then the recommended " + cMonitors + " and may result in performance degradation.");
            }
            cMonitors = c2;
        }
        MONITORS = new Object[cMonitors];
        for (int i2 = 0; i2 < cMonitors; ++i2) {
            Base.MONITORS[i2] = new CommonMonitor();
        }
        s_out = new PrintWriter(System.out, true);
        s_err = new PrintWriter(System.err, true);
        s_log = new PrintWriter(NullImplementation.getWriter(), true);
        s_fEchoLog = true;
        s_ldtLastTime = System.currentTimeMillis();
        s_lTimeCorrection = 0L;
        s_threadFactory = Base.instantiateThreadFactory();
        CacheFactory.initLogging();
    }

    private static class CommonMonitor {
        private CommonMonitor() {
        }
    }

    public static class StackFrame {
        public static final StackFrame UNKNOWN = new StackFrame("unknown", "unknown", "unknown", 0);
        private String m_sFile;
        private String m_sClass;
        private String m_sMethod;
        private int m_nLine;

        public StackFrame(String sExcept) {
            try {
                int of = sExcept.indexOf(40);
                String sLeft = sExcept.substring(sExcept.lastIndexOf(32, of) + 1, of);
                String sRight = sExcept.substring(of + 1, sExcept.lastIndexOf(41));
                of = sLeft.lastIndexOf(46);
                String sClass = sLeft.substring(0, of);
                String sMethod = sLeft.substring(of + 1);
                String sFile = "unknown";
                int nLine = 0;
                of = sRight.lastIndexOf(58);
                if (of >= 0) {
                    sFile = sRight.substring(0, of);
                    try {
                        nLine = Integer.parseInt(sRight.substring(of + 1));
                    }
                    catch (RuntimeException e) {
                        // empty catch block
                    }
                }
                this.init(sFile, sClass, sMethod, nLine);
            }
            catch (RuntimeException e) {
                Base.out("Exception constructing StackFrame for \"" + sExcept + "\"");
                throw e;
            }
        }

        public StackFrame(String sFile, String sClass, String sMethod, int nLine) {
            this.init(sFile, sClass, sMethod, nLine);
        }

        protected void init(String sFile, String sClass, String sMethod, int nLine) {
            this.m_sFile = sFile;
            this.m_sClass = sClass;
            this.m_sMethod = sMethod;
            this.m_nLine = nLine;
        }

        public String getFileName() {
            return this.m_sFile;
        }

        public String getClassName() {
            return this.m_sClass;
        }

        public String getShortClassName() {
            String sClass = this.m_sClass;
            sClass = sClass.substring(sClass.lastIndexOf(46) + 1);
            return sClass.replace('$', '.');
        }

        public String getMethodName() {
            return this.m_sMethod;
        }

        public int getLineNumber() {
            return this.m_nLine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getLine() {
            block8: {
                String string;
                InputStream stream;
                int nLine = this.getLineNumber();
                if (nLine == 0) {
                    return null;
                }
                String sClass = this.getClassName();
                int of = sClass.indexOf(36);
                if (of >= 0) {
                    sClass = sClass.substring(0, of);
                }
                if ((stream = Class.forName(sClass, false, Base.getContextClassLoader()).getClassLoader().getResourceAsStream(sClass.replace('.', '/') + ".java")) == null) break block8;
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                try {
                    String sLine = null;
                    for (int i = 0; i < nLine; ++i) {
                        sLine = reader.readLine();
                    }
                    string = sLine;
                }
                catch (Throwable throwable) {
                    try {
                        reader.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
                reader.close();
                return string;
            }
            return null;
        }

        public String toString() {
            int nLine = this.getLineNumber();
            String sLine = nLine == 0 ? "?" : "" + nLine;
            return this.getClassName() + '.' + this.getMethodName() + '(' + this.getFileName() + ':' + sLine + ')';
        }

        public String toShortString() {
            int nLine = this.getLineNumber();
            String sLine = nLine == 0 ? "?" : "" + nLine;
            return this.getShortClassName() + '.' + this.getMethodName() + " [" + sLine + ']';
        }
    }
}

