/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.io.AbstractByteArrayReadBuffer;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.ReadBuffer;
import com.tangosol.util.BinaryWriteBuffer;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;

public final class Binary
extends AbstractByteArrayReadBuffer
implements Cloneable,
Comparable,
Externalizable,
ExternalizableLite {
    private transient int m_nHash;

    public Binary() {
        super(NO_BYTES, 0, 0);
    }

    public Binary(byte[] ab) {
        this(ab, 0, ab.length);
    }

    public Binary(byte[] ab, int of, int cb) {
        try {
            if (cb == 0) {
                this.m_ab = NO_BYTES;
            } else {
                byte[] abNew = new byte[cb];
                System.arraycopy(ab, of, abNew, 0, cb);
                this.m_ab = abNew;
                this.m_cb = cb;
            }
        }
        catch (Exception e) {
            Binary.azzert(ab != null, "byte array is null");
            Binary.azzert(of >= 0, "offset is negative");
            Binary.azzert(of <= ab.length, "offset > array length");
            Binary.azzert(cb >= 0, "length is negative");
            Binary.azzert(of + cb <= ab.length, "offset + length > array length");
            throw Binary.ensureRuntimeException(e);
        }
    }

    public Binary(Binary that) {
        int cbAlloc = that.m_ab.length;
        int cbUsed = that.m_cb;
        if (cbAlloc - 1024 > cbUsed && (cbAlloc >>> 1) + (cbAlloc >>> 2) > cbUsed) {
            byte[] abNew = new byte[cbUsed];
            System.arraycopy(that.m_ab, that.m_of, abNew, 0, cbUsed);
            this.m_ab = abNew;
            this.m_cb = cbUsed;
        } else {
            this.m_ab = that.m_ab;
            this.m_of = that.m_of;
            this.m_cb = that.m_cb;
            this.m_nHash = that.m_nHash;
        }
    }

    public Binary(ByteArrayOutputStream stream) {
        byte[] ab = stream.toByteArray();
        if (stream.getClass() != ByteArrayOutputStream.class) {
            ab = (byte[])ab.clone();
        }
        this.m_ab = ab;
        this.m_cb = ab.length;
    }

    public Binary(DataInput stream) throws IOException {
        this.readExternal(stream);
    }

    Binary(Binary that, int of, int cb) {
        super(that.m_ab, that.m_of + of, cb);
    }

    Binary(BinaryWriteBuffer buf) {
        byte[] ab = buf.getInternalByteArray();
        int cbData = buf.length();
        int cbTotal = ab.length;
        int cbWaste = cbTotal - cbData;
        if (cbWaste <= cbData >>> 3) {
            this.m_ab = ab;
        } else {
            byte[] abNew = new byte[cbData];
            System.arraycopy(ab, 0, abNew, 0, cbData);
            this.m_ab = abNew;
        }
        this.m_cb = cbData;
    }

    public boolean regionMatches(int ofThis, Binary that, int ofThat, int cb) {
        if (ofThis < 0 || (long)ofThis > (long)this.m_cb - (long)cb || ofThat < 0 || (long)ofThat > (long)that.m_cb - (long)cb) {
            return false;
        }
        byte[] abThis = this.m_ab;
        byte[] abThat = that.m_ab;
        ofThis += this.m_of;
        ofThat += that.m_of;
        while (--cb >= 0) {
            if (abThis[ofThis++] == abThat[ofThat++]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(Binary bin, int ofFrom) {
        return this.regionMatches(ofFrom, bin, 0, bin.m_cb);
    }

    public boolean startsWith(Binary bin) {
        return this.startsWith(bin, 0);
    }

    public boolean endsWith(Binary bin) {
        return this.startsWith(bin, this.m_cb - bin.m_cb);
    }

    public int indexOf(byte b) {
        return this.indexOf(b, 0);
    }

    public int indexOf(byte b, int ofFrom) {
        byte[] ab = this.m_ab;
        int of = this.m_of;
        int cb = this.m_cb;
        if (ofFrom < 0) {
            ofFrom = 0;
        }
        if (ofFrom < cb) {
            int ofStop = of + cb;
            for (int ofCur = of + ofFrom; ofCur < ofStop; ++ofCur) {
                if (ab[ofCur] != b) continue;
                return ofCur - of;
            }
        }
        return -1;
    }

    public int lastIndexOf(byte b) {
        return this.lastIndexOf(b, this.m_cb - 1);
    }

    public int lastIndexOf(byte b, int ofFrom) {
        if (ofFrom >= 0) {
            byte[] ab = this.m_ab;
            int of = this.m_of;
            int cb = this.m_cb;
            if (ofFrom >= cb) {
                ofFrom = cb - 1;
            }
            for (int ofCur = of + ofFrom; ofCur >= of; --ofCur) {
                if (ab[ofCur] != b) continue;
                return ofCur - of;
            }
        }
        return -1;
    }

    public Binary toBinary() {
        return this;
    }

    public Binary toBinary(int of, int cb) {
        int cbBuf = this.m_cb;
        if (of == 0 && cb == cbBuf) {
            return this;
        }
        if (of < 0 || cb < 0 || of + cb > cbBuf) {
            throw new IndexOutOfBoundsException("of=" + of + ", cb=" + cb + ", length()=" + cbBuf);
        }
        return cb == 0 ? NO_BINARY : new Binary(this, of, cb);
    }

    protected ReadBuffer instantiateReadBuffer(int of, int cb) {
        return this.toBinary(of, cb);
    }

    protected boolean isByteArrayPrivate() {
        return true;
    }

    public Object clone() {
        return this;
    }

    public String toString() {
        return "Binary(length=" + this.m_cb + ", value=" + Binary.toHexEscape(this.m_ab, this.m_of, this.m_cb) + ')';
    }

    public int hashCode() {
        int nHash = this.m_nHash;
        if (nHash == 0) {
            this.m_nHash = nHash = Binary.toCrc(this.m_ab, this.m_of, this.m_cb);
        }
        return nHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Binary) {
            Binary that = (Binary)o;
            int cbThis = this.m_cb;
            int cbThat = that.m_cb;
            if (cbThis == cbThat) {
                if (cbThis == 0) {
                    return true;
                }
                int nThisHash = this.m_nHash;
                int nThatHash = that.m_nHash;
                if (nThisHash == 0 || nThatHash == 0 || nThisHash == nThatHash) {
                    byte[] abThis = this.m_ab;
                    byte[] abThat = that.m_ab;
                    int ofThis = this.m_of + cbThis;
                    int ofThat = that.m_of + cbThat;
                    int ofStop = this.m_of;
                    while (ofThis > ofStop) {
                        if (abThis[--ofThis] == abThat[--ofThat]) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public int compareTo(Object o) {
        int nResult;
        int cbRemain;
        Binary that = (Binary)o;
        byte[] abThis = this.m_ab;
        byte[] abThat = that.m_ab;
        int ofThis = this.m_of;
        int ofThat = that.m_of;
        int cbThis = this.m_cb;
        int cbThat = that.m_cb;
        if (cbThis < cbThat) {
            cbRemain = cbThis;
            nResult = -1;
        } else if (cbThis == cbThat) {
            cbRemain = cbThis;
            nResult = 0;
        } else {
            cbRemain = cbThat;
            nResult = 1;
        }
        int ofStop = ofThis + cbRemain;
        while (ofThis < ofStop) {
            if (abThis[ofThis] != abThat[ofThat]) {
                return (abThis[ofThis] & 0xFF) - (abThat[ofThat] & 0xFF);
            }
            ++ofThis;
            ++ofThat;
        }
        return nResult;
    }

    public void readExternal(ObjectInput in) throws IOException {
        this.readExternal((DataInput)in);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternal((DataOutput)out);
    }

    public void readExternal(DataInput in) throws IOException {
        if (this.m_cb > 0) {
            throw new NotActiveException();
        }
        int cb = in.readInt();
        byte[] ab = new byte[cb];
        in.readFully(ab);
        this.m_ab = ab;
        this.m_cb = cb;
    }

    public void writeExternal(DataOutput out) throws IOException {
        out.writeInt(this.m_cb);
        out.write(this.m_ab, this.m_of, this.m_cb);
    }

    public InputStream getInputStream() {
        return (InputStream)((Object)this.getBufferInput());
    }

    public void writeTo(OutputStream stream) throws IOException {
        stream.write(this.m_ab, this.m_of, this.m_cb);
    }
}

