/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.Base;

public class BitHelper
extends Base {
    private static final byte[] BIT_COUNT = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};
    private static final byte[] BIT_LEFTMOST = new byte[]{-1, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static final byte[] BIT_RIGHTMOST = new byte[]{-1, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};

    public static int countBits(byte b) {
        return BIT_COUNT[b & 0xFF];
    }

    public static int countBits(int n) {
        byte[] BIT_COUNT = BitHelper.BIT_COUNT;
        return BIT_COUNT[n & 0xFF] + BIT_COUNT[(n & 0xFF00) >>> 8] + BIT_COUNT[(n & 0xFF0000) >>> 16] + BIT_COUNT[(n & 0xFF000000) >>> 24];
    }

    public static int countBits(long l) {
        byte[] BIT_COUNT = BitHelper.BIT_COUNT;
        int n1 = (int)l;
        int n2 = (int)(l >>> 32);
        return BIT_COUNT[n1 & 0xFF] + BIT_COUNT[(n1 & 0xFF00) >>> 8] + BIT_COUNT[(n1 & 0xFF0000) >>> 16] + BIT_COUNT[(n1 & 0xFF000000) >>> 24] + BIT_COUNT[n2 & 0xFF] + BIT_COUNT[(n2 & 0xFF00) >>> 8] + BIT_COUNT[(n2 & 0xFF0000) >>> 16] + BIT_COUNT[(n2 & 0xFF000000) >>> 24];
    }

    public static int indexOfMSB(byte b) {
        return BIT_LEFTMOST[b & 0xFF];
    }

    public static int indexOfMSB(int n) {
        int cShift = (n & 0xFFFF0000) != 0 ? ((n & 0xFF000000) != 0 ? 24 : 16) : ((n & 0xFF00) != 0 ? 8 : 0);
        return cShift + BIT_LEFTMOST[n >>> cShift];
    }

    public static int indexOfMSB(long l) {
        int n = (int)(l >>> 32);
        return n == 0 ? BitHelper.indexOfMSB((int)l) : BitHelper.indexOfMSB(n) + 32;
    }

    public static int indexOfLSB(byte b) {
        return BIT_RIGHTMOST[b & 0xFF];
    }

    public static int indexOfLSB(int n) {
        if (n == 0) {
            return -1;
        }
        int cShift = (n & 0xFFFF) != 0 ? ((n & 0xFF) != 0 ? 0 : 8) : ((n & 0xFF0000) != 0 ? 16 : 24);
        return cShift + BIT_RIGHTMOST[n >>> cShift & 0xFF];
    }

    public static int indexOfLSB(long l) {
        if (l == 0L) {
            return -1;
        }
        int n = (int)l;
        return n == 0 ? BitHelper.indexOfLSB((int)(l >>> 32)) + 32 : BitHelper.indexOfLSB(n);
    }

    public static String toBitString(byte b) {
        char[] ach = new char[8];
        for (int i = 7; i >= 0; --i) {
            ach[i] = (char)(48 + (b & 1));
            b = (byte)(b >>> 1);
        }
        return new String(ach);
    }

    public static String toBitString(int n) {
        char[] ach = new char[32];
        for (int i = 31; i >= 0; --i) {
            ach[i] = (char)(48 + (n & 1));
            n >>>= 1;
        }
        return new String(ach);
    }

    public static String toBitString(long l) {
        char[] ach = new char[64];
        for (int i = 63; i >= 0; --i) {
            ach[i] = (char)(48 + ((int)l & 1));
            l >>>= 1;
        }
        return new String(ach);
    }
}

