/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.util;

import com.tangosol.util.ChainedEnumerator;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ChainedMap
extends AbstractMap
implements Serializable {
    protected Map m_mapFirst;
    protected Map m_mapSecond;
    protected transient EntrySet m_setEntries;

    public ChainedMap(Map mapFirst, Map mapSecond) {
        this.m_mapFirst = mapFirst;
        this.m_mapSecond = mapSecond;
        if (!mapFirst.isEmpty() && !mapSecond.isEmpty()) {
            mapSecond.keySet().removeAll(mapFirst.keySet());
        }
    }

    public Map getFirstMap() {
        return this.m_mapFirst;
    }

    public Map getSecondMap() {
        return this.m_mapSecond;
    }

    public int size() {
        return this.m_mapFirst.size() + this.m_mapSecond.size();
    }

    public boolean containsKey(Object oKey) {
        return this.m_mapFirst.containsKey(oKey) || this.m_mapSecond.containsKey(oKey);
    }

    public Object get(Object oKey) {
        Object oValue = null;
        Map mapFirst = this.m_mapFirst;
        Map mapSecond = this.m_mapSecond;
        if (mapFirst.containsKey(oKey)) {
            oValue = mapFirst.get(oKey);
        } else if (mapSecond.containsKey(oKey)) {
            oValue = mapSecond.get(oKey);
        }
        return oValue;
    }

    public Object put(Object oKey, Object oValue) {
        Map mapFirst = this.m_mapFirst;
        if (mapFirst.containsKey(oKey)) {
            return mapFirst.put(oKey, oValue);
        }
        Map mapSecond = this.m_mapSecond;
        if (mapSecond.containsKey(oKey)) {
            return mapSecond.put(oKey, oValue);
        }
        return mapFirst.put(oKey, oValue);
    }

    public Object remove(Object oKey) {
        Map mapFirst;
        Object oValue = null;
        Map mapSecond = this.m_mapSecond;
        if (mapSecond.containsKey(oKey)) {
            oValue = mapSecond.remove(oKey);
        }
        if ((mapFirst = this.m_mapFirst).containsKey(oKey)) {
            oValue = mapFirst.remove(oKey);
        }
        return oValue;
    }

    public Set entrySet() {
        EntrySet setEntries = this.m_setEntries;
        if (setEntries == null) {
            this.m_setEntries = setEntries = this.instantiateEntrySet();
        }
        return setEntries;
    }

    protected EntrySet instantiateEntrySet() {
        return new EntrySet();
    }

    public class EntrySet
    extends AbstractSet
    implements Serializable {
        public Iterator iterator() {
            return new ChainedEnumerator(ChainedMap.this.m_mapFirst.entrySet().iterator(), ChainedMap.this.m_mapSecond.entrySet().iterator());
        }

        public int size() {
            return ChainedMap.this.size();
        }

        public boolean contains(Object o) {
            Map.Entry entry;
            Object oKey;
            ChainedMap map;
            if (o instanceof Map.Entry && (map = ChainedMap.this).containsKey(oKey = (entry = (Map.Entry)o).getKey())) {
                Object oThis = map.get(oKey);
                Object oThat = entry.getValue();
                return oThat == null ? oThis == null : oThat == oThis || oThat.equals(oThis);
            }
            return false;
        }

        public Object[] toArray() {
            Object[] aoResult;
            Map mapFirst = ChainedMap.this.m_mapFirst;
            Map mapSecond = ChainedMap.this.m_mapSecond;
            if (mapFirst.isEmpty()) {
                aoResult = mapSecond.entrySet().toArray();
            } else if (mapSecond.isEmpty()) {
                aoResult = mapFirst.entrySet().toArray();
            } else {
                Object[] aoFirst = mapFirst.entrySet().toArray();
                int coFirst = aoFirst.length;
                Object[] aoSecond = mapSecond.entrySet().toArray();
                int coSecond = aoSecond.length;
                int coResult = coFirst + coSecond;
                aoResult = new Object[coResult];
                System.arraycopy(aoFirst, 0, aoResult, 0, coFirst);
                System.arraycopy(aoSecond, 0, aoResult, coFirst, coSecond);
            }
            return aoResult;
        }

        public Object[] toArray(Object[] aoDest) {
            Object[] aoResult;
            Map mapFirst = ChainedMap.this.m_mapFirst;
            Map mapSecond = ChainedMap.this.m_mapSecond;
            if (mapFirst.isEmpty()) {
                aoResult = mapSecond.entrySet().toArray(aoDest);
            } else if (mapSecond.isEmpty()) {
                aoResult = mapFirst.entrySet().toArray(aoDest);
            } else {
                Object[] aoSecond;
                int coSecond;
                int coDest = aoDest.length;
                Object[] aoFirst = mapFirst.entrySet().toArray();
                int coFirst = aoFirst.length;
                int coResult = coFirst + (coSecond = (aoSecond = mapSecond.entrySet().toArray()).length);
                if (coDest < coResult) {
                    aoResult = (Object[])Array.newInstance(aoDest.getClass().getComponentType(), coResult);
                } else if (coDest > coResult) {
                    aoResult = aoDest;
                    aoResult[coResult] = null;
                } else {
                    aoResult = aoDest;
                }
                System.arraycopy(aoFirst, 0, aoResult, 0, coFirst);
                System.arraycopy(aoSecond, 0, aoResult, coFirst, coSecond);
            }
            return aoResult;
        }

        public boolean add(Object o) {
            Map.Entry entry = (Map.Entry)o;
            if (this.contains(entry)) {
                return false;
            }
            ChainedMap.this.put(entry.getKey(), entry.getValue());
            return true;
        }
    }
}

